# report size of dgroup from map file, assumes dgroup is first data segment

$6 ~ /STACK|CONST|MEMORY|Data/  { 
	if (selector == 0) {
		selector = $4
		startmem = hexvalue($1)
	}
	if ($4 == selector)
		endmem = hexvalue($2)
}

END { printf("dgroup %s = %d bytes\n", selector, endmem - startmem + 1) }

function hexvalue(s,  i, n) {
	convert = "0123456789ABCDEF"
	for(i = 1; i <= 5; i++) {
		n = (n * 16) + (index(convert, substr(s, i, 1)) - 1)
	}
	return n
}