;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: SmString.asm                                                        *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:  System Manager text messages                                *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 10/12/89 120C.04 T. Ball      / Removed sbQicDevice and sbTapeDevice,     *;
;*                                 added sbProcName                          *;
;* 09/13/89 120C.03 T. Ball      / Added FloppySet                           *;
;* 08/03/89 120C.02 T. Ball      / Removed support for SRP statistics        *;
;* 06/01/89 120B/01 T. Ball      / Added CantAccessMsg                       *;
;*                                                                           *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT TECHNOLOGIES INC. ALL RIGHTS RESERVED *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

; SmString.asm
;
; Declaration of strings used by System Manager.
;
; Last modified:
;
; -- 11.0 --
; 07/10/86  JM created
; 12/12/86 PBC completed hacking
; -- 11.2 --
; 8/4/87   MS sbStringErrorCode stuff.
; -- 12.0 --
; 8/17/88  TAB  removed sbStringErrorCode stuff for System Manager.
;

$INCLUDE([sys]<edf>String.mdf)

%InitStrings

%sbString	sbDblBar	('') ; 
%sbString	sbBar		('') 
%sbString	sbMapLine0 ('') ; 
%sbString	sbMapLine1 ('') ; 
%sbString	sbMapLine2 ('') ; 
%sbString	sbMapLine3 ('') ; 
%sbString	sbMapLine4 ('') ; 

%sbString	sbBlanks ('                                                                                ') ; 

%sbString	sbDeviceName ('~DeviceName')
%sbString	sbDevicePswd ('~DevicePswd')
%sbString	sbVolumeName ('~VolumeName')
%sbString	sbClstrLine  ('~ClusterLine')
%sbString	sbProcName   ('~ProcessorName~')
%sbString	sbPrompt     ('~PromptUser')

%sbString	sbNSet       ('NgenProcSet')
%sbString	sbSSet       ('SrpProcSet')
%sbString	sbDSet       ('DiskSet')
%sbString	sbVSet       ('VideoSet')
%sbString	sbMSet       ('MouseSet')
%sbString	sbKSet       ('KeyboardSet')
%sbString	sbESet       ('EthernetSet')
%sbString	sbPSet       ('PhoneSet')
%sbString	sbTSet       ('TapeSet')
%sbString	sbXSet       ('XC002Set')
%sbString	sbCSet       ('PcEmulatorSet')
%sbString	sbRSet       ('TokenRingSet')
%sbString	sbLSet       ('EthernetLanMgrSet')
%sbString	sbNullSet    ('NullSet')
%sbString	sbFloppySet  ('FloppySet')

%sbString	sbParStatSet ('PartitionStatus')
%sbString	sbPsDetailSet ('PartitionDetails')
%sbString	sbPsMapSet   ('PartitionMap')

%sbString	sbRemoteCase ('RM')
%sbString	sbParStatCase ('PS')

%sbString	sbExecMsgFile ('[sys]<sys>ExecMsg.bin')
%sbString	sbSmRunFile ('[Sys]<Sys>SystemMgr.run')
%sbString	sbExecRunFile ('[Sys]<Sys>Exec.run')
%sbString	sbMsgFileName ('[Sys]<Sys>SystemMgrMsg.bin')
%sbString	sbRumNulFile ('[Sys]<Sys>RumNul.run');
%sbString	sbConsoleFile ('[Sys]<Sys>ClusterView.run');

%sbString	sbCnfgFile ('[Sys]<Sys>SystemMgrConfig.sys')

%sbString	sbClusterStatusCmd ('ClusterStatus')

%rgbcbString (CantAccessMsgFile)
	 ('The message file, [Sys]<Sys>SystemMgrMsg.bin cannot be accessed.')

%FinishStrings
END
