/*****************************  MODULE HEADER  *******************************/
/*                                                                           */
/*                                                                           */
/*  MACHINE:                LANGUAGE:  Metaware C            OS: CTOS        */
/*                                                                           */
/*  seq_service_msgs.c                                                       */
/*                                                                           */
/*  Default messages and functions for CTOS Sequential Access service        */
/*                                                                           */
/*  HISTORY:                                                                 */
/*  --------                                                                 */
/*                                                                           */
/*  MM/DD/YY  VVVV/MM  PROGRAMMER    /  DESCRIPTION                          */
/*                                                                           */
/*  11/19/90  121E.00  P. Johansson  /  Created.                             */
/*  02/23/91  121G.01  P. Johansson  /  Additional messages.                 */
/*                                                                           */
/*                    PROPRIETARY  PROGRAM  MATERIAL                         */
/*                                                                           */
/*  THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO         */
/*  BE REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM       */
/*  LICENSE OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF          */
/*  UNISYS CORPORATION, DETROIT, MICHIGAN 48232, USA.                        */
/*                                                                           */
/*  COPYRIGHT (C) 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED               */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*  UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE         */
/*  AND RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION. HOWEVER,  */
/*  NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       */
/*  CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS     */
/*  OF PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO     */
/*  WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                */
/*                                                                           */
/*  THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     */
/*  WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       */
/*  JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          */
/*                                                                           */
/**************************  END OF MODULE HEADER  ***************************/

#define debug

#ifdef debug
#define private
#else
#define private static
#endif

/* Standard C library macros and functions invoked by this module */

pragma Off(List);
#include <intel80X86.h>
#include <string.h>
pragma Pop(List);

/* There are no procedures in the Sequential Access service that can cope with
   a variable number of arguments, so this pragma makes everything much more
   efficient.  However, it has to be established AFTER any standard C library
   functions are defined because it reverses the normal C convention. */

pragma Calling_convention(_CALLEE_POPS_STACK);

/* External CTOS and CTOS Toolkit functions invoked by this module */

#define ErrorExit
#define ErrorExitString
#define ExpandLocalMsg
#define GetServerMsg
#define OpenServerMsgFile
#define OutputBytesWithWrap
#define WriteLog

pragma Off(List);
#include <ctoslib.h>
pragma Pop(List);

/* Type definitions used by this module */

#define last(array) (sizeof(array) / sizeof(*array) - 1)

#define sdType

pragma Off(List);
#include <ctosTypes.h>
#include "seq_service.h"
pragma Pop(List);

/* Static variables global within this manuscript */

private void (*exit_procedure[10])(void);
private unsigned n_exit_procedure = 0;

/* Function prototypes defined before the functions themselves are declared */

void exit_with_msg(unsigned erc, unsigned msg_num);

/*-----------------------------------------------------------------------------
 Here are all the messages used by the Sequential Access service.  If
 possible, the pointers to these compiled strings are replaced by text that
 comes from a (potentially) nationalized message file.  If no message file is
 available, these will have to do.  The table MUST be terminated with message
 number zero and a null pointer to a zero length string (in case anyone
 searches for a message number that is not present). */

private msg_descriptor_type message[] = {
   default_msg(NLS_COMMAND_VERSION, "%0S %1S\n\n"),
   default_msg(NLS_NGEN_SERVICE, "[Sys]<Sys>NGenSeqService.Run"),
   default_msg(NLS_SRP_SERVICE, "[Sys]<Sys>SrpSeqService.Run"),
   default_msg(NLS_PERTEC_SERVICE, "[Sys]<Sys>PertecSeqService.Run"),
   default_msg(NLS_SERVER_SYS_VOLUME, "!Sys"),
   default_msg(NLS_DEFAULT_SEQ_DEVICE, "[QIC]"),
   default_msg(NLS_DEVICE_DEINSTALLED_OK, "Device %0S has been deinstalled\n"),
   default_msg(NLS_DEVICE_UNKNOWN, "Device %0S is not recognized by the "
                                   "Sequential Access service\n"),
   default_msg(NLS_DEVICE_DEINSTALLATION_ERROR, "Device %0S cannot be "
                                                "deinstalled (Error %1N)\n"),
   default_msg(NLS_SERVICE_DEINSTALLED_OK, "The Sequential Access service has "
                                           "been deinstalled"),
   default_msg(NLS_SERVICE_NOT_INSTALLED, "The Sequential Access service is "
                                           "not installed"),
   default_msg(NLS_SERVICE_DEINSTALLATION_ERROR, "The Sequential Access "
                                                 "service cannot be "
                                                 "deinstalled (Error %1N)"),
   default_msg(NLS_QIC36_CLASS, "QIC36"),
   default_msg(NLS_HALF_INCH_CLASS, "HalfInch"),
   default_msg(NLS_SCSI_CLASS, "SCSI"),
   default_msg(NLS_WRONG_OS, "The Sequential Access service requires CTOS "
                             "9.9, BTOS 8.2, BTOS II, CTOS/VM 2.3 or CTOS/VM "
                             "3.0 or later"),
   default_msg(NLS_WRONG_HARDWARE, "This hardware configuration does not "
                                   "support the workstation Tape Backup "
                                   "module"),
   default_msg(NLS_NO_XBIF, "The XBIF service must be installed before the "
                            "Sequential Access service"),
   default_msg(NLS_ALREADY_INSTALLED, "The Sequential Access service is "
                                      "already installed"),
   default_msg(NLS_INSTALLED_OK, "The Sequential Access service has been "
                                 "installed"),
   default_msg(NLS_PARTITION_NAME, "Seq Access"),
   default_msg(NLS_CANT_INSTALL, "This service must be installed before the "
                                 "Context Manager is installed"),
   default_msg(NLS_NO_DEVICES, "No sequential access devices found\nThe "
                               "Sequential Access service has not been "
                               "installed"),
   default_msg(NLS_CASE_INVALID, "Command case (from Sys.Cmds or $RUN "
                                 "directive) is not recognized\n"),
   default_msg(0, "")};

/*-----------------------------------------------------------------------------
 Attempt to open the standard message file in order to replace the hard-coded
 messages (above) with native-language messages if they are available.
 Because the message file for services is relatively small, all the messages
 are kept in memory. */

void initialize_msgs(void) {

   unsigned i;

   if (OpenServerMsgFile(MSG_FILE, last(MSG_FILE), NULL, 0, 0) == ercOK)
      for (i = 0; message[i].msg_num != 0; i++)
         GetServerMsg(message[i].msg_num, &message[i].msg_text);

}

/*-----------------------------------------------------------------------------
 Descriptor information for the above-defined messages may be returned by
 calling the function below with a message number.  If found, the address of
 the sdType that describes the message is returned.  Callers should be careful
 that their code can handle a null sdType (in case they have asked for a
 message not in the table. */

sdType *standard_msg(unsigned msg_num) {

   unsigned i;

   for (i = 0; i <= last(message); i++)
      if (msg_num == message[i].msg_num)
         break;
   return((sdType *) &message[i].msg_text);

}

/*-----------------------------------------------------------------------------
 Commonly used function to display a standardized message on the screen.  If
 the referenced message number cannot be found, a new line character is output
 instead. */

void log_msg(unsigned nls_msg_index, sdType nls_parms[],
             unsigned nls_parms_len) {

   char msg[256];
   unsigned erc, msg_len;
   sdType *sd_msg;

   sd_msg = standard_msg(nls_msg_index);
   if (ExpandLocalMsg(nls_parms, nls_parms_len, sd_msg->pb, sd_msg->cb, msg,
                      sizeof(msg), &msg_len, FALSE) == ercOK)
      if ((erc = OutputBytesWithWrap(msg, msg_len)) != ercOK)
         exit_with_msg(erc, 0);

}

/*-----------------------------------------------------------------------------
 The Sequential Access service may be exited (before a ConvertToSys operation)
 with an error return code and an optional message index number by a call to
 the function below. */

void exit_with_msg(unsigned erc, unsigned msg_num) {

   unsigned i;
   sdType *sd;

   for (i = 0; i < n_exit_procedure; i++)
      exit_procedure[i]();
   if (msg_num == 0)
      ErrorExit(erc);
   else {
      sd = standard_msg(msg_num);
      ErrorExitString(erc, sd->pb, sd->cb);
   }

}

void register_exit_procedure(void (*procedure)(void)) {

   if (n_exit_procedure < last(exit_procedure))
      exit_procedure[n_exit_procedure++] = procedure;

}

/*-----------------------------------------------------------------------------
 When an unexpected nonzero erc arises that should be mentioned in the system
 log, call this procedure. */

void log_erc(unsigned erc) {

   seq_access_log_msg_type log_msg;

   memset(&log_msg, 0, sizeof(log_msg));
   log_msg.erc = erc;
   WriteLog(&log_msg, sizeof(log_msg));

}
