$TITLE(03 JAN 90: DMA Memory-to-Memory Service for CTOS/VM 3.0)
$PAGEWIDTH(132)
$PAGELENGTH(60)
$MOD386
%SET(Debug, 1)

DmaMover_MfP	SEGMENT	PUBLIC 'Code'
DmaMover_MfP	ENDS

DGroup		GROUP	DATA
Data		SEGMENT	PUBLIC 'Data'
Data		ENDS

; PUBLIC interfaces exported by this module

		PUBLIC	DmaTransfer
		PUBLIC	DmaTransferForMassIo
		PUBLIC	SoftwareDmaInterrupt
		PUBLIC	DmaMoveComplete

; Type definitions used by this module (see CtosTypes.Edf)

chain		EQU	WORD PTR 0
ctrlFlags	EQU	BYTE PTR 2
	mStageDma		EQU	00010000b
	mCompletionProc		EQU	00001000b
	mRequesterMapped	EQU	00000100b
	mTargetMapped		EQU	00000010b
	mTargetWrite		EQU	00000001b

	mCtosFlags		EQU	00001111b
	mApplicationFlags	EQU	00000111b
slotId		EQU	BYTE PTR 3
pRequester	EQU	DWORD PTR 4
baRequester	EQU	DWORD PTR 8
pTarget		EQU	DWORD PTR 12
baTarget	EQU	DWORD PTR 16
xferLength	EQU	WORD PTR 20
userDS		EQU	WORD PTR 22
completionExch	EQU	WORD PTR 24
pCompletionMsg	EQU	DWORD PTR 26
pIob		EQU DWORD PTR 30
paIob		EQU DWORD PTR 34
sDmaIob		EQU	30		;Size (in bytes) of 'iobDmaType' client fields

; EXTERNAL data and/or definitions imported by this module

bOpEnable	EQU	0
bOpDisable	EQU	1
tyMegaBusDMA	EQU	22

Data		SEGMENT

	EXTRN	bMySlot:BYTE
	EXTRN vf:BYTE

Data		ENDS

%SET(DMA82380, 1)
%SET(DMA82380PortsType, 1)
%SET(GP, 1)

$SAVE NOLIST
$INCLUDE(:F1:Srp386.Mdf)
$INCLUDE(:F1:VfEqu.idf)
$RESTORE

; EXTERNAL interfaces imported by this module

		EXTRN	ControlInterrupt:FAR
		EXTRN	Crash:FAR
		EXTRN	KSend:FAR
		EXTRN	MapBusAddress:FAR
		EXTRN	UnmapBusAddress:FAR
		EXTRN	ScheduleRemoteDma:FAR

; PUBLIC data exported by this module

		PUBLIC	baStagingBuffer
%IF(%Debug) THEN(%'
		PUBLIC	cFreeDmaIob
		PUBLIC	cFreeDmaIobMin
)FI%'
		PUBLIC	dma82380Ports
		PUBLIC	oFreeDmaIob
		PUBLIC	rgOActiveDmaIob

Data		SEGMENT


baStagingBuffer	DD	0
%IF(%Debug) THEN(%'
cFreeDmaIob	DW	?
cFreeDmaIobMin	DW	?
)FI%'
dma82380Ports	dma82380PortsType<>
oFreeDmaIob	DW	0
rgOActiveDmaIob	DW	8 DUP(0)

Data		ENDS

; PRIVATE, STATIC data global within this module

%IF(%Debug) THEN(%'
		PUBLIC	cLocalDma
		PUBLIC	cLocalDmaInt
		PUBLIC	cRemoteDma
		PUBLIC	cRemoteDmaInt
		PUBLIC	cMisalignedDmaIn
		PUBLIC	cMisalignedDmaOut
		PUBLIC	cbLocalDma
		PUBLIC	cbRemoteDma
		PUBLIC	cbMisalignedDmaIn
		PUBLIC	cbMisalignedDmaOut
		PUBLIC	fLocalDmaIntActive
		PUBLIC	fRemoteDmaIntActive
		PUBLIC	fStartLocalDmaActive
		PUBLIC	fStartRemoteDmaActive
		PUBLIC	oQueuedDmaIob
)FI%'

Data		SEGMENT

%IF(%Debug) THEN(%'
cLocalDma	DD	0
cLocalDmaInt	DD	0
cRemoteDma	DD	0
cRemoteDmaInt	DD	0
cMisalignedDmaIn DD	0
cMisalignedDmaOut DD	0
cbLocalDma	DD	0
cbRemoteDma	DD	0
cbMisalignedDmaIn DD	0
cbMisalignedDmaOut DD	0
fLocalDmaIntActive DB	0
fRemoteDmaIntActive DB	0
fStartLocalDmaActive DB	0
fStartRemoteDmaActive DB 0
)FI%'
oQueuedDmaIob	DW	0
pRgOActiveDmaIob DD	rgOActiveDmaIob

Data		ENDS

; Error return codes used by this module

ercOddByteBufferAddress EQU	234
ercNoFreeIob		EQU	303
ercNoRemoteDma		EQU 120
$EJECT

DmaMover_MfP	SEGMENT

		ASSUME	CS:DmaMover_MfP
		ASSUME	DS:Data

;-------------------------------------------------------------------------------
; When a client wishes to transfer data locally or remotely via DMA, it prepares
; fields in a parameter block used by the DMA mover and then calls a system
; common procedure.  The parameter block supplied is copied to an Iob retained
; by the DMA mover and is queued along with other DMA moves awaiting an
; available 82380 channel.  The "DmaTransfer" interface is public and available
; to system services and other applications; note that this  interface does not
; allow the user to request the "completion procedure" form of the DMA move, but
; only to receive a completion message at a specified exchange.  The
; "DmaTransferForMassIo" interface is private to CTOS and is used by ICC and
; MassIo, to give two examples.  It allows the client to specify whether DMA
; move completion is to be signalled by a message sent to an exchange or by a
; call to a completion procedure.

; DmaTransfer: PROCEDURE(oIob) ercType REENTRANT PUBLIC;
; DECLARE oIob OFFSET, iob BASED oIob iobDmaType;

oIob		EQU	WORD PTR 6[BP]
clientDS	EQU	WORD PTR -2[BP]

DmaTransfer	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	DS			;Save client's DS for return
		MOV	DX,DS			;Transfer client's DS to FS
		MOV	FS,DX
		MOV	SI,oIob			;Pass Iob reference in FS:[SI]
		AND	ctrlFlags[SI],mApplicationFlags
		JMP	SHORT QueueDmaIob	;Erc returned in AX

DmaTransfer	ENDP

; DmaTransferForMassIo: PROCEDURE(oIob) ercType REENTRANT PUBLIC;
; DECLARE oIob OFFSET, iob BASED oIob iobDmaType;

DmaTransferForMassIo PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	DS			;Save client's DS for return
		MOV	DX,SS			;Transfer client's SS to FS
		MOV	FS,DX
		MOV	SI,oIob			;Pass Iob reference in FS:[SI]
		AND	SS:ctrlFlags[SI],mCtosFlags
;		JMP	SHORT QueueDmaIob	;Erc returned in AX

DmaTransferForMassIo ENDP
$EJECT

;-------------------------------------------------------------------------------
; Try to obtain a local Iob to make a copy of the parameter block supplied by
; the client and then queue this Iob along with any others awaiting service.
; Critical sections with the DMA interrupt service are enforced by
; disabling/enabling interrupts; this is more efficient than masking off both
; the local 82380 DMA interrupt and the MegaBus DMA interrupt.  Once the Iob is
; queued, try to start any waiting DMA on any free channel.

; Register usage:
;		DS:[BX]	--> Iob
;		FS:[SI]	--> Client's Iob (FS, SI passed on entry)

QueueDmaIob	PROC	FAR

		MOV	DX,DGroup	;Switch to our own DGroup
		MOV	DS,DX
		CLI			;Critical section for free Iob
		MOV	BX,oFreeDmaIob
		OR	BX,BX
		 JE	SHORT NoFreeIob
		MOV	AX,chain[BX]
		MOV	oFreeDmaIob,AX
%IF(%Debug) THEN(%'
		MOV	AX,cFreeDmaIob
		DEC	AX
		MOV	cFreeDmaIob,AX
		CMP	AX,cFreeDmaIobMin
		 JAE	CopyParamBlock
		MOV	cFreeDmaIobMin,AX
CopyParamBlock:
)FI%'
		STI
		MOV	DX,DS		;Copy parameter block to local Iob
		MOV	ES,DX
		MOV	DI,BX
		MOV	ECX,sDmaIob SHR 1
		CLD
		ROR	ECX,1		;Word count MOD 2 into high part of ECX
		DB	0F3h,64h	;REP and FS: segment override prefixes
		MOVSD			;DWORD move Iob to local variable
		ROL	ECX,1
		DB	0F3h,64h	;REP and FS: segment override prefixes
		MOVSW			;WORD move remainder of Iob
		MOV	FS,CX		;Clear FS in case selector deallocated
		MOV	chain[BX],CX	;Clear the link field
		MOV	CX,clientDS	;Save caller's DS for later
		MOV	userDS[BX],CX
		CMP	slotId[BX],0		;Is this a remote request?
		 JE	SHORT MapRequester	;No, local
		MOV	AL,bMySlot		;"Pseudo" remote request?
		CMP	slotId[BX],AL
		 JE	SHORT ForceLocalDma	;Yes, talking to ourselves
		JMP	MapTarget

ForceLocalDma:	MOV	slotId[BX],0	;Good! Any free channel can be used
MapRequester:	TEST	ctrlFlags[BX],mRequesterMapped
		 JNZ	SHORT MapTarget	;Requester already mapped

		TEST BYTE PTR vf_f82380, 0FFh
		JZ   MapTarget

		PUSH	BX		;Save BX through system common call
		PUSH	pRequester[BX]
		PUSH	xferLength[BX]
		PUSH	0		;No DMA fences on the GP
		LEA	AX,baRequester[BX]
		PUSH	DS
		PUSH	AX
		LEA	AX,xferLength[BX]
		PUSH	DS
		PUSH	AX
		CALL	MapBusAddress	;Activate mapper slots for requester
		POP	BX
		OR	AX,AX
		 JNZ	SHORT FreeIobOnError
MapTarget:	TEST	ctrlFlags[BX],mTargetMapped
		 JNZ	SHORT CheckAlignment	;Target already mapped

		CMP	slotId[BX],0		;Is this a remote request?
		 JE	SHORT CheckAlignment	;No, local
		MOV	AL,bMySlot		;"Pseudo" remote request?
		CMP	slotId[BX],AL
		 JE	CheckAlignment	;Yes, talking to ourselves

		PUSH	BX		;Save BX through system common call
		PUSH	pTarget[BX]
		PUSH	xferLength[BX]
		PUSH	0		;No DMA fences on the GP
		LEA	AX,baTarget[BX]
		PUSH	DS
		PUSH	AX
		LEA	AX,xferLength[BX]
		PUSH	DS
		PUSH	AX
		CALL	MapBusAddress	;Activate mapper slots for target
		POP	BX
		OR	AX,AX
		 JNZ	SHORT FreeIobOnError
CheckAlignment:	CMP	slotId[BX],0		;Remote DMA?
		 JE	SHORT AddIobToQueue	;No, alignment doesn't matter
		TEST	vf_fXe, 0FFh
		 JZ	AddIobToQueue
		MOV	AL,baRequester[BX]	;See if local and remote match
		XOR	AL,baTarget[BX]		
		TEST	AL,11b			;Two least significant bits...
		 JZ	SHORT AddIobToQueue	;Alignment OK, rejoin mainstream
		OR	ctrlFlags[BX],mStageDma	;Misaligned, do two DMA moves
AddIobToQueue:	CLI			;Critical section
		LEA	AX,oQueuedDmaIob
ScanIobs:	MOV	DI,AX		;DI --> previous Iob
		MOV	AX,chain[DI]	;End of the queue?
		OR	AX,AX
		 JNZ	ScanIobs	;No, advance to next Iob
		MOV	chain[DI],BX	;Link the new Iob at the end
		STI
		CALL	StartPendingDma	;OK, now go start DMA if we can
		XOR	AX,AX		;Clear error return code
ExitQueueDmaIob:POP	DS		;Restore client's DS
		POP	BP
		RET	2

NoFreeIob:	STI
		MOV	AX,ercNoFreeIob
		JMP	ExitQueueDmaIob

FreeIobOnError:	CLI
		MOV	DX,oFreeDmaIob	;Return Iob to the free list
		MOV	chain[BX],DX
		MOV	oFreeDmaIob,BX
%IF(%Debug) THEN(%'
		INC	cFreeDmaIob
)FI%'		
		STI
		JMP	ExitQueueDmaIob	;Erc is already in AX

QueueDmaIob	ENDP
$EJECT

;-------------------------------------------------------------------------------
; The search for an eligible DMA to start continues as long as a) there are DMA
; Iob's queued and awaiting processing and b) there are DMA channels free that
; can (potentially) service them.  Only the MegaBus channel can handle remote
; DMA, while any of the eight channels can handle local DMA.  Free channels are
; most likely to be found above the MegaBus channel, so the search is conducted
; from the end of the array of active Iob's backwards.  DMA channels that are
; reserved to other uses (e.g. RS-422, the parallel port or SCSI) are marked in
; the array by initialization code with a sentinel value of 0FFFFh; these
; channels NEVER become available for the DMA mover.  If an idle DMA channel is
; found and it is the MegaBus channel, any waiting Iob may be serviced, either
; local or remote.  When idle channels are found that can only handle local DMA,
; the queue of Iob's must be searched to see if any waiting requests are for
; local DMA.  When a local or remote DMA may be started, copy the channel number
; into the Iob for later reference.  Note that for remote DMA, the remote and
; local buffer alignments within a DWORD must match.  If they don't, this
; hardware limitation is circumvented by performing two DMA transfers: one
; between the remote location and a private staging buffer (address alignment
; is forced) and a second, local transfer between the staging buffer and the
; user specified local buffer.

; Register usage:
;		DS:[BX]	--> iob
;		CX	iChannel
;		ES:[DI]	--> rgOActiveDmaIob(iChannel)
;		DS:[SI]	--> prevIob

StartPendingDma	PROC	NEAR

		MOV	CX,LENGTH rgOActiveDmaIob
		JMP	SHORT SearchDma

LocalDma:	CALL	StartLocalDma		;Eligible channel and Iob
SearchDma:	DEC	CX			;Move down through channels
		 JS	SHORT ExitStartPendingDma	;Nope, can't continue
		LEA	SI,oQueuedDmaIob	;Reference to previous Iob
		CLI				;Critical section
		CMP	chain[SI],0			;Any work waiting?
		 JE	SHORT ExitStartPendingDma	;Nope, all done
		MOV	BX,chain[SI]		;Reference first Iob in queue
		CMP	slotId[BX],0		; Not local?
		 JNE	IobAccept
		LES	DI,pRgOActiveDmaIob	;Prepare ES:[DI] for scan
		ADD	DI,CX			;Index to scan start point
		ADD	DI,CX
		INC	CX			;Adjust CX for scan count
		XOR	AX,AX			;Free channels marked with zero
		STD
		REPNZ SCASW
		 JNZ	SHORT ExitStartPendingDma	;No channels are free
		ADD	DI,2			;Adjust [DI] --> free channel
;		CMP	CX,dmaMegaBus		;Is this the MegaBus channel?
;		 JE	SHORT EligibleIob	;Yes, can do local and remote
;SearchLocalIob:	CMP	slotId[BX],0		;Remote slot specified?
;		 JE	SHORT EligibleIob	;OK, this is a local request
;		MOV	SI,BX			;Make current Iob previous
;		MOV	BX,chain[SI]		;And advance to the next
;		OR	BX,BX
;		 JNZ	SearchLocalIob
;		STI				;No local DMA Iob's in queue
;		SUB	CX,dmaMegaBus		;Already past MegaBus channel?
;		 JB	SHORT ExitStartPendingDma	;No other will work
;		SHL	CX,1			;Skip directly to MegaBus
;		SUB	DI,CX
;		CLI
;		CMP	WORD PTR ES:[DI],0	;Is the MegaBus available?
;		 JNE	SHORT ExitStartPendingDma	;No, OK to give up
EligibleIob:	MOV	ES:[DI],BX		;Update rgOActiveDmaIob
IobAccept:
		MOV	AX,chain[BX]		;Unlink it from the queue
		MOV	chain[SI],AX
		STI				;End of critical section
		CMP	slotId[BX],0		;Local DMA?
		 JE	LocalDma		;Yes, go start it
;		TEST	ctrlFlags[BX],mStageDma	;Is staged DMA required?
;		 JZ	SHORT RemoteDma		;No, initiate MegaBus DMA
;		TEST	ctrlFlags[BX],mTargetWrite	;Must stage, but when?
;		 JZ	LocalDma			;Source local, align now
RemoteDma:
		PUSH	CX
		PUSH	DS
		PUSH	BX
		CALL	ScheduleRemoteDma;(pIob)
		POP	CX
		JMP	SearchDma

ExitStartPendingDma:
		STI				;Leave the critical section
		RET

StartPendingDma	ENDP
$EJECT

;------------------------------------------------------------------------------
; Register usage:
;		DS:[BX]	--> iob
;		CX	iChannel
;		SI	iChannel SHL 1
WorkstationMove	PROC	NEAR

	PUSH DS
	PUSH SI
	MOVZX ECX, xferLength[BX]
	MOV  AL, ctrlFlags[BX]
; Write from Requester to Target
	LES DI, pTarget[BX]
	LDS SI, pRequester[BX]
ASSUME DS:Nothing, ES:Nothing
	TEST AL, mTargetWrite
	JNZ  WMMove
; Read from Target to Requester
	XCHG SI, DI
	PUSH DS
	PUSH ES
	POP DS
	POP ES
WMMove:
	CLD
	ROR ECX, 2
	REP MOVSD
	ROL ECX, 2
	REP MOVSB

	POP SI
	POP DS
	ASSUME	DS:Data
%IF(%Debug) THEN(%'
		DEC	fStartLocalDmaActive
)FI%'
	MOV	rgOActiveDmaIob[SI],0	;Clear rgOActiveDmaIob(iChannel)
	CALL	MoveComplete		;Common completion procedures
	MOV	CX,LENGTH rgOActiveDmaIob
	RET

WorkstationMove	ENDP
$EJECT

;------------------------------------------------------------------------------
; This procedure is called when an eligible channel has been assigned to an Iob
; for a local DMA move.  Program the target and requester bus address for
; autoincrement, set up the transfer count and then start the DMA transfer.
; Note that it is essential to user the 82380 Single Transfer mode: either Block
; or Demand mode will, if the transfer length is longer than 64 bytes, keep the
; system bus occupied so long that other boards in the SRP will detect bus
; timeouts if they attempt to access this board's memory.  The 82380 generates a
; software interrupt when the DMA transfer has completed. */

; Register usage:
;		DS:[BX]	--> iob
;		CX	iChannel
;		SI	iChannel SHL 1; later (iChannel MOD 4) SHL 1

StartLocalDma	PROC	NEAR

%IF(%Debug) THEN(%'
		INC	fStartLocalDmaActive
)FI%'
;		CMP	CX,dmaMegaBus
;		 JNE	SHORT NotMegaBus
;		MOV	DX,dmaRemoteEnable
;		XOR	AL,AL
;		OUT	DX,AL			;Make sure PAL's are quiescent
NotMegaBus:	MOV	SI,CX			;Create channel index
		SHL	SI,1
		TEST BYTE PTR vf_f82380, 0FFh
		JNZ has82380
		JMP WorkstationMove
has82380:
		MOV	EAX,baTarget[BX]
		MOV	DX,dma82380Ports[SI].targetAddrLow
		CLI
		OUT	dmaClearFlipFlop,AL
		OUT	DX,AL
		MOV	AL,AH
		OUT	DX,AL
		MOV	DX,dma82380Ports[SI].targetAddrHighB
		SHR	EAX,16
		XCHG	AH,AL
		AND	AL,7			;HW ENGINEERING KLUGE
		OUT	DX,AL
		STI
		MOV	AL,AH
		MOV	DX,dma82380Ports[SI].targetAddrHighA
		OUT	DX,AL
		MOV	AX,xferLength[BX]	;Program byte count minus one
		DEC	AX
		MOV	DX,dma82380Ports[SI].byteCountLow
		CLI
		OUT	dmaClearFlipFlop,AL
		OUT	DX,AL
		MOV	AL,AH
		OUT	DX,AL
		STI
		TEST	ctrlFlags[BX],mStageDma	;Local DMA with staging buffer?
		 JZ	SHORT NonStagedLocal
%IF(%Debug) THEN(%'
		INC	cMisalignedDmaOut
		DB	66h			;Assembler bug
		MOVZX	EAX,xferLength[BX]
		ADD	cbMisalignedDmaOut,EAX
)FI%'
		MOV	EAX,baRequester[BX]
		AND	EAX,11b			;Alignment within DWORD relevant
		ADD	EAX,baStagingBuffer	;Force same alignment as remote
		JMP	SHORT ReqAddress	;Rejoin common logic

NonStagedLocal:
%IF(%Debug) THEN(%'
		INC	cLocalDma
		DB	66h			;Assembler bug
		MOVZX	EAX,xferLength[BX]
		ADD	cbLocalDma,EAX
)FI%'
		MOV	EAX,baRequester[BX]	;Program the requester address
ReqAddress:	MOV	DX,dma82380Ports[SI].requesterAddrLow
		CLI
		OUT	dmaClearFlipFlop,AL
		OUT	DX,AL
		MOV	AL,AH
		OUT	DX,AL
		SHR	EAX,16
		MOV	DX,dma82380Ports[SI].requesterAddrHigh
		OUT	DX,AL
		MOV	AL,AH
		AND	AL,7			;HW ENGINEERING KLUGE
		OUT	DX,AL
		STI
		SHR	SI,3			;Now need group index
		SHL	SI,1
		MOV	AL,CL			;Subgroup index to channel
		AND	AL,03h
		OR	AL,dmaSingleXferMode OR incrTarget
		MOV	AH,dmaXferWrite
		TEST	ctrlFlags[BX],mTargetWrite
		 JNZ	SHORT ModeRegILocal
		MOV	AH,dmaXferRead
ModeRegILocal:	OR	AL,AH
		MOV	DX,dma82380Ports[SI].modeRegI
		OUT	DX,AL
		AND	AL,03h			;Preserve subgroup index, only
		OR	AL,twoCycleXfer OR requesterMemory OR targetMemory OR incrRequester
		MOV	DX,dma82380Ports[SI].modeRegII
		OUT	DX,AL
		AND	AL,03h
		OR	AL,requester32Bit OR target32Bit
		MOV	DX,dma82380Ports[SI].busSize
		OUT	DX,AL
		AND	AL,03h
;		OR	AL,clearMask		;Zero means clear the mask
		MOV	DX,dma82380Ports[SI].channelMask
		OUT	DX,AL
;		AND	AL,03h			;Bits 7 through 2 already zero
		OR	AL,requestDMA
		MOV	DX,dma82380Ports[SI].softwareRq
		OUT	DX,AL			;Start the DMA
%IF(%Debug) THEN(%'
		DEC	fStartLocalDmaActive
)FI%'
		RET

StartLocalDma	ENDP
$EJECT

;------------------------------------------------------------------------------
; Software DMA interrupts are triggered by the underflow of the byte count from
; zero to 0FFFFh on an 82380 channel that was started by an assertion of
; software DMA request.  Determine which channel(s) have interrupted and
; service the completing Iob.  Note that the terminal count (TC) bit may be
; active for channels that do not have any software transfer in progress.

; Stack frame usage:
tcStatus	EQU	BYTE PTR -2[BP]
iChannel	EQU	WORD PTR -4[BP]

; Register usage:
;		DS:[BX]	--> iob



SoftwareDmaInterrupt PROC FAR

		ENTER	4,0
%IF(%Debug) THEN(%'
		INC	fLocalDmaIntActive
		INC	cLocalDmaInt
)FI%'
		OUT	dmaClearTCIntRq,AL	;Clear pending INT's
		IN	AL,dmaCh4To7ChannelStatus
		SHL	AL,4		;Channels 0 - 3 are not available
		MOV	tcStatus,AL
		MOV	iChannel,8		;Start at highest channel...
NextChannel:	DEC	iChannel		;...and work down
		SHL	tcStatus,1		;This channel complete?
		 JC	SHORT SoftwareTC	;Yes, see if an Iob is active
		 JNZ	NextChannel		;No, but other channels done
		CALL	StartPendingDma		;No channels left to check
%IF(%Debug) THEN(%'
		DEC	fLocalDmaIntActive
)FI%'
		LEAVE
		RET

SoftwareTC:	MOV	DI,iChannel	;See if this channel is active
		SHL	DI,1
		MOV	BX,rgOActiveDmaIob[DI]
		CMP	BX,0FFFFh
		 JE	NextChannel	;Channel unavailable for DMA mover
		OR	BX,BX
		 JZ	NextChannel	;Channel idle
;		TEST	ctrlFlags[BX],mStageDma	;First part of staged DMA?
;		 JNZ	SHORT Stage1Outbound	;Yes, stage 1 complete
		CMP	slotId[BX],0		;Local DMA?
		 JNE	NextChannel
		MOV	rgOActiveDmaIob[DI],0	;Clear rgOActiveDmaIob(iChannel)
;		CMP	iChannel,dmaMegaBus	;MegaBus channel used for local?
;		 JNE	SHORT SfwUnmapReq
;		XOR	AX,AX			;Yes, clear INT from DMA PALs
;		MOV	DX,dmaRemoteEnable
;		OUT	DX,AL
SfwUnmapReq:	TEST	ctrlFlags[BX],mRequesterMapped
		 JNZ	SHORT SfwComplete
		PUSH	BX
		PUSH	baRequester[BX]	;Ditto
		CALL	UnmapBusAddress
		POP	BX
		OR	AX,AX
		 JNE	SHORT SfwUnmapFailed
SfwComplete:	CALL	MoveComplete
		JMP	NextChannel

SfwUnmapFailed:	PUSH	AX
		CALL	Crash

SoftwareDmaInterrupt ENDP
$EJECT

;------------------------------------------------------------------------------
; Icc dma completion proc
; DmaMoveComplete:PROCEDURE(pIob);
;
DmaMoveComplete	PROC	FAR
	ENTER	0,0
	LDS	BX, DWORD PTR [BP+6]
	CALL	MoveComplete
	LEAVE
	RET	4
DmaMoveComplete ENDP
$EJECT

;------------------------------------------------------------------------------
; Common completion procedure for both software dma and Workstation MOVSD
; service.  According to the 'mCompletionProc' bit in the Iob, either send a
; token to the specified exchange or call a user completion procedure with
; a 16-bit "handle" pushed on the stack.  Then deallocate the Iob and return.

; Register usage:
;		DS:[BX]	--> iob

MoveComplete	PROC	NEAR

		TEST	ctrlFlags[BX],mTargetMapped
		 JNZ	SHORT ChkComplProc
		PUSH	BX
		PUSH	baTarget[BX]		;We mapped this, we unmap it
		CALL	UnmapBusAddress
		POP	BX
		OR	AX,AX
		 JNZ	UnmapFailed
ChkComplProc:	TEST	ctrlFlags[BX],mCompletionProc
		 JNZ	SHORT UserComplProc
UserComplMsg:	PUSH	BX
		PUSH	completionExch[BX]
		PUSH	pCompletionMsg[BX]
		CALL	KSend
		POP	BX
		JMP	SHORT DeallocateIob

UserComplProc:	MOV	DX,DS		;Set up ES to replace DS
		MOV	ES,DX
		MOV	DS,userDS[BX]	;Switch to user's DS
		PUSH	BX		;Save offset of current Iob
		PUSH	ES:completionExch[BX]
		CALL	DWORD PTR ES:pCompletionMsg[BX]
		POP	BX		;Restore --> Iob
		MOV	DX,DGroup	;Restore our own DS
		MOV	DS,DX
DeallocateIob:	CLI
		MOV	AX,oFreeDmaIob
		MOV	chain[BX],AX
		MOV	oFreeDmaIob,BX
%IF(%Debug) THEN(%'		
		INC	cFreeDmaIob
)FI%'
		STI
		RET

UnmapFailed:	PUSH	AX
		CALL	Crash

MoveComplete	ENDP

DmaMover_MfP	ENDS
$EJECT

;------------------------------------------------------------------------------
; Modification History
;
;	19 JUL 88 by PGJ	Initial release for CTOS/VM 3.0
;	06 APR 89 by MTR	'iob.xferLength' is bytes; not words
;	12 MAY 89 by PGJ	New parameter block (DMA "Iob") is passed
;	23 MAY 89 by PGJ	Hardware design of DMA completely reworked
;	13 JUN 89 by PGJ	Translate to assembler for optimization,
;				add staging of misaligned MegaBus DMA
;	25 JUL 89 by MTR	Critical region (NMI) fixes
;	26 JUL 89 by MTR	DmaTransferForMassIo's oDmaIob is SS:, not DS:
;	30 DEC 89 by MTR	HW engineering kluge: never set top 5 bits in
;				82380 address
;	03 JAN 90 by MTR	Debugging code
;	16 MAR 90 by  AT	Set dma82380PortsType
;	28 APR 92 by  JA	WorkstationMove for PC/Comarch.
;	08 FEB 93 by  JA	DmaMoveComplete for Icc on PC.
;	02 MAR 93 by  JM    do MapBusAddress iff vf.f82380.
;	17 MAY 93 by  JA    do MapBusAddress in MapTarget iff remote dma.
;
;------------------------------------------------------------------------------

		END
