; file: CompatibleSubs.asm
;
; Miscellaneous procedures used primarily to shorten code
; in PLM modules.  This module isolates procedures having
; different implementations in real and protected modes.
;
; 4/10/86  DR - derived form CommonSubs.asm
; 2/26/87  JA - FRealUser use asib.fRealMode
; 3/19/87  DR - GetLdtr, GetLdtAlias use asib.sgLdtr, asib.sgStack
; 3/25/87  DR - use ValidateCanonicalUser to check usernum 0/1 for
;               all system common 
; 5/11/87  JA - push ercNoFreeSelectorName
; CTOS VM 3.0
; 10/6/87  JA - Asib,Arib now selector-based.
; 10/16/87 JA - FRealUser notice sgAsib=0, return false.
; 10/19/87 JA - SetStructure take long pointer.
; 05/04/88 DR - PaFromSn support for 386i
; 08/31/88 AT - 10-bit userNums, masking of slot bits.
; 09/14/88 MTR- ExUcbs out of Dgroup.
; 09/26/88 JA - use vf_f386..., SaFromSn use baseLinearOffset so GP works.
; 10/31/88 JA/KH - fix SaFromSn.
; 03/06/89 PGJ - mask slotID out of userNum in GetLdtr
; 05/22/89 AT - QueryCoprocessor for 186 SRP boards.
; 06/01/89 JA - added Movsb386, EccScrub.
; 07/14/89 JA - added EccScrubNext.
; 09/25/89 MTR- added BoundsTest.
; 09/27/89 JMR - added OS protection for FRealUser, GetLdtr UserNumber =< 0.
; 10/10/89 MTR- use ONextUserPcb.
; 10/31/89 JMR/mtr - ValidateUser treats nil slot bits = my slot bits
; 11/14/89 JM - use FadsTypesAsm.edf.
; 12/15/89 JWF - Implement PaFromLa to use page table instead of 
;				baseLinearOffset. Change PaFromSn to use PaFromLa. 
;				NOTE: PaFromLa should return an erc!
; 01/25/89 DR - remove EXTRN sgTmp
; 03/06/90 JM - use rgsgLdt instead of asib.sgLdtr in GetLdtr so don't
;				have to deal with different asib types.
; 03/10/90 DR - for v series, remove SaFromSn and PaFromSn to SegAccess and
;               restore old p series code   
;             - p series does nothing for PaFromLa
; 03/14/90 MTR- Movsb386 tests vf_f386, add FS version of Movsb386
; 04/18/90 DR - use sgZero
; 04/24/90 JM - allow GetLdtAlias to be called with user DS - it's called from
;				system common PaFromP.
; 05/10/90 JM - fix ValidateUserNum to ret 2, not 4.
; 05/23/90 JM - fix SaFromSn gp fault.
; 09/28/90 DR - ReloadTr (support for ResizeIoMap)
; 01/15/91 DR - support ErcPaFromLa for p series (for DefineLocalPageMap)
; 01/17/91 DR - support Fetch/Store32 for p series (for MapPhysicalAddress)
; 01/21/91 DR - support MappedPaFromLa for p series (for MapPhysicalAddress)
; 01/24/91 JF - LoadLdt(ldt) routine created.  Loads parameter into LDT 
;				register.  Called by Traps.plm to load sgLdtOs.
;				SetLdtrDS sets default system ldt sgLdtOs if 0 argued.
; 03/07/91 JF - Fix GetLdtr -- leaves with OsLdtr in AX if OS
; 03/09/91 MTR- Add OsFetchLdtr
; 05/17/91 JM-  BoundsTest works on expand down segments.
; 06/-3/91 JM   add QSnLimit.
; 07/16/91 DR   ammend QSnLimit to workaround 386 errata (LSL followed by PUSH)
; 08/07/91 JM   replace ILockUser with ILockIntHandler
; 11/13/91 DR   BIOS video routines
; 03/24/92 JM   return UserNumCurrent.
; 03/04/93 JM	DmaAddrFromP
; 04/02/93 JM   add dummy AllocMemoryInit for FS.
; 06/17/93 JM   change DmaAddrFromP bounds check from 32MB to 128MB.
; 07/19/93 sg/JA  check usernum in fRealuser > nParDesc.


%IF(NOT %*IsDef(%ctosv)) THEN (%SET(ctosv,0))FI

$include(:f1:vfequ.idf)
$include(:f1:descriptors.mdf)

%' DWord if ctosP
%DEFINE(DifP)(%'
%IF(%ctosp) THEN (
	db 66h
)FI)

%DEFINE(REP)(%'
	DB 0F3h
)

%*DEFINE(RepMOVSB) (%'
%IF(%ctosp) THEN (
%DifP ROR	CX, 2	; Hide quad-alignment bits (2 bits) in top of ECX.
%REP %DifP MOVSW	; CX used for count, NOT ECX.
%DifP ROL	CX, 2	; Restore alignment bits to zeroed CX.
REP	MOVSB			; CX used for count, NOT ECX.  Moves 0-3 bytes.
)ELSE(%'
	SHR	CX, 1
REP	MOVSW
	RCL	CX, 1
REP	MOVSB
)FI%' NOT ctosp
)

data segment public 'data'
%IF (%fs) THEN(%'
EXTRN pVf: DWORD
)ELSE(%'
EXTRN wMySlotBits: WORD
extrn vf:byte
%if(%ctosp)then(
extrn baseLinearOffset:byte
extrn sgFreeHead:word
extrn sgFreeTail:word
extrn oPcbRun: word
extrn nParDesc:word
extrn pRgOExUcb:dword
extrn rgsgAsib:word
extrn plaEndMemory:dword
extrn processorType:byte
extrn prgsgLdt:dword
extrn paGlobalPagemap:dword
extrn sgLdtOs:word
extrn sgTssIntLast:word

ercBadPartitionHandle	EQU	803
ercNotAddressable	EQU	408
ercNotImplemented equ 7

;	ExUcb
oParDesc	EQU	0
cMassIoRq	EQU	2

$INCLUDE(:f1:fadsTypesAsm.edf)

public cSlotsAlloc, cSlotsAllocMax
cSlotsAlloc dw 0
cSlotsAllocMax dw 0

public bCoprocessorStatus
bCoprocessorStatus db 0

SpSave		EQU	4H
maskRealMode equ 1
maskNotRealMode equ 0FFFEh

plaWash DD 0		;for EccScrubNext

)else(
extrn plaEndMemory:word
plaWash DW 0		;for EccScrubNext

)fi
%if(not %ctosv)then(
public sgAltZero
sgAltZero dw 0
)fi


%SET(Debug,1)
%IF (%Debug) THEN(
PUBLIC sgDaDebug, laDaDebug, paDaDebug
sgDaDebug 	DW 0ffffh
laDaDebug 	DW 0ffffh,0ffffh
paDaDebug 	DW 0ffffh,0ffffh
)FI

)FI%'NOT fs

data ends

dgroup group data

%IF (NOT %fs) THEN(%'
PUBLIC PointersEqual

%if (%ctosp) then(
extrn FEqP:far
extrn Crash:far
extrn CheckPSlot:far
extrn BuildGdtSlot:far
extrn GlaFromP:far
extrn MapGlaISlot:far
extrn FarAliasIpcSr:far
)fi
%if (%ctosv) then(
extrn MapGlaPPdh:far
extrn CallBios:far
)fi
extrn AllocP:far
extrn AllocSgFromPla:far
extrn ONextUserPcb:far
extrn ReleaseP:far
extrn ReleaseSg:far
)ELSE(%'fs
extrn Crash:far
)FI

CommonSubs_Code	SEGMENT	PUBLIC 'CODE'     

assume CS:CommonSubs_Code, DS:Nothing

%if(not %ctosv)then(
public ILockIntHandler
ILockIntHandler proc far
	xor ax, ax
	ret 6
ILockIntHandler endp
)fi

public SsRaFromO

SsRaFromO proc far
	push bp
	mov  bp, sp
	mov bx, word ptr [bp+6]
	push ss
	pop es
	pop  bp
	ret 2	
SsRaFromO endp

public Movsb386

Movsb386 proc far
; procedure (p1, p2, cb)
;
; Ala pl/m movb, but uses dword move if hardware allows.
; Not interrupt disabled, can only movsd if 386 tss preserves ECX.
; May be called with DS <> DGroup.
argP1 EQU DWORD PTR [BP+12]
argP2 EQU DWORD PTR [BP+8]
argCb EQU WORD PTR [BP+6]
	push	bp
	mov		bp, sp
	push	ds
%IF (%ctosp) THEN(%'
	mov		ax, DGroup
	mov		ds, ax
assume ds: DGroup
%IF (%fs) THEN(%'
	les		di, pVf
vf equ byte ptr es:[di]
)FI%'
	test	vf_f386Tss, 1	; Set ZF for test...
assume ds: Nothing
)FI%'
	lds		si, argP1
	les		di, argP2
	cld
%IF (%ctosp) THEN(%'
	jz		Movsb386Ala186	;...here

	%DifP xor cx, cx		; Prepare ECX for MOVSD
	mov		cx, argCb
	%DifP ror cx, 2			; Hide quad-alignment bits (2 bits) in top of ECX.
	%rep %DifP movsw		; CX used for count, NOT ECX.
	%DifP rol cx, 2			; Restore alignment bits to zeroed CX.
	rep movsb				; CX used for count, NOT ECX.  Moves 0-3 bytes.
	jmp		short Movsb386Ret
Movsb386Ala186:
)FI%'
	mov		cx, argCb
	shr		cx, 1
	rep movsw
	rcl		cx, 1
	rep movsb

Movsb386Ret:
	pop		ds
	pop		bp
	ret		10
Movsb386 endp

%if(not %fs)then(

; PointersEqual: PROCEDURE(p1, p2) FLAG;
p1Low		EQU		WORD PTR [BP+6]
p1High		EQU		WORD PTR [BP+8]
p2Low		EQU		WORD PTR [BP+10]
p2High		EQU		WORD PTR [BP+12]

PointersEqual				PROC		FAR
; calls to this should be replaced with calls to fEqP
	PUSH		BP				;Save BP
	MOV		BP,SP
%if(%ctosp) then(
	push p2high
	push p2low
	push p1high
	push p1low
	call FEqP
) else (
	MOV		SI,p1High
	MOV		CL,4
	MOV		AX,p1Low
	SHR		AX,CL
	ADD		SI,AX				;SI = address p1 shifted right 4
	MOV		DI,p2High
	MOV		AX,p2Low
	SHR		AX,CL
	ADD		DI,AX				;DI = address p2 shifted right 4
	CMP		SI,DI
	JNE		PointersNotEqual

	MOV		AX,0FFh				;Assume pointers are equal
	MOV		DX,p1Low
	AND		DX,0FH
	MOV		BX,p2Low
	AND		BX,0FH
	CMP		BL,DL
	JZ		PointersAreEqual
PointersNotEqual:
	XOR		AX,AX
PointersAreEqual:
)fi
	POP		BP
	RET		8
PointersEqual				ENDP

public QFetchScat
QFetchScat proc far
; procedure (p) quad
	push bp
	mov  bp, sp
	pushf
	cli
	les  bx, dword ptr [bp+6]
	mov  ax, word ptr es:[bx]
	mov  dx, word ptr es:[bx+2]
	popf
	pop  bp
	ret  4
QFetchScat endp

public StoreQScat
StoreQScat proc far
; procedure (p,q) quad
	push bp
	mov  bp, sp
	pushf
	cli
	les  bx, dword ptr [bp+10]
	mov  ax, word ptr [bp+6]	
	mov  word ptr es:[bx], ax
	mov  ax, word ptr [bp+8]	
	mov  word ptr es:[bx+2], ax
	popf
	pop  bp
	ret  8
StoreQScat endp

public fSwapRealMask
FSwapRealMask proc far
%if(%ctosp)then(
	push		bp
	mov		bp, sp
	push		ds
	mov		ax, DGroup
	mov		ds, ax
assume ds:dgroup
	pushf
	mov		bx, oPcbRun
;*** begin critical region
	cli
	mov		dx, word ptr [bx+spSave]
; set result to current value of real mode bit
	xor		ax, ax
	test		dx, maskRealMode
	jz		@@1
	dec		ax
; set real mode bit 
@@1: and			dx, maskNotRealMode
	xor		cx, cx
	cmp		byte ptr [bp+6], 0
	je		@@2
	inc		cx
	or		dx, cx
@@2:	mov		word ptr [bx+spSave], dx	
;*** end critical region
	popf
	pop		ds
	pop		bp
assume ds:nothing
)fi
	ret		2
FSwapRealMask endp

PUBLIC SetStructure

SetStructure PROC FAR
argcb EQU 6
argP EQU DWORD PTR 8
argList EQU 12

PUSH BP
MOV BP, SP

LES DI, argP[BP]
MOV CX, argcb[BP]
MOV DX, CX	;save for RET (DX)
LEA SI, argList[BP]
CLD
REP MOVSB

POP BP
POP AX	;IP
POP BX	;CS

;Pop arg words
ADD DX, 1
AND DX, 0FFFEh
ADD SP, DX
PUSH BX
PUSH AX
RET
SetStructure ENDP


%if (%ctosp) then (
$MOD286
; 	513 int 205 instuctions, used for access to request procedural interface
public RqInterfaceVector
RqInterfaceVector proc far
db 513 dup (0CDh)
RqInterfaceVector endp

rsvd  equ 6
ercNoFreeSelectorName  equ 404

public UnthreadSg
UnthreadSg proc far
assume ds:DGroup
; unthread gdt slot from head of free list. To keep
; code simple, crash when sgFreehead=sgFreeTail, that is,
; do not allocate the last sg

	push bp
	mov bp, sp
	pushf
	cli
	mov bx, sgFreeHead
	cmp bx, sgFreeTail
	je NoFreeGdtSlots

	mov ax, sgGdt
	mov es, ax
	mov ax, word ptr es:[bx+rsvd]
	mov word ptr es:[bx+rsvd], 0
	mov sgFreeHead, ax
	mov ax, bx
	
	inc cSlotsAlloc
	mov bx, cSlotsAlloc
	cmp bx , cSlotsAllocMax
	jbe UnthreadSgExit
	mov cSlotsAllocMax, bx

UnthreadSgExit:
	popf
	pop bp
	ret

NoFreeGdtSlots:
	popf
	push ercNoFreeSelectorName
	call crash
UnthreadSg endp

sgFree equ word ptr [bp+6]

public ThreadSg
ThreadSg proc far
assume ds:DGroup
	push bp
	mov bp, sp

%if (0) then (
	push sgFree
	call VerifyFree
)fi

	pushf
	cli

	mov ax, sgGdt
	mov es, ax
	mov bx, sgFreeTail
	mov ax, sgFree
	mov word ptr es:[bx+rsvd], ax
	mov sgFreeTail, ax
; zero access byte
	mov bx, ax
	mov byte ptr es:[bx+5], 0

	dec cSlotsAlloc

	popf
	pop bp
	ret 2
ThreadSg endp

%if (0) then (
$MOD386
; VerifyFree(sgFree)
; verfies that sgFree is not already in the free list
VerifyFree PROC NEAR	
	push   bp
	mov    bp, sp
	mov    ax, word ptr [bp+4]
	push   sgGdt
	pop    es
	pushf
	cli
	db     66h
	movzx  ecx, sgFreeHead
VerifyFreeMore:
	jcxz   VerifyFreeDone
	cmp    cx, ax
	je     VerifyBummer
	mov    cx, word ptr es:[ecx+rsvd]
	jmp    short VerifyFreeMore
VerifyBummer:
	int    3
VerifyFreeDone:
	popf
	pop    bp
	ret    2
VerifyFree ENDP
$MOD286
)fi


public FRealUser
FRealUser proc far
;
; FRealUser: procedure (userNum) flag
;
; returns TRUE (AL = 0FFh) if user is a real mode user
; no other registers corrupted
;
; may enter with any DS

pcbStatus    equ 2
pcbSpSave    equ 4
pcbTss       equ 6 
pcbUserNum   equ 14
pcbSize      equ 18
maskUsed     equ 080H
maskRealMode equ 1
argUserNum   equ word ptr [bp+6]

	push bp
	mov  bp, sp
	push ds
	mov ax, DGroup
	mov ds, ax
ASSUME DS:DGroup
	push bx

	xor  ax, ax
	mov  bx, argUserNum
    cmp  bh, 0FFH
	je   FRealRet	; -1, -2, -3 are OS user numbers, protected mode
    and  bx, 03FFH
	cmp	 bx, nParDesc
	jae	 FRealRet
    shl  bx, 1
    cmp  bx, 0H		;JMR
	jz   FRealRet	;0 is also an OS usernum
	mov  ax, rgsgAsib[bx]
	or   ax, ax
	jz   FRealRet
	mov  ds, ax
ASSUME DS:Nothing
	mov  al, ds:[asibBRealMode]
; if bottom bit(fReal) of bRealMode is 1, return 0FFh else 0.
	ror  al, 1		; fReal now in top bit
	cbw				; fReal now in ah
	mov  al, ah
FRealRet:
	pop  bx
	pop  ds
ASSUME DS:Nothing
	pop	 bp
	ret	2
FRealUser endp


;
; ReadTss: procedure (userNum, rTss, pbRet, cb) 
; 
; Copies data from a TSS of this user at sgTss:rTss to pbRet
;
; assert DS is OS DGroup

; equs used by ReadTss and WriteTss

argUserNum equ word ptr [bp+14]
argrTss    equ word ptr [bp+12]
argPb      equ dword ptr [bp+8]
argCb      equ word ptr [bp+6]

public ReadTss
ReadTss proc far
	push		bp
	mov		bp, sp
	push		0
	jmp 		short AccessTss
ReadTssExit:
	push		ds
	mov		ds, ax
assume ds:nothing
	mov		si, argrTss
	les		di, argPb
	repnz		movsb
	pop		ds
assume ds:dGroup
	mov		sp, bp
	pop		bp
	ret	10
ReadTss endp

;
; WriteTss: procedure (userNum, rTss, pb, cb) 
; 
; Copies data at pb (length cb) into all the TSSs of this user
; at sgTss:rTss
;
; assert DS is OS DGroup

public WriteTss
WriteTss proc far
	push		bp
	mov		bp, sp	
	push		0FFFFh
AccessTss:
	xor		bx, bx
	mov		dx, argUserNum
WriteTssLoopTop:
	push	dx							;userNum
	push	bx							;oPcb
	call	ONextUserPcb
	mov		bx, ax						;oPcbNext
	or		bx, bx
	jz		WriteTssExit

	mov		cx, argCb
	jcxz	WriteTssLoopTop				;silly, but supposed to do this

	mov		ax, word ptr [bx+pcbTss]
	and		ax, 0FFF8h
	sub		ax, 8
	cmp		word ptr [bp-2],0
	je		ReadTssExit
	mov		es, ax
	mov		di, argrTss
	push		ds
	lds		si, argPb
assume ds:nothing
	repnz		movsb
	pop		ds
assume ds:dGroup
	jmp		WriteTssLoopTop

WriteTssExit:
	mov		sp, bp
	pop		bp
	ret	10
WriteTss endp

public ValidateUser
ValidateUser proc far
; procedure (userNum) : ercType
;
; No registers corrupted, AX = ercOk if valid user
assume ds:DGroup
	push	bp
	mov		bp, sp
    push    di
	mov		ax, ercBadPartitionHandle ; set erc
	mov		di, word ptr [bp+6]
    and     di, 0FC00H                ;mask userNum bits
    jz      VuNilSlot
    cmp     di, wMySlotBits           ;compare slot bits
    jne     ValidateUserExit
VuNilSlot:
    mov     di, word ptr [bp+6]
    and     di, 03FFH          ;mask slot bits
	cmp		di, nParDesc
	jae		ValidateUserExit
	shl		di, 1				; word index
	push	bx
	push	es
	les		bx, pRgOExUcb
	mov		bx, es:[bx][di]
	cmp		word ptr es:[bx+cMassIoRq], 0FFFFh
	pop		es
	pop		bx
	je		ValidateUserExit   	; Bogus user
	xor		ax, ax				; erc = ercOk
ValidateUserExit:
    pop     di
	pop		bp
	ret		2
ValidateUser endp

ValidateCanonicalUser proc near
; on entry, bx is user num
; on exit, bx is canonical usernum, ax is ercRet
	cmp		bx, 1
	ja		GotUserNum
	mov		bx, oPcbRun
	mov		bx, [bx+pcbUserNum]
GotUserNum:
	push	bx
	call	ValidateUser
	ret
ValidateCanonicalUser endp

%if(%ctosv)then(

public ValidateUserNum 

ValidateUserNum proc far
;	procedure (oUserNum) ercType

	push bp
	mov bp, sp
	push ds
	mov ax, dGroup
	mov ds, ax

	mov bp, word ptr [bp+6] ; .userNum (SS relative)
	mov bx, word ptr [bp]

	call ValidateCanonicalUser

	mov word ptr [bp], bx
	
	pop ds
	pop bp
	ret 2

ValidateUserNum endp

)fi

public GetLdtr
GetLdtr proc far
;
; GetLdtr: procedure (userNum) word
;
; assert DS is OS DGroup
; returns ldtr of this user or 0

argUserNum equ word ptr [bp+6]

ASSUME DS:DGroup
	push	bp
	mov		bp, sp
	mov		bx, argUserNum
	cmp		bh, 0FFH	;JMR
	je		GetOsLdtr	; -1, -2, -3 are OS user numbers, protected mode
	and		bx, 03FFh
	cmp		bx, 0
	jne		GetUserLdtr
GetOsLdtr:
	mov		ax,sgLdtOs
	jmp		short GetLdtrExit
GetUserLdtr:
	shl		bx, 1
	les     si, prgsgLdt
	mov		ax, es:[si][bx]
GetLdtrExit:
	mov		sp, bp
	pop		bp
	ret		2

GetLdtr endp


public GetLdtAlias
GetLdtAlias proc far
;
; GetLdtAlias: procedure (userNum) word
;
; returns sgLdt of this user or 0

ASSUME DS:Nothing
	push bp
	mov  bp, sp
	mov  ax, dgroup
	mov  es, ax
ASSUME ES:DGROUP
	cmp	 argUserNum, 0
	jne	 GetUserLdtAlias
	mov	 bx, oPcbRun
	mov  ax, [bx+pcbSpSave]
	and  ax, 0FFF8h
	jmp  short GetLdtrExit
GetUserLdtAlias:
	mov  bx, argUserNum
	and  bx, 03FFH
    shl  bx, 1
	mov  es, rgsgAsib[bx]
ASSUME ES: NOTHING
	mov  ax, es:[asibSgLdt]
	jmp  short GetLdtrExit
GetLdtAlias endp

public QueryLdtr

QueryLdtr proc far
; procedure (userNum, pLdtrRet) ercType
; System common procedure

	push	bp
	mov		bp, sp
	push	ds
	mov		ax, DGroup
	mov		ds, ax
ASSUME DS:DGroup
	mov		bx, word ptr [bp+10]
	call	ValidateCanonicalUser
	or		ax, ax
	jne		QueryLdtrExit
	push	bx
	call	GetLdtr
; storeback result
	les		bx, dword ptr [bp+6]
	mov		es:[bx], ax
	xor		ax, ax ; erc = ercOk
QueryLdtrExit:
	pop		ds
	pop		bp
	ret		6

QueryLdtr endp

public DefineInterlevelStack
DefineInterlevelStack proc far
; DefineInterlevelStack: procedure (iLevel, pStack) ercType

argSP     equ word ptr [bp+6]
argSS     equ word ptr [bp+8]
argiLevel equ word  ptr [bp+10]

	push		bp
	mov		bp, sp

	mov		di, argiLevel
	cmp		di, 2
	ja		BogusLevel

	push		ds
	mov		ax, DGroup
	mov		ds, ax
assume ds:DGroup
	mov		bx, oPcbRun
	mov		ax, word ptr [bx+pcbTss]
	sub		ax, 8
	mov		es, ax
	test	vf_f386Tss, 1
	jnz		Define386Stack

; 286 Tss	
	shl		di, 2 ; times 4
	add		di, 2
	mov		ax, argSP
	stosw
	mov		ax, argSS
	stosw
	jmp short DefineStackErcOk

Define386Stack:
	shl		di, 3 ; times 8
	add		di, 4
	db 66h
	xor ax, ax
	mov		ax, argSP
	db 66h
	stosw
	mov		ax, argSS
	db 66h
	stosw

DefineStackErcOk:	
	pop		ds
	xor		ax, ax
DefineStackRet:
	pop		bp
	ret		6

BogusLevel:
	mov		ax, 5
	jmp		short DefineStackRet
assume ds:nothing
DefineInterlevelStack endp

public SnFromSr
SnFromSr proc far
; SnFromSr: procedure(sr, pSnRet)
argSr equ word ptr [bp+10]
argpsnRet equ dword ptr [bp+6]
	push	bp
	mov		bp, sp
	push	ds
	mov		ax, DGroup
	mov		ds, ax
assume DS:DGroup
	mov		bx, oPcbRun
	mov		ax, ercNotImplemented
	test	word ptr [bx+pcbspSave], maskRealMode
	jz		ExitSnFromSr
	mov		ax, argSr
	call	FarAliasIpcSr
	les		bx, argpsnRet
	mov		word ptr es:[bx], ax
	xor		ax, ax ; erc = ercOk
ExitSnFromSr:	
	pop		ds
assume DS:nothing
	pop		bp
	ret		6
SnFromSr endp

$MOD386

PUBLIC ErcPaFromLa
ErcPaFromLa PROC FAR
;	ErcPaFromLa:
;		procedure(pPaRet, la, userNum) ercType public reentrant;
pPaRet		EQU		DWORD PTR[BP+12]
	ENTER	0,0
	PUSH	ESI ; preserve esi for old pc emulator
	PUSH	DS
	PUSH	0FFh ; fErcPaFromLa = true
	JMP		SHORT CommonPaFromLa
ErcPaFromLa ENDP

PUBLIC MappedPaFromLa
MappedPaFromLa LABEL FAR

%if(%ctosv)then(
PUBLIC PaFromLa
)fi
PaFromLa PROC FAR
;	PaFromLa:
;		procedure(la, userNum) paType public reentrant;
userNum		EQU		WORD PTR[BP+6]
la			EQU		DWORD PTR[BP+8]
laHigh		EQU		DWORD PTR[BP+10]
laLow		EQU		DWORD PTR[BP+8]
	ENTER	0,0
	PUSH	DS
	PUSH	0 ; fErcPaFromLa = false
CommonPaFromLa:
	MOV		AX,DGroup
	MOV		DS,AX
assume ds:Dgroup
%if(%ctosv)then(
	MOV		CX,sgZero
)else(
	MOV		CX,sgAltZero
)fi
	MOV		FS,CX
	MOV		ESI,paGlobalPagemap	;FS:ESI points to page directory
	OR		ESI, ESI			; pa=la if paging not enabled
	JZ		@Identity
%if(not %ctosv)then(
	XOR		AX, AX
	MOV		AL, baseLinearOffset
	MOV		DI, AX
	SHL		EDI, 24
	OR		ESI, EDI			; baseLinearOffset
)fi
	MOV		EDX,la				;EDX has linear address
	MOV		CX,DX				;Save page offset
	SHR		EDX,10				;page in 2-11, dir in 12-21
	MOV		EBX,EDX
	SHR		EBX,10				;EBX has dir in 2-11 
	AND		EBX,000000FFCh		;EBX has offset in page directory
	MOV		ESI,FS:[ESI][EBX]	;ESI = page directory entry
	BT		ESI,0				;Test present bit in page directory entry
	JNC		@NotAddressable		;Jump if directory entry not present
	AND		ESI,0FFFFF000h		;Remove all but page table address
	AND		EDX,000000FFCh		;EDX has page table offset
	ADD		ESI,EDX				;ESI points to PageTableEntry
%if(not %ctosv)then(
	OR		ESI, EDI			; baseLinearOffset
)fi
	MOV		AX,FS:[ESI]			;AX = low bits of page table entry
	BT		AX,0				;Test present bit in page table entry
	JNC		@NotAddressable		;Jump if directory entry not present
	AND		AX,0F000h			;Remove all but physical address
	AND		CX,0FFFh			;CX has offset in page
	OR		AX,CX				;Add page offset
	MOV		DX,FS:[ESI+2]		;DX has high 16 bits
	JMP		SHORT PaFromLaRet
@Identity:
	MOV		AX,WORD PTR laLow
	MOV		DX,WORD PTR laHigh

PaFromLaRet:
	POP		CX ;fErcPaFromLa
	BT		CX, 0 ; carry flag is fErcPaFromLa
	JNC		PaFromLaExit
	LES		BX, pPaRet
	MOV		WORD PTR ES:[bx], ax
	MOV		WORD PTR ES:[bx+2], dx
	XOR		AX, AX ; erc = ercOk

PaFromLaExit:
	POP		DS
assume ds:nothing
	LEAVE
	BT		CX, 0 ;carry flagErcPaFromLa
	JC		ErcPaFromLaExit
	RET		6
ErcPaFromLaExit:
	RET		10

@NotAddressable:
	MOV		AX, ercNotAddressable
	POP		CX ;fErcPaFromLa
	BT		CX, 0 ;carry flagErcPaFromLa
	JC		PaFromLaExit
	MOV		AX,WORD PTR laLow
	MOV		DX,WORD PTR laHigh
	JMP		SHORT PaFromLaExit
PaFromLa ENDP

public Fetch32
Fetch32 proc far
	push bp
	mov bp, sp

	mov ebx, word ptr [bp+6]

%if(%ctosv)then(
	mov ax,sgZero
)else(
assume ds:dGroup
	mov ax,sgAltZero
assume ds:nothing
)fi
	mov es, ax

	mov eax, es:[ebx]

; put EAX into DX:AX (PL/M dword)
	mov dx, ax
;	shr eax, 16
	mov cl, 16

	db 66h
	shr ax, cl
	xchg ax, dx

	pop bp
	ret 4
Fetch32 endp

public Store32
Store32 proc far
	push bp
	mov bp, sp

	mov ebx, word ptr [bp+10]

%if(%ctosv)then(
	mov ax,sgZero
)else(
assume ds:dGroup
	mov ax,sgAltZero
assume ds:nothing
)fi
	mov es, ax

	mov eax, word ptr [bp+6]
	mov es:[ebx], eax

	pop bp
	ret 8
Store32 endp

$MOD286

%if(not %ctosv)then(
public PaFromSn
PaFromSn proc far
; PaFromSn: procedure(sn, userNum, pSaRet)
	push	bp
	mov		bp, sp
	push	0
	jmp		short @0
PaFromSn endp

public SaFromSn
SaFromSn proc far
; SaFromSn: procedure(sn, userNum, pSaRet)
argSn         equ word  ptr [bp+12]
argUserNum    equ word  ptr [bp+10]
argpSaRet     equ dword ptr [bp+6]
argpPaRet     equ dword ptr [bp+6]
fSa           equ byte  ptr [bp-2]
pSlot         equ dword ptr [bp-6]
desc286base   equ word  ptr es:[bx+2]
desc286baseHi equ byte  ptr es:[bx+4]
desc386Msb    equ byte  ptr es:[bx+7]
ercNotAddressable equ 408

sgVideoRam    equ 70h
sgFontRam     equ 78h
typeNewGen    equ 9

	push	bp
	mov		bp, sp
	push	 0FFFFh
@0:
	sub		sp, 4 ; for pSlot
	push	ds
	mov		ax, DGroup
	mov		ds, ax
assume ds:DGroup

	mov		bx, argUserNum
	call	ValidateCanonicalUser
	or		ax, ax
	jnz		SaFromSnExit

	pushf
	push	argSn
	push	bx ; userNum
	push	ss
	lea		ax, pSlot
	push	ax
;*** begin  critical region
	cli
	call	CheckPSlot
	or		ax, ax
	jz		@2
	popf		
	jmp		short SaFromSnExit
@2:
; zero msb to account for 16Mb wrap on all machines
	xor		dh, dh 
	les		bx, pSlot
	test	vf_fPaging, 1
	jz		@21
; adjust for paging wrap bits
; if any bit on left of baseLinearOffset then already pa=la.
	mov		dh, desc386Msb
	mov		al, baseLinearOffset
	shl		al, 1
	dec		al	
	cmp		dh, al
	ja		@21
	shr		al, 1
	and		dh, al ; remove the wrap bits, preserve lower order bits
@21:
	mov		ax, desc286Base
	mov		dl,	desc286BaseHi
	popf
;*** end critical region

; return an sa or a pa?
	cmp		fSa, 0
	je		@6

	mov		cx, 4
@3:	clc
	rcr		dx, 1
	rcr		ax, 1	
	loop		@3

	cmp		argSn, sgVideoRam
	je		@31
	cmp		argSn, sgFontRam
	jne		@32
@31:
	and		dx, 0FFF0h
@32:

	or		dx, dx
	jz		@4
	mov		ax, ercNotAddressable
	jmp		short SaFromSnExit
@4:
	les		bx, argPSaRet
	mov		word ptr es:[bx], ax
	xor		ax, ax	
SaFromSnExit:
	pop		ds
	mov		sp, bp
	pop		bp
	ret		8

@6:	 ; PaFromSn
	les		bx, argPPaRet
	mov		word ptr es:[bx], ax
	mov		word ptr es:[bx+2], dx
	xor		ax, ax
	jmp		SaFromSnExit

SaFromSn endp
)fi


public OsFetchLdtr
OsFetchLdtr proc far
	sldt ax
	ret
OsFetchLdtr endp


public OsFetchTR
OsFetchTR proc far
	str ax
	ret
OsFetchTR endp

; ReloadTr: procedure(sgTss) 
;
; If the current TR = sgTss, then ASSUME that the TSS selector of the active
; task has been rewritten -- so, TR must be reloaded to update the internal TR
; cache.  If TR <> sgTss, reloading TR would cause a GP fault since 
; TR is currently busy.

public ReloadTr
ReloadTr proc far
	push bp
	mov bp, sp
	str ax
	cmp ax, word ptr [bp+6]
	jne ReloadTrExit
	ltr ax
ReloadTrExit:
	pop bp
	ret 2
ReloadTr endp

LoadLdt PROC FAR
PUBLIC LoadLdt
ASSUME DS:DGroup
	PUSH BP
	MOV  BP, SP
	MOV  AX, WORD PTR [BP+6]
	LLDT AX
	POP  BP
	RET  2
LoadLdt ENDP

public SetLdtrDS
SetLdtrDS	 proc far

rTss286LDT					EQU 42 
rTss386LDT					EQU 96 

; if 386 interrupt tasks used, change code for 386 case

	push		bp
	mov		bp, sp
	mov		ax, DGroup
	mov		ds, ax
assume ds:dGroup
	str		ax
	sub		ax, 8
	mov		es, ax
	mov		dx, [bp+8]

; set default system ldt if 0 argued
	or		dx, dx
	jnz		@00
	mov		dx, sgLdtOs
@00:

; put ldtr in TSS as well because state save does not
; save LDTR
	pushf
	cli
	lldt		dx
	mov al, vf_f386Tss
	rcr al, 1
	jc SetLdtrDs386	
	mov es:[rTss286Ldt], dx
	jmp short SetLdtrDsExit
SetLdtrDs386:
	mov es:[rTss386Ldt], dx
SetLdtrDsExit:
	popf

	mov		AX, [BP+6]
	mov		DS, AX
	pop		bp
	ret		4
SetLdtrDS endp

public ReuseAlias
public ReuseAliasLarge

ReuseAliasLarge proc far
; procedure(snAlias, snSource, offsetSource, limit)

snAlias     equ word ptr [bp+14]
snSource    equ word ptr [bp+12]
offsetHiSource    equ word ptr [bp+10]
offsetLoSource    equ word ptr [bp+8]
limit       equ word ptr [bp+6]
%if(%ctosv)then(
saPdhAlias	equ dword ptr [bp-2]
raPdhAlias	equ dword ptr [bp-4]
)else(
iSlotAlias  equ word ptr [bp-2]
)fi

liNull      equ 0FFFFh
maskLdt equ 4
accessWritableData equ 92h
ercBadSelectorName equ 405
ercRealUser equ 40

	push	bp
	mov		bp, sp
%if(%ctosv)then(
	push	cx ; local variable
)fi
	push	cx ; local variable
	push	ds

	test		snAlias, maskLdt
	jz		InGdt
	jmp		ReuseAliasError

InGdt:
	mov		ax, DGroup
	mov		ds, ax

	mov		bx, oPcbRun
	test	word ptr [bx+spSave], maskRealMode
	jz		NotRealMode
	mov		ax, ercRealUser
	jmp		short ReUseAliasExit

NotRealMode:
	pushf	
	push	snAlias
	push	0
%if(not %ctosv)then(
	cli		;---- begin critical region
)fi
	call	GlaFromP
	push	dx
	push	ax
	mov		bx, oPcbRun
	push	[bx+pcbUserNum]
%if(%ctosv)then(
	cli		;---- begin critical region
	call	MapGlaPPdh
	popf	;---- end critical region
	mov		ax, es
	mov		raPdhAlias, bx
	mov		saPdhAlias, ax
)else(
	call	MapGlaISlot
	popf	;---- end critical region
	mov		iSlotAlias, ax
)fi

	pushf		
	push		snSource
	push		offsetLoSource
%if(not %ctosv)then(
	cli		;---- begin critical region
)fi
	call		GlaFromP
	add		dx, offsetHiSource
	push		dx
	push		ax
	mov		bx, oPcbRun
	push		[bx+pcbUserNum]
%if(%ctosv)then(
	cli		;---- begin critical region
	call	MapGlaPPdh
	popf	;---- end critical region
	mov		ax, es
	cmp		raPdhAlias, bx
	jne		ReuseAliasError
	cmp		saPdhAlias, ax
	jne		ReuseAliasError
	or		ax, ax ; null pPdh?
	jz		ReuseAliasError
)else(
	call	MapGlaISlot
	popf	;---- end critical region
	cmp		ax, iSlotAlias
	jne		ReuseAliasError
	cmp		ax, liNull
	je		ReuseAliasError
)fi

	pushf	;---- begin critical region
	cli
	push		snAlias
	push		snSource
	push		offsetLoSource
	call		GlaFromP
	add		dx, offsetHiSource
	push		dx
	push		ax
	push		limit
	push		accessWritableData
	call		BuildGdtSlot
	popf		;---- end critical region

	xor		ax, ax ; return(ercOk)

ReuseAliasExit:
	pop		ds
	mov		sp, bp
	pop		bp
	ret		10


ReuseAliasError:
	mov		ax, ercBadSelectorName
	jmp		short ReuseAliasExit

ReuseAliasLarge endp

ReuseAlias proc far
; procedure(snAlias, pSource)
	push		bp
	mov		bp, sp
	push		word ptr [bp+10]; snAlias
	push		word ptr [bp+8]; snSource
	push		0
	push		word ptr [bp+6]; raSource
	push		0FFFFh
	call		ReuseAliasLarge
	pop		bp
	ret 6
ReuseAlias endp


; FGetRmosUser: procedure(userNum, pFRmosRet) ercType
;
; system common procedure

public GetFRmosUser
GetFRmosUser proc far


argUserNum equ word ptr [bp+10]
argpfRmosRet equ dword ptr [bp+6]

	push	bp
	mov		bp, sp
	push	ds
	mov		ax, DGroup
	mov		ds, ax
assume ds:DGroup

; if userNum=0, use caller's user num
	mov		bx, argUserNum
	call	ValidateCanonicalUser
	or		ax, ax
	jne		GetFRmosUserExit

	push	bx
	call	FRealUser
	les		bx, argpfRmosRet
	mov		es:[bx], al
	xor		ax, ax ; ercRet = ercOk
GetFRmosUserExit:
	pop		ds
assume ds:nothing
	pop		bp
	ret		6

GetFRmosUser endp

) fi %'ctosp

$MOD186

; AllocPSub: procedure(pa, limit, userNum) pointer
;
; system common procedure

public AllocPSub
AllocPSub proc far

argPaHi equ 12
argPaLo equ 10
argLimit equ 8
argUserNum equ 6

	push	ds
	mov		ax, DGroup
	mov		ds, ax
assume ds:DGroup
	mov		bx, sp
	push	ss:argPaHi[bx]
	push	ss:argPaLo[bx]
	push	ss:argLimit[bx]
	push	ss:argUserNum[bx]
	call	AllocP
	pop		ds
assume ds:Nothing
	ret		8

AllocPSub endp


; ReleasePSub:
;	procedure (p,userNum);
; system common procedure

public ReleasePSub
ReleasePSub PROC FAR

argSa equ 10
argRa equ 8
argUserNum equ 6

	push	ds
	mov		ax, DGroup
	mov		ds, ax
assume ds:DGroup
	mov		bx, sp
	push	ss:argSa[bx]
	push	ss:argRa[bx]
	push	ss:argUserNum[bx]
	call	ReleaseP
	pop		ds
assume ds:Nothing
	ret		6

ReleasePSub endp

public QueryCoprocessor

QueryCoprocessor proc far
; procedure (pStatusRet) ercType
; System common procedure

	push	bp
	mov		bp, sp
	push	ds
	mov		ax, DGroup
assume ds:dgroup
	mov		ds, ax
	les		bx, dword ptr [bp+6]
%if(%ctosp) then (
	mov		al, bCoprocessorStatus
) else (
	mov		al, 0
)fi
	mov		byte ptr es:[bx], al
	xor		ax, ax ; erc = ercOk
	pop		ds
	pop		bp
	ret		4

QueryCoprocessor endp


public EccScrub

; Not interrupt disabled, can only lodsd if 386 tss preserves ECX.
EccScrub proc far
; procedure (p1, cb)
argP1 EQU DWORD PTR [BP+8]
argCb EQU WORD PTR [BP+6]
	push	bp
	mov		bp, sp
	push	ds
%IF(%ctosp) THEN (%'
%DifP XOR CX, CX	; Prepare ECX for LODSD
	test	vf_f386Tss, 1	; flags set, pending check ...
)FI
	lds		si, argP1
	mov		cx, argCb
	cld
%IF(%ctosp) THEN (
	jz		Lodsb186		; ... here!

%DifP ROR	CX, 2	; Hide quad-alignment bits (2 bits) in top of ECX.
%REP %DifP LODSW	; CX used for count, NOT ECX.
%DifP ROL	CX, 2	; Restore alignment bits to zeroed CX.
REP	LODSB			; CX used for count, NOT ECX.  Moves 0-3 bytes.
	jmp Short ESExit
)FI

Lodsb186:
	SHR	CX, 1
REP	LODSW
	RCL	CX, 1
REP	LODSB

ESExit:
	pop		ds
	pop		bp
	ret		6
EccScrub endp


public EccScrubNext

l64K EQU 0FA0h; Fits in 16 bits.
liNull EQU 0FFFFh
%IF(%ctosp) THEN (
userNumOS EQU 0FFFFh
$MOD386
) ELSE (%' real
userNumOS EQU 0
)FI

EccScrubNext proc far
	PUSH	BP
	MOV		BP, SP
	PUSH	plaWash
	PUSH	0FFFFh	;limit
	PUSH	userNumOs
	CALL	AllocSgFromPla

	PUSH	AX		;pWash.sa saved for ReleaseSg

	PUSH	AX		;pWash.sa
	PUSH	0		;pWash.ra
%DIfP
	 MOV	AX, plaEndMemory
%DIfP
	 SUB	AX, WORD PTR plaWash
%IF(%ctosp) THEN (
	 CMP		EAX, l64K	; cannot DIfP on instruction with immediate data
) ELSE (%' real
	 CMP		AX, l64K
)FI
	JBE		EccDoScrub
	MOV		AX, l64K
EccDoScrub:
	SHL		AX, 4	;in bytes
	PUSH	AX
	CALL	EccScrub

	 ADD	plaWash, l64K
%DIfP
	 MOV	AX, plaWash
%DIfP
	 CMP	AX, plaEndMemory
	JB		EccFinish
	MOV	plaWash, 0

EccFinish:
;	POP		AX		; pWash.sg already pushed
	PUSH	userNumOs
	PUSH	liNull
	CALL	ReleaseSg

	POP		BP
	RET

EccScrubNext endp

%IF (%ctosv) THEN(%'
;
; QSnLimit: PROCEDURE (wSn) DWORD
;	return selector limit in ax:dx
;	runs on user thread
;
PUBLIC QSnLimit
QSnLimit		PROC FAR
ASSUME DS: Nothing, ES: Nothing
$MOD386
	PUSH	BP
	MOV		BP, SP
	MOV		AX, WORD PTR [BP+6]	; wSn
    XOR		ECX, ECX	; return 0 for bogus selector
	DB		66h, 0Fh, 3, 0C8h	; LSL ECX, AX	
	XOR		AX, AX ; dummy instruction so that LSL will not be followed
			       ; by PUSH - on some 386 chips, this corrupts SP
	PUSH	ECX
	POP		AX
	POP		DX	
	POP		BP
	RET		2
QSnLimit		ENDP
)FI

PUBLIC BiosInitVideo      ; procedure
PUBLIC BiosWriteChar      ; procedure(b) 
PUBLIC BiosPositionCursor ; procedure(iRow, iCol)
%IF (%ctosv) THEN(%'
BIOSInitVideo proc far

	mov ax, 0003h  ; set video mode to mode 3 (ah = 0)
	push 10h
	call CallBios

	mov ax, 0500h  ; set active display page to 0
	push 10h
	call CallBios

	mov ax, 0200h  ; position cursor
	mov dx, 0000h  ; row = 0, col = 0
	xor bx, bx
	push 10h
	call CallBios

	xor ax, ax     ; erc = ercOk
	ret
BIOSInitVideo endp

BIOSWriteChar proc far
	push bp
	mov bp, sp
	mov al, [bp+6]
	mov ah, 0Eh
	xor bx, bx
	push 10h         ; video
	call CallBios
	xor ax, ax     ; erc = ercOk
	pop bp
	ret 2
BIOSWriteChar endp

BIOSPositionCursor proc far
	push bp
	mov bp, sp
	mov dh, [bp+8] ; row
	mov dl, [bp+6] ; column
	mov ax, 0200h  ; position cursor
	xor bx, bx
	push 10h
	call CallBios
	xor ax, ax     ; erc = ercOk
	pop bp
	ret 4
BIOSPositionCursor endp
) ELSE (
; labels are here to avoid link errors - never called in p series
BIOSInitVideo label far
BIOSWriteChar label far
BIOSPositionCursor label far
)FI

%IF (%ctosP) THEN(
$MOD286
)ELSE(
$MOD186
)FI
;
; BoundsTest: PROCEDURE (wSn, qO, qCb, bTestMode) ErcType
;
; Verifies that selector wSn is not nil and is valid for read or write access
; (per bTestMode), that the given offset and byte count (qO and qCb) are within
; the bounds of the selector's descriptor, and that the descriptor is marked
; "present".  Works on 286 and above processors (ercOK always returned on 186).
;
; Returns:
;	ercOK				Access to the specified memory will not fault
;	ercBoundsCheck		Selector is Nil, invalid, or of a type that cannot
;						be read nor written, or read-only and bTestMode
;						indicates that write access is needed, or the passed
;						offset and byte count violate the descriptor's limit
;	ercNotPresentFault	The descriptor is marked not present (all other
;						validity tests have passed)
; 						N.B. does not test for page not present.
;
wSn					EQU          16 [BP]
hiqO				EQU WORD PTR 14 [BP]
xO					EQU	         12 [BP]
hiqCb				EQU WORD PTR 10 [BP]
xCb					EQU          08 [BP]
bTestMode			EQU BYTE PTR 06 [BP]
mTestWritable		EQU 01h
sArgs				EQU 12

ercBoundsCheck		EQU 86
ercNotPresentFault	EQU 83
maskPresent			EQU 80h
maskSelector		EQU 0FFF8h
maskExpandDown		EQU 04h
maskBbit			EQU 400000h

ASSUME DS: Dgroup, ES: Nothing

PUBLIC BoundsTest
BoundsTest		PROC FAR

%IF (%ctosP) THEN(%'
	PUSH	BP
	MOV		BP, SP
	MOV		AX, wSn
	TEST	AX, maskSelector
	JZ		BtOob				; Zero (Nil) selector = bounds error
	TEST	bTestMode, mTestWritable
	JZ		BtReadable
	VERW	AX					; ZF <- writeable (or nil!) selector
	JMP		BtCheckType
BtReadable:
	VERR	AX					; ZF <- readable (or nil!) selector
BtCheckType:
	JNZ		BtOob
	TEST	vf_f386Tss, 1
	JZ		BtLimit286

BtLimit386:
$MOD386
; Test if 32 bit offset and 32 bit byte count are within range of descriptor
; get expansion direction and b-bit
	DB		66h, 0Fh, 2, 0D8h	; LAR EBX, AX		
	DB		66h, 0Fh, 3, 0C8h	; LSL ECX, AX	(ASSEMBLER BUG)
	TEST    BH, maskExpandDown
	JZ		BtLimit386ExpandUp
	CMP 	xO, ECX
	JBE		BtOob			
; b-bit determines upper limit of expand-down segs. when set upper limit=4gb.
	TEST    EBX, maskBbit	
	JNZ		BtPresent
; b-bit reset, offset + count must be <= 0ffffh
	MOV		EAX, xO		
	ADD		EAX, DWORD PTR [xCb]
	CMP		EAX, 0ffffh
	JA		BtOob
	JMP		BtPresent
	
BtLimit386ExpandUp:
	DB		66h
	SUB		CX, xO				; SUB ECX, qO
	JC		BtOob
	DB		66h
	INC		CX					; INC ECX
	DB		66h
	CMP		CX, xCb				; CMP ECX, qCb
	JB		BtOob
$MOD286

BtPresent:
; Test if descriptor is marked present
	TEST	BH, maskPresent
	JZ		BtAbs
)FI%'
	XOR		AX, AX				; ercOK (always so in real mode)
BtRet:
	POP		BP
	RET		sArgs

%IF (%ctosP) THEN(%'

BtOob:
	MOV		AX, ercBoundsCheck
	JMP		BtRet
BtAbs:
	MOV		AX, ercNotPresentFault
	JMP		BtRet

BtLimit286:
; Test if 16 bit offset and 16 bit byte count are within range of descriptor
	CMP		hiqO, 0				; For 286, offset out of bounds if > 64K
	JNE		BtOob
	CMP		hiqCb, 0
	JNE		BtOob
; get expansion direction
	DB		0Fh, 2, 0D8h		; LAR BX, AX				
	DB		0Fh, 3, 0C8h		; LSL CX, AX	(ASSEMBLER BUG)
	TEST    BH, maskExpandDown
	JZ		BtLimit286ExpandUp
	CMP 	xO, CX
	JBE		BtOob			
	MOV		AX, xO
	ADD		AX, xCb
	JC		BtOob
	JMP		BtPresent
	
BtLimit286ExpandUp:
	SUB		CX, xO
	JC		BtOob
	CMP		CX, xCb				; CMP ECX, qCb
	JB		BtOob
	JMP		BtPresent

)FI%'

BoundsTest		ENDP


UserNumCurrent PROC FAR
PUBLIC UserNumCurrent
ASSUME DS:Nothing
pcbUserNum	EQU	14
	PUSH  BP
	MOV   BP, SP
	XOR   AX, AX 	;userNumRet
	MOV   BX, Dgroup
	MOV   ES, BX
	STR   BX
	CMP   BX, ES:WORD PTR [sgTssIntLast]
	JBE	  UserNumCurrRet
	MOV	  BX, ES:WORD PTR oPcbRun
	MOV   AX, ES:WORD PTR [BX+pcbUserNum]
UserNumCurrRet:	
	POP   BP 
	RET
UserNumCurrent ENDP

;
;  DmaAddrFromP: PROCEDURE (p) PUBLIC REENTRANT
;
DmaAddrFromP PROC FAR
PUBLIC DmaAddrFromP
sg 	EQU WORD PTR [BP+8]
ra 	EQU WORD PTR [BP+6]
ASSUME DS:Nothing
$MOD386
	ENTER 0, 0
	PUSH  DS
	MOV   AX, Dgroup
ASSUME DS:DGroup
	MOV   BX,sg
	TEST  BX, 4		; sg's only
	JNZ	  BogusP
	MOV   AX, sgGdt
	MOV   ES, AX
	MOV   BX, SG
	MOV   DH, ES:BYTE PTR [BX+7]
	MOV   DL, ES:BYTE PTR [BX+4]
	MOV   AX, ES:WORD PTR [BX+2]
	ADD   AX, ra
	ADC	  DX, 0
	PUSH  DX
	PUSH  AX
	PUSH  0 	;userNum
%IF (%Debug) THEN (
	MOV	  sgDaDebug, BX
	MOV   laDaDebug, AX
	MOV   laDaDebug+2, DX
)FI
	CALL  PaFromLa
%IF (%Debug) THEN (
	MOV   paDaDebug, AX
	MOV   paDaDebug+2, DX
	CMP   DX, 800h	; > 128mb
	JAE	  BogusP
)FI
	POP	  DS
	LEAVE
	RET   4
BogusP:
	PUSH  3
	CALL  Crash
DmaAddrFromP ENDP


MemSet PROC FAR
PUBLIC MemSet
wPattern EQU WORD PTR [BP+6]
pla		 EQU DWORD PTR [BP+8]
cPar 	 EQU DWORD PTR [BP+12]
	ENTER	0,0
	MOV		ECX, cPar
	SHL		ECX, 2		;cPar=>cDword
	MOV		EDI, pla	
	SHL 	EDI, 4		;pla=>la
	MOV		AX, sgZero
	MOV		ES, AX		;es:di logical now addresses pla 
	PUSH	wPattern
	PUSH	wPattern
	POP		EAX
	CLD
	DB		67h		; 32-bit addr prefix - old assemblers don't do it.
	REP		STOSD		
	LEAVE
	RET		10
MemSet ENDP
)fi %'NOT FS


%IF (%fs) THEN(
public AllocMemoryInit
AllocMemoryInit proc far
	push 3
	call crash
AllocMemoryInit endp
)fi

CommonSubs_Code				ENDS
END
