/***
*time.h - definitions/declarations for time routines
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file contains the various declarations and definitions
*	for the time routines.
*	[POSIX/ANSI/System V]
*
****/

#if !defined(_TIME_DEFINED)

#define _TIME_DEFINED

#include <stddef.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif

/* implementation defined time types */

typedef signed long time_t;

typedef signed long clock_t;

/* structure for use with localtime(), gmtime(), &c. */

struct tm {
	signed int tm_sec;	/* seconds after the minute - [0,61] */
	signed int tm_min;	/* minutes after the hour - [0,59] */
	signed int tm_hour;	/* hours since midnight - [0,23] */
	signed int tm_mday;	/* day of the month - [1,31] */
	signed int tm_mon;	/* months since January - [0,11] */
	signed int tm_year;	/* years since 1900 */
	signed int tm_wday;	/* days since Sunday - [0,6] */
	signed int tm_yday;	/* days since January 1 - [0,365] */
	signed int tm_isdst;	/* daylight savings time flag */
	};


/* clock ticks macro - ANSI version */

#if !defined(_POSIX_SOURCE)
#define CLOCKS_PER_SEC	1000
#else
#define CLOCKS_PER_SEC	10
#endif

/* clock ticks macro - archaic version */

#if !defined(_POSIX_SOURCE)
#define CLK_TCK 	1000
#else
#define CLK_TCK 	10
#endif


/* extern declarations for the global variables used by the ctime family of
 * routines.
 */

#if defined(_DLL)
extern signed int _FAR_ _cdecl daylight;    /* non-zero if daylight savings time is used */
extern signed long _FAR_ _cdecl timezone;   /* difference in seconds between GMT and local time */
extern char _FAR_ * _FAR_ _cdecl tzname[2]; /* standard/daylight savings time zone names */
#else
extern signed int _near _cdecl daylight;    /* non-zero if daylight savings time is used */
extern signed long _near _cdecl timezone;   /* difference in seconds between GMT and local time */
extern char * tzname[2];       /* standard/daylight savings time zone names */
#endif


/* function prototypes */

#if defined(_MT)
extern double _FAR_ _pascal difftime(time_t, time_t);
#else
extern double _FAR_ _cdecl difftime(time_t, time_t);
#endif

#if !defined(_POSIX_SOURCE)
extern char _FAR_ *      _FAR_ _cdecl _strdate(char _FAR_ *);
extern char _FAR_ *      _FAR_ _cdecl _strtime(char _FAR_ *);
#endif
extern char _FAR_ *      _FAR_ _cdecl asctime(const struct tm _FAR_ *);
extern clock_t           _FAR_ _cdecl clock(void);
extern char _FAR_ *      _FAR_ _cdecl ctime(const time_t _FAR_ *);
extern struct tm _FAR_ * _FAR_ _cdecl gmtime(const time_t _FAR_ *);
extern struct tm _FAR_ * _FAR_ _cdecl localtime(const time_t _FAR_ *);
extern time_t            _FAR_ _cdecl mktime(struct tm _FAR_ *);
extern size_t            _FAR_ _cdecl strftime(char _FAR_ *, size_t,
	const char _FAR_ *, const struct tm _FAR_ *);
extern time_t            _FAR_ _cdecl time(time_t _FAR_ *);
extern void              _FAR_ _cdecl tzset(void);

#endif /* !_TIME_DEFINED */
