/***
*sys\utsname.h - definitions/declarations for uname()
*
*	Copyright 1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file defines the structure used by the uname routine to get
*	system names.
*	[POSIX]
*
****/

#if !defined(_SYS_UTSNAME_DEFINED)

#define _SYS_UTSNAME_DEFINED

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif


/* define struct used by uname() function */

struct utsname {
	char sysname[14];
	char nodename[12];
	char release[10];
	char version[4];
	char machine[5];
	};


/* function prototype */

extern signed int _FAR_ _cdecl uname(struct utsname _FAR_ *);

#endif /* !_SYS_UTSNAME_DEFINED */
