/***
*pwd.h - function declarations for user database handling
*
*	Copyright 1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file contains the function declarations for the library functions
*	related to user database handling.
*	[POSIX]
*
****/

#if !defined(_PWD_DEFINED) && defined(_POSIX_SOURCE)

#define _PWD_DEFINED

#include <sys/types.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif

struct passwd {
	char *pw_name;
	char *pw_passwd;
	uid_t pw_uid;
	gid_t pw_gid;
	char *pw_age;
	char *pw_comment;
	char *pw_gecos;
	char *pw_dir;
	char *pw_shell;
	};


/* function prototypes */

extern struct passwd _FAR_ * _FAR_ _cdecl getpwuid(uid_t);
extern struct passwd _FAR_ * _FAR_ _cdecl getpwnam(const char _FAR_ *);

#endif /* !_PWD_DEFINED && _POSIX_SOURCE */
