/***
*fcntl.h - file control options used by open()
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file defines constants for the file control options used
*	by the open() function.
*	[POSIX/System V]
*
****/

#if !defined(_FCNTL_DEFINED)

#define _FCNTL_DEFINED

#include <sys/types.h>

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif

#define O_RDONLY	0x0000	/* open for reading only */
#define O_WRONLY	0x0001	/* open for writing only */
#define O_RDWR		0x0002	/* open for reading and writing */
#define O_APPEND	0x0008	/* writes done at eof */

#define O_CREAT 	0x0100	/* create and open file */
#define O_TRUNC 	0x0200	/* open and truncate */
#define O_EXCL		0x0400	/* open only if file doesn't already exist */

#if defined(_POSIX_SOURCE)
#define O_ACCMODE	(O_RDONLY | O_WRONLY | O_RDWR)
#define O_SYNC		0x0004
#define O_NONBLOCK	0x0010
#define O_NOCTTY	0x0020
#define O_LOCKCH	0x0040
#define FD_CLOEXEC	0x0080
#define O_PIPE		0x0800
#define O_DIRECT	0x1000
#define O_DEVICE	0x2000
#define O_FSTAT     (O_SYNC   | O_APPEND | O_NONBLOCK | O_NOCTTY | \
                     O_LOCKCH | FD_CLOEXEC)
#endif

/*
 * O_TEXT files have <cr><lf> sequences translated to <lf> on read()'s.
 */

#define O_TEXT		0x4000	/* file mode is text (translated) */
#define O_BINARY	0x8000	/* file mode is binary (untranslated) */

/* macro to translate the C 2.0 name used to force binary mode for files */

#define O_RAW	O_BINARY

/* Open handle inherit bit */

#define O_NOINHERIT	0x0080	/* child process doesn't inherit file */

#if defined(_POSIX_SOURCE)
#define F_DUPFD		0
#define F_GETFD		1
#define F_SETFD		2
#define F_GETFL		3
#define F_SETFL		4
#define F_GETLK		5
#define F_SETLK		6
#define F_SETLKW	7

#define F_RDLCK		1
#define F_WRLCK		2
#define F_UNLCK		3

struct flock {
	signed short l_type;
	signed short l_whence;
	off_t l_start;
	off_t l_len;
	signed short l_sysid;
	pid_t l_pid;
	};

extern signed int _FAR_ _cdecl open(const char _FAR_ *, signed int, ...);
extern signed int _FAR_ _cdecl fcntl(signed int, signed int, ...);
extern signed int _FAR_ _cdecl creat(const char _FAR_ *, mode_t);
#endif

#endif /* !_FCNTL_DEFINED */
