;
; InitParseTables.asm
;

Data SEGMENT PUBLIC 'Data'
PUBLIC pMasterParseTable, pTocParseTable, pWorkStationParseTable, pIccParseTable
pMasterParseTable DD masterParseTable
pTocParseTable DD tocParseTable
pWorkStationParseTable DD workStationParseTable
pIccParseTable DD iccParseTable
Data ENDS

ParseTableSeg SEGMENT PUBLIC 'Memory'

masterParseTable LABEL BYTE
DB 'b0<'
DB '      '
DB ' | :Processor:'
DB       ' b1<EP#b2|Default> '
DB ' | :Boot: b1<(|(>'
DB       ' Processor b2<EP#b3>'
DB       ' {[OS p4] [Dump b8<N..|LowMem|Y..>] [IgnoreRomError b9<Y..|N..>]}) '
DB ' | :LogUnknownEntries: b1<Y..|N..> '
DB ' | ...'
DB '    >'
DB 0

tocParseTable LABEL BYTE
DB 'b0<'
DB '   '
DB ' | :FileType: b1<  '
DB                 ' | tocSrpFp'
DB                 ' | tocSrpFp.m'
DB                 ' | tocSrpFp.r'
DB                 ' | tocSrpFp.n'
DB                 ' | tocSrpTp'
DB                 ' | tocSrpCp'
DB                 ' | tocSrpSp'
DB                 ' | tocSrpDp'
DB                 ' | tocSrpDp.m'
DB                 ' | tocSrpDp.r'
DB                 ' | tocSrpDp.n'
DB                 ' | tocSrpBt'
DB                 ' | tocSrpGp'
DB                 ' | tocSrpGp.m'
DB                 ' | tocSrpGp.r'
DB                 ' | tocSrpGp.n'
DB                 ' | tocSrpTable'
DB                 ' | tocMemDisk1'
DB                 ' | tocMemDisk3'
DB                 ' | tocMemDiskDiag'
DB                 ' | ...> '
DB ' | ...'
DB ' >'
DB 0

workStationParseTable LABEL BYTE 
DB 'b0<'
DB '      '
DB ' | :Processor:'
DB ' | :ActionKeySticks: b1<Y..|N..> '
DB ' | :AgentCacheDefaultEnable: b1<Y..|N..> '
DB ' | :BeepOnToggle: b1<Y..|N..> '
DB ' | :CacheService: b1<(|(>'
DB        ' {[BlockSize w2 [,]]'
DB         ' [BlockCount w4 [,]]'
DB         ' [MinWorkingSetBlockCount w6 [,]]'
DB         ' [DirtyBlockCount w8 [,]]} ) '
DB ' | :CharMapDebugger: b1<Y..|N..> '
DB ' | :CheckDai: b1<Y..|N..> '
DB ' | :ChordKeysStick: b1<Y..|N..> '
DB ' | :ClusterLine1: b1<(|(>'
DB        ' {[Speed b2<307K..|1.8M..|2M..|2.0M..|3.68M..|3.7M..> [,]]'
DB         ' [MaxWs b3 [,]]'
DB         ' [msPollIntervalMax w4 [,]]} ) '
DB ' | :ClusterLineSpeed: b1<307K..|1.8M..|2M..|2.0M..|3.68M..|3.7M..> '
DB ' | :ClusterTimeout: w2 '
DB ' | :CompensateFloppy: b1<Y..|N..> '
DB ' | :ContinueLoadOnError: b1<Y..|N..> '
DB ' | :cParExitRunFile: w2 '
DB ' | :cParSpecHeap: w2 '
DB ' | :cParSysCommonHeap: w2 '
DB ' | :CrashDumpPath: p2 '
DB ' | :CreateDirectoryProtection: b1<Y..|N..> '
DB ' | :cSemaphoreRecords: w2 '
DB ' | :DebugIcc: b1<Y..|N..> '
DB ' | :DiskAllocationLimit: d4 '
DB ' | :DiskLogThreshold: w2 '
DB ' | :DiskRetryCount: w2 '
DB ' | :EISA: <(|(>'
DB        ' {ID p4 [,] [Slot b8 [,]] [ConfigFile p10 [,]]} ) '
DB ' | :EnterDebuggerOnFault: b1<Y..|N..> '
DB ' | :ErcDebug: w2 '
DB ' | :ExtCrashVDMFile: p4 '
DB ' | :fAllowCommlineDMAonCPU: b1<Y..|N..> '
DB ' | :FileCacheDefaultEnable: b1<Y..|N..> '
DB ' | :FileCacheDefault: b1<(|(>'
DB        ' {[Enable b2<Y..|N..> [,]]'
DB         ' [WriteBehind b3<Y..|N..> [,]]'
DB         ' [CleanPriority w4 [,]]} ) '
DB ' | :FileCacheService: b1<(|(>'
DB        ' {[BlockSize w2 [,]]'
DB         ' [BlockCount w4 [,]]'
DB         ' [MinWorkingSetBlockCount w6 [,]]'
DB         ' [DirtyBlockCount w8 [,]]} ) '
DB ' | :FileStructureVerify: b1<Y..|N..> '
DB ' | :FloppyVerify: b1<Y..|N..|All..|T1..|T2..|T3..> '
DB ' | :ForceDump: b1<Y..|N..> '
DB ' | :KbdCallFilter: w2 '
DB ' | :KbdProfile: b1<(|(> {[ID b2 [,]] [AltNlsStyle b3<Y..|N..> [,]]} ) '
DB ' | :KbdTables: b1<(|(> {[Number w2 [,]] [Size w4 [,]]} ) '
DB ' | :LfsToMaster: b1<Y..|N..|All|p4> '
DB ' | :LibraryAlias: b1<p4 p8> '
DB ' | :LibrarySearchPath: b1<(|(>'
DB        ' p4 [, p8] [, p12] [, p16] [, p20] [, p24] [, p28] [, p32] ) '
DB ' | :LoadableRequestFile: p4 '
DB ' | :LoadDebugger: b1<Y..|N..> '
DB ' | :MapKeyboardID: b1<(|(> {Source b2 [,] Target b3 [,]} ) '
DB ' | :MassStorage: b1<(|(>'
DB        ' Class b2<SCSI|CACHEMEMORY> [,]'
DB        ' b3<Unit b4 [,]|Adapt.. b4 [,] {[Target b5 [,]] [LUN b6 [,]]}>'
DB        ' {[Device p8 [,]]      [Password p12 [,]]'
DB         ' [Volume p16 [,]]     [VolumePassword p20 [,]]'
DB         ' [MaxSectors d24 [,]] [MaxDirectories w28 [,]]'
DB         ' [MaxFiles w30 [,]]   [MaxSysFiles w32 [,]]'
DB         ' [MaxTempFiles w34 [,]]} ) '
DB ' | :MaxConcurrentTerm: w2 '
DB ' | :MaxConcurrentQuiet: w2 '
DB ' | :MaxHugeSg:  w2 '
DB ' | :MaxInstanceSeg:  w2 '
DB ' | :MaxWs: b1 '
DB ' | :MaxXBlocksOut: b1 '
DB ' | :MemoryScrub: b1<Y..|N..> '
DB ' | :ModuleType: b2'
DB        ' {[] [<XBusWindowSize|:XBusWindowSize:> b3<0K|96K|224K|480K>]'
DB        ' [] [<:UsedFromVirtualRealMode:|UsedFromVirtualRealMode> b4<Y..|N..>]'
DB        ' [] [<:Mode3DmaMaster:|Mode3DmaMaster> b5<Y..|N..>]}'
DB ' | :nMaxNetUsers: w2 '
DB ' | :NoBeep: b1<Y..|N..> '
DB ' | :nRepollActive: b1 '
DB ' | :nRkvsUsers: b1 '
DB ' | :OldMaster: b1<Y..|N..> '
DB ' | :PreLoad: b1<Y..|N..> '
DB ' | :RebootClusterOnMasterDown: w2 '
DB ' | :RemoteCacheService: b1<(|(> {[Priority b2]'
DB                                  ' [Descriptors w4]'
DB                                  ' [StackSize w6]} ) '
DB ' | :RemoteCachePool: b1<(|(> {[Name p2]'
DB                               ' [Password p6]'
DB                               ' [BlockSize w10]'
DB                               ' [BlockCount w12]'
DB                               ' [MinWorkingSetBlockCount w14]} ) '
DB ' | :RemoteCacheClient: b1<(|(> {[Name p2] [Pool p6]} ) '
DB ' | :RepeatKeyFactor: w2 '
DB ' | :RequestTracker: b1<Y..|N..> '
DB ' | :ResidentBsac: b1<Y..|N..> '
DB ' | :ResidentDebugger: b1<Y..|N..> '
DB ' | :RkvsFile: p4 '
DB ' | :RqTracker: b1<Y..|N..> '
DB ' | :sBroadcastHeap: w2 '
DB ' | :ScratchVolumeName: p4 '
DB ' | :ScreenTimeout: w2 '
DB ' | :ScsiManagerName: p8 '
DB ' | :sEnvironment: w2 '
DB ' | :SequentialStorage: b1<(|(>'
DB                         ' {[Device p2] [Class p6] [Password p10]'
DB                         '  [Adapt.. b14] [Target b15] [LUN b16]'
DB                         '  [Unit b17]} ) '
DB ' | :sExitProcStack: w2 '
DB ' | :sKernelTraceBuffer: w2 '
DB ' | :sKernelStack: w2 '
DB ' | :sLoaderHeap: w2 '
DB ' | :sMapTrace: w2 '
DB ' | :sMemMgrHeap: w2 '
DB ' | :sNameHash: w2 '
DB ' | :sNameHeap: d4 '
DB ' | :sTraceBuffer: w2 '
DB ' | :SupportPreII30Compatible:  b1<Y..|N..> '
DB ' | :SuppressAutoDump: b1<Y..|N..> '
DB ' | :SuppressCommDmaBufferCheck: b1<Y..|N..> '
DB ' | :SuppressDebugger: b1<Y..|N..> '
DB ' | :SuppressDsLimitHack: b1<Y..|N..> '
DB ' | :SuppressGlobalPolicy: b1<Y..|N..> '
DB ' | :SuppressPmDefaults: b1<Y..|N..> '
DB ' | :SuppressRamSemaphoreHack: b1<Y..|N..> '
DB ' | :SwapFile: p4 '
DB ' | :SwapFileAlternate: p4 '
DB ' | :SwapFileSize: d4 '
DB ' | :SwapFileSizeMax: d4 '
DB ' | :SysCtl: w2 '
DB ' | :SystemCommonProcedure: w2 p4 '
DB ' | :TraceExchange: w2 '
DB ' | :TraceRequestCode: w2 '
DB ' | :TraceUserNumber: w2 '
DB ' | :VDMFile: p4 '
DB ' | :VM103Reset: b1<Y..|N..> '
DB ' | :WakeUpInterval: w2 '
DB ' | :WatchDogStatus: b1<None|<SetFlag|Abort>|Crash> '
DB ' | :WBlocks: ...'
DB ' | :WBlocksIn: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | :WBlocksOut: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | :XBlocks: b1<(|(> {[Number w2 [,]] [Size w4 [,]]} ) '
DB ' | :XBlocksSmall: b1<(|(> {[Number w2 [,]] [Size w4 [,]]} ) '
DB ' | :YBlocks: ...'
DB ' | :YBlocksIn: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | :YBlocksOut: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | :ZBlocks: ...'
DB ' | :ZBlocksIn: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | :ZBlocksOut: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | :SrvrAgentFile: p4 '
DB ' | :ClientAgentFile: p4 '
DB ' | :OsNameClstr: p4 '
DB ' | :OsNameClstrLfs: p4 '
DB ' | :OsNameSrvr: p4 '
DB ' | :OsNameStnd: p4 '
DB ' | :nWsUsers: w2 '
DB ' | :ECOM: p4 '	;*AA*;
DB ' | ...'
DB '    >'
DB 0

iccParseTable LABEL BYTE
DB 'b0<'
DB '      '
DB ' | :Processor:'
DB ' | :WBlocks: ...'
DB ' | :WBlocksIn: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | :WBlocksOut: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | :XBlocks: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | :XBlocksSmall: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | :YBlocks: ...'
DB ' | :YBlocksIn: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | :YBlocksOut: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | :ZBlocks: ...'
DB ' | :ZBlocksIn: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | :ZBlocksOut: b1<(|(> {[Number w2] [Size w4]} ) '
DB ' | ...'
DB '    >'
DB 0

ParseTableSeg ENDS

END

; log
; 02/18/93 JM cloned from InitParseTables.edf
; 02/25/93 JM remove down-arrow from :Processor: of workStationParseTable.
; 02/27/93 KH Added MakeKbdCalls
; 03/03/93 JA DirtyPercentMax -> DirtyBlockCount
; 03/15/93 KH Replace MakeKbdCalls with KbdCallFilter
; 03/19/93 RA Added :ECOM: for SG4000/6000.
; 06/09/93 JA Changed WYZBlocks to WYZBlocksIn/Out.
; 07/06/93 JF Change ClstrAgentFile to ClientAgentFile
; 07/07/93 JA Added <SetFlag|Abort>.
; 08/05/93 sg Added IgnoreRomError.
;

