;
; FILE Clstr.Asm --
;
; COPYRIGHT 1990 CONVERGENT TECHNOLOGIES, INC.
; ALL RIGHTS RESERVED
;
; THIS PROGRAM IS FURNISHED UNDER A LICENSE RESTRICTING ITS USE
; SOLELY FOR THE OPERATION OF A DESIGNATED COMPUTER FOR A
; PARTICULAR PURPOSE, AND MAY NOT BE COPIED OR OTHERWISE USED
; WITHOUT THE PRIOR WRITTEN CONSENT OF CONVERGENT TECHNOLOGIES,
; INC.  TITLE TO AND OWNERSHIP OF THE PROGRAM, INCLUDING ITS
; SOURCE CODE, SHALL AT ALL TIMES REMAIN IN CONVERGENT
; TECHNOLOGIES.
;
$INCLUDE(Sysgen_Common.Mdf)
%Begin
EVEN
;################################################################
; The following list of request codes are those requests for which the
; cluster agent will NOT mark the user as using resources on the master
; and therefore require no termination on the master. Clusters
; which issue to the master only the requests which are in this list will 
; not have termination requests sent to the master.
;
;################################################################
%RequestNoRemoteTermination(14)		;GetDateTime
%RequestNoRemoteTermination(235)	;CheckForMail
%RequestNoRemoteTermination(101Ah)	;RemoteTermination
%EndRemoteTermination
;###############################################################
;
;  Space occupied by the tables below this location will be
; recalimed by the OS after its initialization
;
;  ANY RE-ORDERING OF THIS FILE MUST NOT CROSS THIS BOUNDRY !!!
;
; CTOS has been carefully constructed so that the various parts
; of CTOS reside either before this boundry (resident code and
; data) or after (initialization code and data).  There are
; five segments which are used in controlling this:
;
;	"code" ... anything in this segment will be resident
;	"const" .. anything in this segment will be resident
;	"data" ... anything in this segment will be resident if
;		   the module is linked before SysGen.Obj, or
;		   non resident if linked after
;	"stack" .. anything in this segment will be nonresident
;	"coed" ... anything in this segment will be non
;		   resident (ie discarded after intialization)
;
; The CTOS processes are allocated stacks out of memory
; reserved by the following macro call, and the stack segment
; is used only for a stack during CTOS initialization.
;
; The following macro is invoked with one argument, the number
; of bytes to be reserved for CTOS to use to build its
; structures, tables, and to allocate the stacks for the
; different processes (declared later in this file).  The macro
; variable sOsData may be defined in the prefix file if
; desired.  The OS will crash with as error 101 if this value
; is too small.
;################################################################

%ResidentDataBoundry(20000)

EVEN
;###############################################################
;
;   Table which describes the CTOS resident processes.  Each
; process is described by 4 attributes:     
;				
;      1. Process entry point                       
;      2. Size of its stack
;      3. priority (0 is highest, 254 lowest)
;      4. default exchange (0 if not required, <> 0 allocs next available)
;      5. optional "check proc" name; if supplied (non-0), proc is called
;         to decide if the process should be created
;
;   Stack size --
;	The stack size for a CTOS process must be large enough
; for the largest local variable and procedure call sequence,
; plus enough space for all possible interrupts that can occur.
; CTOS requires 64 bytes of user stack to save the context of a
; process when an interrupt occurs.
;                                                   
;###############################################################

%OsProcDesc(WsAgent, 300, 3, %TRUE, 0)
%OsProcDesc(LclFsFilterProcess, 256, 7, %TRUE, 0)

EVEN
;###############################################################
; CTOS INITIALIZATION --
; The following macros generate three tables of pointers which
; are used by WsAgent during its initialization phase. All of the
; routines pointed to in these tables reside in modules which
; are linked near the start of the image, and the code for these
; modules is discarded after initialization is complete. These
; routines should have their code segments named "coed", and
; should use "data" for the name of their data segments. This
; is to insure that the Linker will place the code and data at
; the start of the run file, before the "ResidentDataBoundry"
; mentioned earlier in this file. The routines should obey the
; Convergent programming conventions related to register usage
; (refer to The Assembly Language Manual). The routines are
; executed at one of three times during initialization:
;
;   InitProcHardware
;		First after booted. This is the place to put hardware
;		test and verification routines.
;
;   InitProcIntDisable
;		After structures have been initialized but before
;		any processes have been started. This is the place to
;		put hardware inititialization routines.
;
;   InitProcIntEnable
;		After interrupts are enabled these routines are executed
;		as if they were a user program. (CTOS processes are running).
;		This is the place to put initialization routines.
;
; The routines are called in the order given, with no arguments, as
; subroutines using the Assembly Language indirect far call instruction.
;

	    %InitProcIntDisable(InitSysConfig)
	    %InitProcIntDisable(WsInit)

		%InitProcIntEnable(DAIIntoXID)
		%InitProcIntEnable(PrepareIdSearch)



EVEN
;###############################################################
; System common subroutine definitions
;  The macro takes number, name and procedural interface for each routine
;  to be installed.
;
;################################################################
%SystemCommon(128, "FSrpUpProc",      "")
%SystemCommon(202, "FMasterRqSentTestAndClear", "w")
%SystemCommon(222, "ConnectAgentCache", "ww")
%SystemCommon(225, "GetClstrGenerationNumber", "p-")

EVEN
;###############################################################
; Interrupt routine definitions
;  The macro takes device type, name, fDevice and fRaw for each routine
;  to be installed.
;
;################################################################
%Interrupt(tyRS4221, "SigIsr", TRUE, FALSE)

EVEN
;###############################################################
; RTC initialization
;  Externally defined RTC blocks may be initialized at installation
;  using the RtcRq macro.
;  Arguments are
;      public name, timeInterval, resetValue, cEvents, exchange, rqCode.
;
;################################################################
%RtcRq(timerRq,20,0,1,12,0)%' for timing out master, see :ClusterTimeout:
%RtcRq(rqClock,0FFFFh,0FFFFh,1,0,0)%' for statistics in ClusterStatus
%RtcRq(rqTimeCws,300,300,0,17,14)%' for GetDateTime polling'

EVEN
;###############################################################
; FINAL --
;    This macro does error checking, and fills in various
; counts in the tables generated by the above macros calls.
;
;################################################################
%Final
END
