;******************************* MODULE HEADER ******************************;
;*                                                                          *;
;* FILE: RstorMsg.asm                                                       *;
;*                                                                          *;
;* MACHINE: B20     LANGUAGE: ASSEMBLER  OS: BTOS                           *;
;*                                                                          *;
;* DESCRIPTION:                                                             *;
;*                                                                          *;
;*              Nationalization Module.                                     *;
;*                                                                          *;
;*                                                                          *;
;*                                                                          *;
;*                                                                          *;
;* HISTORY:                                                                 *;
;*                                                                          *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first)*;
;*                                                                          *;
;* 10/10/89 120D.01 P. Campbell  / Added sbMisMatchedWild (34517)           *;
;* 05/20/89 120B/00 V. Muppidi   / Changed 34266, 34676 and 34701 so they   *;
;*                                 match Fileutilmsg.mtxt .   (UVA)         *;
;*                                                                          *;
;*                                                                          *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                             *;
;*                                                                          *;
;*          PROPRIETARY PROGRAM MATERIAL                                    *;
;*                                                                          *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE      *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE  *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS           *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                               *;
;*                                                                          *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED    *; 
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED         *;
;* ************************************************************************ *;
;*                                                                          *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND     *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,     *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF  *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO        *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                *;
;*                                                                          *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          *;
;*                                                                          *;
;*                                                                          *;
;*************************** END OF MODULE HEADER ***************************;

$INCLUDE(:f0:String.Mdf)
;
;************ NLS Internationalization ***************
;MDD 10/17/86 - Added comments to show location of error messages
;               in new message file FileUtilMsg.txt
;GM  10/28/86 - Remove nulls at beginning of headings.
;JAY 07/18/88 - Added rgRCommandMenuLine10 (34154).
;************ NLS Internationalization ***************
;

%InitStrings
   ;
   ;  See "String.Mdf" for description of Macro definitions.
   ;
   ;
   ;  /***********************************/
   ;  /*   Output text for Restor.plm    */
   ;  /***********************************/
   ;
   ;
   ; The following are output text messages.
   ;
%sbString rgHeadingFile       ('File Restore '); NLS Msg 34651
%sbString rgHeadingTape       ('Tape Restore '); NLS Msg 34652
%sbString rgRTapeFile         ('Tape file number '); NLS Msg 34653
%sbString rgRCommandMenuLine1 ('Archive file '); NLS Msg 34654
%sbString rgRCommandMenuLine2 ('File list from '); NLS Msg 34655
%sbString rgRCommandMenuLine3 ('To file list '); NLS Msg 34656
%sbString rgRCommandMenuLine4 ('Overwrite ok '); NLS Msg 34657
%sbString rgRCommandMenuLine5 ('Confirm each '); NLS Msg 34658
%sbString rgRCommandMenuLine6 ('Sequence number '); NLS Msg 34659
%sbString rgRCommandMenuLine7 ('Merge with existing file '); NLS Msg 34660
%sbString rgRCommandMenuLine8 ('List file only '); NLS Msg 34661
%sbString rgRCommandMenuLine9 ('Log file '); NLS Msg 34662
%sbString rgRCommandMenuLine10 ('Boot tape '); NLS Msg 34154
%sbString rgRToAndFromFileListDoNotAgree (' "To file list" must agree in number with "From file list"'); NLS Msg 34663
;*** Use NLS Msg 34464 for international version of the following message
%sbString rgRFromFileListForm (' "File list from" must be of form <dir>file.
')
%sbString sbMisMatchedWild ('Wild card mismatch: ') ; NLS Msg 34517
%sbString rgRIllegal (' is illegal.'); NLS Msg 34665
%sbString rgRCannotOpenLogFile ('Cannot open the log file.
'); NLS Msg 34266 *m00*
;*** Use NLS Msg 34462 for international version of the following message
%sbString rgRCannotOpenArchiveFile ('Cannot open archive file.
')
;*** Use NLS Msg 34666 for international version of the following message
%sbString rgRNumOfFilesProcessed ('
Number of files processed : ')
%sbString rgRNumFilesSuccessfulRestored ('
Number of files successfully restored: '); NLS Msg 34667  
%sbString rgRNumFilesRestoreWithIoError ('
Number of files restored with IO errors in the data: '); NLS Msg 34668
%sbString rgRNumFilesWithLostHdrInfo ('
Number of files which had lost header information : '); NLS Msg 34669
%sbString rgRNumFilesNotRestoreToDest ('
Number of files which could not be restored to destination: '); NLS Msg 34670
%sbString rgRNumFilesUnrecoverable ('
Number of files which were unrecoverable: '); NLS Msg 34671
%sbString rgRSpaces ('                                        ')
; 25h = Percent character which cannot occur in macros
%sbString rgProcessFile ('Processing file ',25h,'0N ...'); NLS Msg 34702
   ;
   ;  /***********************************/
   ;  /*   Output text for RstorC.plm    */
   ;  /***********************************/
   ;
%rgbcbString (RestoreFileSpec) ('&Restore.'); NLS Non-translatable
%sbString rgUnrecoverableFileHeaderInfo ('Unrecoverable file header information. '); NLS Msg 34672
;*** rgCreating and rgThreeDots are combined to form NLS Msg 34673
%sbString rgCreating ('Creating ')
%sbString rgQuestionMarkChar ('?'); NLS Non-translatable
;*** rgCreatingDirectory and rgThreeDots are combined to form NLS Msg 34674
%sbString rgCreatingDirectory ('Creating directory ')
%sbString rgDirAlreadyExists (' directory already exists.'); NLS Msg 34675
%sbString rgPageCount10 ('	Sector count: 10
'); NLS Msg 34676
%sbString rgFile ('File '); NLS Msg 34677
%sbString rgAlreadyExist (' already exists. Overwrite?'); NLS Msg 34678
%sbString rgAlreadyExists (', already exists.
'); NLS Msg 34679
%sbString rgNoRestore ('Did not restore '); NLS Msg 34680
%sbString rgProtectedFileTooSmall (' too small! Do you want to partially copy it?'); NLS Msg 34681
%sbString rgUnableToReadDirInfo ('Unable to read directory information sectors '); NLS Msg 34682
%sbString rgAtSymbol (' - '); NLS Non-translatable
%sbString rgPageCount ('  Sector count:'); NLS Msg 34676 *m00*
%sbString rgUnableToCreateDir ('Unable to create directory '); NLS Msg 34684
%sbString rgError ('Error '); NLS Msg 34685
%sbString rgDirInfoOnBackupInvalid ('Directory information sector on backup files is invalid.'); NLS Msg 34686
;*** Use NLS Msg 34687 for international version of the following message
%sbString rgUnrecoverableFiles (' unrecoverable files on archive media')
;*** Use NLS Msg 34688 for international version of the following message
%sbString rgIOErrorWhileReadData (' ... I/O error while reading data.')
%sbString rgIoErrorWhileReadArchiveFile ('I/O error encountered while reading archive file.'); NLS Msg 34689
%sbString rgDataErrorExistedWhenBackedUp ('
Data error existed when file was backed up.'); NLS Msg 34690
;*** rgRestore, rgTo and rgQuestionMarkChar are combined to form NLS Msg 34691
%sbString rgRestore ('Restore ')
%sbString rgTo (' to ')
;*** rgRestoring and rgTo are combined to form NLS Msg 34692
%sbString rgRestoring ('Restoring ')
%sbString rgOverwriting (32,40,'overwriting',41); NLS Msg 34693
%sbString rgThreeDots (' ... '); NLS Non-translatable
   ;
   ;  /***********************************/
   ;  /*   Output text for RstorB.plm    */
   ;  /***********************************/
   ;
%sbString rgBUnexpectErrWhileRdingArchFil ('Unexpected error while reading archive file.'); NLS Msg 34701 *m00*
;*** Use NLS Msg 34695 for international version of the following message
%sbString rgBIoErrorRestoringToFile ('
I/O error restoring to file ')

;*** The following 4 messages have been combined to form NLS Msg 34696 for
;*** InsertZeroes and 34697 for NoDataRestore.  Both Msgs have two parameters.
%sbString rgBInsertZeroesFromLfa ('        0''s are inserted from lfa ')
%sbString rgBNoDataRestoreFromLfa ('        No data restored from lfa ')
%sbString rgBFor (' for ')
%sbString rgBSector (' sectors')

;*** Use NLS Msg 34698 for international version of the following message
%sbString rgBIoErrorFoundInArchiveFile ('I/O error found in archive file.')
%sbString rgBDataErrorInFileWhenBackedUp ('
Data error in file when backed up.  '); NLS Msg 34699
; NLS Msg 34564: 25h = Percent character which macros don't like
%sbString rgProcFileOf ('Processing file ',25h,'0N of ',25h,'1N ... ') ; 
%FinishStrings
END
