;******************************* MODULE HEADER ******************************;
;*                                                                          *;
;* FILE: FloppyCopyText.asm                                                 *;
;*                                                                          *;
;*                                                                          *;
;* MACHINE: B20     LANGUAGE: ASSEMBLER  OS: BTOS                           *;
;*                                                                          *;
;* DESCRIPTION:                                                             *;
;*                                                                          *;
;* HISTORY:                                                                 *;
;*                                                                          *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first)*;
;*                                                                          *;
;* 08/28/89 120C/01 P. Campbell  / Master -> Server, Server -> Service      *;
;* 05/20/89 120B/00 V. Muppidi   / Updated file to match fileutilmsg.txt.   *;
;*                                 Erc 250                                  *;
;*                                                                          *;
;* ----                                                                     *;
;* 02/07/85 FW  Add new strings for invalid device & device not local.      *;
;*                                                                          *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                             *;
;*                                                                          *;
;*          PROPRIETARY PROGRAM MATERIAL                                    *;
;*                                                                          *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE      *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE  *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS           *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                               *;
;*                                                                          *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED    *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED         *;
;* ************************************************************************ *;
;*                                                                          *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND     *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,     *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF  *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO        *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                *;
;*                                                                          *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          *;
;*                                                                          *;
;*                                                                          *;
;*************************** END OF MODULE HEADER ***************************;

$INCLUDE(:f0:ErcMsg.Mdf)
$INCLUDE(:f0:String.Mdf)
;
;
; Declare GetErcMessage, with strings sbType (fZbType=0) --
;
%InitErrorCodes(GetErcMessage,0)
;
; Misc. CTOS error codes --
;
;NLS message number is the same as error code for GetErcMessage
;
%ErrorCode(1,"End of file (EOF) (Error 1).")
%ErrorCode(2,"End of medium (EOM) (Error 2).")
%ErrorCode(6,"The server is not responding (Error 6).")
%ErrorCode(202,"Directory full (Error 202).")
%ErrorCode(203,"No such file (Error 203).")
%ErrorCode(204,"No such Directory (Error 204).")
%ErrorCode(205,"Bad file specification (Error 205).")
%ErrorCode(210,"Bad file handle (Error 210).")
%ErrorCode(211,"Bad buffer size (Error 211).")
%ErrorCode(213,"No free FAB (Error 213).")
%ErrorCode(214,"No free file number. (Error 214).")
%ErrorCode(215,"No such volume or device (Error 215).")
%ErrorCode(216,"Volume not mounted (Error 216).")
%ErrorCode(217,"Invalid password (Error 217).")
%ErrorCode(219,"Access denied (Error 219).")
%ErrorCode(220,"File in use (Error 220).")
%ErrorCode(221,"File header bad checksum (Error 221).")
%ErrorCode(224,"File already exists (Error 224).")
%ErrorCode(225,"No free File Headers (Error 225).")
%ErrorCode(226,"Free File Headers broken (Error 226).")
%ErrorCode(227,"Device is in use (Error 227).")
%ErrorCode(228,"Device already mounted (Error 228).")
%ErrorCode(229,"Device not mounted (Error 229).")
%ErrorCode(230,"Disk full or fragmented (Error 230).")
%ErrorCode(232,"No valid volume home block (Error 232).")
%ErrorCode(234,"Odd bytes buffer address (Error 234).")
%ErrorCode(235,"Original volume no longer mounted (Error 235).")
%ErrorCode(243,"Volume structure verify error (Error 243).")
%ErrorCode(250,"File containes too many extents (Error 250).");*M00*
%ErrorCode(255,"Data verification error (Error 255).")
%ErrorCode(320,"Floppy disk controller busy in comand (Error 320).")
%ErrorCode(321,"Floppy disk controller never ready in command (Error 321).")
%ErrorCode(322,"Floppy disk controller data input in command (Error 322).")
%ErrorCode(323,"Floppy disk controller never ready in result (Error 323).")
%ErrorCode(324,"Floppy disk controller not data input in result (Error 324).")
%ErrorCode(325,"Floppy disk controller not busy after Xfer request (Error 325).")
%ErrorCode(326,"Floppy disk controller wrong unit after Xfer request (Error 326).")
%ErrorCode(327,"Floppy disk controller busy without Xfer request (Error 327).")
%ErrorCode(328,"Floppy disk controller interrupt from undefined unit (Error 328).")
%ErrorCode(329,"Floppy time out (Error 329).")
%ErrorCode(330,"Incomplete DMA transfer to/from floppy (Error 330).")
%ErrorCode(340,"Disk controller busy in command (Error 340).")
%ErrorCode(341,"Disk controller never ready in command (Error 341).")
%ErrorCode(342,"Disk controller data input in command (Error 342).")
%ErrorCode(343,"Disk controller never ready in result (Error 343).")
%ErrorCode(344,"Disk controller not data input in result (Error 344).")
%ErrorCode(345,"Disk controller not busy after Xfer request (Error 345).")
%ErrorCode(346,"Disk controller wrong unit after Xfer request (Error 346).")
%ErrorCode(347,"Disk controller busy without Xfer request (Error 347).")
%ErrorCode(348,"Disk controller interrupt from undefined unit (Error 348).")
%ErrorCode(349,"Disk timeout (Error 349).")
%ErrorCode(350,"Incomplete DMA transfer to/from disk (Error 350).")
%ErrorCode(351,"Bad disk controller (Error 351).")
%ErrorCode(300,"Device not ready (Error 300).")
%ErrorCode(301,"I/O error (Error 301).")
%ErrorCode(302,"Write protected (Error 302).")
%ErrorCode(303,"No free I/O Block (Error 303).")
%ErrorCode(400,"Not enough memory available (Error 400).")
%ErrorCode(402,"Memory deallocation error (Error 402).")
%ErrorCode(410,"All exchanges already allocated (Error 410).")
%ErrorCode(411,"Exchange deallocation error (Error 411).")
;
; Internal errors:
;
%ErrorCode(8001h,"Data compare error."); MDD 8001h = 32769 decimal
%ErrorCode(8002h,"Cannot use drives at another workstation."); MDD 32770.

%FinishErrorCodes
%InitStrings

; 10/21/86  CLR  added .bin file spec
%pbcbString (MsgFilename) ('[sys]<sys>FileUtilMsg.bin')
%pbcbString (F0)     ('[f0]'); NLS Non-translatable
%pbcbString (F0Pswd) (''); NLS Non-translatable
%pbcbString (F1)     ('[f1]'); NLS Non-translatable
%pbcbString (F1Pswd) (''); NLS Non-translatable
%pbcbString (TmpFile)  ('[Scr]<$>FloppyCopy.Tmp'); NLS Non-translatable

%sbString sbHeader1 ('Floppy Copy '); NLS Msg 34201
%sbString sbHeader2 (0FFh,'VN'); NLS Non-translatable

%sbString sbYes ('yY'); Use NLSYesOrNo
%sbString sbNo ('nN'); Use NLSYesOrNo

;*** The following 2 messages are combined to form NLS Msg 34202
%sbString sbInvalidParam1 (10,'Invalid parameter ')
%sbString sbInvalidParam2 ('')

;*** The following 2 messages are combined to form NLS Msg 34203
%sbString sbMustBeLocal1 (10,10,'The floppy disk drive ')
%sbString sbMustBeLocal2 (' must be a local device. ')

;*** The following 2 messages are combined to form NLS Msg 34204
%sbString sbIsntAFloppy1 (10,10,'The device ')
%sbString sbIsntAFloppy2 (' does not exist or is not a floppy drive.')

;*** Use NLS Msg 34205 for international version of the following message
%sbString sbNotADualFloppy (10,10,'This is not a dual floppy workstation.')

;*** The following 2 messages are combined to form NLS Msg 34206
%sbString sbVolume1 (10,'Volume name: "')
%sbString sbVolume2 ('"')

;*** The following 3 messages are combined to form NLS Msg 34207
%sbString sbCopyNumber1 (10,10,10,'Copy number ')
%sbString sbCopyNumber2 (' of ')
%sbString sbCopyNumber3 ('.')

;*** The following 2 messages are combined to form NLS Msg 34208
%sbString sbFormat1 (10,'Formatting ')
%sbString sbFormat2 (' ... ')
%sbString sbFormat3 ('done.'); NLS Msg 34135

;*** The following 3 messages are combined to form NLS Msg 34220
%sbString sbCopying1 (10,'Copying ')
%sbString sbCopying2 (' to ')
%sbString sbCopying3 (' ... ')
%sbString sbCopying4 ('done.'); NLS Msg 34135

;*** The following 3 messages are combined to form NLS Msg 34209
%sbString sbCopyIoWarning1 (10,10,'WARNING: Soft I/O Error at lfa ')
%sbString sbCopyIoWarning2 (' (hex) of ')
%sbString sbCopyIoWarning3 ('.')
;*** The following 2 messages are combined to form NLS Msg 34210
%sbString sbIoLfa1 (10,9,'I/O Error at lfa ')
%sbString sbIoLfa2 (' (hex)')
%sbString sbCannotMount (10,10,'Note: Copy cannot be mounted due to duplicate volume name.'); NLS Msg 34211
%sbString sbDevNamesMustDiffer (10,10,'In dual floppy mode, device names must be different.'); NLS Msg 34212
%sbString sbMustSpecifyTwoDevices (10,10,'In dual floppy mode, you must specify two devices.'); NLS Msg 34213

;*** The following 2 messages are combined to form NLS Msg 34214
%sbString sbLoadMasterStr1 (4 dup(10),'Insert MASTER floppy to be copied in drive ')
%sbString sbLoadMasterStr2 ('.',10,'Press GO to continue or FINISH to quit. ')

;*** The following 2 messages are combined to form NLS Msg 34215
%sbString sbLoadCopyStr1 (10,'Insert blank diskette in drive ')
%sbString sbLoadCopyStr2 ('.',10,'Press GO to continue, CANCEL to use another master, or FINISH to quit. ')

;*** The following 3 messages are combined to form NLS Msg 34216
%sbString sbLoadMasterAndCopyStr1 (4 dup(10),'Insert MASTER floppy in drive ')
%sbString sbLoadMasterAndCopyStr2 (' and blank diskette in drive ')
%sbString sbLoadMasterAndCopyStr3 ('.',10,'Press GO to continue or FINISH to quit. ')

;*** Use NLS Msg 34217 for international version of the following message
%sbString sbContinueOrQuit (10,9,'Press GO to continue or FINISH to quit. ')
;*** Use NLS Msg 34218 for international version of the following message
%sbString sbContinueOrDeny (10,9,'Press GO to continue or FINISH to deny. ')

;*** The following 4 messages are combined to form NLS Msg 34219
%sbString sbOverwriteOK1 (10,10,9,'Diskette in drive ')
%sbString sbOverwriteOK2 (' is a valid volume.',10,9,'Volume name: "')
%sbString sbOverwriteOK3 ('"',10,9,                  'Password:    "')
%sbString sbOverwriteOK4 ('"',10,9,'Overwrite OK?',10)

%sbString sbInvalidVolumeName ('?'); NLS Non-translatable

;*** The following 2 messages are combined to form NLS Msg 34221
%sbString sbBadVhb1 (10,10,9,'Diskette in drive ')
%sbString sbBadVhb2 (' is not a valid volume.',10,9,'Do you wish to copy this diskette?')

%sbString sbDevType1DIws (' (8-inch diskette)'); NLS message 34222
;*** Use NLS Msg 34223 for international version of the following message
%sbString sbDevType1DAws (' (single sided 5',10h,'-inch diskette)')
;*** Use NLS Msg 34224 for international version of the following message
%sbString sbDevType2DAws (' (dual sided 5',10h,'-inch diskette)')

;*** The following 2 messages may be combined to form NLS Msg 34138
%sbString sbTypeErc1 ('Error '); NLS Msg 34136
%sbString sbTypeErc2 (' (see documentation)'); NLS Msg 34137
%sbString rgDone ('done.
'); NLS Msg 34619
;*** Use NLS Msg 34139 for international version of the following message
%sbString sbInsertSysdiskette ('

**** Cannot load Exit Run File, please reinsert system diskette.')

fBeep DB 0FFh
PUBLIC fBeep

%FinishStrings
END
