;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: BackupVolumeMsg.asm                                                 *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 08/28/89 120C/00 P. Campbell  / Master -> Server, Server -> Service       *;
;*                                                                           *;
;* --11.2--                                                                  *;
;* 07/15/87 MDE Add stumble through messages for IVolume (rgTooFew*)         *;
;* ----                                                                      *;
;* 10/15/86 PBC merged 5.0 MegaFrame changes (of 3/21/86 and 4/25/86)        *;
;* 09/16/86 PBC change message for debug prompt and add rgNoEncryption       *;
;* 04/25/86 SFH Added .rgBadStepRate for stepRate range check                *;
;* 03/21/86 RGS Added new strings to support FP-4 (WD2010 w/ ECC)            *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED     *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

$INCLUDE(:f0:ErcMsg.Mdf)
$INCLUDE(:f0:String.mdf)

%InitErrorCodes(OGetErcMessage,0)

%ErrorCode(1,"Not enough arguments provided.")
%ErrorCode(2,"Illegal number.")
%ErrorCode(3,"Starting byte count and length outside of valid boundaries.")
%ErrorCode(4,"Invalid cylinder or head.")
%ErrorCode(5,"Illegal sector address for floppy.")
%ErrorCode(6,"Sector address is out of valid range.")
%ErrorCode(7,"Bad spots for floppy can only be given in the form ''cylinder/head/#sector''. ")
%ErrorCode(8,"Bad spots must be given in the form ''cylinder/head/#sector'' with SMD controller.")

%FinishErrorCodes
;
; Text messages for IVolume
;
%InitStrings

%sbString	rgName				('Initialize Volume ')
%sbString	rgSRPName			('SRP Initialize Volume  ')
%sbString	rgNoDevName			(' ''Device name'' must be supplied.')
%sbString	rgNoVolName			(' ''Volume name'' must be supplied.')
%sbString	rgNoEncryption		('Password encryption is not supported on this version of the OS.'); NLS Msg 34405
%sbString	rgBadDevName		('Unbalanced brackets in device name or device name more than twelve characters.')
%sbString	rgBadVolName		('Unbalanced brackets in volume name or volume name more than twelve characters.')
%sbString	rgBadDevPassword	('Device password may not be more than twelve characters.')
%sbString	rgBadVolPassword	('Volume password may not be more than twelve characters.')
%sbString	rgBadSysPassword	('Sys Directory password may not be more than twelve characters.')
%sbString	rgCantOpenLog		('Cannot open the log file.')
%sbString	rgExtTracksNotAppl	('Extended floppy tracks are only applicable to 8-inch diskettes.')
%sbString	rgDevInUse			('Device is currently in use.  It cannot be initialized.')
%sbString	rgBadSectorSize		('Device must have 512 byte sectors.')
%sbString	rgBadDiskParamFile	('Error in disk parameter file.')
%sbString	rgNoDiskParamFile	('No disk parameter file exists for this device type.');
%sbString	rgNoDevTypeGiven	('No device type given and this device is not a valid volume.')
%sbString	rgWaitingForDisk	('Waiting for removable disk to become ready ...')
%sbString	rgDiskTimeOut		('Removable disk never came ready.')
%sbString	rgBadModelCode		('Unknown winchester model code.')
%sbString	rgSingleSideNotAppl	('Single-sided minifloppy is only applicable to 5-inch diskettes.')
%sbString	rgInsertDisk    	('Please insert disk to be initialized.')
%sbString	rgInsertDiskette	('Please insert diskette to be initialized.')
%sbString	rgValidVolume		('Medium is a valid volume.')
%sbString	rgDestroyVolume		('
Do you wish to ERASE this volume?')
%sbString	rgOperationAborted	('Operation aborted by operator.')
%sbString	rgEnterPassword		('#Please enter the volume''s password : ')
%sbString	rgInvalidPassword	('
Invalid password was supplied.')
%sbString	rgErrOpenDevice		('Error while trying to open the device.')
%sbString	rgInvalidDevName	('An invalid device name was specified.')
%sbString	rgCantAccessDev		('
Unable to successfully access the device.')
%sbString	rgDiskNotBigEnough	('Disk not large enough for requested file sizes.')
%sbString	rgTooManyFilesSpec	 ('Too many files were specified.')
%sbString	rgNeedBootExttoStart ('File [Sys]<Sys>BootExt.Sys is missing.')
%sbString	rgMaxDirs		('
Maximum number of directories on volume: ')
%sbString	rgMaxFilesOnVol	('
Maximum number of files on volume: ')
%sbString	rgMaxFilesOnDir	('
Maximum number of files on directory SYS: ')
%sbString	rgTo			('to ')
%sbString	rgCantAllocMap	('Not enough good disk for allocation map.')
%sbString	rgLocalOnly		('Can only initialize local disks.')
%sbString	rgCantInit		('Disk cannot be initalialized.')
%sbString	rgFHBAllocErr	('Software error in FHB allocation.')
%sbString	msgA	('Device Name: ')
%sbString	msgB	('#Device Password: ')
%sbString 	msgC	('Volume Name: ')
%sbString 	msgD	('#Volume Password: ')
%sbString 	msgE	('System Image sectors: ')
%sbString 	msgF	('Log file sectors : ')
%sbString 	msgG	('Maximum number of directories on volume: ')
%sbString 	msgH	('Maximum number of files on volume: ')
%sbString 	msgI	('Maximum number of files in Sys directory: ')
%sbString	msgJ	('Write protect Sys directory? ')
%sbString 	msgK	('Crash file size in sectors: ')
%sbString 	msgL	('Drive Type Code or Device Parameter: ')
%sbString	msgO	('Suppress format of medium? ')
%sbString	msgP	('Surface tests: ')
%sbString	msgQ	('Debug (y to debug, p for encrypted passwords): ')
%sbString	msgR	('Log file: ')
%sbString	msgS	('#Sys Directory password: ')
%sbString	msgT	('Primary file headers only? ' )
%sbString	msgU	('Debug? ' )
%sbString	msgW	('Write ECC Format? ')
%sbString	msgX	('Bad spots: ')
%sbString	msgZ	('High Capacity floppy or Extended floppy tracks? ')
%sbString	rgBadSpotInfo		('
Bad spot information for volume: ')
%sbString	rgAltBadSpotInfo	('
To enter bad spots in Ivolume utility [Bad Spots] field, use: ')
%sbString	rgBadSpotTable1		('  Cylinder  Head  Sector  # Sectors')
%sbString	rgBadSpotTable2		('
  ========  ====  ======  =========')
%sbString	rgBadSpotSyn		('Syntax error in bad spots parameter : ')
%sbString	rgCylinder			(' Cylinder : ')
%sbString	rgHead				(' Head : ')
%sbString	rgSector			(' Sector : ')
%sbString	rgAllocError		('
Allocation error. Bad spot not correctly allocated.')
%sbString	rgDiskContains		('
Disk contains ')
%sbString	rgBadSector			(' bad sector.
')
%sbString	rgBadSectors		(' bad sectors.
')
%sbString	rgSpaces			('   ')	; used in printing disk address
%sbString	rgTooManyBadSpots	('Too many bad spots, initialization terminated.')
%sbString	rgFormatting		('Formatting Disk ... ')
;*** Use NLS Msg 34331 for international version of the following message
%sbString	rgSCSIFormatting		('Formatting SCSI hard drive ... ')
%sbString	rgBadSpotLoc		('Bad spot at ')
%sbString	rgSurfaceTest		('
Surface test - Pass : ')
%sbString	rgRetryCyl			('Retrying cylinder : ')
%sbString	rgControllerMalfunc	('Data read does not compare with data written -- controller malfunction!.')
%sbString	rgInvalidVolName	('Volume name provided is an invalid volume name.')
%sbString	rgUnableToInit		('Unable to initialize the device with the new volume name given.')
%sbString	rgNameConflicts		('
This volume name probably conflicts with another volume on the system.')
%sbString	rgUnableReadBad		('
Unable to read the bad spot information from the disk.  Error: ')
%sbString	rgInvalidBSData		('
The bad spot file contains invalid bad spot information for this device.')
%sbString	rgInitializing		('Initializing the disk on ')
%rgbcbString	(DataLost)		(' ... all data on the disk is lost!')
%sbString	rgWriteProtected	('Disk is write-protected.  It cannot be initialized.')
%sbString	rgInsertTab			('Insert the write-enable tab.')
%sbString	rgRemoveTab			('
Remove the write-protect tab.')
%sbString	rgDevNotReady		('Device is not ready.')
%sbString	rgPlaceProperly		('
Make sure diskette is properly placed in the drive.')
%sbString	rgWritingVolStrucs	('
Writing volume structures on disk.')
%sbString	rgAllocBitDisagree	('Allocation error.  Bit map addresses disagree.')
%sbString	rgFirst14Bad		('First 14 sectors are all bad.')
%sbString	rgFirstSectorBad	('The first disk sector is bad.  This disk is unusable as a volume.')
%sbString	rgNotEnufSecs		('
Not enough consecutive sectors for SYS directory. 
Specify fewer files.')
%sbString	rgTooFewSecs		('SYS directory too big.  Actual number of sectors allocated: ')
%sbString	rgNotEnufSys		('Not enough consecutive good sectors for system image.')
%sbString	rgTooFewSys			('System image too big.  Actual number of sectors allocated: ')
%sbString	rgNotEnufCrash		('Not enough consecutive good sectors for crash dump.')
%sbString	rgTooFewCrash		('Crash file too big.  Actual number of sectors allocated: ')
%sbString	rgNotEnufLog		('Not enough consecutive good sectors for log file. Specify a smaller log file.')
%sbString	rgTooFewLog			('Log file too big.  Actual number of sectors allocated: ')
%sbString	rgNotEnufMFD		('Not enough consecutive sectors for the master file directory.')
%sbString	rgTooFewMfd			('Master file directory too big.  Actual number of files allocated: ')
%sbString	rgNotEnufMemory		('Not enough memory to build track format data.')
%sbString	rgSpecifyFewer		('Specify fewer directories.')
%sbString	rgNotEnufFH			('Not enough consecutive sectors for file headers. Specify fewer files.')
%sbString	rgTooFewFH			('Too many file headers.  Actual number of file headers allocated: ')
%sbString	rgFHBErr			('Error while initializing the FHBs.')
%sbString	rgCantMount			('Unable to mount the new volume.')
%sbString	rgSysFilesErr		('Error while creating system files.')
%sbString	rgIVComplete		('
Volume initialization complete.')
%sbString	rgInitAnother		('
Initialize another volume?
')
%sbString	rgFMore				('more?')
%sbString	rgPrintHex			(':   ')
%sbString	rgFVolName			('Volume Name: ')
%sbString	rgFCreateDT			('
Creation Date/Time: ')
%sbString	rgLastMod			('
Last Modification Date/Time: ')
%sbString	rgFreePages			('
Number of Free Sectors: ')
%sbString	rgFreeHeaders		('
Number of Free File Headers: ')
%sbString	rgMaxValuesAre		('Maximum values are,')
%sbString	rgMaxCylinder		(' cylinder: ')
%sbString	rgMaxHead			(' head: ')
%sbString	rgMaxSector			(' sector: ')
%sbString	rgDriveVendorCode	('Drive vendor code: ')
%sbString	rgCylsPerDisk		('Cylinders per disk: ')
%sbString	rgSectsPerTrk		(' Sectors per track: ')
%sbString	rgHeadsPerCyl		(' Heads/tracks per cylinder: ')

%sbString	paramTextA ('Removable Media? ')
%sbString	paramTextB ('Cylinders per disk: ')
%sbString	paramTextC ('Tracks per cylinder: ')
%sbString	paramTextD ('Sectors per Track: ')
%sbString	paramTextE ('Bytes per sector: ')
%sbString	paramTextF ('Step rate code: ')
%sbString	paramTextG ('Write Precomp Cylinder: ')
%sbString	paramTextH ('Spiral format factor: ')
; NLS Msg 34407
%sbString	paramTextI ('Avg single track seek, in tenths of msec: ')
%sbString	paramTextJ ('Seek settling time, tenths of msec: ')

%sbString	rgParamDoNotAgree	('Input disk parameters do not agree with values on the Valid Volume--Overwrite?')
%sbString	rgCylOutOfRange		('This controller can only address 1024 cylinders per disk.') ; NLS Msg 34265
;*** Use NLS Msg 34364 for international version of the following message
%sbString	rgEccNotAvailable	('This controller cannot use ECC format.')

;*** Use NLS Msg 34408 for international version of the following message
%sbString	rgEccParamMismatch	('Input ECC format parameter does not agree with value on the volume--Overwrite?')
%sbString	rgCannotChangeEcc	('Cannot change ECC format without formatting the disk.'); NLS Msg 34409
;*** Use NLS Msg 34410 for international version of the following message
%sbString	rgNoEccOnSmd  ('ECC formatting is automatic for SMD devices.')
;*** Use NLS Msg 34411 for international version of the following message
%sbString	rgBadStepRate ('Invalid Step Rate code, must be <= 15.')
%sbString	rgSpiralNotAvailable ('This controller cannot perform spiral formatting.') ; NLS Msg 34404

%sbString	sbDefectPrompt	('Defect: ')
%sbString	sbDefectPrompt1	('Enter as  cyl/head/BFI or  cyl/head/#sector  and,')
%sbString	sbDefectPrompt2	('press NEXT or RETURN.  Press GO to start Ivolume.')
%sbString	sbDefectPrompt3	('Enter defect and press NEXT or RETURN.')
%sbString	sbDefectPrompt4	('Press GO to start Ivolume.')
%sbString	sbVendorPrompt	('Vendor code: ')
%sbString	sbVendorPrompt1	('Enter code or cyls/heads/sectors and press GO.')
%sbString	sbDevTmpPrompt	('Device Template: ')
%sbString	sbDevTmpPrompt1	('Enter Device Template name and press GO.')


fInteractive	DB 0ffh		;if set to 0ffh then ivolume will enter the
			;interactive mode when initializing an Ngen winchester which
			;had not been initialized previously.  If set to zero, the
			;interactive mode will not be entered.

cVendorPrompt	DB 13	;number of chars in 'Vendor code: ' string /* ???????*/
cDevTmpPrompt	DB 17	;number of chars in 'Device Template: ' string
cDefectPrompt	DB 8	;number of chars in 'Defect: ' string
iSizeWindow		DB 12	;number of lines in defect entry window
PUBLIC cVendorPrompt,cDevTmpPrompt,cDefectPrompt,fInteractive,iSizeWindow

%pbcbString  (TypeError) 	(' That is an unknown vendor code. ')
%pbcbString  (DefectError1) (' Format of entry is cyl/head/#sector or cyl/head/BFI. ')
%pbcbString  (DefectError2) (' Syntax of entry is incorrect. ')
%pbcbString  (DefectNumBad) (' Cylinder, head, sector or BFI values are out of range. (Press Help) ')
%pbcbString  (DefectArgBad) (' Not enough arguments in the defect entry. (Press Help) ')
%pbcbString  (NumRange) 	(' Range of value entered is incorrect.  Cannot be negative or zero.')
%pbcbString  (InvalidFormat) (' Format must be  Cylinders/Heads/Sectors.')
%pbcbString  (NotEnoughArgs) (' Not enough arguments.  Format  is Cylinders/Heads/Sectors.')

%pbcbString	(HelpDevTmp1)	('A valid device template name is required to continue to backup this ')

%pbcbString	(HelpDevTmp2)	('disk. The name last used to initialize this disk can usually be found in ')

%pbcbString	(HelpDevTmp3)	('[sys]<sys>FormatDiskConfig.sys.  For workstations, the device template ')

%pbcbString (HelpDevTmp4)	('name usually matches the vendor code or type found on the defect label ')

%pbcbString	(HelpDevTmp5)	('attached to the underside of the disk module.  A device template in ') 

%pbcbString (HelpDevTmp6)	('the configuration file can identified by the field  :DeviceTemplate:.')

%pbcbString (HelpDevTmp7)	('The number of cylinders, heads, and sectors may be used in place        ')

%pbcbString (HelpDevTmp8)	('of the device template name.  Enter the code or disk size and then         ')

%pbcbString	(HelpDevTmp9)	('          Press  GO  to continue,  Finish  to terminate or Help.      ')

%pbcbString (BadFcfOpen)	('Unable to open [sys]<sys>FormatDiskConfig.sys.')

%pbcbString	(BadCapInfo)	('The disk capacity information in FormatDiskConfig.sys is invalid.')

%pbcbString (NotEnufCapInfo) ('The disk capacity information in FormatDiskConfig.sys is incomplete.')

%pbcbString (BadDeviceTemplate) ('No match found for device template name.')

; The following rgbcbstrings are format configuration file field names and not 
;   for nationalization.

%rgbcbString (FormatTemplate) 		('FormatTemplate')
%rgbcbString (DeviceTemplate) 		('DeviceTemplate')
%rgbcbString (CylindersPerDisk) 	('CylindersPerDisk')
%rgbcbString (TracksPerCylinder) 	('TracksPerCylinder')
%rgbcbString (SectorsPerTrack) 		('SectorsPerTrack')
%rgbCbString (BytesPerSector)		('BytesPerSector')
%rgbCbString (WritePreCompCyl)		('WritePreCompCyl')
%rgbCbString (WritePreComp)			('WritePreComp?')
%rgbCbString (SeekStepRate)			('SeekStepRate')
%rgbCbString (Removable)			('Removable?')
%rgbCbString (UtilizeEcc)			('UtilizeEcc?')	
%rgbCbString (SpiralFactor)			('SpiralFactor')

%FinishStrings

END
