; Data_Clstr.asm - data publics for the workstation agent.

%SET(nTryNewMaster,32)
%SET(nXBlk,2)
%SET(sXBlk,4096+64)
%SET(sioClock,24)
%SET(nRcb, 50)
%SET(clusterTimeout, 10)

; Size of Control Block Definitions

sRcbIws        EQU 18
sRcbAws        EQU 18

lxBlockHeaderSize EQU 36 ; 
lxBlockRqSize EQU 64  ;max size request block header that can fit in an XBlock

data SEGMENT PUBLIC 'DATA'

; This is the number of times to retry sending XID to the master before we decide it must be an old master.  It takes longer for a workstation to come up if this number if large.  It should be around 10 for an NGen workstation on a cluster of 40 workstations.
PUBLIC nTryNewMaster 
nTryNewMaster DB %nTryNewMaster

PUBLIC nXBlk, sXBlk, sXBlkHeader, sXBlkRqMax
PUBLIC sRcb,cRcbMax
PUBLIC daiLocal
PUBLIC clusterTimeout
PUBLIC sioClock
PUBLIC wsAgentPriority
PUBLIC fRebootClstr
PUBLIC FilterProcessExch

nDct DW 0
nXBlk  DW %nXBlk
sXBlk  DW %sXBlk
sXBlkHeader DW lxBlockHeaderSize
sXBlkRqMax  DW lxBlockRqSize
cRcbMax  DW %nRcb
sRcb  DW sRcbAws
clusterTimeout DW (%clusterTimeout+1)/2 ;each unit of clusterTimeout is 2sec.
daiLocal DW ?
sioClock DB %sioClock
wsAgentPriority DB 1
fRebootClstr DB 0
FilterProcessExch DW ?
; Dummy stuff
Public	pStat, pDiskStat, pCdt, nmbHeap

pCdt		DD ?
pStat		DD ?
pDiskStat	DD ?
nmbHeap		LABEL BYTE

data ENDS
END
; 2/23/90 by JA Created from sysgen.mdf.
; 4/26/90 by JC Added Public specification for prgoUcb
; 7/30/90 by JM obsolete nSectorPerXblock
; 8/29/90 by JA Config,NetServerData,vf to Data_All.
; 10/16/92 by JF add FilterProcessExch to move filterProcess out of OS.
; 3/30/93 by JA Added cbLineTable, mpiLinebSlot.
; 03/31/93 by JA recant above.
; 07/13/93 by JF Make XBlock header size 4 bytes bigger for cache.