(*
---------------------------------------------------------------------
   :Program.       Logigraph.mod
   :Contents.      Bildschirmaufbau fr Logikus.mod
   :Author.        Franz X. Dimbeck
   :ADdress.       Troppauerstr. 48, D-8058 Erding, BRD
   :Phone.         08122 18135
   :Copyright.     Public Domain
   :Language.      Modula-2
   :Translator.    M2Amiga V3.3d
   :History.       V1.1 13.Mar.1990
---------------------------------------------------------------------
*)

(* $R- $V- $S- $F- *)
IMPLEMENTATION MODULE LogiGraph;

FROM Arts       IMPORT TermProcedure, Assert, CurrentLevel;
FROM Dos        IMPORT Delay;
FROM Graphics   IMPORT RastPortPtr, ViewPortPtr, Move, Draw, Text, SetAPen,
                       SetBPen, LoadRGB4, WritePixel, SetRast, SetDrMd ,jam1,
                       jam2, DrawModes, DrawModeSet, RectFill,ViewModeSet ,
                       ViewModes ;
FROM Intuition  IMPORT customScreen, IDCMPFlags, IDCMPFlagSet, NewScreen ,
                       NewWindow, ScreenFlags , ScreenFlagSet , ScreenPtr,
                       WindowFlags, WindowFlagSet, WindowPtr,
                       CloseScreen, CloseWindow, MakeScreen, OpenWindow,
                       OpenScreen, ShowTitle, RethinkDisplay,
                       ScreenToFront, Gadget, strGadget, GadgetFlags,
                       GadgetFlagSet, StringInfo, ActivationFlags,
                       ActivationFlagSet, MoveScreen;
FROM Str        IMPORT Length;
FROM SYSTEM     IMPORT ADR, INLINE;

CONST
   maxspalte = 19;
   maxreihe  = 9;
   maxlampen = 9;
(*   In Logigraph.def
TYPE
   String80 = ARRAY [0..79] OF CHAR;
*)
VAR
   Ciapra [0BFE001H]: SET OF (s0,s1,s2,s3,s4,s5,lmb);
(*   In Logigraph.def
   MyScreen         : ScreenPtr;
   MyWindow         : WindowPtr;
   MyRast           : RastPortPtr;
   MyGadget         : GadgetPtr;
   Buf              : ARRAY [0..4] OF String80;
   UBuf             : ARRAY [0..4] OF String80;
*)
   AWindow          : WindowPtr;
   ARast            : RastPortPtr;
   NewWin,AWin      : NewWindow;
   NewScr           : NewScreen;
   StartLevel       : INTEGER;
   MyView           : ViewPortPtr;
   Name , a , b     : String80;
   fehler           : BOOLEAN;
   length           : INTEGER;
   x, y,
   xalt ,yalt ,
   xneu,yneu,Dummy  : LONGINT;
   i, j             : INTEGER;
   SchiebGadget     : ARRAY [0..4] OF Gadget;
   Info             : ARRAY [0..4] OF StringInfo;

PROCEDURE FarbDaten1; (* $E- *)
BEGIN
INLINE (0000H, 0DA7H, 0FC9H, 0531H, 0531H, 0531H, 0531H, 0531H,
        0531H, 0531H, 0531H, 0531H, 0531H, 0E30H, 0B85H, 07FH);
END FarbDaten1;

PROCEDURE FarbDaten2; (* $E- *)
BEGIN
INLINE (0000H, 0532H, 0643H, 0100H, 0100H, 0100H, 0100H, 0100H,
        0100H, 0100H, 0100H, 0100H, 0100H, 0610H, 0432H, 0057H);
END FarbDaten2;

PROCEDURE FarbDaten3; (* $E- *)
BEGIN
INLINE (0000H, 0DA7H, 0000H, 0E30H, 0531H, 0531H, 0531H, 0531H,
        0531H, 0531H, 0531H, 0531H, 0531H, 0E30H, 0B85H, 007FH);
END FarbDaten3;

PROCEDURE Farbdaten0; (* $E- *)
BEGIN
INLINE (0000H, 0000H, 0000H, 0000H, 0000H, 0000H, 0000H, 0000H,
        0000H, 0000H, 0000H, 0000H, 0000H, 0000H, 0000H, 0000H);
END Farbdaten0;

PROCEDURE Schatten(x,y,laenge:INTEGER;text:ARRAY OF CHAR);
BEGIN
   SetDrMd (MyRast,jam1);
   Move (MyRast,x-1,y-1);
   SetAPen (MyRast,2);
   Text (MyRast,ADR(text),laenge);
   Move (MyRast,x+1,y+1);
   SetAPen (MyRast,0);
   Text (MyRast,ADR(text),laenge);
   Move (MyRast,x,y);
   SetAPen (MyRast,14);
   Text (MyRast,ADR(text),laenge);
   SetDrMd (MyRast,jam2);
END Schatten;

PROCEDURE Lampe(x:INTEGER);
VAR  x1,y1,x2,y2,Breite,Hoehe : INTEGER;
BEGIN
   Breite := 57;
   Hoehe  := 45;
   x1 := 48+x*(Breite+2);
   x2 := x1+Breite;
   y1 := 2;
   y2 := y1+Hoehe;
   SetAPen(MyRast,x+3);
   RectFill(MyRast,x1,y1,x2,y2);
END Lampe;

PROCEDURE Lampen;
VAR i,x1,y1,x2,y2,Breite,Hoehe : INTEGER;
BEGIN
   Breite := 57;
   Hoehe  := 45;
   y1 := 2;
   y2 := y1+Hoehe;
   FOR i := 0 TO 9 DO
      Lampe(i);
   END;
   SetDrMd (MyRast,jam1);
   SetAPen (MyRast,0);
   FOR i := 1 TO 4 DO
      Move (MyRast,48,9*i+9);
      Text (MyRast,ADR(Buf[i]),Length(Buf[i]));
   END;
   SetAPen(MyRast,0);
   FOR i := 0 TO 9 DO
      x1 := 48+i*(Breite+2);
      x2 := x1+Breite;
      Move(MyRast,x2+1,y1);
      Draw(MyRast,x2+1,y2);
   END;
      Move(MyRast,48,y1);Draw(MyRast,48,y2);
      Move(MyRast,48,y1);Draw(MyRast,638,y1);
      Move(MyRast,48,y2);Draw(MyRast,638,y2);
END Lampen;

PROCEDURE LampSchrift(x:INTEGER);
VAR  x1,y1,x2,y2,Breite,Hoehe: INTEGER;
BEGIN
   Breite := 57;
   Hoehe  := 45;
   x1 := 48+x*(Breite+2);
   x2 := x1+Breite;
   y1 := 2;
   y2 := y1+Hoehe;
   SetAPen(MyRast,0);
   Move(MyRast,x1+23,y2+3);Draw(MyRast,x1+25,y2+3);
   Move(MyRast,x1+29,y2+3);Draw(MyRast,x1+31,y2+3);
   Move(MyRast,x1+35,y2+3);Draw(MyRast,x1+37,y2+3);
   a := "L ";
   a[1] := CHAR(x+48);
   Schatten(x1+22,y2+13,2,a);
END LampSchrift;

PROCEDURE Noch3();
VAR y : INTEGER;
BEGIN
   y  := 50;
   SetAPen(MyRast,0);
   Move(MyRast,12,y);Draw(MyRast,14,y);
   Move(MyRast,18,y);Draw(MyRast,20,y);
   Move(MyRast,24,y);Draw(MyRast,26,y);
   a := "Q ";
   Schatten(14,y+11,2,a);
   y  := 75;
   SetAPen(MyRast,0);
   Move(MyRast,12,y);Draw(MyRast,14,y);
   Move(MyRast,18,y);Draw(MyRast,20,y);
   Move(MyRast,24,y);Draw(MyRast,26,y);
   a := "Ta";
   Schatten(10,y+11,2,a);
   y  := 100;
   SetAPen(MyRast,0);
   Move(MyRast,12,y);Draw(MyRast,14,y);
   Move(MyRast,18,y);Draw(MyRast,20,y);
   Move(MyRast,24,y);Draw(MyRast,26,y);
   a := "Tb";
   Schatten(10,y+11,2,a);
END Noch3;

PROCEDURE Box(x,y:INTEGER);
VAR i, j, x1, y1, x2, y2, Breite, Hoehe: INTEGER;
BEGIN
   Breite := 29;
   Hoehe  := 24;
   x1     := 73+x*2*Breite;
   y1     := 75+y*(Hoehe+2);
   x2     := x1+Breite;
   y2     := y1+Hoehe;
   IF x = 0 THEN
      a[0] := CHAR(y*2+65);
      Schatten(x1-14,y1+9,1,a);
      a[0] := CHAR(y*2+66);
      IF y=4 THEN a[0] := "K";END;
      Schatten(x1-14,y2-2,1,a);
   END;
   SetAPen (MyRast,2);
   Move (MyRast,x1-1,y2);
   Draw (MyRast,x1-1,y1);
   Move (MyRast,x1,y2);
   Draw (MyRast,x1,y1);
   Draw (MyRast,x2,y1);
   SetAPen (MyRast,14);
   Draw (MyRast,x2,y2);
   Draw (MyRast,x1,y2);
   Move (MyRast,x1+5,y1+Hoehe/2);
   Draw (MyRast,x2-5,y1+Hoehe/2);
   RectFill(MyRast,x1+8,y1+5,x2-8,y1+7);
   RectFill(MyRast,x1+8,y2-7,x2-8,y2-5);
   SetAPen (MyRast,0);
   i := x1+3;
   FOR j := y1+2 TO y2-2 BY 4 DO
      Move(MyRast,i,j);
      Draw(MyRast,i+2,j);
   END;
   i := x2-3;
   FOR j := y1+2 TO y2-2 BY 4 DO
      Move(MyRast,i-2,j);
      Draw(MyRast,i,j);
   END;
END Box;

PROCEDURE Schieber(x:INTEGER;an:BOOLEAN);
VAR x1, y1, x2, y2, Breite, Hoehe: INTEGER;
BEGIN
   Breite := 29;
   Hoehe  := 24;
   x1     := 73+x*2*Breite+6;
   y1     := 235;
   x2     := x1+Breite-6;
   y2     := 255;
   SetAPen (MyRast,1);
   SetDrMd (MyRast,jam2);
   RectFill(MyRast,x1-3,y1-13,x2+2,y2);
   IF an THEN
      SetAPen (MyRast,0); (*SCHWARZ*)
      RectFill(MyRast,x1+7,y1,x2-7,y2);(*SCHLITZ*)
      SetAPen (MyRast,13); (*ROT*)
      RectFill(MyRast,x1,y1-13,x2,y2-13); (*KNOPF*)
      SetAPen (MyRast,2);
      Move(MyRast,x1-1,y2-13);Draw(MyRast,x1-1,y1-12);
      Move(MyRast,x1,y2-13);Draw(MyRast,x1,y1-13);Draw(MyRast,x2,y1-13);
      SetAPen (MyRast,14);
      Move(MyRast,x2+1,y2-13);Draw(MyRast,x2+1,y1-13);
      Move(MyRast,x2,y1-13);Draw(MyRast,x2,y2-13);Draw(MyRast,x1,y2-13);
   ELSE
      SetAPen (MyRast,13); (*ROT*)
      RectFill(MyRast,x1,y1,x2,y2); (*KNOPF*)
      SetAPen (MyRast,0); (*SCHWARZ*)
      RectFill(MyRast,x1+7,y1-13,x2-7,y1-1);(*SCHLITZ*)
      SetAPen (MyRast,2);
      Move(MyRast,x1-1,y2);Draw(MyRast,x1-1,y1);
      Move(MyRast,x1,y2);Draw(MyRast,x1,y1);Draw(MyRast,x2,y1);
      SetAPen (MyRast,14);
      Move(MyRast,x2+1,y2);Draw(MyRast,x2+1,y1);
      Move(MyRast,x2,y1);Draw(MyRast,x2,y2);Draw(MyRast,x1,y2);
   END;(*IF*)
END Schieber;

PROCEDURE Taster;
BEGIN
   SetDrMd (MyRast,jam1);
   SetAPen (MyRast,13);
   RectFill(MyRast,21,235,44,255);
   SetAPen (MyRast,2);
   Move(MyRast,21-1,255);Draw(MyRast,21-1,235);
   Move(MyRast,21,255);Draw(MyRast,21,235);Draw(MyRast,44,235);
   SetAPen (MyRast,14);
   Move(MyRast,44+1,255);Draw(MyRast,44+1,235);
   Move(MyRast,44,235);Draw(MyRast,44,255);Draw(MyRast,21,255);
END Taster;

PROCEDURE Tastan;
BEGIN
   SetDrMd (MyRast,jam1);
   SetAPen (MyRast,13);
   RectFill(MyRast,21,235,44,255);
   SetAPen (MyRast,0);
   Move(MyRast,21-1,255);Draw(MyRast,21-1,235);
   Move(MyRast,21+1,255);Draw(MyRast,21+1,235);
   Move(MyRast,21+2,255);Draw(MyRast,21+2,235);
   Move(MyRast,21,255);Draw(MyRast,21,235);Draw(MyRast,44,235);
   SetAPen (MyRast,2);
   Move(MyRast,44+1,255);Draw(MyRast,44+1,235);
   Move(MyRast,44,235);Draw(MyRast,44,255);Draw(MyRast,21,255);
END Tastan;

PROCEDURE Streifen();
VAR x1,y1,x2,y2 : INTEGER;
BEGIN
   x1 := 3;
   y1 := 210;
   x2 := 637;
   y2 := 220;
   SetDrMd (MyRast,jam1);
   SetAPen (MyRast,2);
   RectFill(MyRast,x1,y1,x2,y2);
   SetAPen (MyRast,14);
   Move(MyRast,x1,y1);
   Draw(MyRast,x2,y1);Draw(MyRast,x2,y2);
   Draw(MyRast,x1,y2);Draw(MyRast,x1,y1);
   Move (MyRast,4,218);
   SetAPen (MyRast,0);
   Text (MyRast,ADR(Buf[0]),Length(Buf[0]));
END Streifen;

PROCEDURE Bild;
   BEGIN
   SetRast (MyRast,1);
   FOR i :=0 TO 9 DO
      FOR j := 0 TO 4 DO
         Box (i,j);
      END;
      a[0] := CHAR(48+i);
      Schatten(i*58+106,231,1,a);
      a := "a  b";
      Schatten(i*58+71,72,4,a);
      Schieber(i,Schalter[i]);
      LampSchrift(i);
   END;
   Noch3;
   Taster;
   Schatten (10,70,6,"kosmos");
   Schatten (63,230,1,"y");
   Schatten (63,250,1,"x");
   Schatten (29,230,1,"T");
   Lampen;
   Streifen;
END Bild;

PROCEDURE Farben1;
BEGIN
   LoadRGB4 (MyView, ADR(FarbDaten1), 16);
END Farben1;

PROCEDURE Farben2;
BEGIN
   LoadRGB4 (MyView, ADR(FarbDaten2), 16);
END Farben2;

PROCEDURE Farben3;
BEGIN
   LoadRGB4 (MyView, ADR(FarbDaten3), 16);
END Farben3;

PROCEDURE IniGadg;
VAR i : INTEGER;
BEGIN
   Buf[0] := " ";
   Buf[1] := " ";
   Buf[2] := " ";
   Buf[3] :=
   "    0     1       2      3      4      5       6      7      8      9";
   Buf[4] := " ";
   FOR i := 0 TO 4 DO
      UBuf[i] := Buf[i];
      WITH Info[i] DO
         buffer       := ADR(Buf[i]);
         undoBuffer   := ADR(UBuf[i]);
         bufferPos    := 0;
         IF (i=0) THEN
            maxChars  := 80;
         ELSE
            maxChars  := 74;
         END;
         dispPos      := 0;
      END;
      WITH SchiebGadget[i] DO
         IF (i=4) THEN
            nextGadget := NIL;
         ELSE
            nextGadget := ADR(SchiebGadget[i+1]);
         END;
         IF (i=0) THEN
            leftEdge  := 4;
            topEdge   := 212;
            width     := 638;
            height    := 9;
         ELSE
            leftEdge  :=48;
            topEdge   :=9*i+3;
            width     := 616;
            height    := 9;
         END;
         flags        :=GadgetFlagSet{};
         activation   :=ActivationFlagSet{gadgImmediate,
                                        relVerify,
                                        toggleSelect};
         gadgetType   :=strGadget;
         gadgetRender :=NIL;
         selectRender :=NIL;
         gadgetText   :=NIL;
         specialInfo  :=ADR(Info[i]);
         gadgetID     :=i+1;
         userData     :=NIL;
      END; (* WITH SchiebGadget[i] *)
      MyGadget[i] := ADR(SchiebGadget[i]);
   END; (* FOR i *)
END IniGadg;


PROCEDURE MyScreenWindow();
BEGIN
   WITH NewScr DO
      width        :=640;
      leftEdge     :=0;
      topEdge      :=0;
      height       :=255;
      depth        :=4;
      detailPen    :=1;
      blockPen     :=0;
      viewModes    :=ViewModeSet{hires};
      type         :=ScreenFlagSet {wbenchScreen,screenBehind};
      font         :=NIL;
      defaultTitle :=ADR("LOGIKUS");
      gadgets      :=NIL;
      customBitMap :=NIL;
   END;
   MyScreen := OpenScreen(NewScr);
   Assert(MyScreen<>NIL,ADR("Konnte LogikusScreen nicht ffnen"));
   ShowTitle(MyScreen,FALSE);
   MyView := ADR(MyScreen^.viewPort);
  LoadRGB4 (MyView, ADR(Farbdaten0),16);
   WITH NewWin DO
      leftEdge    :=0;
      topEdge     :=0;
      width       :=640;
      height      :=255;
      detailPen   :=0;
      blockPen    :=1;
      idcmpFlags  :=IDCMPFlagSet{};
      flags       :=WindowFlagSet{backDrop,
                                 borderless,
                                 activate}; (* smartRefresh *)
      title       :=NIL;
      type        :=customScreen;
      firstGadget := ADR(SchiebGadget[0]);
      checkMark   :=NIL;
      screen      :=MyScreen;
      bitMap      :=NIL;
   END;
   IniGadg;
   MyWindow := OpenWindow(NewWin);
   Assert(MyWindow<>NIL,ADR("konnte Fenster nicht ffnen"));
   MyRast := MyWindow^.rPort;
   Farben1;
END MyScreenWindow;

PROCEDURE AboutWindow;
CONST
Br=240;
Ho=100;
BEGIN

   WITH AWin DO
      leftEdge    :=(640-Br)/2;
      topEdge     :=(256-Ho)/2;
      width       :=Br;
      height      :=Ho;
      detailPen   :=1;
      blockPen    :=14;
      idcmpFlags  :=IDCMPFlagSet{};
      flags       :=WindowFlagSet {noCareRefresh,
                                  activate}; (* smartRefresh *)
      title       :=NIL;
      type        :=customScreen;
      firstGadget :=NIL;
      checkMark   :=NIL;
      screen      :=MyScreen;
      bitMap      :=NIL;
   END;
   AWindow := OpenWindow(AWin);
   Assert(AWindow<>NIL,ADR("konnte Fenster nicht ffnen"));
   ARast := AWindow^.rPort;
   SetRast(ARast,1);
   SetBPen(ARast,1);
   SetAPen(ARast,0);
   Move(ARast,Br-6,3);
   Draw(ARast,6,3);
   Draw(ARast,6,Ho-3);
   SetAPen(ARast,2);
   Draw(ARast,Br-6,Ho-3);
   Draw(ARast,Br-6,3);
   SetAPen(ARast,2);
   Move(ARast,Br-1,1);
   Draw(ARast,1,1);
   Draw(ARast,1,Ho-1);
   SetAPen(ARast,0);
   Draw(ARast,Br-1,Ho-1);
   Draw(ARast,Br-1,1);
   Move(ARast,70,17);
   Text (ARast,ADR("L O G I K U S"),13);
   Move(ARast,70,28);
   Text (ARast,ADR(" Version 1.1 "),13);
   Move(ARast,50,45);
   Text (ARast,ADR(" Franz Dimbeck"),15);
   Move(ARast,50,55);
   Text (ARast,ADR("  Troppauerstr.48"),17);
   Move(ARast,50,65);
   Text (ARast,ADR("  D-8058 Erding"),15);
   Move(ARast,50,90);
   Text (ARast,ADR("- PUBLIC DOMAIN -"),17);
   WHILE lmb IN Ciapra DO
     Delay(5);
   END;
   CloseWindow(AWindow);
   AWindow := NIL;
END AboutWindow;

PROCEDURE CloseMyScreenWindow;
BEGIN
   IF AWindow<>NIL THEN
      CloseWindow(AWindow);
      AWindow := NIL
   END;
   IF MyWindow<>NIL THEN
      CloseWindow(MyWindow);
      MyWindow:=NIL
   END;
   IF MyScreen<>NIL THEN
      CloseScreen(MyScreen);
      MyScreen:=NIL
   END;
END CloseMyScreenWindow;

PROCEDURE Cleanup;
BEGIN
   IF CurrentLevel()<=StartLevel THEN
      CloseMyScreenWindow;
   END
END Cleanup;


BEGIN (*Hauptprogramm*)
   MyScreen:=NIL;
   MyWindow:=NIL;
   StartLevel:=CurrentLevel();
   TermProcedure(Cleanup);
   MyScreenWindow;
END LogiGraph.mod

