; module for RGB select in 128 RAM

COLORpgn
          DISP PgnAdr

Color
          ld hl,(ARW_ADR)
          ld (.arw_adr),hl
          ld hl,(ARW_XDISP)
          ld (.arw_xdisp),hl
          call ARW_DEFAULT_
      ;    ld a,Fire2Cancel_Y  ;ArrCancel_Y     ; cancel
      ;    call GUI
           call Fire2Cancel_Y_
          ld (.sp),sp

.n0       ld ix,WRgb      ;     (   )
          call .PutRGBwn
.n1       ld a,%1010      ;        .
.a        ld ix,WRgb      ;     0     
          ld (ix+6),a
.sp  EQU $+1 : ld sp,#0000
          call ReDrawA
          call .ini_Op

          ld hl,TRGB.tPrevi_
          ld a,(MASKRGB)
          inc a
         jr z,1F
          ld hl,TRGB.tTransp_
1         ld (TRGB.adrTP_),hl

          ld c,#FF          ;  
          ld a,(REALRGB)
          ld b,a
          and #40
         jr z,1F
          ld a,c
1         ld (FlRGB+3),a
          ld a,b
          and #80
         jr z,1F
          ld a,c
1         ld (FlRGB+9),a
          ld a,(MASKRGB)
          ld b,a
          and #40
         jr z,1F
          ld a,c
1         ld (FlRGB+15),a
          ld a,b
          and #80
         jr z,1F
          ld a,c
1         ld (FlRGB+21),a

          call Win_
          cp #FF
         jp z,.Exit_RGB_
           ld e,a
           ld a,(But)
      ;     cp #FF
      ;    jr z, 1F
           ld d,8
           cp d
          jr c,.setInk
           sub d
           cp d
          jr c,.setPap
           sub d
          jr z,.setMi
           dec a
          jr z,.setMp
       ;   jr .n0
1          ld bc,TbColOp
           ld a,e
          jp TAB_JP

.next     ld a,%1000
         jr .a


.setInk    ld c,a
           ld b,#F8
1          ld a,(MASKRGB)
           and b
           ld (MASKRGB),a
           ld a,(REALRGB)
           and b
           or c
2          ld (REALRGB),a
          jr .next
.setPap    add a,a
           add a,a
           add a,a
           ld c,a
           ld b,#C7
          jr 1B
.setBrg_    call .StopARW
.setBrg     ld a,(REALRGB)
            xor #40
           jr 2B
.setFls_    call .StopARW
.setFls     ld a,(REALRGB)
            xor #80
           jr 2B
.setMp      ld a,(MASKRGB)
            ld b,#38
           jr 3F
.setMi      ld a,(MASKRGB)
            ld b,7
3           ld c,a
            and b
            ld a,c
           jr z,4F
            or b
            xor b
           jr 5F
4           or b
5           ld (MASKRGB),a
           jr .next

.setMbr_    call .StopARW
.setMbr     ld a,(MASKRGB)
            xor #40
           jr 5B
.setMfl_    call .StopARW
.setMfl     ld a,(MASKRGB)
            xor #80
           jr 5B
.transp     call .tran_00
           jr 5B
.stand      call RgbSTND
6          jr .next
.swpIP      ld a,(MASKRGB)
            call .swp__
            ld (MASKRGB),a
            ld a,(REALRGB)
            call .swp__
           jr 2B

.inkInv    ld a,(REALRGB)
           ld c,a
           rra
           rra
           rra
           cpl
           and 7
           ld b,a
           ld a,c
           and #F8
7          or b
           ld (REALRGB),a
          jr 6B
.paperInv  ld a,(REALRGB)
           ld c,a
           cpl
           and 7
           add a,a
           add a,a
           add a,a
           ld b,a
           ld a,c
           and #C7
          jr 7B

.tran_00    ld a,(MASKRGB)
.tran_01    inc a
            ret z
            ld a,#FF
            ret

.swp__       ld c,a
             and 7
             add a,a
             add a,a
             add a,a
             ld b,a
             ld a,c
             rrca
             rrca
             rrca
             and 7
             or b
             ld b,a
             ld a,c
             and #C0
             or b
            ret

.take       ld hl,Ret
            call .take_
1          jp .n0

.take_      ld (.takeI_),hl
            call .CloseRGB
            call SWAP_SCR
            call NOKEY_
            ld hl,Ret
.takeI_  EQU $-2
            ld a,ARW_SCN
            call GUI
           jr c,1F
            ld de,(ARW_XC)
            call RASCHA
            ld a,(hl)
            ld (REALRGB),a
            call ReMixRgb
1          jp SWAP_SCR


.op0       ld a,8
          jr 1F
.op1       ld a,6
1          ld (.num_cnk),a
2         jp .next

.StopARW    ld a,STOP_ARW
           jp GUI
         ;      v3.12 /DA
; in: B - sx , C - sy , D - x , E - y , A - cnk

.Cr_53c    xor a
           ld c,8
.num_cnk  EQU $-1
           call .cr_cnk
           call .crLnCnk

           ld de,#170C
           call RealWin
           ld bc,CTB+(4*8)
           call .cr_53c__
           ld bc,CTB+(4*6)
           call .cr_53c__
           inc e
           inc e
           ld bc,(FA_cnk.de)
.crtoFls_  call .cr_53c__
           dec e
           dec e
           call RASCHA_
           ld (.Int_53de),hl
          ret

.cr_53c__  push de
           call RASCH
           ld d,b
           ld e,c
           call .cr_53_
           pop de
           inc e
           inc e
          ret

.cr_53_    push de
           call 1F
           pop de
1          ld b,4
2          ld a,(de)
           inc de
           ld (hl),a
           inc h
          djnz 2B
          ret

.crLnCnk   ld de,#0801
           call RealWin
           push de
           call RASCH
           ld de,CTB
           ld c,16
1          push hl
           call .cr_53_
           pop hl
           inc l
           dec c
          jr nz,1B
           pop de
           ld bc,#1001
           ld a,(REALRGB)
          jp SetV_

.sel53col  call SetINXY   ; in WinGUI
           push ix
           ld hl,.cr_hl
           call LookBox   ; in WinGui
           ld a,(REALRGB)
           pop ix
          ret c
           ld de,(ARW_XC)
           call RASCHA
           ld a,(hl)
           or a
          ret

.Int_53c   call .sel53col
1          ld (#0000),a
.Int_53de  EQU $-2
          ret

.cr_hl    DB 6,11,16,8

.Cr_Fls    ld de,#1712
           call RealWin
           ld bc,CTB+(4*15)
           call .crtoFls_
           call .crLnCnk
           ld a,#80
           ld c,15
.cr_cnk    ld (.setFl),a
           ld a,c
           ld bc,#1008
           ld de,#060B

           call RealWin
           push de
           call FA_cnk
           pop de
           call RASCHA_
           ld de,32
           ld c,8
1          push hl
           ld b,8
2          ld a,8
           sub c
           add a,a
           add a,a
           add a,a
           add a,8
           sub b
           or 0
.setFl EQU $-1
           ld (hl),a
           inc l
           or #40   ; bright
           ld (hl),a
           inc l
          djnz 2B
           pop hl
           add hl,de
           dec c
          jr nz,1B
          ret


.clULA     call .selULApos
           ld a,(REALRGB)
           ld c,a
           ld a,l
           ld b,#38   ; ink
           rr h       ; /2
          jr nc,1F
           ld b,#07   ; paper
           add a,a
           add a,a
           add a,a
1          ld l,a
           ld a,c
           and b
           or l
           ld c,a
           ld a,h
           rra
          jr nc,2F
           set 6,c
2          rra
          jr nc,3F
           set 7,c
3          ld a,c
          jr 4F
.cl53fl   ld de,(ARW_XC)
          call RASCHA
          ld a,(hl)
4         ld (REALRGB),a
          xor a
5         ld (MASKRGB),a
         jp .next



.Cr_ULA
           call .crLnCnk
           ld hl,#0B06
           call .crula_HL
           push ix
           ld ix,.cr_ula_ix
           ld a,(REALRGB)
           ld e,a
           rlca
           rlca
           or a
           rla
           and 7
           add a,11 ; y
           ld (.cr_ula_ix+1),a

           ld a,e
           push af
           ld (ix+5),%100
           call 1F
           inc (ix+1)
           ld (ix+5),%000
           pop af
           rra
           rra
           rra
           call 1F
           pop ix
          ret

1          and 7
           add a,a
           add a,6
           ld (.cr_ula_ix),a
           ld de,gULAcur
          jp ToScrOfI


.crula_HL  push ix
           ld (.cr_ula_ix),hl

           ld ix,.cr_ula_ix
           call RealWin_gui
           ld (.ulapos_),de
           push de

           ld bc,#0400
1          push bc
           ld c,2
           ld de,gULAcol
           ld (ix+5),%100
2          ld b,8
3          push bc
           push de
           ld de,gULAsel
           call ToScrOfI
           call RealWin_gui
           call RASCHA_
           pop de
           ld a,(de)
           or 0
.crula_P  EQU $-1
           ld (hl),a
           inc l
           ld (hl),a
           inc de

           inc (ix+0)
           inc (ix+0)
           pop bc
          djnz 3B

           ld (ix+0),#06
           inc (ix+1)
           xor a
           ld (.cr_ula_ix+5),a
           dec c
          jr nz,2B
           pop bc
            ld a,64
            add a,c
            ld c,a
            ld (.crula_P),a
          djnz 1B
           pop de

           ld a,16
           add a,d
           ld d,a
           ld ix,.cr_ula_ip
           ld (ix+0),d
           ld (ix+1),e
           ld b,4
1          ld de,gULAip_    ;  
           push bc
           call LoadWS      ;   
           pop bc
           inc (ix+1)
           inc (ix+1)
          djnz 1B
           pop ix
          ret



.selULApos  ld hl,(ARW_XC)
            ld de,#0000
.ulapos_   EQU $-2
            ld a,h
            sub e
            ld h,a
            ld a,l
            sub d
            or a
            rra    ; /2
            ld l,a    ; hl - position in tbl
           ret



.cr_ula_ix   DB 0,0,2,1,0,%000  ;
.cr_ula_ip   DB 0,0,1,2         ;  i/p


.selOp      sub num_op_53c
            ld (.opten),a
            ld de,#060B   ; d=x , e=y
            ld bc,#1208   ; b=sx , c=sy
            call CleanWS  ;  
            call .wr_Op
            call .ini_Op
          ;  call WRgb.Cr_w
          jp  .next

.wr_Op      ld a,(WRgb+4)   ; color
            ld de,#010C   ; d=x , e=y
            ld bc,#0503   ; b=sx , e=sy
            call SetAtrW

            ld a,(.opten)
            add a,12
            ld e,a     ; e=y
            ld d,#01   ; d=x
            ld bc,#0401   ; b=sx , e=sy
            ld a,7*8   ; color
            call SetAtrW

            ld a,5          ; a= color
            ld de,23*256+3  ; e = y , d = x
            call .SetAtr1
            dec d
            inc e
            call .SetAtr1
            inc d
            inc e
            ld a,5*8
            call .SetAtr1
            dec d
            inc e
.SetAtr1    push de        ; e = y , d = x , a= color
            ld bc,#0101    ; b = sx , c = sy
            push af
            call SetAtrW
            pop af
            pop de
           ret

.ini_Op
          ld a,0
.opten   EQU $-1
          call .op_stb
         push ix
          ld ix,.cl53fl
          ld bc,TRGB.Ntt
          ld hl,.Cr_53c      ; 53c create
          ld de,.Int_53c
          or a
         jr z,1F
          ld ix,.clULA
          ld hl,.Cr_ULA      ; ULA create
          ld de,Ret
          ld bc,TRGB.Ula_
          dec a
         jr z,1F
          ld ix,.cl53fl
          ld hl,.Cr_Fls    ; Flash create
          ld bc,TRGB.Ntt
          ld de,.Int_53c
1         ld (TbColOp.col_tabl),ix
          ld (WRgb.Cr_addr),hl
          ex de,hl
          ld (WRgb.Int_addr),hl
          ld h,b
          ld l,c
          ld (TRGB.Dptext),hl
         pop ix
         ret

.op_stb  ld c,a
         or a
         ld a,%11
        jr z,1F
         xor a
1        ld (SRGB.aopt+4),a
         ld (SRGB.aopt+9),a
         ld a,c
        ret

.PutRGBwn    ;     RGB (25x20  4500 )
             ;        ScrPage 2560 
             ;      NEWCAT   2048 
              ld a,(ix+6)
              and 2
             ret z
              call ScrRam
              ld de,SysBuff
              call SaveWA   ;   500 ,  2060
              ld a,10       ; ========
              ld (ix+3),a
              call SaveWS   ;   25x10 = 2000 
              call guiRAM
              ld a,(ix+1)
              ld (.rixPl1),a
              add a,10         ; =======
              ld (ix+1),a
              ld de,NEWCAT
              call SaveWS   ;   25x10 = 2000 
.rixRGBwn     ld a,20       ;    ix+
              ld (ix+3),a
.rixPl1 EQU $+1 : ld a,2
              ld (ix+1),a
             ret

.Exit_RGB_   ld hl,0
.arw_adr    EQU $-2
             ld (ARW_ADR),hl
             ld hl,0
.arw_xdisp  EQU $-2
             ld (ARW_XDISP),hl
.CloseRGB    ;     RGB
              call ScrRam
              ld de,SysBuff
              call LoadWA   ;   500 
              ld a,10       ; =========
              ld (ix+3),a
              call LoadWS   ;   25x10 = 2000 
              call guiRAM
              ld a,(ix+1)
              ld (.rixPl1),a
              add a,10         ; =========
              ld (ix+1),a
              ld de,NEWCAT
              call LoadWS   ;   25x10 = 2000 
             jr .rixRGBwn



TbColOp    DW sBORDER          ; 0 - Border
           DW sRGBip           ; 1 - sets
           DW Color.swpIP      ; 2 - Swap ink and paper
           DW Color.inkInv     ; 3 - ink
           DW Color.paperInv   ; 4 - paper
           DW Color.setBrg     ; 5 - bright +-
           DW Color.setFls     ; 6 - flash  +-
           DW Color.setMbr     ; 7 - bright msk
           DW Color.setMfl     ; 8 - flash msk
           DW Color.stand      ; 9 - standart
           DW Color.transp     ; 10 - transparent
           DW rgb_Medit        ; 11 - Mask
           DW rgb_edit         ; 12 - Color
      ;     DW Color.Exit_RGB_  ; 13 - Exit
           DW Color.take       ; 13 - take
           DW Color.selOp      ; 14 - 53c
           DW Color.selOp      ; 15 - ULA
           DW Color.selOp      ; 16 - Flash
.col_tabl  DW Color.next       ; 17 - coltbl
           DW Color.op0        ; 18
           DW Color.op1        ; 19
           DW Color.Exit_RGB_  ; 20 - Exit

num_op_53c EQU 14


WRgb    DB 4,2,25,20,5*8,5,%1010     ;      
      ;   / ,   .PutRGBwn  .CloseRGB
          DB 0
          DW TRGB         ; -
          DW SRGB         ; - ()
          DW HRGB         ;  
          DW BRGB         ; - ()
          DW FlRGB        ; -
      ;    DW Nil          ; - 
      ;    DW Nil          ; 
          DW 2            ; 
          DW .Cr_         ;   
.Int_addr DW Ret          ;   ""
          DW #FFFF

.Cr_       call Color.wr_Op
.Cr_w     jp Ret
.Cr_addr  EQU $-2

TRGB
        MSG_RGB_Border : DB #17,5,"_"
        DB 13,15,13
        MSG_RGB_Ink
        DB 13,13
        MSG_RGB_Paper
        DB 13,13,15,13
        MSG_RGB_Bright : DB #17,7
        MSG_RGB_Nop : DB #17,11
        MSG_RGB_Standart : DB #17,17," M#",#17,19
.mtedit DB "FF",13
        MSG_RGB_Flash : DB #17,7
        MSG_RGB_Nop : DB #17,11,#0A
.adrTP_  DW .tTransp_          ;  / 
        DB #17,17," C#",#17,19
.tedit  DB "07",13,15,13,13

        DB "53c",13
        DB "ULA",13
        DB "Flash",13,13
        DB " ...",13,13
        MSG_RGB_Take : DB 13,#0A
.Dptext DW .Ntt
        DB 0

.tTransp_  MSG_RGB_Transp : DB #FF
.tPrevi_   MSG_RGB_Previous : DB #FF

.Ula_    DB #16,23,11,"0",13,13,"1",13,13,"2",13,13,"3"
.Ntt     DB #FF



BRGB
; .ink    DB 6,3,2,2,7*8,%10   ; 0
;        DW OFFS
;        DB 8,3,2,2,1,%10     ; 1
;        DW OFFS
;        DB 10,3,2,2,2,%10    ; 2
;        DW OFFS
;        DB 12,3,2,2,3,%10    ; 3
;        DW OFFS
;        DB 14,3,2,2,4,%10    ; 4
;        DW OFFS
;        DB 16,3,2,2,5,%10    ; 5
;        DW OFFS
;        DB 18,3,2,2,6,%10    ; 6
;        DW OFFS
;        DB 20,3,2,2,7,%10    ; 7
;        DW LASTONS

        DB 96+8,64+6,3,2,2,7*8,%10
.inkDW   DW OFFS
          DB 1
         DW OFFS
          DB 2
         DW OFFS
          DB 3
         DW OFFS
          DB 4
         DW OFFS
          DB 5
         DW OFFS
          DB 6
         DW OFFS
          DB 7
         DW LASTONS



; .pap    DB 6,5,2,2,7,%110       ; 8
;        DW LASTONS
;        DB 8,5,2,2,1*8,%110     ; 9
;        DW OFFS
;        DB 10,5,2,2,2*8,%110    ; 10
;        DW OFFS
;        DB 12,5,2,2,3*8,%110    ; 11
;        DW OFFS
;        DB 14,5,2,2,4*8,%110    ; 12
;        DW OFFS
;        DB 16,5,2,2,5*8,%110    ; 13
;        DW OFFS
;        DB 18,5,2,2,6*8,%110    ; 14
;        DW OFFS
;        DB 20,5,2,2,7*8,%110    ; 15
;        DW OFFS

        DB 96+8,64+6,5,2,2,7,%110
.papDW   DW LASTONS
          DB 1*8
         DW OFFS
          DB 2*8
         DW OFFS
          DB 3*8
         DW OFFS
          DB 4*8
         DW OFFS
          DB 5*8
         DW OFFS
          DB 6*8
         DW OFFS
          DB 7*8
         DW OFFS


     ;   DB 22,3,2,2,7,%10         ; 16  
     ;   DW ONS
     ;   DB 22,5,2,2,7*8,%110      ; 17  
     ;   DW ONS

          DB 64+2,128+22,3,2,2,7,%10
.trinkDW   DW ONS
          DB 7*8,%110
.trpapDW   DW ONS

        DB 22,8,2,2,7,%00     ; 18
.dtrs  EQU $-2                ;  
        DW DTRS

       DB #FF

SRGB   DB 1,1,4,1,%11      ; 0 - border
       DB 5,1,3,1,%11      ; 1 - sets
       DB 8,1,16,1,%10     ; 2 - Swap ink and paper
       DB 1,3,5,1,%11      ; 3 - ink
       DB 1,5,5,1,%11      ; 4 - paper
       DB 1,8,6,128+2,%11      ; 5 - bright ,  6 - flash
    ;   DB 1,9,6,1,%11      ; 6 - flash
       DB 8,8,3,128+2,%11      ; 7 - bright msk , 8 - flash msk
    ;   DB 8,9,3,1,%11      ; 8 - flash msk
       DB 12,8,6,128+2,%11     ; 9 - standart , 10 - transparent
   ;    DB 12,9,6,1,%11     ; 10 - transparent
       DB 18,8,4,128+2,%11     ; 11 - Mask , 12 - Color
   ;    DB 18,9,4,1,%11     ; 12 - Color
   ;    DB 1,16,4,1,%00     ; 13 - sets
       DB 1,18,4,1,%11     ; 13 - take

       DB 1,12,4,128+3,%11     ; 14 - 53c
    ;   DB 1,13,4,1,%11     ; 15 - ULA
    ;   DB 1,14,4,1,%11     ; 16 - Flash
       DB 6,11,16,8,%10    ; 17 - coltbl  -   

.aopt  DB 23,12,1,1,%00    ; 18-19  -    53c
       DB 23,14,1,1,%00    ; 19


      DB #FF

FlRGB
        DB 6,8,5,#00
         DW Color.setBrg_
        DB 6,9,6,#00
         DW Color.setFls_
        DB 10,8,7,#FF
         DW Color.setMbr_
        DB 10,9,8,#FF
         DW Color.setMfl_
       DB #FF


HRGB
         DB "E", 0
          DW 2     ; Swap ink and paper
         DB "T", 0
          DW 13    ; Take
         DB "B", 0
          DW 5     ; Bright
         DB "F", 0
          DW 6     ; Flash
         DB "W", 0
          DW 10    ; Transparent
         DB "C", 0
          DW 20    ; Close
        DB #FF


rgb_Medit  ld de,#1408
           ld bc, TRGB.mtedit
           ld hl,MASKRGB
          jr  rgb_edit_

rgb_edit ;LD HL,TRGB.tedit
           ld de,#1409
           ld bc, TRGB.tedit
           ld hl,REALRGB
rgb_edit_  ld (.toaddr),hl
           ld l,c
           ld h,b
           push hl
           ld b,2
       ;    xor a
           ex af,af'
           ld a,EDIT
           call GUI
           pop hl
1    ;     jp c,ReFr
           ld a,(hl)
           inc hl
           call .sub
          jr c,1B
           add a,a
           add a,a
           add a,a
           add a,a
           ld c,a
           ld a,(hl)
           call .sub
          jr c,1B
           or c
           ld (REALRGB),a
.toaddr  EQU $-2
         ;  call ReMixM
    ;      jp ReFr.r
        jp Color.next
.sub       sub 48    ; "0"
          ret c
           cp 10
          jr c,1F
           sub 7
1          cp 16
          jr c,2F
           sub 32
          ret c
           cp 16
2          ccf
          ret

rgb_hexO    ld de,TRGB.tedit ; -      /DA
            ld a,(REALRGB)
            ld (BRGB.dtrs),a
            call CHEX_A
            ld de,TRGB.mtedit ; -      /DA
            ld a,(MASKRGB)
            call CHEX_A
           ret

ReDrawA    call col_sBRFL
           call .but_pre
           call rgb_hexO
           call setDTRS
          ret

.but_pre
           ld a,(REALRGB)
           ld c,a
           ld a,(MASKRGB)    ;   c = REALRGB a = MASKRGB
           push af

           ld hl,BRGB.trinkDW
           ld b,#F8
           call .but_vt
           ld hl,BRGB.inkDW   ; ink
           ld a,c
           and 7
           call .but_vtt

           pop af

           ld hl,BRGB.trpapDW
           ld b,#C7
           call .but_vt
           ld hl,BRGB.papDW   ; paper
           ld a,c
           and #38
           rrca : rrca : rrca
.but_vtt   ld e,a
           add a,a
           add a,e  ; *3
           call setOFFS8_        ; ( D=0 )
           ld e,a
           add hl,de
           ld (hl),b
          ret

.but_vt    ld (hl),OFFS
           or b
           ld b,ONS
           inc a
          ret nz
           ld (hl),b
           ld b,LASTONS
          ret

setOFFS8_  push hl,bc
           ld b,8
           ld de,3
1          ld (hl),OFFS    ; .. OFFS<256
           add hl,de
          djnz 1B          ;  
           pop bc,hl
          ret





sRGBip      ;        
           call .sele
          jp sBORDER.end
.sele      ld hl,(WRgb)
           ld bc,#0201
           add hl,bc
           ld (.Wrgb),hl    ;   
           ld ix,.Wrgb
           ld a,%1010
           ld (ix+6),a
           call Win_
          ret

.Wrgb       DB 0,0,9,11,6*8,6,%1010  ; bit2=0 -   
             DB 0
            DW .Trgb        ; -
            DW .Srgb         ; - ()
            DW 2            ; :   , - ()
            DW .Frgb         ; -
            DW #FFFF

.Trgb       MSG_RGB_Ink
            DB 13,#0A :  DW .Trgb_b
            MSG_RGB_Paper : DB 13
.Trgb_b     DB 15,13
            MSG_RGB_Bright
            DB 13
             MSG_RGB_Flash
            DB 13,0

.Srgb
            DB 1,3,7,128+2,%11    ; 0,1 - /  
            DB 1,8,7,128+2,%11    ; 2,3 - /  
            DB #FF

; - (switch)
; x, y,  ,  (#00/#FF)
;       ,  
;     
.Frgb       DB 7,3,0,#FF  ;    
             DW Nil
            DB 7,4,1,#00  ;   
             DW Nil
            DB 7,8,2,#FF  ;   
             DW Nil
            DB 7,9,3,#00  ;   
             DW Nil
            DB #FF


col_sBRFL
             ld hl,sRGBip.Frgb+3
             ld de,6
             call .sBRm
             push hl
             ld hl,BRGB.inkDW-2
             call .sBRc
             pop hl

             call .sBRm
             ld hl,BRGB.papDW-2

.sBRc        ld a,(REALRGB)
             and c
             ld c,a
          ;   ld a,(hl)
          ;   and #3F
          ;   or c    ; e= 0 of #80 for flash, #40 for bright
          ;   ld (hl),a
          ;   inc hl
          ;   inc hl
          ;   inc hl
          ;   inc hl
              ld b,1
              call 1F
              inc hl

             ld b,7
1            ld a,(hl)
             and #3F
             or c
             ld (hl),a
             inc hl
             inc hl
             inc hl
            djnz 1B
            ret

.sBRm        ld a,(hl)
             and #40
             ld c,a
             add hl,de
             ld a,(hl)
             add hl,de
             and #80
             or c
             ld c,a
            ret



sBORDER      ;  
           call .sele
.end       call NOKEY_
          jp  Color.n1
.sele      ld hl,(WRgb)
           ld bc,#0204
           add hl,bc
           ld (Wborder),hl    ;   
           ld a,%1010
1          ld ix,Wborder
           ld (ix+6),a
           ld hl,Wborder.butDW
           call setOFFS8_
           ld a,(BORDER)
           and 7
           ld e,a
           add a,a
           add a,e
           ld e,a
           ld d,0
           add hl,de
           ld a,ONS
           ld (hl),a
           call Win_
           cp #FF
          ret z
           and 7
           ld (BORDER),a
           out (#FE),a
           ld a,%1000
          jr 1B

Wborder     DB 0,0,18,4,6*8,6,%1010  ; bit2=0 -   
             DB 0
            DW 3        ;    
            DW .But   ;   - () (buttons object) Wborder.butDW
            DW #FFFF

.But  ;  DB 1,1,2,2,7,%110
      ;  DW ONS
      ;  DB 3,1,2,2,1*8,%110
      ;  DW OFFS
      ;  DB 5,1,2,2,2*8,%110
      ;  DW OFFS
      ;  DB 7,1,2,2,3*8,%110
      ;  DW OFFS
      ;  DB 9,1,2,2,4*8,%110
      ;  DW OFFS
      ;  DB 11,1,2,2,5*8,%110
      ;  DW OFFS
      ;  DB 13,1,2,2,6*8,%110
      ;  DW OFFS
      ;  DB 15,1,2,2,7*8,%110
      ;  DW OFFS

        DB 96+8,64+1,1,2,2,7,%110
.butDW   DW ONS
          DB 1*8
         DW OFFS
          DB 2*8
         DW OFFS
          DB 3*8
         DW OFFS
          DB 4*8
         DW OFFS
          DB 5*8
         DW OFFS
          DB 6*8
         DW OFFS
          DB 7*8
         DW OFFS
        DB #FF




gULAsel     DB #00,#01, #00,#01, #00,#01, #00,#01, #00,#01,  #00,#01, #00,#01, #FF,#FF  ;  
gULAcur     DB #00,#01, #00,#01, #01,#01, #07,#C1, #01,#01,  #00,#01, #00,#01, #FF,#FF  ;   
gULAcol     DB #38,1,2,3,4,5,6,7, #07,8,16,24,32,40,48,56   ;   ink & paper    
gULAip_     DB 0,0,96,0,96,96,96,0,112,104,120,96,0,0,0,0   ;  I/P  ULA

LColor    EQU $-Color
        ENT

        DISPLAY "COLORpgn len   :",/a,LColor