
/* Code generated by Toolmaker V1.19 */

/* Includes */
 
#include <stdlib.h>
#include <exec/types.h>
#include <intuition/intuition.h>
#include <intuition/gadgetclass.h>
#include <libraries/gadtools.h>
#include <exec/memory.h>
#include <graphics/view.h>
#include <graphics/displayinfo.h>

#include "VIC20.h"

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>

/* Pragma includes for register parameters */
 
#include <pragmas/exec_pragmas.h>
#include <pragmas/intuition_pragmas.h>
#include <pragmas/gadtools_pragmas.h>

/* static function prototypes */
 
static BOOL TM_WindowSignal(struct TMData *);
static VOID TM_RemoveWindow(struct TMWindowInfo *);
static BOOL WindowIDCMP_VIC20(struct TMData *, struct IntuiMessage *);

/* Mouse pointer data for disabled window */
 
#ifdef _DCC    /* For DICE compatibiliity */
__chip UWORD WaitPointer[36] =
#else
UWORD __chip WaitPointer[36] =
#endif
  {
  0x0000, 0x0000,
  0x0400, 0x07C0,
  0x0000, 0x07C0,
  0x0100, 0x0380,
  0x0000, 0x07E0,
  0x07C0, 0x1FF8,
  0x1FF0, 0x3FEC,
  0x3FF8, 0x7FDE,
  0x3FF8, 0x7FBE,
  0x7FFC, 0xFF7F,
  0x7EFC, 0xFFFF,
  0x7FFC, 0xFFFF,
  0x3FF8, 0x7FFE,
  0x3FF8, 0x7FFE,
  0x1FF0, 0x3FFC,
  0x07C0, 0x1FF8,
  0x0000, 0x07E0,
  0x0000, 0x0000,
  };

/* Screen data */
 
/* Window data */
 
struct NewMenu newmenu_VIC20[] =
  {
  {NM_TITLE, (UBYTE *)MENUTEXT_PROJECT,	NULL,	0,	0,	NULL},	/* Project */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_CONTINUE,	(UBYTE *)"C",	0,	0,	(APTR) &tmobjectdata_CONTINUE},	/* Continue */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_RESET,	(UBYTE *)"R",	0,	0,	(APTR) &tmobjectdata_RESET},	/* Reset */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_LOADPREF,	(UBYTE *)"L",	0,	0,	(APTR) &tmobjectdata_LOADPREF},	/* Load Prefs */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_SAVEPREF,	(UBYTE *)"S",	0,	0,	(APTR) &tmobjectdata_SAVEPREF},	/* Save Prefs */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_LOADCART,	(UBYTE *)"O",	0,	0,	(APTR) &tmobjectdata_LOADCART},	/* Load Cartridge */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_CHANGEDI,	(UBYTE *)"D",	0,	0,	(APTR) &tmobjectdata_CHANGEDI},	/* Change Directory */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_ABOUT,	(UBYTE *)"?",	0,	0,	(APTR) &tmobjectdata_ABOUT},	/* About */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_QUIT,	(UBYTE *)"Q",	0,	0,	(APTR) &tmobjectdata_QUIT},	/* Quit */
  {NM_TITLE, (UBYTE *)MENUTEXT_MEMORY,	NULL,	0,	0,	NULL},	/* Memory */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_UNEXPAND,	(UBYTE *)"U",	0,	0,	(APTR) &tmobjectdata_UNEXPAND},	/* Unexpanded */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_3KEXP,	NULL,	CHECKIT | MENUTOGGLE,	0,	(APTR) &tmobjectdata_3KEXP},	/* 3k exp */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_8EXPBLK1,	NULL,	CHECKIT | MENUTOGGLE,	0,	(APTR) &tmobjectdata_8EXPBLK1},	/* 8k exp blk 1 */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_8EXPBLK2,	NULL,	CHECKIT | MENUTOGGLE,	0,	(APTR) &tmobjectdata_8EXPBLK2},	/* 8k exp blk 2 */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_8EXPBLK3,	NULL,	CHECKIT | MENUTOGGLE,	0,	(APTR) &tmobjectdata_8EXPBLK3},	/* 8k exp blk 3 */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_FULLEXPA,	(UBYTE *)"F",	0,	0,	(APTR) &tmobjectdata_FULLEXPA},	/* Full expanded */
  {NM_TITLE, (UBYTE *)MENUTEXT_GRAPHICS,	NULL,	0,	0,	NULL},	/* Graphics */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_SPEEDOME,	(UBYTE *)"M",	0,	0,	(APTR) &tmobjectdata_SPEEDOME},	/* SpeedoMeter */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_SAVESCRE,	(UBYTE *)"A",	0,	0,	(APTR) &tmobjectdata_SAVESCRE},	/* Save Screen */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_INTERLAC,	NULL,	CHECKIT | MENUTOGGLE,	0,	(APTR) &tmobjectdata_INTERLAC},	/* Interlace */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_HIRES,	NULL,	CHECKIT | MENUTOGGLE,	0,	(APTR) &tmobjectdata_HIRES},	/* Hires */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_MULTISYN,	NULL,	CHECKIT | MENUTOGGLE,	0,	(APTR) &tmobjectdata_MULTISYN},	/* Multisync */
  {NM_TITLE, (UBYTE *)MENUTEXT_IO,	NULL,	0,	0,	NULL},	/* I/O */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_ABOUTKEY,	(UBYTE *)"K",	0,	0,	(APTR) &tmobjectdata_ABOUTKEY},	/* About Keyboard */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_PADDLES,	NULL,	CHECKIT | MENUTOGGLE,	0,	(APTR) &tmobjectdata_PADDLES},	/* Paddles */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_DISKDRIV,	NULL,	CHECKIT | MENUTOGGLE,	0,	(APTR) &tmobjectdata_DISKDRIV},	/* Diskdrive */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_CASSETTE,	NULL,	CHECKIT | MENUTOGGLE,	0,	(APTR) &tmobjectdata_CASSETTE},	/* Cassette */
  {NM_END,   NULL,	NULL,	0,	0,	NULL}
  };


/* Font data */
 
struct TextAttr topaz8 =
  {
  (STRPTR)"topaz.font",	/* ta_Name */
  8,	/* ta_YSize */
  FS_NORMAL,	/* ta_Style */
  0x0	/* ta_Flags */
  };

/****** VIC20_tm.c/TM_Request *****************************
*
*   NAME
*	TM_Request -- display a message in a system requester.
*
*   SYNOPSIS
*	num = TM_Request(Window, Title, TextFormat, GadgetFormat,
*	                 IDCMP_ptr, Arg1, Arg2, ...)
*
*	LONG TM_Request(struct Window *, UBYTE *, UBYTE *, UBYTE *,
*	                ULONG *, APTR, ...);
*
*   FUNCTION
*	Calls EasyRequestArgs to display a message in a system
*	requester without having to fill in an EasyStruct structure.
*	This function uses a varargs calling convention.
*
*	EasyRequestArgs has the capability to display more than one
*	gadget by separating the GadgetText with the '|' character.
*	Also printf style formatting may be used in the TextFormat
*	and GadgetFormat strings.  The formatting arguments should
*	be added first for the TextFormat, then for the GadgetFormat.
*
*   INPUTS
*	Window = pointer to window (passed to EasyRequestArgs()).
*	Title = title bar string (passed to EasyRequestArgs()).
*	TextFormat = body text (passed to EasyRequestArgs()).
*	GadgetFormat = gadget text (passed to EasyRequestArgs()).
*	IDCMP_ptr = IDCMP value (passed to EasyRequestArgs()).
*	Args = arguments (passed to EasyRequestArgs()).
*
*   RESULT
*	num = gadget number returned by EasyRequestArgs().
*
*   EXAMPLE
*	To display a requester with two choices:
*
*	result = TM_Request(NULL, "Question", "Are you sure?",
*	                    "OK|Cancel", NULL, NULL);
*
*   NOTES
*	The intuition library must be open before calling this
*	function.
*
*   BUGS
*
*   SEE ALSO
*	intuition.library/EasyRequestArgs()
*
**************************************************************
*
*/
LONG TM_Request(struct Window *Window, UBYTE *Title, UBYTE *TextFormat, UBYTE *GadgetFormat, ULONG *IDCMP_ptr, APTR Arg1, ...)
  {
  struct EasyStruct es;

  es.es_StructSize = sizeof(struct EasyStruct);
  es.es_Flags = 0;
  es.es_Title = Title;
  es.es_TextFormat = TextFormat;
  es.es_GadgetFormat = GadgetFormat;

  return(EasyRequestArgs(Window, &es, IDCMP_ptr, &Arg1));
  }

/****** VIC20_tm.c/TM_Open *****************************
*
*   NAME
*	TM_Open -- initialize user-interface data.
*
*   SYNOPSIS
*	TMData = TM_Open(ErrorCode)
*
*	struct TMData *TM_Open(ULONG *error);
*
*   FUNCTION
*	Creates an initializes a TMData structure.  This
*	includes allocating memory for a TMData structure,
*	creating a message port for window IDCMP messages,
*	and opening any fonts on disk.
*
*   INPUTS
*	error = pointer to ULONG to store an error number.
*	        Error numbers are defined in the _tm.h file.
*
*   RESULT
*	TMData = pointer to an initialized TMData structure
*	         or NULL if an error occurred.
*
*   EXAMPLE
*	if(!(TMData = TM_Open(&error)))
*	  {
*	  switch(error)
*	    {
*	    case TMERR_MEMORY:
*	      TM_Request(NULL, "Error", "Out of memory", "Abort", NULL, NULL);
*	      break;
*	    case TMERR_MSGPORT:
*	      TM_Request(NULL, "Error", "Error creating\nmessage port", "Abort", NULL, NULL);
*	      break;
*	    }
*	  CleanExit(NULL, RETURN_FAIL);
*	  }
*
*   NOTES
*	The intuition and gadtools libraries must be open before
*	calling this function.  If any fonts other than topaz 8
*	and topaz 9 are used, the diskfont and graphics libraries
*	must also be open.
*
*   BUGS
*
*   SEE ALSO
*	TM_Close()
*
**************************************************************
*
*/
struct TMData *TM_Open(ULONG *error)
  {
  struct TMData *tmdata;

  if(tmdata = AllocMem(sizeof(struct TMData), MEMF_CLEAR))
    {
    tmdata->Size = sizeof(struct TMData);

    if(tmdata->WindowMsgPort = CreateMsgPort())
      {
      *error = TMERR_OK;
      return(tmdata);
      }
    else
      {
      *error = TMERR_MSGPORT;
      }
    FreeMem(tmdata, sizeof(struct TMData));
    }
  else
    {
    *error = TMERR_MEMORY;
    }

  return(NULL);
  }

/****** VIC20_tm.c/TM_Close *****************************
*
*   NAME
*	TM_Close -- frees user-interface data.
*
*   SYNOPSIS
*	TM_Close(TMData)
*
*	VOID TM_Close(struct TMData *TMData);
*
*   FUNCTION
*	Frees resources allocated by TM_Open().
*
*   INPUTS
*	TMData = pointer to TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*	if(TMData) TM_Close(TMData);
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	TM_Open()
*
**************************************************************
*
*/
VOID TM_Close(struct TMData *TMData)
  {
  if(TMData)
    {
    if(TMData->WindowMsgPort) DeleteMsgPort(TMData->WindowMsgPort);
    FreeMem(TMData, TMData->Size);
    }
  }

/****** VIC20_tm.c/TM_EventLoop *****************************
*
*   NAME
*	TM_EventLoop -- waits for all events.
*
*   SYNOPSIS
*	TM_EventLoop(TMData)
*
*	VOID TM_EventLoop(struct TMData *);
*
*   FUNCTION
*	Waits for any events to signal program.  All IDCMP, ARexx,
*	and a user signal messages received are sent to the
*	appropriate signal function.  A return value of TRUE from
*	any of the signal functions will terminate the loop.
*
*   INPUTS
*	TMData = pointer to TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*	TM_EventLoop(TMData);
*
*   NOTES
*	An event signal must be set up before calling TM_EventLoop.
*	Either a window must be open, the SimpleRexx option selected,
*	or a user signal set up.
*
*   BUGS
*
*   SEE ALSO
*	TM_WindowSignal(), TM_ARexxSignal(), exec.library/Wait()
*
**************************************************************
*
*/
VOID TM_EventLoop(struct TMData *TMData)
  {
  BOOL done=FALSE, result;
  ULONG windowsignal, signals;

  windowsignal = 1L << TMData->WindowMsgPort->mp_SigBit;

  while(!done)
    {
    signals = Wait(windowsignal);

    if(signals & windowsignal)
      {
      if(result = TM_WindowSignal(TMData)) done = result;
      }
    }
  }

/****** VIC20_tm.c/OpenScreen_Workbench *****************************
*
*   NAME
*	OpenScreen_Workbench -- Use the default public screen.
*
*   SYNOPSIS
*	success = OpenScreen_Workbench(TMData)
*
*	BOOL OpenScreen_Workbench(struct TMData *);
*
*   FUNCTION
*	Locks the default public screen and gets its visual info.  If the
*	screen was already locked, it will be brought to front.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*	success = TRUE if command was successfully completed.
*	          FALSE if not.
*
*   EXAMPLE
*	if(!(OpenScreen_Workbench(TMData)))
*	  {
*	  TM_Request(NULL, "Error", "Error opening screen", "Abort", NULL, NULL);
*	  CleanExit(TMData, RETURN_FAIL);
*	  }
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	CloseScreen_Workbench()
*
**************************************************************
*
*/
BOOL OpenScreen_Workbench(struct TMData *TMData)
  {
  if(ScreenInfo_Workbench.Screen)
    {
    ScreenToFront(ScreenInfo_Workbench.Screen);
    return(TRUE);
    }
  else
    {
    if(ScreenInfo_Workbench.Screen = LockPubScreen(NULL))
      {
      if(ScreenInfo_Workbench.VisualInfo = GetVisualInfo(ScreenInfo_Workbench.Screen, TAG_DONE))
        {
        return(TRUE);
        }
      UnlockPubScreen(NULL, ScreenInfo_Workbench.Screen);
      }
    }

  return(FALSE);
  }

/****** VIC20_tm.c/CloseScreen_Workbench *****************************
*
*   NAME
*	CloseScreen_Workbench -- Free the default public screen.
*
*   SYNOPSIS
*	CloseScreen_Workbench(TMData)
*
*	VOID CloseScreen_Workbench(struct TMData *);
*
*   FUNCTION
*	Unlocks the default public screen and frees the visual info.
*	It's ok to re-close a screen that is already closed.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*	CloseScreen_Workbench(TMData);
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	OpenScreen_Workbench()
*
**************************************************************
*
*/
VOID CloseScreen_Workbench(struct TMData *TMData)
  {
  if(ScreenInfo_Workbench.VisualInfo)
    {
    FreeVisualInfo(ScreenInfo_Workbench.VisualInfo);
    ScreenInfo_Workbench.VisualInfo = NULL;
    }
  if(ScreenInfo_Workbench.Screen)
    {
    UnlockPubScreen(NULL, ScreenInfo_Workbench.Screen);
    ScreenInfo_Workbench.Screen = NULL;
    }
  }

/****** VIC20_tm.c/OpenWindow_VIC20 *****************************
*
*   NAME
*	OpenWindow_VIC20 -- Open window "VIC20".
*
*   SYNOPSIS
*	success = OpenWindow_VIC20(TMData)
*
*	BOOL OpenWindow_VIC20(struct TMData *);
*
*   FUNCTION
*	Opens the window with label "VIC20"
*	along with any gadgets it contains.  If the window was already
*	open, it will be brought to front.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*	success = TRUE if command was successfully completed.
*	          FALSE if not.
*
*   EXAMPLE
*	if(!OpenWindow_VIC20(TMData))
*	  {
*	  TMRequest(NULL, "Error", "Error opening window", "Abort", NULL, NULL);
*	  CleanExit(TMData, RETURN_FAIL);
*	  }
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	CloseWindow_VIC20()
*
**************************************************************
*
*/
BOOL OpenWindow_VIC20(struct TMData *TMData)
  {
  ULONG lasttag;
  struct NewGadget ng;

  if(WindowInfo_VIC20.Window)
    {
    WindowToFront(WindowInfo_VIC20.Window);
    ActivateWindow(WindowInfo_VIC20.Window);
    return(TRUE);
    }
  else
    {
    WindowInfo_VIC20.FirstGadget = NULL;
    WindowInfo_VIC20.ContextGadget = CreateContext(&WindowInfo_VIC20.FirstGadget);

    ng.ng_VisualInfo = ScreenInfo_Workbench.VisualInfo;

    ng.ng_LeftEdge = 12;
    ng.ng_TopEdge = 21+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_Width = 244;
    ng.ng_Height = 12;
    ng.ng_Flags = PLACETEXT_LEFT;
    ng.ng_TextAttr = &topaz8;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_TEXT2;	 
    ng.ng_GadgetID = 0;
    ng.ng_UserData = NULL;
    lasttag = GadgetInfo_TEXT2.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_TEXT2.Gadget = CreateGadget(TEXT_KIND, WindowInfo_VIC20.ContextGadget, &ng,
		GTTX_Border, TRUE,
		GTTX_Text, GTTX_Text_TEXT2,
		lasttag, GadgetInfo_TEXT2.MoreTags);

    ng.ng_TopEdge = 5+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_TEXT1;	 
    ng.ng_GadgetID = 0;
    ng.ng_UserData = NULL;
    lasttag = GadgetInfo_TEXT1.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_TEXT1.Gadget = CreateGadget(TEXT_KIND, GadgetInfo_TEXT2.Gadget, &ng,
		GTTX_Border, TRUE,
		GTTX_Text, GTTX_Text_TEXT1,
		lasttag, GadgetInfo_TEXT1.MoreTags);

    ng.ng_LeftEdge = 136;
    ng.ng_TopEdge = 37+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_Width = 120;
    ng.ng_Flags = PLACETEXT_IN;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_CHANBUT;	/* Change Dir. */
    ng.ng_GadgetID = ID_CHANBUT;
    ng.ng_UserData = (APTR) &tmobjectdata_CHANBUT;
    lasttag = GadgetInfo_CHANBUT.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_CHANBUT.Gadget = CreateGadget(BUTTON_KIND, GadgetInfo_TEXT1.Gadget, &ng,
		lasttag, GadgetInfo_CHANBUT.MoreTags);

    ng.ng_TopEdge = 53+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_ABOUBUT;	/* About */
    ng.ng_GadgetID = ID_ABOUBUT;
    ng.ng_UserData = (APTR) &tmobjectdata_ABOUBUT;
    lasttag = GadgetInfo_ABOUBUT.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_ABOUBUT.Gadget = CreateGadget(BUTTON_KIND, GadgetInfo_CHANBUT.Gadget, &ng,
		lasttag, GadgetInfo_ABOUBUT.MoreTags);

    ng.ng_LeftEdge = 12;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_RESEBUT;	/* Reset */
    ng.ng_GadgetID = ID_RESEBUT;
    ng.ng_UserData = (APTR) &tmobjectdata_RESEBUT;
    lasttag = GadgetInfo_RESEBUT.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_RESEBUT.Gadget = CreateGadget(BUTTON_KIND, GadgetInfo_ABOUBUT.Gadget, &ng,
		lasttag, GadgetInfo_RESEBUT.MoreTags);

    ng.ng_TopEdge = 37+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_CONTBUT;	/* Continue */
    ng.ng_GadgetID = ID_CONTBUT;
    ng.ng_UserData = (APTR) &tmobjectdata_CONTBUT;
    lasttag = GadgetInfo_CONTBUT.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_CONTBUT.Gadget = CreateGadget(BUTTON_KIND, GadgetInfo_RESEBUT.Gadget, &ng,
		lasttag, GadgetInfo_CONTBUT.MoreTags);

    if(GadgetInfo_CONTBUT.Gadget)
      {
      lasttag = WindowInfo_VIC20.MoreTags ? TAG_MORE : TAG_DONE;

      if((WindowInfo_VIC20.Window = OpenWindowTags(NULL,
		WA_PubScreen, ScreenInfo_Workbench.Screen,
		WA_Title, WINDOWTEXT_VIC20,	/* VIC-20 */
		WA_IDCMP, NULL,
		WA_Gadgets, WindowInfo_VIC20.FirstGadget,
		WA_Left, 186,
		WA_Top, 58,
		WA_Width, 268,
		WA_Height, 80,
		WA_DragBar, TRUE,
		WA_CloseGadget, TRUE,
		WA_DepthGadget, TRUE,
		WA_Activate, TRUE,
		WA_SimpleRefresh, TRUE,
		lasttag, WindowInfo_VIC20.MoreTags)))
        {
        if((WindowInfo_VIC20.Menu = CreateMenus(newmenu_VIC20, TAG_DONE)))
          {
          if((LayoutMenus(WindowInfo_VIC20.Menu, ScreenInfo_Workbench.VisualInfo, TAG_DONE)))
            {
            if((SetMenuStrip(WindowInfo_VIC20.Window, WindowInfo_VIC20.Menu)))
              {
              WindowInfo_VIC20.Window->UserPort = TMData->WindowMsgPort;
              ModifyIDCMP(WindowInfo_VIC20.Window,
			IDCMP_REFRESHWINDOW |
			BUTTONIDCMP |
			IDCMP_GADGETUP |
			IDCMP_MENUPICK |
			IDCMP_CLOSEWINDOW);
              GT_RefreshWindow(WindowInfo_VIC20.Window, NULL);
              WindowInfo_VIC20.Flags |= TMWF_OPENED;
              return(TRUE);
              }
            }
          FreeMenus(WindowInfo_VIC20.Menu);
          }
        CloseWindow(WindowInfo_VIC20.Window);
        }
      FreeGadgets(WindowInfo_VIC20.FirstGadget);
      }
    }
  return(FALSE);
  }

/****** VIC20_tm.c/CloseWindow_VIC20 *****************************
*
*   NAME
*	CloseWindow_VIC20 -- Close window "VIC20".
*
*   SYNOPSIS
*	CloseWindow_VIC20(TMData)
*
*	VOID CloseWindow_VIC20(struct TMData *);
*
*   FUNCTION
*	Closes the window with label "VIC20"
*	and frees its resources.  It's ok to re-close a window
*	that is already closed.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	OpenWindow_VIC20()
*
**************************************************************
*
*/
VOID CloseWindow_VIC20(struct TMData *TMData)
  {
  TM_RemoveWindow(&WindowInfo_VIC20);
  }

/****** VIC20_tm.c/DisableWindow_VIC20 *****************************
*
*   NAME
*	DisableWindow_VIC20 -- disable input to window "VIC20".
*
*   SYNOPSIS
*	DisableWindow_VIC20(TMData)
*
*	VOID DisableWindow_VIC20(struct TMData *);
*
*   FUNCTION
*	Disables all input to window with label "VIC20"
*	and changes its mouse pointer.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	EnableWindow_VIC20()
*
**************************************************************
*
*/
VOID DisableWindow_VIC20(struct TMData *TMData)
  {
  if((WindowInfo_VIC20.DisableCount == 0) && (WindowInfo_VIC20.Flags & TMWF_OPENED))
    {
    InitRequester(&WindowInfo_VIC20.Requester);
    if(Request(&WindowInfo_VIC20.Requester, WindowInfo_VIC20.Window))
      {
      WindowInfo_VIC20.Flags |= TMWF_DISABLED;
      SetPointer(WindowInfo_VIC20.Window, WaitPointer, 16, 16, -6, 0);
      }
    }
  WindowInfo_VIC20.DisableCount++;
  }

/****** VIC20_tm.c/EnableWindow_VIC20 *****************************
*
*   NAME
*	EnableWindow_VIC20 -- enable input to window "VIC20".
*
*   SYNOPSIS
*	EnableWindow_VIC20(TMData)
*
*	VOID EnableWindow_VIC20(struct TMData *);
*
*   FUNCTION
*	Enables input to window with label "VIC20"
*	and clears its mouse pointer.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	DisableWindow_VIC20()
*
**************************************************************
*
*/
VOID EnableWindow_VIC20(struct TMData *TMData)
  {
  WindowInfo_VIC20.DisableCount--;
  if((WindowInfo_VIC20.DisableCount == 0) && (WindowInfo_VIC20.Flags & (TMWF_DISABLED | TMWF_OPENED)))
    {
    EndRequest(&WindowInfo_VIC20.Requester, WindowInfo_VIC20.Window);
    WindowInfo_VIC20.Flags &= ~TMWF_DISABLED;
    ClearPointer(WindowInfo_VIC20.Window);
    }
  }

/* *********************************************************** */
/* Static functions (available only to functions in this file) */
/* *********************************************************** */
 
static BOOL TM_WindowSignal(struct TMData *TMData)
  {
  BOOL done=FALSE;
  BOOL result;
  struct IntuiMessage *imessage;

  while(imessage = GT_GetIMsg(TMData->WindowMsgPort))
    {
    if(imessage->IDCMPWindow == WindowInfo_VIC20.Window)
      {
      WindowInfo_VIC20.GT_IMsg = imessage;
      if(result = WindowIDCMP_VIC20(TMData, imessage)) done = result;
      if(WindowInfo_VIC20.GT_IMsg)
        {
        GT_ReplyIMsg(WindowInfo_VIC20.GT_IMsg);
        WindowInfo_VIC20.GT_IMsg = NULL;
        }
      }
    }

  return(done);
  }

static BOOL WindowIDCMP_VIC20(struct TMData *TMData, struct IntuiMessage *imessage)
  {
  BOOL done=FALSE;
  BOOL result;

  switch(imessage->Class)
    {
    case IDCMP_REFRESHWINDOW:	/* Always refresh */
      GT_BeginRefresh(WindowInfo_VIC20.Window);
      GT_EndRefresh(WindowInfo_VIC20.Window, TRUE);
      break;

    case IDCMP_MENUPICK:
      if(result = Window_VIC20_MENUPICK(TMData, imessage)) done = result;
      break;

    case IDCMP_GADGETUP:
      if(result = Window_VIC20_GADGETUP(TMData, imessage)) done = result;
      break;

    case IDCMP_CLOSEWINDOW:
      if(result = Window_VIC20_CLOSEWINDOW(TMData, imessage)) done = result;
      break;

    }

  return(done);
  }

static VOID TM_RemoveWindow(struct TMWindowInfo *TMWindowInfo)
  {
  struct IntuiMessage *imessage;
  struct Node *succ;

  if(TMWindowInfo->Window)
    {
    if(TMWindowInfo->Menu)
      {
      ClearMenuStrip(TMWindowInfo->Window);
      FreeMenus(TMWindowInfo->Menu);
      TMWindowInfo->Menu = NULL;
      }

    if(TMWindowInfo->GT_IMsg)
      {
      GT_ReplyIMsg(TMWindowInfo->GT_IMsg);
      TMWindowInfo->GT_IMsg = NULL;
      }

    if(TMWindowInfo->Window->UserPort)
      {
      Forbid();
      imessage = (struct IntuiMessage *) TMWindowInfo->Window->UserPort->mp_MsgList.lh_Head;
      while(succ = imessage->ExecMessage.mn_Node.ln_Succ)
        {
        if(imessage->IDCMPWindow == TMWindowInfo->Window)
          {
          Remove((struct Node *) imessage);
          ReplyMsg((struct Message *) imessage);
          }
        imessage = (struct IntuiMessage *) succ;
        }
      TMWindowInfo->Window->UserPort = NULL;
      ModifyIDCMP(TMWindowInfo->Window, 0L);
      Permit();
      }

    CloseWindow(TMWindowInfo->Window);
    TMWindowInfo->Window = NULL;
    TMWindowInfo->Flags = 0;
    }

  if(TMWindowInfo->FirstGadget)
    {
    FreeGadgets(TMWindowInfo->FirstGadget);
    TMWindowInfo->FirstGadget = NULL;
    }
  }

