/*

   this is pretty much a hack of ftpwho supplied with gl-ftpd, since
   i was too lazy to redo the shared-memory routines.

   turned out pretty good btw ;)  <cyberkid@ktsascii.net>

 */

#define HIDDENDIRFILE "/ftp-data/misc/mwho-hiddendirs.txt"
#define HIDDENTAG "** HIDDEN **"
#define SITEDIR "/site"

#define HEAD "                                                        ,_
                     ________     ________________     / /
     __ ________/\\   \\       \\   (         __    /  __/ /
      ((_      /  \\___\\____ _ \\___\\__ __________/  /__  \\      _______ _
// muggi \\______/\\ \\      /  \\       \\_           //  \\ /______\\  ___///
/---------------/ \\______/____\\________\\         //   ///_________\\
    user.grp   /--------------------------------/_\\__//-----------------/
 -------------//   tagline.online     action.catalog
             //---------------------------------------------------------
"
#define	SHOWLINE " [@FLAG] @-10.10USER @-18.18TAGLINE @ACTION
   @-12.12GROUP   online: @-8.8ONLINE   @-33.33CWD
"
#define FOOT " --------------/              < transfers : @2DL leechers, @2UL uploaders >
 < @NUM of @TOTAL > //--------------------------------------------------------
"
#define DLLINE "Get: @FILE (@BYTES @ @SPEEDK)"
#define ULLINE "Put: @FILE (@BYTES @ @SPEEDK)"

#define KEY	0x0000DEAD   // Default KEY used by DAEMON

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <syslog.h>
#include <unistd.h>
#include <sys/param.h>
#include "pmcparse.h"
#include <grp.h>

struct ONLINE {
	char tagline[64];
	char username[24];
	char status[256];
	char host[256];
	char currentdir[256];
	long groupid;
	time_t login_time;
	struct timeval tstart;
	unsigned long bytes_xfer;
	pid_t procid;
};

struct strlist {
	char s[512];
	struct strlist *next;
};

static struct ONLINE *online;
static int dl=0;
static int ul=0;
static int shmid;
static struct shmid_ds ipcbuf;

static void quit();
static double calc_time();

static char *trim(char *str) {
	char *ibuf;
	char *obuf;

	if (str) {
		for (ibuf=obuf=str;*ibuf;) {
			while (*ibuf&&(isspace(*ibuf)))
				ibuf++;
			if (*ibuf&&(obuf!=str))
				*(obuf++)=' ';
			while (*ibuf&&(!isspace(*ibuf)))
				*(obuf++)=*(ibuf++);
		}
		*obuf='\0';
	}
	return(str);
}

static char hmsbuf[50];
void pid_hms_format(time_t testtime) {
	time_t timenow=time(NULL);
	time_t difftime;
	int days = 0;
	int hours = 0;
	int minutes = 0;
	int seconds = 0;

	difftime=timenow-testtime;

	while (difftime>=(time_t)3600) {
		difftime-=(time_t)3600;
		hours++;
	}

	while (difftime>=(time_t)60) {
		difftime-=(time_t)60;
		minutes++;
	}

	if (hours!=0)
		sprintf(hmsbuf,"%02d:%02d:%02d",hours,minutes,difftime);
	else
		sprintf(hmsbuf,"   %02d:%02d",minutes,difftime);
}

char *fgetsnolfs(char *buf, int n, FILE *fh) {
        char *in;
        char *tmp;

        in=fgets(buf,n,fh);
        if (!in) return 0;
        tmp=buf;
        while (*tmp) {
                if ((*tmp==10)||(*tmp==13)) {
                        *tmp=0;
                        break;
                }
                tmp++;
        }
        return in;
}

char *makeage(time_t t) {
	time_t age=time(0);
	char *buf=(char*)malloc(1024);
	time_t days=0,hours=0,mins=0,secs=0;

	if (t>=age)
		sprintf(buf,"0");
	else {
		age-=t;
// printf("age is: %lu, t is: %lu\n",age,t);
		days=age/(3600*24);
		age-=days*3600*24;
		hours=age/3600;
		age-=hours*3600;
		mins=age/60;
		secs=age-(mins*60);

		if (days)
			sprintf(buf,"%dd %dh",days,hours);
		else if (hours)
			sprintf(buf,"%dh %dm",hours,mins);
		else
			sprintf(buf,"%dm %ds",mins,secs);
	}


	return buf;
}

int checkusers(int slots,int ppid,struct strlist *l) {
	register int secret,i,j,found = 0;
	char statbuf[500],buf[2048];
	char pidbuf[10];
	char filename[20],tmpbuf[300];
	struct group *grp;
	struct strlist *tl;

	for (i=0;i<slots;i++) {
		if (online[i].procid==0)
			continue;

		// find out if we need to hide stats about this node.
		secret=0;
		tl=l;
		while (tl) {
			if ((!strncasecmp(online[i].currentdir,tl->s,strlen(tl->s)))&&(online[i].procid!=ppid))
				secret=1;
			tl=tl->next;
		}

#ifdef NOSHOWHIDDEN
		if (!secret) {
#endif

		sprintf(pidbuf,"%u",online[i].procid);

		/* uploading */
		if (!strncasecmp(online[i].status,"STOR", 4) ||
			!strncasecmp(online[i].status,"APPE",4)) {
			if (online[i].bytes_xfer==0)
				goto do_idle;
			if (secret)
				strcpy(filename,HIDDENTAG);
			else {
				strncpy(filename,online[i].status+5,sizeof(filename));
				j=strlen(filename);
				if (!isprint(filename[j-2]))
					filename[j-2]='\0';
				else if (!isprint(filename[j-1]))
					filename[j-1] = '\0';
			}

			strcpy(statbuf,ULLINE);
			pmcparse2(statbuf,'@',"FILE",filename);
			sprintf(tmpbuf,"%lu",online[i].bytes_xfer);
			pmcparse2(statbuf,'@',"BYTES",tmpbuf);
			sprintf(tmpbuf,"%.1f",calc_time(i));
			pmcparse2(statbuf,'@',"SPEED",tmpbuf);

//			sprintf(statbuf,"Up: %-17.17s at %.1fK/sec",filename,
//				calc_time(i));
			ul++;
		}
		/* Downloading */
		else if (!strncasecmp(online[i].status,"RETR",4)) {
			// jump at once, not to end up showing RETR filename
			// on hidden dirs.
			if (online[i].bytes_xfer==0)
				goto do_idle;

			if (secret)
				strcpy(filename,HIDDENTAG);
			else {
				strncpy(filename,online[i].status+5,sizeof(filename));
				j=strlen(filename);
				if (!isprint(filename[j-2]))
					filename[j-2]='\0';
				else if (!isprint(filename[j-1]))
					filename[j-1]='\0';
			}

			strcpy(statbuf,DLLINE);
			pmcparse2(statbuf,'@',"FILE",filename);
			sprintf(tmpbuf,"%lu",online[i].bytes_xfer);
			pmcparse2(statbuf,'@',"BYTES",tmpbuf);
			sprintf(tmpbuf,"%.1f",calc_time(i));
			pmcparse2(statbuf,'@',"SPEED",tmpbuf);
//			sprintf(statbuf,"Dn: %-17.17s at %.1fK/sec",filename,
//				calc_time(i) );
			dl++;
		/* Idling */
		} else if (time(NULL)-online[i].tstart.tv_sec>5) {
do_idle:
			sprintf(statbuf,"Idling for %s",makeage(online[i].tstart.tv_sec));
		} else if (!strncasecmp(online[i].status,"SITE who",8)) {
			sprintf(statbuf,"Snooping on other users..");
		} else {
		/* Doing something else... */
			sprintf(statbuf,"%s",online[i].status);
			trim(statbuf);
		}

		// now parse the line and show it.
		strcpy(buf,SHOWLINE);
		if (secret)
			strcpy(tmpbuf,HIDDENTAG);
		else
			strcpy(tmpbuf,online[i].currentdir+strlen(SITEDIR));

		if (!tmpbuf[0])
			strcpy(tmpbuf,"/");

		pmcparse2(buf,'@',"CWD",tmpbuf);
		pmcparse2(buf,'@',"USER",online[i].username);
		pmcparse2(buf,'@',"TAGLINE",online[i].tagline);
		pmcparse2(buf,'@',"PID",pidbuf);
		pmcparse2(buf,'@',"ACTION",statbuf);
		pmcparse2(buf,'@',"ONLINE",makeage(online[i].login_time));

		if (online[i].procid==ppid)
			pmcparse2(buf,'@',"FLAG","*");
		else
			pmcparse2(buf,'@',"FLAG"," ");

		grp=getgrgid(online[i].groupid);
		if (grp)
			pmcparse2(buf,'@',"GROUP",grp->gr_name);
		else
			pmcparse2(buf,'@',"GROUP","???");
//		free(grp);

		printf(buf);
//		printf("| %-8.8s | %-5.5s | %-8.8s | %-44.44s |\n",
//			online[i].username,pidbuf,hmsbuf,statbuf);
		found++;

#ifdef NOSHOWHIDDEN
		}
#endif
	}
	return (found);
}

int main(int argc, char *argv[]) {
	int online_now,online_max,pid_parent;
	char buf[1024],tmpbuf[300];
	struct strlist *l=NULL,*tmpl;
	FILE *hf;

	if (hf=fopen(HIDDENDIRFILE,"r")) {
		while (fgetsnolfs(tmpbuf,300,hf)) {
			if (tmpbuf[0]&&(tmpbuf[0]!='#')) {
				tmpl=(struct strlist*)malloc(sizeof(struct strlist));
				strcpy(tmpl->s,tmpbuf);
				tmpl->next=l;
				l=tmpl;
			}
		}
		fclose(hf);
	}

	if ((shmid=shmget((key_t)KEY,0,0))==-1) {
		printf("No one online?\n");
		exit(1);
	}

	if ((online=(struct ONLINE*)shmat(shmid,NULL,SHM_RDONLY))==(struct ONLINE*)-1) {
		printf("Error: (SHMAT) Failed!\n");
		exit(1);
	}

	shmctl(shmid,IPC_STAT,&ipcbuf);
	online_max=ipcbuf.shm_segsz/sizeof(struct ONLINE);
	pid_parent=getppid();

	printf(HEAD);
	online_now=checkusers(online_max,pid_parent,l);
	strcpy(buf,FOOT);
	sprintf(tmpbuf,"%2d",online_now);
	pmcparse2(buf,'@',"NUM",tmpbuf);
	sprintf(tmpbuf,"%2d",online_max);
	pmcparse2(buf,'@',"TOTAL",tmpbuf);
	sprintf(tmpbuf,"%d",dl);
	pmcparse2(buf,'@',"DL",tmpbuf);
	sprintf(tmpbuf,"%d",ul);
	pmcparse2(buf,'@',"UL",tmpbuf);
	printf(buf);

	while (l) {
		tmpl=l;
		l=l->next;
		free(tmpl);
	}

	quit(0);
}

static double calc_time(int pid) {
	struct timeval tstop;
	double delta,rate;

	if (online[pid].bytes_xfer<1)
		return 0;
	gettimeofday(&tstop,(struct timezone *)0);
	delta=((tstop.tv_sec*10.)+(tstop.tv_usec/100000.))-
		((online[pid].tstart.tv_sec*10.)+(online[pid].tstart.tv_usec/100000.));
	delta=delta/10.;
	rate=((online[pid].bytes_xfer/1024.0)/(delta));
	if (!rate) rate++;
	return (double)(rate);
}

static void quit(int exit_status) {
	shmctl(shmid,IPC_STAT,&ipcbuf);
	if (ipcbuf.shm_nattch<=1) {
		shmctl(shmid,IPC_RMID,0);
	}
	shmdt(0);
	exit(exit_status);
}



