/* Example program for UnESP-lib    (C) 1999 A'rpi/ESP-team */

/* Extracts raw data from an .ESP archive file. If you have only one file
   compressed in it, then it will uncompress that file. */

#include <stdio.h>
#include <stdlib.h>
#include "unesp.h"

#define IN_BUFFSIZE 8192
#define OUT_BUFFSIZE 8192

#define MEMSIZE (DICT_SIZE+LOOK_AHEAD+OUT_BUFFSIZE)

/************ INPUT ********************/

static byte in_buff[IN_BUFFSIZE];
static FILE *in_file;
static dword in_xor=0;

int buffer_read(byte **in_buff_pos){
  int i=fread(*in_buff_pos=in_buff,1,IN_BUFFSIZE,in_file);
  if(i>0 && in_xor){
    dword* p=(dword*)in_buff;
    do{ *p++ ^= in_xor;} while( (byte*)p < (in_buff+i) );
  }
  putchar('r');fflush(stdout);
  return i;  /* 0=EOF or -1=error or buffersize */
}

/************ OUTPUT ********************/

static FILE *out_file;

int buffer_write(char *buff_pos,int buff_size){
  int i=fwrite(buff_pos,1,buff_size,out_file);
  putchar('W');fflush(stdout);
  if(i>0) return i;
  return -1;
}

/************************* MAIN *******************************/

int main(int argc,char* argv[]){
int i;
char *mem;

in_file=fopen("COPYING.esp","rb"); if(!in_file) return 1;
fseek(in_file,10,SEEK_SET);

out_file=fopen("COPYING","wb"); if(!out_file) return 2;

mem=(char*)malloc(MEMSIZE); if(!mem) return 3;

in_xor=*((dword*)"GyiK"); /* ESP v1.6+ always uses XOR32 'GyiK' coding */

i=unesp(mem,MEMSIZE,buffer_read,buffer_write);

if(i<0){
  printf("\nUnpack error: %d\n",i);
} else {
  printf("\nUnpacked %d bytes\n",i);
}

fclose(out_file);
fclose(in_file);
return 0;
}
