#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#if 1
#include <elf.h>
#else
#include "elf.h"
#endif

FILE *f;
Elf32_Ehdr eh;
Elf32_Shdr sh;
char *shstrtab;
char *rodata=(char*)NULL;
unsigned long rodata_min,rodata_max;

int read_section(char *name){
int i;
  for(i=0;i<eh.e_shnum;i++){
    fseek(f,eh.e_shoff+i*eh.e_shentsize,SEEK_SET);
    fread(&sh,1,eh.e_shentsize,f);
    if(strcmp(&shstrtab[sh.sh_name],name)==0){
      if(fseek(f,sh.sh_offset,SEEK_SET)==-1) return 0;
      return 1; // +van
    }
  }
return 0;  
}


/******************** SYMBOLS ***************************/

typedef struct _sym_entry {
  Elf32_Addr addr;
  char *name;
//  Elf32_Sym *sym;
  struct _sym_entry* next;
} sym_entry;

#define sym_NULL (sym_entry*)NULL;

#define HASH_BITS 10
#define HASH_MAX (1<<HASH_BITS)
#define HASH_FV(addr) ( ((addr)^(addr>>HASH_BITS))&(HASH_MAX-1) )
sym_entry* hash_table[HASH_MAX];

sym_entry* sym_add_entry(Elf32_Addr addr,char *name){
sym_entry* e;
int hash=HASH_FV(addr);;

  // search for redefinition!
  e=hash_table[hash];
  while(e){
    if(e->addr==addr && strcmp(e->name,name)==0 ) return e;  // redef!!
    e=e->next;
  }

  e=malloc(sizeof(sym_entry));
  e->name=name;
  e->addr=addr;
  e->next=hash_table[hash];
  hash_table[hash]=e;
//  printf("%d %s\n",hash,name);
  return e;
}

int sym_list_entries(Elf32_Addr addr){
int num=0;
sym_entry* e=hash_table[HASH_FV(addr)];
  while(e){
    if(e->addr==addr){
      ++num;
      printf("%s ",e->name);
    }
    e=e->next;
  }
  return num;
}

int sym_load_table(char *sym_name,char *str_name){
Elf32_Sym sym;
char* strtable;
int num=0;
int i;

if(!read_section(str_name)) return 0;
// printf("STR:  off=%X  size=%d\n",sh.sh_offset,sh.sh_size);

// printf("Reading STRINGs...");fflush(stdout);
strtable=malloc(sh.sh_size); if(!strtable) return 0;
if(sh.sh_size != fread(strtable,1,sh.sh_size,f)) return 0;
// printf("OK.  size=%d\n",sh.sh_size);

if(!read_section(sym_name)) return 0;
// printf("SYM:  off=%X  size=%d\n",sh.sh_offset,sh.sh_size);

// printf("Reading SYMBOLs...");fflush(stdout);
i=sh.sh_size;
while((i-=sizeof(Elf32_Sym))>0){
  fread(&sym,1,sizeof(Elf32_Sym),f);
//  printf("%08X '%s'\n",sym.st_value,&strtable[sym.st_name]);
  if(sym.st_value && sym.st_name){
     sym_add_entry(sym.st_value,&strtable[sym.st_name]);
     ++num;
  }
}

printf("%d symbols read\n",num);

return num;
}

/********************** END of SYMBOLS ********************/

#include "insns.h"
#include "nasm.h"
#include "nasmlib.h"
#include "sync.h"
#include "disasm.h"

#define BPL 8			       /* bytes per line of hex dump */

int autosync = FALSE;
int bits = 32;
unsigned long prefer = 0;


static void output_ins (unsigned long offset, unsigned char *data,
			int datalen, char *insn) 
{
    int bytes;
    char *hexina;
    int num=0;
    sym_entry* e=hash_table[HASH_FV(offset)];

    while(e){
      if(e->addr==offset){
        if(num==0) printf("\n");
        ++num;
        printf("%s:\n",e->name);
      }
      e=e->next;
    }
    
    printf("%08lX  ", offset);

    bytes = 0;
    while (datalen > 0 && bytes < BPL) {
	printf("%02X", *data++);
	bytes++;
	datalen--;
    }

    printf("%*s%s\n", (BPL+1-bytes)*2, "", insn);

    while (datalen > 0) {
	printf("         -");
	bytes = 0;
	while (datalen > 0 && bytes < BPL) {
	    printf("%02X", *data++);
	    bytes++;
	    datalen--;
	}
	printf("\n");
    }
    
    hexina=strstr(insn,"0x");
    while(hexina){
      long addr;
      char *endptr;
      addr=strtoul(hexina,&endptr,0);
      if(addr){
        int num=0;
        sym_entry* e=hash_table[HASH_FV(addr)];
        while(e){
          if(e->addr==addr){
            if(num==0) printf(" ^-- 0x%08X",(int)addr);
            ++num;
            printf(" = %s",e->name);
          }
          e=e->next;
        }
	if(num) printf("\n");
	// search for strings:
	if(rodata && addr>=rodata_min && addr<=rodata_max){
	  unsigned char *p = &rodata[addr-rodata_min];
          printf(" ^-- 0x%08X = \"",(int)addr);
	  while(1){
	    int c=p[0];
	    p++;
	    if(c==10){ printf("\\n");continue;}
	    if(c==13){ printf("\\r");continue;}
	    if(c<32 || c>=128 ) break;
	    putchar(c);
	  }
	  printf("\"\n");
	}
      }
      hexina=strstr(hexina+1,"0x");
    }
    
}


int disasm_file(int fstart,int fsize,unsigned long offset){
unsigned char *buffer, *p, *q;
char outbuf[256];
int lendis;

    if(fsize==0){
      fseek(f,0,SEEK_END);
      fsize=ftell(f)-fstart;
    }
    fseek(f,fstart,SEEK_SET);

    buffer=malloc(fsize+2*INSN_MAX);
    if(!buffer){ printf("Not enough memory :-(\n");return(0); }

    fsize=fread(buffer,1,fsize,f);

    q = buffer;
    p = q + fsize;
    while(p>q) {
	    lendis=disasm(q, outbuf, bits, offset, FALSE, prefer);
	    if (!lendis || lendis>(p-q)) lendis=eatbyte(q, outbuf);
	    output_ins (offset, q, lendis, outbuf);
	    q += lendis;  offset += lendis;
    };
    
    free(buffer);

    return 1;

}



/************************* M A I N ************************/

void main(int argc,char* argv[]){
int i;

if(argc<2) f=fopen("hello1","r"); else f=fopen(argv[1],"r");
if(!f) return;
  
fread(&eh,1,sizeof(Elf32_Ehdr),f);
if(strncmp(eh.e_ident,ELFMAG,SELFMAG)) return;  // not ELF
// printf("ELF rulez\n");

// printf("PH: off=%08X  num=%4d  entsize=%4d\n",eh.e_phoff,eh.e_phnum,eh.e_phentsize);
// printf("SH: off=%08X  num=%4d  entsize=%4d\n",eh.e_shoff,eh.e_shnum,eh.e_shentsize);
printf("Entry point=%08X\n",eh.e_entry);
// printf("e_shstrndx=%08X\n",eh.e_shstrndx);

fseek(f,eh.e_shoff+eh.e_shstrndx*eh.e_shentsize,SEEK_SET);
fread(&sh,1,eh.e_shentsize,f);
// printf("strtable off=%X  size=%d\n",sh.sh_offset,sh.sh_size);
shstrtab=(char*)malloc(sh.sh_size);
fseek(f,sh.sh_offset,SEEK_SET);
fread(shstrtab,1,sh.sh_size,f);

for(i=0;i<eh.e_shnum;i++){
  fseek(f,eh.e_shoff+i*eh.e_shentsize,SEEK_SET);
  fread(&sh,1,eh.e_shentsize,f);
  printf("%2d. %08X  %08X  %08X  '%s'\n",i,sh.sh_offset,sh.sh_addr,sh.sh_size,&shstrtab[sh.sh_name]);
}

printf("Reading STATIC symbols...\n");
sym_load_table(".symtab",".strtab");  // static
printf("Reading DYNAMIC symbols...\n");
sym_load_table(".dynsym",".dynstr");  // dynamic

if(read_section(".rodata")){
  printf("Reading .rodata section (strings)...\n");
  rodata=malloc(sh.sh_size);
  fread(rodata,1,sh.sh_size,f);
  rodata_min=sh.sh_addr;
  rodata_max=rodata_min+sh.sh_size;
}

if(read_section(".text")){
  disasm_file(sh.sh_offset,sh.sh_size,sh.sh_addr);
}

fclose(f);
}





