/* example.c -- usage example of the zlib compression library
 * Copyright (C) 1995-1996 Jean-loup Gailly.
 * For conditions of distribution and use, see copyright notice in zlib.h 
 */

/* $Id: example.c,v 1.16 1996/05/23 17:11:28 me Exp $ */

#include <stdio.h>
#include "zlib.h"

#define CHECK_ERR(err, msg) if (err != Z_OK){ fprintf(stderr, "%s error: %d\n", msg, err); exit(1); }

#define IN_BUFSIZE 1024
#define OUT_BUFSIZE 2048

/* ========================================================================== */
int inflate_file(FILE* f_in,FILE* f_out){
  int err;
  z_stream d_stream; /* decompression stream */
  char *in_buf,*out_buf;
  
  in_buf=malloc(IN_BUFSIZE);if(!in_buf) return 0;
  out_buf=malloc(OUT_BUFSIZE);if(!out_buf) return 0;

    d_stream.zalloc = (alloc_func)Z_NULL;
    d_stream.zfree = (free_func)Z_NULL;
    d_stream.opaque = (voidpf)Z_NULL;

    err = inflateInit(&d_stream); CHECK_ERR(err, "inflateInit");

    d_stream.avail_in = 0;

    while(1){
        if(d_stream.avail_in==0){
          d_stream.next_in=in_buf;
	  d_stream.avail_in=fread(in_buf,1,IN_BUFSIZE,f_in);
  	  fputc('I',stderr);
	}
        d_stream.next_out = out_buf;            /* discard the output */
        d_stream.avail_out = OUT_BUFSIZE;
        err = inflate(&d_stream, Z_NO_FLUSH);
	fwrite(out_buf,1,OUT_BUFSIZE-d_stream.avail_out,f_out);
  	fputc('O',stderr);
//  printf("err=%d\n",err);
        if (err == Z_STREAM_END) break;
        CHECK_ERR(err, "large inflate");
    }

    err = inflateEnd(&d_stream);
    CHECK_ERR(err, "inflateEnd");

    return d_stream.total_out;
}


/* ========================================================================== */
int deflate_file(FILE* f_in,FILE* f_out,int level){
  int err;
  z_stream d_stream; /* decompression stream */
  char *in_buf,*out_buf;
  
  in_buf=malloc(IN_BUFSIZE);if(!in_buf) return 0;
  out_buf=malloc(OUT_BUFSIZE);if(!out_buf) return 0;

    d_stream.zalloc = (alloc_func)Z_NULL;
    d_stream.zfree = (free_func)Z_NULL;
    d_stream.opaque = (voidpf)Z_NULL;

    err = deflateInit(&d_stream,level); CHECK_ERR(err, "deflateInit");

    d_stream.avail_in = 0;

    while(1){
        if(d_stream.avail_in==0){
          d_stream.next_in=in_buf;
	  d_stream.avail_in=fread(in_buf,1,IN_BUFSIZE,f_in);
    	  fputc('I',stderr);
	}
        d_stream.next_out = out_buf;            /* discard the output */
        d_stream.avail_out = OUT_BUFSIZE;
        if(d_stream.avail_in==0)
          err = deflate(&d_stream, Z_FINISH);
	else
          err = deflate(&d_stream, Z_NO_FLUSH);
	fwrite(out_buf,1,OUT_BUFSIZE-d_stream.avail_out,f_out);
  	fputc('O',stderr);
        if (err == Z_STREAM_END) break;
        CHECK_ERR(err, "large deflate");
    }

    err = deflateEnd(&d_stream);
    CHECK_ERR(err, "deflateEnd");

    return d_stream.total_out;
}


/* ===========================================================================
 * Usage:  z [-c|-d] [-0..9] [inputfile outputfile]
 */

int main(int argc, char* argv[]){
FILE *f1=stdin,*f2=stdout;
int opt=0;
int fnc=0;
int decompress=0;
int level=9;

    while(opt<argc-1){
      ++opt;
      if(argv[opt][0]=='-'){
        int c=argv[opt][1];
	if(c=='c'){ decompress=0;continue; }   // not really required
	if(c=='d'){ decompress=1;continue; }
	if(c>='0' && c<='9'){ level=c-'0';continue; }
	printf("Invalid option: %s\n",argv[opt]);exit(4);
      } else {
	++fnc;
        if(fnc==1){
           f1=fopen(argv[opt],"rb");
	   printf("file1=%s\n",argv[opt]);
	   if(f1) continue;
	   printf("Cannot open file: %s\n",argv[opt]);exit(1);
	}
        if(fnc==2){
           f2=fopen(argv[opt],"wb");
	   printf("file2=%s\n",argv[opt]);
	   if(f2) continue;
	   printf("Cannot open file: %s\n",argv[opt]);exit(2);
	}
	printf("Too many filename specified\n");exit(3);
      }
    }

    if(decompress)
      inflate_file(f1,f2);
    else
      deflate_file(f1,f2,level);
    
    if(f2!=stdout) fclose(f2);
    if(f1!=stdin)  fclose(f1);

    return 0;
}
