#ifndef _LOCAL_DOSRUN_H
#define _LOCAL_DOSRUN_H

#include <asm/vm86.h>

typedef 	unsigned int 		dword;
typedef 	unsigned short int 	word;
typedef 	unsigned char 		byte;

extern struct vm86_struct vm;

/* DO NOT feed these macros with args greater than 16 bit values ... */
#define DOS_PA(s,o) ((s<<4)+o)
#define DOS_PB(s,o) ((byte*)((s<<4)+o))
#define DOS_PW(s,o) ((word*)((s<<4)+o))
#define DOS_PD(s,o) ((dword*)((s<<4)+o))
#define DOS_LONG(h,l) ((h<<16)|l)

#define DWORD(reg) (*((dword*)&reg))
#define WORD(reg) (*((word*)&reg))
#define BYTE(reg) (*((byte*)&reg))
#define BYTE_HI(reg) (*((byte*)&reg+1))

#define EAX DWORD(vm.regs.eax)
#define AX  WORD(vm.regs.eax)
#define AL  BYTE(vm.regs.eax)
#define AH  BYTE_HI(vm.regs.eax)

#define EBX DWORD(vm.regs.ebx)
#define BX  WORD(vm.regs.ebx)
#define BL  BYTE(vm.regs.ebx)
#define BH  BYTE_HI(vm.regs.ebx)

#define ECX DWORD(vm.regs.ecx)
#define CX  WORD(vm.regs.ecx)
#define CL  BYTE(vm.regs.ecx)
#define CH  BYTE_HI(vm.regs.ecx)

#define EDX DWORD(vm.regs.edx)
#define DX  WORD(vm.regs.edx)
#define DL  BYTE(vm.regs.edx)
#define DH  BYTE_HI(vm.regs.edx)

#define ESI DWORD(vm.regs.esi)
#define SI  WORD(vm.regs.esi)

#define EDI DWORD(vm.regs.edi)
#define DI  WORD(vm.regs.edi)

#define ESP DWORD(vm.regs.esp)
#define SP  WORD(vm.regs.esp)

#define EBP DWORD(vm.regs.ebp)
#define BP  WORD(vm.regs.ebp)

#define EIP DWORD(vm.regs.eip)
#define IP  WORD(vm.regs.eip)

#ifdef CONFIG_RAW_INT
# define EFLAGS DWORD(vm.regs.eflags)
# define FLAGS  WORD(vm.regs.eflags)
# define CLC vm.regs.eflags&=~1
# define STC vm.regs.eflags|=1
#else
# define EFLAGS DWORD(vm.regs.eflags)
# define FLAGS  WORD(vm.regs.eflags)
# define CLC vm.regs.eflags&=~1
# define STC vm.regs.eflags|=1
#endif

#define CS vm.regs.cs
#define DS vm.regs.ds
#define ES vm.regs.es
#define SS vm.regs.ss
#define FS vm.regs.fs
#define GS vm.regs.gs

#define CLC vm.regs.eflags&=~1
#define STC vm.regs.eflags|=1


#endif
