/* Some XMS settings, only valid if CONFIG_XMS is defined */

#define XMS_SIZE 256         /* in Ks by default */
#define XMS_HANDLES 64       /* max number of XMS handles by default */
#define HMA_MIN 16348        /* minimum HMA request size for successfull HMA allocation */
#define XMS_PROC_SEG 0xF000  /* address after int emulation in int_raw mode */
#define XMS_PROC_OFS 0x400

/* dosrun config files */

#define CONFIG_FILE_SYSTEM "/etc/dosrun.conf"
#define CONFIG_FILE_USER "/.dosrunrc"      /* string, without user home directory, but the trailing '/' is requied ! */

/* emulated DOS version number by default */
#define DOS_VER_MAJOR 6
#define DOS_VER_MINOR 22

#define DOS_PATH_MAXSIZE 256

/* int eumation paramters in RAW_INT mode */

#define EMU_INT 0xFF         /* interrupt for emulating interrupts, functions ... */
#define EMU_INT_SEG 0xF000   /* (in RAW_INT mode the only interrupt which return from vm86 mode) */
#define EMU_INT_OFS 0

/* now some switchable options for you */

#define CONFIG_RAW_INT       /* if defined, dos programs may redirect interrupt vectors but slower */


#define CONFIG_XMS           /* XMS implementation */
#define CONFIG_INT10         /* INT 10 implementation */
#define CONFIG_INT15         /* INT 15 implementation */
#define CONFIG_INT16         /* INT 16 implementation */
#define CONFIG_INT2F         /* general INT 2F implementation */
#define CONFIG_INT2F_OTHER   /* misc INT 2F implementation */

#define CONFIG_DEBUG_UNIMPLEMENTED_FUNC  /* warning on unimplemented functions */
#define CONFIG_DEBUG_UNIMPLEMENTED_INT   /* warning on unimplemented interrupts */


/* !! DO NOT EDIT BELOW !! */

#define XMS_INT EMU_INT

/* XMS and INT2F_OTHER needs INT 2F function */
#if (defined(CONFIG_XMS) || defined (CONFIG_INT2F_OTHER)) && !defined(CONFIG_INT2F)
#define CONFIG_INT2F
#endif

struct config_struct {
  char *chdir_path;
  int ro,roexec;
  char *rw;
  int timer;
};
