/*

  DOS Runner v0.3  *  (C) 1999 by Arpad Gereoffy  <arpi@banki1.banki.hu>
  based on Linux Real Mode Interface - Copyright (C) 1998 by Josh Vanderhoof

  see README for details.

*/

#define DOSENV_SIZE 4096
// #define RAW_TTY       /* requires for good INT 16h emulation */


#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/kd.h>
#include <sys/stat.h>

#include "lrmi.h"

extern int DTA_ofs,DTA_seg;

char * path_u2d(char *p,char *newpath);
extern int convert_path;
#define strcpy2(d,s) if(convert_path) path_u2d(s,d); else strcpy(d,s);

/* Build DOS environment table from LINUX's env */
void make_dosenv(char *de_p,char *selfname){
int i=0;
char *p;
FILE *f;

while(p=environ[i]){
//  printf("%2d. %s\n",i,p);
  strcpy2(de_p,p);de_p+=strlen(p)+1;
  i++;
}
de_p[0]=0;
de_p[1]=1;
de_p[2]=0;
strcpy2(&de_p[3],selfname);

}



void run_vm86_EXE(char *fnev,int argc,char *argv[]){
struct LRMI_regs r;
int vret;
int fsize2;
unsigned short int exehead[14];  /* 28 bytes */
int exesize,headsize,minmem;
int baseseg;
FILE *f;
char *m;
short *m_sh;
char *dosenv;
char *cmdline;
unsigned short *reloc;
unsigned short *rp;
int i;
int exe;

	dosenv=(void*)dosmem_alloc(DOSENV_SIZE);  /* ENV */
	if(!dosenv) {fprintf(stderr, "not enough memory (env)\n");return;}

	f=fopen(fnev,"rb");if(!f)
	  {fprintf(stderr, "cannot open\n");return;}
	if(14!=fread(exehead,2,14,f))
	  {fprintf(stderr, "filesize<28byte\n");return;}

	if(exehead[0]!=('M'<<8)+'Z' && exehead[0]!=('Z'<<8)+'M'){
	  exe=0; /* COM */
  	  m=(void*)dosmem_alloc(0x10000);  /* 64k */
	  if(!m) {fprintf(stderr, "not enough memory (.com prg)\n");return;}
	  baseseg=((unsigned int)m)>>4;
	  rewind(f);
	  fread(m+0x100,1,0xff00,f);  /* load .COM prg */

	} else {

	  exe=1; /* EXE */

	  if(exehead[1]==0) exesize=exehead[2]*512;
	               else exesize=(exehead[2]-1)*512+exehead[1];
	  headsize=exehead[4]<<4;
	  minmem=exehead[5]<<4;
	  fsize2=exesize-headsize;    /* ennyit kell betolteni */
//	  printf("exe=%d  head=%d  mem=%d  fsize=%d\n",exesize,headsize,minmem,fsize2);

	  m=(void*)dosmem_alloc(fsize2+minmem+15+0x100);  /* EXE+MEM+PSP */
	    if(!m) {fprintf(stderr, "not enough memory (prg)\n");return;}
	  baseseg=((unsigned int)m+0x100)>>4;

	  fseek(f,headsize,SEEK_SET); /* skip reloc.table */
	  if(fsize2!=fread(m+0x100,1,fsize2,f))
	    {fprintf(stderr, "read error\n");return;}

	if(exehead[3]){  /* relocation */
	  reloc=(unsigned short*) malloc(4*exehead[3]);
	    if(!reloc) {fprintf(stderr, "not enough memory (reloc)\n");return;}
	  fseek(f,exehead[12],SEEK_SET);
	  printf("%d reloc. units loaded.\n",
  	    fread(reloc,4,exehead[3],f)
	  );
	  for(i=0;i<exehead[3];i++){
	    rp=(unsigned short*)( ((baseseg+reloc[1])<<4) + reloc[0] );
	    rp[0]+=baseseg;
	    reloc+=2;
	  }
	}

	}
	
	fclose(f);

	/* Setup DOS environment */
	make_dosenv(dosenv,fnev);
	m_sh=(void*)(&m[0x2c]);
	m_sh[0]=(unsigned int)dosenv>>4;

	/* Build PSP */
	m[0]=0xCD; m[1]=0x20;  /* INT 20h opcode */
	m[2]=0x00; m[3]=0xA0;  /* top_of_the_memory=A000h */

	cmdline=&m[0x81];      /* commandline */
	for(i=0;i<argc;i++){
	  cmdline[0]=' ';++cmdline;
	  strcpy2(cmdline,argv[i]);
	  cmdline+=strlen(argv[i]);
	}
        cmdline[0]=0x0D;
	i=(int)cmdline-(int)m-0x81;
	m[0x80]=i;

	memset(&r, 0, sizeof(r));
	if(exe){
	  r.es=baseseg-0x10;      /* -> PSP */
	  r.ip=exehead[10];
	  r.ds=r.cs=exehead[11]+baseseg;
	  r.sp=exehead[8];
	  r.ss=exehead[7]+baseseg;
	} else {
	  r.ss=r.es=r.ds=r.cs=baseseg;
	  r.ip=0x100;
	  r.sp=0xfffe;
	  m[0xfffe]=0; m[0xffff]=0;   /* pushw 0 */
	}
	
	/* setup DTA to PSP:80h */
	DTA_seg=r.es; DTA_ofs=0x80;  
	
//	printf("base=%04X  CS:IP=%04X:%04X  SS:SP=%04X:%04X\n",baseseg,r.cs,r.ip,r.ss,r.sp);
	
	vret=LRMI_call(&r);
	if(!vret){ fprintf(stderr, "vm86 failure\n"); return;}
	     else  printf("vm86 Ok.\n");

//	printf("eax=%8X\n",r.eax);

//	printf("All ok\n");
}



int main(int argc, char *argv[]){
int i;
#ifdef RAW_TTY
    struct termios tio_orig,tio_new;
#endif

    puts("\nDOS Runner v0.3  *  (C) 1999 by Arpad Gereoffy  <arpi@banki1.banki.hu>");
    puts("based on Linux Real Mode Interface by Josh Vanderhoof");
    puts("This software has NO WARRANTY.  Use it at your own risk.\n");

    if(argc<2){
      puts("Usage: dosrun prgname.[COM|EXE] [parameters]\n");
      return 1;
    }

    if (!LRMI_init()) return 1;

#ifdef RAW_TTY
    tcgetattr(0,&tio_orig);
    tio_new=tio_orig;
    cfmakeraw(&tio_new);
    tcsetattr(0,TCSANOW,&tio_new);
#endif
        
/*
	ioperm(0, 0x400, 1);
	iopl(3);
*/
	
	run_vm86_EXE(argv[1],argc-2,&argv[2]);
	
#ifdef RAW_TTY
    tcsetattr(0,TCSANOW,&tio_orig);
#endif
	return 0;
}
