/* Memory block alloc/free/resize/list routines  (C) 1999. A'rpi/ESP-team */

typedef struct _memblock {
  int base;
  int size;
  int free;
  struct _memblock *prev;
  struct _memblock *next;
} memblock;

memblock *dosmem_first=NULL;

void dosmem_init(){
  dosmem_first=(memblock*)malloc(sizeof(memblock));
  dosmem_first->base=REAL_MEM_BASE;
  dosmem_first->size=REAL_MEM_SIZE;
  dosmem_first->free=1;
  dosmem_first->prev=NULL;
  dosmem_first->next=NULL;
}

/* Return:
   ret=0   if not enough memory
   ret>0   allocation ok, offset=ret      
*/
int dosmem_alloc(int size){
memblock *p=dosmem_first;
memblock *best=NULL;
int best_err=0x100000;
  size=(size+15)&(~15);
  while(p){
    if(p->free){
      int err=p->size-size;
      if(err>=0 && err<best_err){
        best=p;
        best_err=err;
      }
    }
    p=p->next;
  }
  if(!best) return 0;
  best->free=0;
  if(best->size>size){
    /* daraboljuk */
    memblock *new=(memblock*)malloc(sizeof(memblock));
    new->size=best->size-size; best->size=size;
    new->prev=best; new->next=best->next; best->next=new; /* insert block */
    new->free=1; new->base=best->base+size;
  }
  return best->base;
}

/* Connect continous free blocks */
void dosmem_pack(){
memblock *p=dosmem_first;
  while(p && p->next){
    memblock *q=p->next;
    if(p->free && q->free && (p->base+p->size==q->base)){
      memblock *r=q->next;
      p->size+=q->size;
      p->next=r; if(r) r->prev=p;
      free(q);
    } else
    p=q;
  }
}


/* Return:
  0 = block not found or already free
  1 = block freeed
*/  
int dosmem_free(int base){
memblock *p=dosmem_first;
  while(p){
    if(p->base==base){
      if(p->free) return 0;
      p->free=1;
      dosmem_pack();
      return 1;
    }
    p=p->next;
  }
  return 0;
}


/* Return:
  ret=0 = block not found or already free
  ret=1  = block resized
*/  
int dosmem_resize(int base,int size){
memblock *p=dosmem_first;
int s;
  while(p){
    if(p->base==base){
      memblock *q=p->next;
      if(p->free || size==p->size)  return 0;  /* free block? */

      if(size<p->size){                 /* decrease block size */
        s=p->size-size;
	if(q && q->free){
	  /* increase next (free) block */
	  q->base-=s;
	  q->size+=s;
	  p->size-=s;
	  return 1;
	}
	/* insert new (free) block */
        q=(memblock*)malloc(sizeof(memblock));
	q->next=p->next; q->prev=p; p->next=q;  /* insert */
	q->size=s; p->size=size;
	q->base=p->base+size;
	q->free=1;
	return 1;
      } 
       /* increase block size */
      if(!q) return 0;  /* this is the last block */
      s=p->size+q->size;
      if((!q->free) || (size>s) || (p->base+p->size!=q->base)) return 0;  /* cannot increase block */
      p->size=size; q->size=s-p->size;
      q->base=p->base+size;
      if(q->size==0){
        /* remove [q] block */
        memblock *r=q->next;
	p->next=r; if(r) r->prev=p;
	free(q);
      }
      return 1;
    }
    p=p->next;
  }
  return 0; /* not found */
}


/* Return:
  ret=largest free block size
*/
int dosmem_largest(){
memblock *p=dosmem_first;
int l=0;
  while(p){
    if(p->free && p->size>l) l=p->size;
    p=p->next;
  }
  return l;
}


void dosmem_list(){
memblock *p=dosmem_first;
  printf("\nFree  Base  Size\n");
  while(p){
    printf("  %1d  %05X  %05X\n",p->free,p->base,p->size);
    p=p->next;
  }
}

