; A FLAT REAL MODE INITIALIZER       by  Walken / IMPACT Studios
; 
; This file is used by UNREAL2.LIB!!! Don't include into your prg!
;
; Compliant with EMS environments
;
; Documentation used :
;   microsoft eXtended Memory Specification (XMS) ver 3.0
;   lotus/intel/microsoft Expanded Memory Specification (EMS) ver 4.0
;   microsoft undocumented Global EMM Import Specification (GEMMIS) ver 1.11
;
; (c) Walken / IMPACT Studios in 1995 - for publication in Imphobia #10
; Michel LESPINASSE - 18 rue Jean Giono - 80090 Amiens - FRANCE
;
; Some optimizations and bugfixes by GyikSoft in 1997.
; MS-DOS 7.x (Win95) support by GyikSoft  1997.10.25.
;

.asm
.486p

o equ offset      ; muszj .ASM-ben, az OFFSET//{ind ...} miatt!
b equ byte ptr
w equ word ptr
d equ dword ptr
f equ fword ptr

mem32_find_segment_type macro
mem32_here=$
push ax
mem32_size=$-mem32_here
org mem32_here
endm

switch_prot macro off
mem32_find_segment_type
        mov eax,cr0
        or al,1
        mov cr0,eax
        db 0eah
if mem32_size eq 1
        dw offset off
else
        dd offset off
endif
        dw _text_selector
endm

switch_real macro off
mem32_find_segment_type
        mov eax,cr0
        and al,0feh
        mov cr0,eax
        db 0eah
if mem32_size eq 1
        dw offset off
else
        dd offset off
endif
        dw ? ;;; code-seg
endm

.bap

{CONST
native_V86 db 0         ;system mode 0=real 1=V86
local_A20 db 0          ;A20 line touched by XMS 0=no 1=yes
no_native db 0          ;running with CPU mode <> system mode 0=no 1=yes
flat_enabled db 0       ;running in FRM 0=no 1=yes
NMI_state_touched db 0  ;touched NMI state 0=no 1=yes

ptr_GDT label fword
        dw 39,o GDT2,0,0
GDT2    dw 0,0,0,0              ;NULL selector
        dw 0ffffh,0,9a00h,0     ;code   selector
        dw 0ffffh,0,9200h,0     ;data16 selector
        dw 0,0,0,0              ;unused
        dw 0ffffh,0,9200h,8fh   ;data32 selector
_text_selector=8

ptr_IDT_native label fword
        dw 3ffh,0,0,0
ptr_IDT_flatreal label fword
        dw 3ffh,offset IDT_flatreal,0,0
}

{VAR
modeswitch dd ?
NMI_state db ?
}

        ;****************************************;
        ;* memory manager init / alloc function *;
        ;****************************************;

GEMMIS_INIT::  ;;;mem32_init::

WPT cs_hely_1:=CS
WPT cs_hely_2:=CS

SI->IDT_flatreal[2]
LOOP(256) WPT [SI]:=CS//SI+=4

;* windows fake init
        call open_ouinedoze // JC UNREAL_INIT_ERROR_GEMMIS

        mov ah,3;5              ;local enable A20
        call x_calladdx
        IF AX=0 THEN UNREAL_INIT_ERROR_A20

        call switch_to_real // JC UNREAL_INIT_ERROR_GEMMIS
        call first_enable_flat

;* install flat real mode interrupt handler
        lidt cs:ptr_IDT_flatreal
        sti
        RETC

;
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^;

        ;*********************************************;
        ;* memory manager exit / unallocate function *;
        ;*********************************************;
        ; DS:DX = exit message to display

GEMMIS_UNINIT::

;* disable flat mode
        IF flat_enabled THENCMD PUSH(FL) !disable_flat

;* native mode switch
        IF no_native THENCMD !switch_to_v86//sti

;* restore NMI state
        IF NMI_state_touched THEN
          mov al,NMI_state
          out 70h,al              ;restore NMI state
          rep(3) jmp $+2
          in al,71h
        ENDIF

;* local disable A20
;        mov ah,6              ;local disable A20
;        call x_calladdx

;* windows fake exit
      call close_ouinedoze

RETC

;==================== INTERRUPT Handler ===========================

        ;***********************************************;
        ;* memory manager interrupt handling functions *;
        ;***********************************************;

{const
.ALIGN 4

IDT_flatreal equ this word              ;flat real mode interrupt table
irpc hex,<0123456789abcdef>
irpc unit,<0123456789abcdef>
dw it&hex&&unit,0 ;_text         ;  _text = Code-segment!!
endm
endm

num=0                                   ;flat real mode interrupt handlers
irpc hex,<0123456789abcdef>
irpc unit,<0123456789abcdef>
it&hex&&unit:
        push eax
        mov al,num
        jmp it
num=num+1
endm
endm
}

.align 16
it::
        lidt cs:ptr_IDT_native
        mov cs:automodif_int+1,al

        push ebx
        push ecx
        push edx
        push esi
        push edi
        push ebp
        push ds
        push es
        push fs
        push gs
          call disable_flat
          call switch_to_v86//jc ^err
          call close_ouinedoze
        pop gs
        pop fs
        pop es
        pop ds
        pop ebp
        pop edi
        pop esi
        pop edx
        pop ecx
        pop ebx
        pop eax

      push esp
        movzx esp,sp
        push w ss:[esp+8]//popf      ;flags, tricky !
automodif_int db 0cdh,0              ;call the old interrupt handler
        pushf//pop w ss:[esp+8]      ;flags, tricky !
        cli
      pop esp

        push eax
        push ebx
        push ecx
        push edx
        push esi
        push edi
        push ebp
        push ds
        push es
        push fs
        push gs
          call open_ouinedoze
          call switch_to_real
          call enable_flat
        pop gs
        pop fs
        pop es
        pop ds
        pop ebp
        pop edi
        pop esi
        pop edx
        pop ecx
        pop ebx
        pop eax
        lidt cs:ptr_IDT_flatreal
        iret

^err:
        WRITELN'Unable to switch to V86 mode for interrupts'
        DOSEXIT ;!!!!!!!!!!!!!!!!

;================== FLATREAL switch ========================

        ;*************************************;
        ;* memory manager internal functions *;
        ;*************************************;

first_enable_flat::
        xor eax,eax
        mov ax,cs
        shl eax,4
        add dword ptr ptr_GDT+2,eax
        add dword ptr ptr_IDT_flatreal+2,eax
        mov si,offset cs:GDT2
        mov word ptr [si+_text_selector+2],ax
        shr eax,16
        mov byte ptr [si+_text_selector+4],al

        cli
        in al,70h
        rep(3) jmp $+2
        mov ah,al
        in al,71h
        rep(3) jmp $+2
        mov al,ah
        mov NMI_state,al
        inc NMI_state_touched
        or al,80h
        out 70h,al              ;disable NMI
        rep(3) jmp $+2
        in al,71h

.align 4
enable_flat:.
        pushf
        cli
        lgdt fword ptr ptr_GDT
        switch_prot ^pmode
^pmode:
        mov ax,32
        mov ds,ax
        mov es,ax
        mov fs,ax
        mov gs,ax
        switch_real ^rmode
        cs_hely_1=$-2
^rmode:
        push cs
        pop ds
        popf
        inc flat_enabled
        ret

.align 4
disable_flat::
        cli
        switch_prot ^pmode
^pmode:
        mov ax,16
        mov ds,ax
        mov es,ax
        mov fs,ax
        mov gs,ax
        switch_real ^rmode
        cs_hely_2=$-2
^rmode:
        push cs
        pop ds
        dec flat_enabled
        ret

;==================== GEMMIS functions ==========================

.align 4
switch_to_real::
        xor ax,ax
        cli
        call cs:modeswitch  ;;; TILOS megvltoztatni a sorrendet!!!
        push cs             ;;;
        pop ds              ;;;
        jc RETS ;exitmsg
        inc no_native
        RETC

.align 4
switch_to_v86::
        mov ax,1
        cli
        call cs:modeswitch  ;;; TILOS megvltoztatni a sorrendet!!!
        push cs             ;;;
        pop ds              ;;;
        mov no_native,0
        ret

open_ouinedoze::
        dl:=0//ax:=1231h//int 2fh  ; Win95 miatt
        mov ax,1605h
        xor bx,bx
        mov cx,bx
        mov dx,bx
        mov si,bx
        mov di,400h ;30bh             ;version number 3.11
        mov ds,bx
        mov es,bx
        int 2fh   ;set device name to "EMMXXXX0" & return entry point addr
        mov ax,ds
        push cs
        pop ds
        or cx,cx
        jnz RETS ;exitmsg             ;cannot run windows
        mov w modeswitch+2,ax
        mov w modeswitch,si
        or ax,si
        jz RETS ;exitmsg              ;modeswitch not available
        RETC

close_ouinedoze::
        mov ax,1606h
        xor dx,dx
        int 2fh                 ;restore device name
        ret

.asm
.386
.bap

