;ENTRY_63.ASM	12-03-1998	      HC05 sort filter coding entry @ 3Fh = 63d
;
;An extremely slow algorithm designed to sort the lines in place so that they
;can be output as a single stream using function AH=09, display string.
;
				.RADIX 16
;
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY,ES:ONLY
				ORG 100
;******************************************************************************
;*		      Copyright (C) Lawrence E. Boothby 1998		      *
;*		     Contract programming <boothbyl@reed.edu>		      *
;*									      *
;* EXECUTION ENVIRONMENT ASSUMPTIONS:					      *
;*		Direction flag = 0, BX=0000,DX=CS=DS=ES=SS, (not loaded high) *
;* INPUT ASSUMPTIONS:							      *
;*		Max input file length = 30,000 = 7530h (room depends on CS)   *
;*		At least one CR,LF pair, no final ^Z			      *
;*		Alphabet = 0Ah,0Dh, 20h-23h,25h-0FFh			      *
;******************************************************************************
;AH=3F saves 6 bytes over AH=06 input and saves 2 byte MOV DX,? on AH,09 output
;
START:		MOV	AH,3F		;read from handle BX=00 = sti
		MOV	CX,SP		;anything >= 7530h = 30,000 bytes
		INT	21h		;DS:DX=CS:CS:==>DTA
		;jc	safe		;in case of read error
		XCHG	BP,AX		;count bytes
		MOV	DI,DX		;=CS
		MOV	BL,'$'		;saves one byte net over immediate
		MOV	BYTE PTR [BP+DI],BL
		MOV	AX,090A		;AH=display string, AL=LF
	;------------------------------------------------------------------:
	; Find lowest sort order line that has not yet been output	   :
	;------------------------------------------------------------------:
FIND_MIN:	PUSH	DI		;start of lines left to sort
UPDATE:		MOV	SI,DI		;SI-->current sort-order 1st
DO_CMP:		DB 60h	;PUSHA		;save SI-->min so far, DI-->next
		MOV	CL,0FF
		REPZ	CMPSB
		DB 61h	;POPA		;restore SI-->, DI-->
		JA	UPDATE		;DI-->line that is before SI-->line
		MOV	CL,0FF
		REPNZ	SCASB		;have saved a JMP by doing this here
		CMP	BYTE PTR[DI],BL ;rather than at start of this loop
		JNZ	DO_CMP		;which will result in extra comparison
		POP	DI		;with self.
	;------------------------------------------------------------------:
	; Move line found to front of unsorted data and update -->unsorted :
	;------------------------------------------------------------------:
NXT_MOV:	MOV	CX,SI		;CX will be a constant inside this loop
		SUB	CX,DI		;recalculating it saves PUSH/POP CX
		STD
		MOV	DI,SI
		LODSB			;(modifies AL=0A)
		PUSH	SI
		REP	MOVSB
		POP	SI
		CLD
		STOSB
		INC	SI
		INC	SI
		CMP	AL,0A
		JNZ	NXT_MOV
		CMP	BYTE PTR [DI],BL
		JNZ	FIND_MIN	;AL=0A again
	;------------------------------------------------------------------:
	; Output entire, now sorted, file				   :
	;------------------------------------------------------------------:
		INT	21		;AH=09 = display string
safe:		RET			;case no more remaining
;******************************************************************************;
BUFFER	LABEL	BYTE
ONLY	ENDS
	END START
