;ENTRY_59.ASM	12-04-1998	      HC05 sort filter coding entry @ 3Bh = 59d
;
;Find and output first sort-order line that has not been sent already, mark it
;done and repeat until all output
;
				.RADIX 16
;
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY,ES:ONLY
				ORG 100
;******************************************************************************
;*		      Copyright (C) Lawrence E. Boothby 1998		      *
;*		     Contract programming <boothbyl@reed.edu>		      *
;*									      *
;* EXECUTION ENVIRONMENT ASSUMPTIONS:					      *
;*		Entry SP=FFFE (full segment available to load program)	      *
;*		BX = 0000 = sti handle, Direction flag = 0		      *
;*		DX = CS and not loaded high so can use CS:CS for buffer	      *
;* INPUT ASSUMPTIONS:							      *
;*		Max input file length = 30,000 = 7530h (depends on DX=CS)     *
;*		At least one CR,LF pair, no final ^Z			      *
;*		Alphabet = 0Ah,0Dh, 20h-0FFh				      *
;******************************************************************************
START:		MOV	AH,3F		;read CX bytes from handle BX = sti
		MOV	CX,SP		;anything >= 7530h = 30,000d bytes
		;DX = CS		 anything >= OFFSET BUFFER
		INT	21h
		;JC	 EXIT		;to handle read error
		XCHG	BX,AX		;get count into BX
		MOV	AX,020A		;get AX = function AH=02, AL = LF
		;(keeping constant initialization outside of loop)
FIND_MIN:	MOV	DI,CS		;initialize -->buffer (DX gets changed)
		MOV	BYTE PTR [DI+BX],00 ;flag end of data (extra after 1st)
	;------------------------------------------------------------------:
	; Find 1st sort order line that has not yet been sent		   :
	;------------------------------------------------------------------:
UPDATE:		MOV	SI,DI		;SI-->current sort-order 1st
TRY_NXT:	MOV	CL,0FF
		REPNZ	SCASB
		CMP	[SI],AH
		JB	EXIT		;if [SI]=00 no more to output
		JZ	UPDATE		;find first not yet done
		CMP	[DI],AH
		JB	OUTPUT		;if [DI]=00, no more to compare
		JZ	TRY_NXT		;no compare with lines already output
		DB 60h	;PUSHA		;save SI-->min so far, DI-->next
		MOV	CL,0FF
		REPZ	CMPSB
		DB 61h	;POPA		;restore SI, DI
		JA	UPDATE		;DI-->line that is before SI-->line
		JMP	SHORT TRY_NXT
EXIT:		RET			;case no more remaining
	;------------------------------------------------------------------:
	; Output this line and mark it sent				   :
	;------------------------------------------------------------------:
OUTPUT:		MOV	DI,SI		;save -->start of line
NXT_CHR:	MOV	DL,[SI]		;get character
		INC	SI
		INT	21		;send this character, returns AL<-DL
		CMP	AL,0Ah		;was this terminal LF?
		JNZ	NXT_CHR
		MOV	[DI],AH		;flag line done (AX=020A)
		JMP	SHORT FIND_MIN
;*******************************************************************************
BUFFER	LABEL	BYTE
ONLY	ENDS
	END START
