; by Dan Dascalescu <dandv@thepentagon.com>
; 65d bytes with TASM 3.2 and TURBO Link 5.1

model tiny
codeseg
.386p
.radix 16
.startup

        mov ah,3f
        neg cx                         ; CX == 0FF00, > 30000
        int 21
        xchg bx,ax                     ; BX == size
        dec dx
        mov byte ptr [edx],0A

find1st:mov cx,bx
        mov di,dx
        mov al,0A
        repne scasb                    ; find BO1st line left to be 'sorted'
        je short findnxt               ; found at least 1 line left
        ret

findnxt:push dx
        mov dx,di                      ; DX points to the minimum string

cmpnext:repne scasb
        mov si,dx                      ; AL == 0A
        mov fs,di                      ; save offset
        rep cmpsb                      ; as long as the strings are '==', cmp
        jc notmin

        mov dx,fs                      ; found a string "smaller" than @DX
notmin: inc cx
        loop cmpnext

@print: mov di,dx                      ; prepare 2 scan 4 EOLN
        mov al,0Dh
        mov [di-1],al                  ; mark the string as "found"
        dec cx                         ; CX == -1
        repne scasb                    ; search for 0D since 0A might not be
        mov bp,'$'shl 8+0A             ; found it; DI == right after
        xchg [di],bp
        mov ah,9
        int 21
        xchg [di],bp

        pop dx
        jmp find1st

end