#include "SM_MainPCH.h"
#include "SM_Keyboard.h"

CKeyboardHandler::CKeyboardHandler()
{  
}

CKeyboardHandler::~CKeyboardHandler()
{
  Shutdown();
}

int   CKeyboardHandler::Init()
{
  Reset();
  return (0);
}

int   CKeyboardHandler::Shutdown()
{
  return (0);
}


void  CKeyboardHandler::OnKeyDown(int iVirtKey, bool bAlt)
{
  m_KeyStates[iVirtKey].m_bActualyPressed=true;
}

void  CKeyboardHandler::OnKeyUp(int iVirtKey, bool bAlt)
{
  m_KeyStates[iVirtKey].m_bActualyPressed=false;
  m_KeyStates[iVirtKey].m_uTimesPressed=1;
}

int CKeyboardHandler::Reset()
{
  memset(m_KeyStates, 0, sizeof(TKeyState)*256); 
  return (0);
}

int CKeyboardHandler::IsDown(int iVirtKey)
{
  if (m_KeyStates[iVirtKey].m_bActualyPressed)
  {
    return (1);
  }

  return  (0);
}

int CKeyboardHandler::IsPressed(int iVirtKey)
{
  if (m_KeyStates[iVirtKey].m_uTimesPressed)      
  {
    m_KeyStates[iVirtKey].m_uTimesPressed=0;
    return (1);
  }

  return  (0);
}
