#include "SM_SysPch.h"
#include "MVFSZip.h"

// Nombre      : 
// Parametros  : 
// Retorno     : 
// Descripcion : 
int MVFSFILEZip::fopen     (const char* pcFileName, const char* pcFileAttrib)
{
  unz_file_info finfo;

  if (unzGetCurrentFileInfo(
               m_zipFile,
					     &finfo,
					     NULL,
					     0,
					     NULL,
					     0,
					     NULL,
					     0)!=UNZ_OK)
  {
    return (-1);
  }

  if (unzOpenCurrentFile(m_zipFile)!=UNZ_OK)
  {
    return (-1);
  }
  m_iPosition=0;
  m_iLength  =finfo.uncompressed_size;

  return (0);
}

// Nombre      : 
// Parametros  : 
// Retorno     : 
// Descripcion : 
int      MVFSFILEZip::fclose()
{
  unzCloseCurrentFile(m_zipFile);
  unzClose           (m_zipFile);		
  return (0);
}

// Nombre      : 
// Parametros  : 
// Retorno     : 
// Descripcion : 
unsigned MVFSFILEZip::fread     (void * pvDest, size_t uItemSize, size_t uItem)
{
  int iRead=unzReadCurrentFile( m_zipFile, pvDest, uItemSize*uItem);
  if (iRead<0)
  {
    return (0);
  }
  else
  {
    m_iPosition+=iRead;
    return (iRead/uItemSize);
  }  
}

// Nombre      : 
// Parametros  : 
// Retorno     : 
// Descripcion : 
unsigned MVFSFILEZip::fwrite    (void * pvSrc,  size_t uItemSize, size_t uItem)
{
  assert(0);
  return (-1);
}

// Nombre      : 
// Parametros  : 
// Retorno     : 
// Descripcion : 
int MVFSFILEZip::ftell()
{
  return (m_iPosition);
}

// Nombre      : 
// Parametros  : 
// Retorno     : 
// Descripcion : 
int MVFSFILEZip::fseek(long lDisplace, int iRelative)
{
  int iNewPosition;

  switch (iRelative)
  {
  case SEEK_SET:
    iNewPosition=lDisplace;
    break;
  case SEEK_CUR:
    iNewPosition=m_iPosition+lDisplace;
    break;
  case SEEK_END:
    iNewPosition=m_iLength+lDisplace;
    break;
  }

  assert(iNewPosition>=0 && iNewPosition<=m_iLength);

  char* pcDummy;
  pcDummy=new char[iNewPosition];
  if (!pcDummy)
  {
    assert(0);
    return(-1);
  }

  if (unzCloseCurrentFile(m_zipFile)!=UNZ_OK)
  {
    assert(0);
    delete[] pcDummy;
    return(-1);
  }

  if (unzOpenCurrentFile(m_zipFile)!=UNZ_OK)
  {
    assert(0);
    delete[] pcDummy;
    return(-1);
  }
  
  int iReturn=unzReadCurrentFile(m_zipFile, pcDummy, iNewPosition);
  delete[] pcDummy;

  m_iPosition=iReturn;
  
  return (iReturn==-1?-1:0);
}

// Nombre      : 
// Parametros  : 
// Retorno     : 
// Descripcion : 
int MVFSFILEZip::fprintf(const char* pcDString)
{
  assert(0);
  return (-1);
}

// Nombre      : 
// Parametros  : 
// Retorno     : 
// Descripcion : 
int MVFSFILEZip::fflush()
{
  return (0);
}

// Nombre      : 
// Parametros  : 
// Retorno     : 
// Descripcion : 
char* MVFSFILEZip::fgets(char* pcBuffer, int iBufferSize)
{
  char c;
  int iRead=0;

  while ( (fread(&c, 1, 1)==1) && c!='\r' && iRead<iBufferSize-1)
  {
    pcBuffer[iRead]=c;
    iRead++;
  }

  if (c=='\r' || iRead==iBufferSize-1)
  {
    if (c=='\r')
    {
      // Leemos \n
      fread(&c, 1, 1);
    }
    pcBuffer[iRead]='\0';
    return(pcBuffer);
  }

  return (NULL);
}

