#ifndef __MVFS

#define __MVFS

#include <stdio.h>

class MVFSFILE;

#define MVFSMAX_PATH 256

namespace MVFS
{
  enum eVFSType
  {
    E_NORMAL,
    E_ZIP,
    E_RESOURCE,
  };

  int __cdecl     Init(char* pcBase);
  int __cdecl     Shutdown();

  const char*     GetBaseDirectory();

  int             AddPackage      (eVFSType eType, char* pcBase);
  int             RemovePackage   (int iID);
    
  MVFSFILE*       fopen           (const char* pcFileName, const char* pcFileAttrib);
  int             fclose          (MVFSFILE* f);
  unsigned        fread           (void * pvDest, size_t uItemSize, size_t uItem , MVFSFILE* f);
  unsigned        fwrite          (void * pvSrc,  size_t uItemSize, size_t uItem , MVFSFILE* f);
  int             ftell           (MVFSFILE* f);
  int             fseek           (MVFSFILE* f, long lDisplace, int iRelative);
  int             fexists         (const char* pcFileName);
  int __cdecl     fprintf         (MVFSFILE* f, const char* pcDString, ...);
  int             fflush          (MVFSFILE* f);
  int             unlink          (const char* pcFileName);
  char*           fgets           (char* pcBuffer, int iBufferSize, MVFSFILE* f);

  int             findfilestart   (const char* pcPath, char* pcFilter);
  int             findfileget     (char* pcPath);
  int             findfileend     ();
};

#endif
