#ifndef __MBINARRAY

#define __MBINARRAY

template <class T>
class MBinArray
{
	public:
	MBinArray();
	~MBinArray();

  MBinArray& operator=(const MBinArray& ea);
										int					Add(const T& tData);
										T					Get(unsigned uIndex) const;	
										T*					GetP(unsigned uIndex) ;	
										unsigned			Used() const;
										int					Reset();
										T*					Get();


	protected:
										unsigned			m_uUsed;
										unsigned			m_uElements;
										T*					m_tElements;
};

// Nombre      : MBinArray<T>::MBinArray()
// Parametros  : No
// Retorno     : No
// Descripcion : Constructor de la clase
template <class T>
MBinArray<T>::MBinArray()
{
	m_uElements=1;
	m_tElements=new T[1];
  m_uUsed=0;
}

// Nombre      : MBinArray<T>::~MBinArray()
// Parametros  : No
// Retorno     : No
// Descripcion : Destructor de la clase
template <class T>
MBinArray<T>::~MBinArray()
{
  if (m_tElements) { delete[] m_tElements; m_tElements=0; }
}

// Nombre      : MBinArray<T>::Add()
// Parametros  : const T& tData
// Retorno     : 0: OK ; -1: ERROR
// Descripcion : Aade un elemento al array
template <class T>
int	MBinArray<T>::Add(const T& tData)
{
	if (m_uUsed<m_uElements)
	{
		m_tElements[m_uUsed]=tData;		
		return (m_uUsed++);
	}
	else
	{
			T* tAux;

			tAux=new T[m_uElements*2];
			if (!tAux)
			{
				return (-1);
			}

			unsigned i;
			for (i=0 ; i<m_uElements ; i++)
			{
				tAux[i]=m_tElements[i];
			}

			delete[] m_tElements;
			m_tElements=tAux;
			m_uElements*=2;
			
			return (Add(tData));		
	}
}

// Nombre      : MBinArray<T>::Get()
// Parametros  : unsigned uIndex
// Retorno     : T
// Descripcion : Devuelve el elemento de indice uIndex
template <class T>
T MBinArray<T>::Get(unsigned uIndex) const
{
	return (m_tElements[uIndex]);
}

// Nombre      :  MBinArray<T>::GetP()
// Parametros  : unsigned uIndex
// Retorno     : T*
// Descripcion : Devuelve el puntero al elemento de indice uIndex
template <class T>
T* MBinArray<T>::GetP(unsigned uIndex) 
{
	return (&m_tElements[uIndex]);
}

// Nombre      : MBinArray<T>::Used()
// Parametros  : no
// Retorno     : unsigned 
// Descripcion : Devuelve el numero de elementos usados en el array
template <class T>
unsigned MBinArray<T>::Used() const
{
	return (m_uUsed);
}

// Nombre      : MBinArray<T>::Reset()
// Parametros  : No
// Retorno     : 0
// Descripcion : Resetea el array
template <class T>
int	MBinArray<T>::Reset()
{
	m_uUsed=0;
	return (0);
}

// Nombre      : MBinArray<T>::Get()
// Parametros  : No
// Retorno     : T*
// Descripcion : Devuelve el puntero al array de elementosf
template <class T>
T*	MBinArray<T>::Get()
{
	return (m_tElements);
}

template <class T>
MBinArray<T>& MBinArray<T>::operator=(const MBinArray& ea)
{
  // Borramos origen
  delete[] m_tElements;
  
  m_tElements=new T[ea.m_uElements];
  m_uUsed=ea.m_uUsed;

  unsigned i;
  for(i=0 ; i<m_uUsed ; i++)
  {
    m_tElements[i]=ea.m_tElements[i];
  }

  return (*this);
}


#endif