#ifndef __MSURFACE

#define __MSURFACE

#include "MSurfaceDescriptor.h"
#include "MPalette.h"
#include "MVFS.h"

#define MAX_SURFACE_NAME_LENGTH  32

/*
  La clase MSurface tiene la funcionalidad necesaria para:

    - Cargar, Grabar imagenes
    - Soporta cualquier formato de pixel
    - Soporta masquerading de superficies ajenas (via Init())
    - Soporta BLTing (no acelerado)


  Notas

    - Paletas: hace tiempo que no se usan. No garantizo nada
    - Por motivos de velocidad se ha implementado la funcion GenerateMipMapChain()
      que tiene varios caminos rapidos para hacer los mipmaps e incluso da mas calidad
      que los ScaleAndConvertFrom (tiene dithering)

*/

struct MSurface
{
public:
												          MSurface                  ();
												          ~MSurface                 ();

					int							        Init								      (const MSurfaceDescriptor& sdSurfaceDescriptor,
																					                    void*		pvSurface,
																					                    MPalette*	pPalette,
																					                    char*		pcName="UNNAMED");

					int							        Shutdown							    ();
													 
					void*						        GetSurfacePointer					() const;
					void*						        GetSurfacePointer					(const int& x, const int& y) const;
					MPalette*					      GetPalette							  ();          

          int                     Modulate                  (float f);
          int                     ScaleFrom                 (MSurface& sSurface, int iWidth, int iHeight);
					int							        ScaleAndConvertFrom			  (MSurface& sSurface);	
          int                     Generate32To16MipMap      (MSurface& sARGB32Source);	
					int							        ConvertFrom							  (MSurface& sSurface);
          int                     GenerateMipMapChain       (MSurface* pSurfaces, unsigned uMips, bool bRenormalizeRGB = false);
					MSurfaceDescriptor			GetSurfaceDescriptor			();
					MSurfaceDescriptor*			GetPSurfaceDescriptor			();
          int                     SwapXY                    ();

          int                     SurfaceBlt                (MSurface& sSource, int xo, int yo, int xw, int yh, int xd, int yd);  

					int				        			LoadARGB32_TGA			    	(MVFSFILE* f, bool bUseAlpha);
					int				        			LoadARGB32_TGA			    	(char* pcFileName, bool bUseAlpha);
          int				        			SaveARGB32_TGA			    	(char* pcFileName);          
					int				        			LoadBMP			    	        (MVFSFILE* f);
					int				        			LoadBMP			    	        (char* pcFileName);
          int                     SaveBMP                   (char* pcFileName);

          int                     LoadJPG                   (char* pcFileName);
          int                     SaveJPG                   (char* pcFileName, int iQuality=50);
          int                     LoadJPG                   (MVFSFILE* f);
          int                     SaveJPG                   (MVFSFILE* f, int iQuality=50);
          int                     Load                      (char* pcFileName, bool bRGBAlpha=false);
          int                     Save                      (char* pcFileName);
                                                                                                                    
					                                                
					char*			        			GetName							    	();
					int				        			SetName							    	(char* pcName);
                                                          
					int				        			WriteRaw						    	(char* pcFileName);
					int				        			ReadRaw							    	(char* pcFileName);
					int				        			WriteRaw						    	(MVFSFILE* f);
					int				        			ReadRaw							    	(MVFSFILE* f);
					int				        			ReadInitializedRaw	    	(char* pcFileName);
					int				        			ReadInitializedRaw	    	(MVFSFILE* f);

          MSurface&               operator=                 (const MSurface& sSurface);
                                  MSurface                  (const MSurface& sSurface);
					
protected:
          int                     Convert32To16             (MSurface& sSurface);
          int                     Convert24To16             (MSurface& sSurface);
          int                     Convert32To32             (MSurface& sSurface);
          int                     Convert24To32             (MSurface& sSurface);



					char						                                  m_pcName[MAX_SURFACE_NAME_LENGTH];
					MSurfaceDescriptor	                              m_sdSurfaceDescriptor;
					bool					                                  	m_bLocalSurfaceAllocation;
					bool					                                  	m_bLocalPaletteAllocation;
					bool					                                  	m_bValid;					
					void*					                                  	m_pvSurface;
					MPalette*			                                  	m_pPalette;					
};                                                        

#endif
