#ifndef __SM_MUSIC

#define __SM_MUSIC

namespace SM_Music
{
  class IEventHandler
  {
  public:
    virtual void  Notify(int iPos, int iRow)=0;    
  };

  int     Init            (HWND hwnd);
  int     Shutdown        ();

  int     MP3Load           (char* pcMP3  , int iLength);
  int     MP3Play           ();
  int     MP3PlayEx         (float fTime);
  int     MP3Free           ();
  int     MP3Stop           ();
  float   MP3Time           ();
  
  
  int     Load            (char* pcMusic, int iLength);
  int     Free            ();
  int     Play            (bool bLoop=false);
  int     PlayEx          (int iPos, int iRow, bool bLoop=false);
  int     Pause           ();
  int     Stop            ();
  int     SetVol          (int iVolume);  // 0<=iVolume<=100
  
  int     SetEventHandler (IEventHandler* pEventHandler); // 0 desactiva actual
}


#endif