#include "SM_MathPCH.h"

Matrix4X4 Matrix4X4::Identity={1.0f, 0.0f, 0.0f, 0.0f,
                               0.0f, 1.0f, 0.0f, 0.0f,
                               0.0f, 0.0f, 1.0f, 0.0f,
                               0.0f, 0.0f, 0.0f, 1.0f};

Matrix4X4* Matrix4X4::Mult(Matrix4X4* pD, const Matrix4X4* pA, const Matrix4X4* pB)
{
  pD->m_11=pA->m_11*pB->m_11 + pA->m_12*pB->m_21 + pA->m_13*pB->m_31 + pA->m_14*pB->m_41;
	pD->m_12=pA->m_11*pB->m_12 + pA->m_12*pB->m_22 + pA->m_13*pB->m_32 + pA->m_14*pB->m_42;
	pD->m_13=pA->m_11*pB->m_13 + pA->m_12*pB->m_23 + pA->m_13*pB->m_33 + pA->m_14*pB->m_43;
	pD->m_14=pA->m_11*pB->m_14 + pA->m_12*pB->m_24 + pA->m_13*pB->m_34 + pA->m_14*pB->m_44;

	pD->m_21=pA->m_21*pB->m_11 + pA->m_22*pB->m_21 + pA->m_23*pB->m_31 + pA->m_24*pB->m_41;
	pD->m_22=pA->m_21*pB->m_12 + pA->m_22*pB->m_22 + pA->m_23*pB->m_32 + pA->m_24*pB->m_42;
	pD->m_23=pA->m_21*pB->m_13 + pA->m_22*pB->m_23 + pA->m_23*pB->m_33 + pA->m_24*pB->m_43;
	pD->m_24=pA->m_21*pB->m_14 + pA->m_22*pB->m_24 + pA->m_23*pB->m_34 + pA->m_24*pB->m_44;

	pD->m_31=pA->m_31*pB->m_11 + pA->m_32*pB->m_21 + pA->m_33*pB->m_31 + pA->m_34*pB->m_41;
	pD->m_32=pA->m_31*pB->m_12 + pA->m_32*pB->m_22 + pA->m_33*pB->m_32 + pA->m_34*pB->m_42;
	pD->m_33=pA->m_31*pB->m_13 + pA->m_32*pB->m_23 + pA->m_33*pB->m_33 + pA->m_34*pB->m_43;
	pD->m_34=pA->m_31*pB->m_14 + pA->m_32*pB->m_24 + pA->m_33*pB->m_34 + pA->m_34*pB->m_44;

	pD->m_41=pA->m_41*pB->m_11 + pA->m_42*pB->m_21 + pA->m_43*pB->m_31 + pA->m_44*pB->m_41;
	pD->m_42=pA->m_41*pB->m_12 + pA->m_42*pB->m_22 + pA->m_43*pB->m_32 + pA->m_44*pB->m_42;
	pD->m_43=pA->m_41*pB->m_13 + pA->m_42*pB->m_23 + pA->m_43*pB->m_33 + pA->m_44*pB->m_43;
	pD->m_44=pA->m_41*pB->m_14 + pA->m_42*pB->m_24 + pA->m_43*pB->m_34 + pA->m_44*pB->m_44;

  return (pD);
}
  

Vector3D*  Matrix4X4::Transform(Vector3D* pD, const Vector3D* pS, unsigned iVectors)
{
  unsigned i;

  for (i=0 ; i<iVectors ; ++i)
  {
    float oow=1.0f/(m_14*pS[i].x+m_24*pS[i].y+m_34*pS[i].z+m_44);
    pD[i].x=(m_11*pS[i].x+m_21*pS[i].y+m_31*pS[i].z+m_41 )*oow;
    pD[i].y=(m_12*pS[i].x+m_22*pS[i].y+m_32*pS[i].z+m_42 )*oow;
    pD[i].z=(m_13*pS[i].x+m_23*pS[i].y+m_33*pS[i].z+m_43 )*oow;    
  }

  return pD;
}

Vector4D*  Matrix4X4::Transform4D(Vector4D* pD, const Vector4D* pS, unsigned iVectors)
{
  unsigned i;

  for (i=0 ; i<iVectors ; ++i)
  {
    pD[i].x=(m_11*pS[i].x+m_21*pS[i].y+m_31*pS[i].z+m_41 );
    pD[i].y=(m_12*pS[i].x+m_22*pS[i].y+m_32*pS[i].z+m_42 );
    pD[i].z=(m_13*pS[i].x+m_23*pS[i].y+m_33*pS[i].z+m_43 );    
    pD[i].w=(m_14*pS[i].x+m_24*pS[i].y+m_34*pS[i].z+m_44 );    
  }

  return pD;
}

Vector3D*  Matrix4X4::RotTransform(Vector3D* pD, const Vector3D* pS, unsigned iVectors)
{
  unsigned i;

  for (i=0 ; i<iVectors ; ++i)
  {
    pD[i].x=(m_11*pS[i].x+m_21*pS[i].y+m_31*pS[i].z );
    pD[i].y=(m_12*pS[i].x+m_22*pS[i].y+m_32*pS[i].z );
    pD[i].z=(m_13*pS[i].x+m_23*pS[i].y+m_33*pS[i].z );    
  }

  return pD;
}

Vector3D*  Matrix4X4::InverseRotTransform(Vector3D* pD, const Vector3D* pS, unsigned iVectors)
{
  unsigned i;

  for (i=0 ; i<iVectors ; ++i)
  {
    pD[i].x=(m_11*pS[i].x+m_12*pS[i].y+m_13*pS[i].z );
    pD[i].y=(m_21*pS[i].x+m_22*pS[i].y+m_23*pS[i].z );
    pD[i].z=(m_31*pS[i].x+m_32*pS[i].y+m_33*pS[i].z );    
  }

  return pD;
}

Matrix4X4* Matrix4X4::InvertAs4X3(Matrix4X4* pD)
{
  pD->m_11=m_11; pD->m_12=m_21; pD->m_13=m_31; pD->m_14=0.0f;
	pD->m_21=m_12; pD->m_22=m_22; pD->m_23=m_32; pD->m_24=0.0f;
	pD->m_31=m_13; pD->m_32=m_23; pD->m_33=m_33; pD->m_34=0.0f;

  pD->m_41=-(m_11*m_41+m_12*m_42+m_13*m_43);
	pD->m_42=-(m_21*m_41+m_22*m_42+m_23*m_43);
	pD->m_43=-(m_31*m_42+m_32*m_42+m_33*m_43);
  pD->m_44=1.0f;

  

  return pD;
}
	

void Matrix4X4::SetScale(float x, float y, float z)
{
  m_11 = x   , m_12 = 0.0f, m_13 = 0.0f, m_14 = 0.0f,
  m_21 = 0.0f, m_22 = y   , m_23 = 0.0f, m_24 = 0.0f,
  m_31 = 0.0f, m_32 = 0.0f, m_33 = z   , m_34 = 0.0f,
  m_41 = 0.0f, m_42 = 0.0f, m_43 = 0.0f, m_44 = 1.0f;
}

void Matrix4X4::LookAt(const Vector3D& pos, const Vector3D& at, const Vector3D& up)
{
  Vector3D zaxis = at - pos; zaxis.Normalize();
  Vector3D xaxis = Vector3D::Cross(up, zaxis); xaxis.Normalize();
  Vector3D yaxis = Vector3D::Cross(zaxis, xaxis);
  
  m_11 = xaxis.x, m_12 = yaxis.x, m_13 = zaxis.x, m_14 = 0.0f,
  m_21 = xaxis.y, m_22 = yaxis.y, m_23 = zaxis.y, m_24 = 0.0f,
  m_31 = xaxis.z, m_32 = yaxis.z, m_33 = zaxis.z, m_34 = 0.0f,
  m_41 = -xaxis.Dot(pos), m_42 = -yaxis.Dot(pos), m_43 = -zaxis.Dot(pos), m_44 = 1.0f;
}


