#ifndef __VERTEXSHADERS

#define __VERTEXSHADERS

#include "SM_Shader.h"
#include "SM_Slider.h"


struct FVF_PosNormalDiffuseTex1;
struct Matrix4X4;



class     VertexShader
{
public:
                VertexShader   ()
                {
                }

  virtual       ~VertexShader  ()
                {
                  Shutdown();
                }

  virtual int   Init           ()
  {
    return 0;
  }

  virtual int   Shutdown       ()
  {
    return 0;
  }
  virtual void  ProcessVertices(FVF_PosNormalDiffuseTex1* pDst, FVF_PosNormalDiffuseTex1* pSrc, unsigned uVertices, unsigned short* pusIndices, unsigned uIndices, Matrix4X4* pWorldTransform)=0;
};

class  WaveController 
{
public:
  LinearSlider m_ExpSlider;
};

class  NoiseNormalShader : public VertexShader, public WaveController 
{  
public:
  int   Init();
  int   Shutdown();
  void  ProcessVertices(FVF_PosNormalDiffuseTex1* pDst, FVF_PosNormalDiffuseTex1* pSrc, unsigned uVertices, unsigned short* pusIndices, unsigned uIndices, Matrix4X4* pWorldTransform);  
};

class  NoiseXYZShader : public VertexShader, public WaveController 
{  
public:
  int   Init();
  int   Shutdown();
  void  ProcessVertices(FVF_PosNormalDiffuseTex1* pDst, FVF_PosNormalDiffuseTex1* pSrc, unsigned uVertices, unsigned short* pusIndices, unsigned uIndices, Matrix4X4* pWorldTransform);

  float m_fAmplitudeX, m_fAmplitudeY, m_fAmplitudeZ, m_fSpaceFrequency, m_fTimeFrequency;
};

class  TwistShader : public VertexShader, public WaveController 
{  
public:
  int   Init();
  int   Shutdown();
  void  ProcessVertices(FVF_PosNormalDiffuseTex1* pDst, FVF_PosNormalDiffuseTex1* pSrc, unsigned uVertices, unsigned short* pusIndices, unsigned uIndices, Matrix4X4* pWorldTransform);
};




extern NoiseNormalShader    TheNormalNoiseShader;
extern NoiseXYZShader       TheNoiseXYZShader;
extern TwistShader          TheTwistShader;




int   InitVertexShaders    ();
int   ShutdownVertexShaders();

#endif
