#ifndef SPIKETUBE
#define SPIKETUBE

// yes, very ugly i need to fix this
#include "..\..\..\demosystem\sm_commonfx\source\fxmesh.h"  
const float c_pi = 3.1415926535897932384626433f;
const float c_2pi = 3.1415926535897932384626433f*2.0f;

class SM_SpikeTube : public IRenderable
{
	int 				m_shader;
	IKFAnimable*		m_pAnimable;

	FXMesh	m_mesh;
	int		m_numPerSide;
	int		m_n;
	int		m_numCells;
	int		m_numRings;
	int		m_numSegments;
	int		m_res;
	float	m_segRadius;
	float	m_spikeSize;
	int		m_maxSegs;

	float m_camX;		// min x coord of cam window
	float m_camVel;		// speed of cam in units/sec
	float m_camHeight;


public:

	SM_SpikeTube()
		: m_shader(-1)
		, m_pAnimable(0)
		, m_numCells(8)
		, m_numRings(7)
		, m_segRadius(10)
		, m_spikeSize(10)
		, m_numSegments(11)
		, m_n(1)
		, m_camX(0)
		, m_camVel(24)
		, m_camHeight(10)
		, m_maxSegs(30)
	{
		m_numPerSide = 2*m_n+1;
		m_res = 4*m_numPerSide-4;
	}

    int 	Init				(int iShader, IKFAnimable* pAnimable);
    int     Shutdown			() {}
    int     Reset				() {}
	virtual void Render(RenderContext* pRenderContext, int iOutcode, float time);


	Vector3D			m_v3dPosition;
	Quaternion			m_qRotation;
  float         m_fStartTime;
private:
	void UpdateMesh(RenderContext* prc, float time);
	void MakeAddNormal(int i0, int i1, int i2);
	void AddSegRing(float x, float w, float time);
	void AddColumnsForRing(float x, float w, int ofs, float time);
	void AddCell2(float a0, float a1, float midX, float time);
	void BuildSkeleton(RenderContext* prc, float time);
	void BuildIndices2();

	inline int GetOfs(int seg) { return (seg%2)*(m_numPerSide/2); } 

	inline float GetRadius(float x, float time) 
	{ 
		//return .8f*((.3f+.7f*(sin(x*.165f+time*c_pi)*.5f+.5f)) + .4f* (sin((x+time)*.23432f+time*.12312f)+1.0f)+.2f*(sin(x*.0224f+time*.012312f)+1)  )*m_segRadius; 
		//return m_segRadius * (.1f+.9f*(3.0f+(sin(x*.165f+time*c_pi) + sin(time*.6234234f) + sin(x*0.085f+time*c_pi*2.0f)))/6.0f);
		//return m_segRadius*(.2f+.6f*((.3f+.7f*(sin(x*.165f+time*c_pi)*.5f+.5f)) + .15f* (sin((x+time)*.23432f+time*.12312f)+1.0f)+.2f*(sin(x*.0224f+time*.012312f)+1)  )); 
		//return m_segRadius * (.2f+.8f*(2.0f+( 1.2*sin(x*.165f+time*c_pi) + .8*sin(x*.165f+time*c_pi*.5f) ))*.25f);
		//return m_segRadius * GetSpikeScale(x, time);
		return m_segRadius*(.75f*(.2f+.8f*(2.0f+( 1.4*sin(x*.165f+time*c_pi) + .8*sin(x*.265f+time*c_pi*.4215f) ))*.25f) + .25f*(.6f*(sin(x*.13434f)+1)));
	}

	inline float GetSpikeScale(float x, float time) 
	{ 
		//float t = (cos(time*.12f+cos(time*.21212f))+cos(time*1.182123f))*.25f+.5f;
		//float t = 1;//.9f + .1f*(sin(time*1.1212f)+sin(time*2.1313f));
		//if (time < 3) t *= (time/3);
		//return t*t; 
		
		//return (.2f+.8f*(2.0f+( 1.2*sin(x*.165f+time*c_pi) + .8*sin(x*.165f+time*c_pi*.5f) ))*.25f);
		//return .75f*(.2f+.8f*(2.0f+( 1.2*sin(x*.165f+time*c_pi) + .8*sin(x*.165f+time*c_pi*.5f) ))*.25f) + .25f*(.5f*(sin(x*.23434f)+1));
		float t = GetRadius(x, time) / m_segRadius;
		return t*t;
	}
};

#endif 


