#ifndef __SM_RENDERCONTEXT

#define __SM_RENDERCONTEXT


#include "SM_Viewport.h"
#include "SM_Plane.h"



class RenderContext
{
public:
                  RenderContext();
  
  void            Set (const    Vector3D&   v3dPosition, 
                       const    Quaternion& qRotation,
                       float    fFOV,
                       float    fAspectRatio,
                       float    fZNear,
                       float    fZFar);

  void            Set (const    Vector3D&   pos, 
                       const    Vector3D&   at, 
                       const    Vector3D&   up, 
                       float    fFOV,
                       float    fAspectRatio,
                       float    fZNear,
                       float    fZFar);


  void            SetViewport               (float x, float y, float w, float h);               

  void            SyncRasterizer            ();
  void            UpdateFrustum             ();

  int             OutcodeSphere(Vector3D* pVector3D, float fRadius);

  const Viewport* GetViewport()
  {
    return &m_Viewport3D;
  }

  Vector3D  m_VPN;
  Vector3D  m_VRP;
  Vector3D  m_VUP;
protected:
  Viewport  m_Viewport3D;
  Plane     m_Planes[6];
  float     m_x;
  float     m_y;
  float     m_w;
  float     m_h;
};


#endif
