#include "SM_Engine3DPCH.h"
#include "SM_Metaballs.h"


namespace SM_Metaballs 
{


struct GRIDCELL
{
   float*    f[8];
};



#define     MAX_BATCH 60000



int s_edgeTable[256]=
{
  0x0  , 0x109, 0x203, 0x30a, 0x406, 0x50f, 0x605, 0x70c,
  0x80c, 0x905, 0xa0f, 0xb06, 0xc0a, 0xd03, 0xe09, 0xf00,
  0x190, 0x99 , 0x393, 0x29a, 0x596, 0x49f, 0x795, 0x69c,
  0x99c, 0x895, 0xb9f, 0xa96, 0xd9a, 0xc93, 0xf99, 0xe90,
  0x230, 0x339, 0x33 , 0x13a, 0x636, 0x73f, 0x435, 0x53c,
  0xa3c, 0xb35, 0x83f, 0x936, 0xe3a, 0xf33, 0xc39, 0xd30,
  0x3a0, 0x2a9, 0x1a3, 0xaa , 0x7a6, 0x6af, 0x5a5, 0x4ac,
  0xbac, 0xaa5, 0x9af, 0x8a6, 0xfaa, 0xea3, 0xda9, 0xca0,
  0x460, 0x569, 0x663, 0x76a, 0x66 , 0x16f, 0x265, 0x36c,
  0xc6c, 0xd65, 0xe6f, 0xf66, 0x86a, 0x963, 0xa69, 0xb60,
  0x5f0, 0x4f9, 0x7f3, 0x6fa, 0x1f6, 0xff , 0x3f5, 0x2fc,
  0xdfc, 0xcf5, 0xfff, 0xef6, 0x9fa, 0x8f3, 0xbf9, 0xaf0,
  0x650, 0x759, 0x453, 0x55a, 0x256, 0x35f, 0x55 , 0x15c,
  0xe5c, 0xf55, 0xc5f, 0xd56, 0xa5a, 0xb53, 0x859, 0x950,
  0x7c0, 0x6c9, 0x5c3, 0x4ca, 0x3c6, 0x2cf, 0x1c5, 0xcc ,
  0xfcc, 0xec5, 0xdcf, 0xcc6, 0xbca, 0xac3, 0x9c9, 0x8c0,
  0x8c0, 0x9c9, 0xac3, 0xbca, 0xcc6, 0xdcf, 0xec5, 0xfcc,
  0xcc , 0x1c5, 0x2cf, 0x3c6, 0x4ca, 0x5c3, 0x6c9, 0x7c0,
  0x950, 0x859, 0xb53, 0xa5a, 0xd56, 0xc5f, 0xf55, 0xe5c,
  0x15c, 0x55 , 0x35f, 0x256, 0x55a, 0x453, 0x759, 0x650,
  0xaf0, 0xbf9, 0x8f3, 0x9fa, 0xef6, 0xfff, 0xcf5, 0xdfc,
  0x2fc, 0x3f5, 0xff , 0x1f6, 0x6fa, 0x7f3, 0x4f9, 0x5f0,
  0xb60, 0xa69, 0x963, 0x86a, 0xf66, 0xe6f, 0xd65, 0xc6c,
  0x36c, 0x265, 0x16f, 0x66 , 0x76a, 0x663, 0x569, 0x460,
  0xca0, 0xda9, 0xea3, 0xfaa, 0x8a6, 0x9af, 0xaa5, 0xbac,
  0x4ac, 0x5a5, 0x6af, 0x7a6, 0xaa , 0x1a3, 0x2a9, 0x3a0,
  0xd30, 0xc39, 0xf33, 0xe3a, 0x936, 0x83f, 0xb35, 0xa3c,
  0x53c, 0x435, 0x73f, 0x636, 0x13a, 0x33 , 0x339, 0x230,
  0xe90, 0xf99, 0xc93, 0xd9a, 0xa96, 0xb9f, 0x895, 0x99c,
  0x69c, 0x795, 0x49f, 0x596, 0x29a, 0x393, 0x99 , 0x190,
  0xf00, 0xe09, 0xd03, 0xc0a, 0xb06, 0xa0f, 0x905, 0x80c,
  0x70c, 0x605, 0x50f, 0x406, 0x30a, 0x203, 0x109, 0x0   
};

static int s_TriTable[256][16] =
{
  {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 8, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 1, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {1, 8, 3, 9, 8, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {1, 2, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 8, 3, 1, 2, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {9, 2, 10, 0, 2, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {2, 8, 3, 2, 10, 8, 10, 9, 8, -1, -1, -1, -1, -1, -1, -1},
  {3, 11, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 11, 2, 8, 11, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {1, 9, 0, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {1, 11, 2, 1, 9, 11, 9, 8, 11, -1, -1, -1, -1, -1, -1, -1},
  {3, 10, 1, 11, 10, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 10, 1, 0, 8, 10, 8, 11, 10, -1, -1, -1, -1, -1, -1, -1},
  {3, 9, 0, 3, 11, 9, 11, 10, 9, -1, -1, -1, -1, -1, -1, -1},
  {9, 8, 10, 10, 8, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {4, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {4, 3, 0, 7, 3, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 1, 9, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {4, 1, 9, 4, 7, 1, 7, 3, 1, -1, -1, -1, -1, -1, -1, -1},
  {1, 2, 10, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {3, 4, 7, 3, 0, 4, 1, 2, 10, -1, -1, -1, -1, -1, -1, -1},
  {9, 2, 10, 9, 0, 2, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1},
  {2, 10, 9, 2, 9, 7, 2, 7, 3, 7, 9, 4, -1, -1, -1, -1},
  {8, 4, 7, 3, 11, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {11, 4, 7, 11, 2, 4, 2, 0, 4, -1, -1, -1, -1, -1, -1, -1},
  {9, 0, 1, 8, 4, 7, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1},
  {4, 7, 11, 9, 4, 11, 9, 11, 2, 9, 2, 1, -1, -1, -1, -1},
  {3, 10, 1, 3, 11, 10, 7, 8, 4, -1, -1, -1, -1, -1, -1, -1},
  {1, 11, 10, 1, 4, 11, 1, 0, 4, 7, 11, 4, -1, -1, -1, -1},
  {4, 7, 8, 9, 0, 11, 9, 11, 10, 11, 0, 3, -1, -1, -1, -1},
  {4, 7, 11, 4, 11, 9, 9, 11, 10, -1, -1, -1, -1, -1, -1, -1},
  {9, 5, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {9, 5, 4, 0, 8, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 5, 4, 1, 5, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {8, 5, 4, 8, 3, 5, 3, 1, 5, -1, -1, -1, -1, -1, -1, -1},
  {1, 2, 10, 9, 5, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {3, 0, 8, 1, 2, 10, 4, 9, 5, -1, -1, -1, -1, -1, -1, -1},
  {5, 2, 10, 5, 4, 2, 4, 0, 2, -1, -1, -1, -1, -1, -1, -1},
  {2, 10, 5, 3, 2, 5, 3, 5, 4, 3, 4, 8, -1, -1, -1, -1},
  {9, 5, 4, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 11, 2, 0, 8, 11, 4, 9, 5, -1, -1, -1, -1, -1, -1, -1},
  {0, 5, 4, 0, 1, 5, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1},
  {2, 1, 5, 2, 5, 8, 2, 8, 11, 4, 8, 5, -1, -1, -1, -1},
  {10, 3, 11, 10, 1, 3, 9, 5, 4, -1, -1, -1, -1, -1, -1, -1},
  {4, 9, 5, 0, 8, 1, 8, 10, 1, 8, 11, 10, -1, -1, -1, -1},
  {5, 4, 0, 5, 0, 11, 5, 11, 10, 11, 0, 3, -1, -1, -1, -1},
  {5, 4, 8, 5, 8, 10, 10, 8, 11, -1, -1, -1, -1, -1, -1, -1},
  {9, 7, 8, 5, 7, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {9, 3, 0, 9, 5, 3, 5, 7, 3, -1, -1, -1, -1, -1, -1, -1},
  {0, 7, 8, 0, 1, 7, 1, 5, 7, -1, -1, -1, -1, -1, -1, -1},
  {1, 5, 3, 3, 5, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {9, 7, 8, 9, 5, 7, 10, 1, 2, -1, -1, -1, -1, -1, -1, -1},
  {10, 1, 2, 9, 5, 0, 5, 3, 0, 5, 7, 3, -1, -1, -1, -1},
  {8, 0, 2, 8, 2, 5, 8, 5, 7, 10, 5, 2, -1, -1, -1, -1},
  {2, 10, 5, 2, 5, 3, 3, 5, 7, -1, -1, -1, -1, -1, -1, -1},
  {7, 9, 5, 7, 8, 9, 3, 11, 2, -1, -1, -1, -1, -1, -1, -1},
  {9, 5, 7, 9, 7, 2, 9, 2, 0, 2, 7, 11, -1, -1, -1, -1},
  {2, 3, 11, 0, 1, 8, 1, 7, 8, 1, 5, 7, -1, -1, -1, -1},
  {11, 2, 1, 11, 1, 7, 7, 1, 5, -1, -1, -1, -1, -1, -1, -1},
  {9, 5, 8, 8, 5, 7, 10, 1, 3, 10, 3, 11, -1, -1, -1, -1},
  {5, 7, 0, 5, 0, 9, 7, 11, 0, 1, 0, 10, 11, 10, 0, -1},
  {11, 10, 0, 11, 0, 3, 10, 5, 0, 8, 0, 7, 5, 7, 0, -1},
  {11, 10, 5, 7, 11, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {10, 6, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 8, 3, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {9, 0, 1, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {1, 8, 3, 1, 9, 8, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1},
  {1, 6, 5, 2, 6, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {1, 6, 5, 1, 2, 6, 3, 0, 8, -1, -1, -1, -1, -1, -1, -1},
  {9, 6, 5, 9, 0, 6, 0, 2, 6, -1, -1, -1, -1, -1, -1, -1},
  {5, 9, 8, 5, 8, 2, 5, 2, 6, 3, 2, 8, -1, -1, -1, -1},
  {2, 3, 11, 10, 6, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {11, 0, 8, 11, 2, 0, 10, 6, 5, -1, -1, -1, -1, -1, -1, -1},
  {0, 1, 9, 2, 3, 11, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1},
  {5, 10, 6, 1, 9, 2, 9, 11, 2, 9, 8, 11, -1, -1, -1, -1},
  {6, 3, 11, 6, 5, 3, 5, 1, 3, -1, -1, -1, -1, -1, -1, -1},
  {0, 8, 11, 0, 11, 5, 0, 5, 1, 5, 11, 6, -1, -1, -1, -1},
  {3, 11, 6, 0, 3, 6, 0, 6, 5, 0, 5, 9, -1, -1, -1, -1},
  {6, 5, 9, 6, 9, 11, 11, 9, 8, -1, -1, -1, -1, -1, -1, -1},
  {5, 10, 6, 4, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {4, 3, 0, 4, 7, 3, 6, 5, 10, -1, -1, -1, -1, -1, -1, -1},
  {1, 9, 0, 5, 10, 6, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1},
  {10, 6, 5, 1, 9, 7, 1, 7, 3, 7, 9, 4, -1, -1, -1, -1},
  {6, 1, 2, 6, 5, 1, 4, 7, 8, -1, -1, -1, -1, -1, -1, -1},
  {1, 2, 5, 5, 2, 6, 3, 0, 4, 3, 4, 7, -1, -1, -1, -1},
  {8, 4, 7, 9, 0, 5, 0, 6, 5, 0, 2, 6, -1, -1, -1, -1},
  {7, 3, 9, 7, 9, 4, 3, 2, 9, 5, 9, 6, 2, 6, 9, -1},
  {3, 11, 2, 7, 8, 4, 10, 6, 5, -1, -1, -1, -1, -1, -1, -1},
  {5, 10, 6, 4, 7, 2, 4, 2, 0, 2, 7, 11, -1, -1, -1, -1},
  {0, 1, 9, 4, 7, 8, 2, 3, 11, 5, 10, 6, -1, -1, -1, -1},
  {9, 2, 1, 9, 11, 2, 9, 4, 11, 7, 11, 4, 5, 10, 6, -1},
  {8, 4, 7, 3, 11, 5, 3, 5, 1, 5, 11, 6, -1, -1, -1, -1},
  {5, 1, 11, 5, 11, 6, 1, 0, 11, 7, 11, 4, 0, 4, 11, -1},
  {0, 5, 9, 0, 6, 5, 0, 3, 6, 11, 6, 3, 8, 4, 7, -1},
  {6, 5, 9, 6, 9, 11, 4, 7, 9, 7, 11, 9, -1, -1, -1, -1},
  {10, 4, 9, 6, 4, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {4, 10, 6, 4, 9, 10, 0, 8, 3, -1, -1, -1, -1, -1, -1, -1},
  {10, 0, 1, 10, 6, 0, 6, 4, 0, -1, -1, -1, -1, -1, -1, -1},
  {8, 3, 1, 8, 1, 6, 8, 6, 4, 6, 1, 10, -1, -1, -1, -1},
  {1, 4, 9, 1, 2, 4, 2, 6, 4, -1, -1, -1, -1, -1, -1, -1},
  {3, 0, 8, 1, 2, 9, 2, 4, 9, 2, 6, 4, -1, -1, -1, -1},
  {0, 2, 4, 4, 2, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {8, 3, 2, 8, 2, 4, 4, 2, 6, -1, -1, -1, -1, -1, -1, -1},
  {10, 4, 9, 10, 6, 4, 11, 2, 3, -1, -1, -1, -1, -1, -1, -1},
  {0, 8, 2, 2, 8, 11, 4, 9, 10, 4, 10, 6, -1, -1, -1, -1},
  {3, 11, 2, 0, 1, 6, 0, 6, 4, 6, 1, 10, -1, -1, -1, -1},
  {6, 4, 1, 6, 1, 10, 4, 8, 1, 2, 1, 11, 8, 11, 1, -1},
  {9, 6, 4, 9, 3, 6, 9, 1, 3, 11, 6, 3, -1, -1, -1, -1},
  {8, 11, 1, 8, 1, 0, 11, 6, 1, 9, 1, 4, 6, 4, 1, -1},
  {3, 11, 6, 3, 6, 0, 0, 6, 4, -1, -1, -1, -1, -1, -1, -1},
  {6, 4, 8, 11, 6, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {7, 10, 6, 7, 8, 10, 8, 9, 10, -1, -1, -1, -1, -1, -1, -1},
  {0, 7, 3, 0, 10, 7, 0, 9, 10, 6, 7, 10, -1, -1, -1, -1},
  {10, 6, 7, 1, 10, 7, 1, 7, 8, 1, 8, 0, -1, -1, -1, -1},
  {10, 6, 7, 10, 7, 1, 1, 7, 3, -1, -1, -1, -1, -1, -1, -1},
  {1, 2, 6, 1, 6, 8, 1, 8, 9, 8, 6, 7, -1, -1, -1, -1},
  {2, 6, 9, 2, 9, 1, 6, 7, 9, 0, 9, 3, 7, 3, 9, -1},
  {7, 8, 0, 7, 0, 6, 6, 0, 2, -1, -1, -1, -1, -1, -1, -1},
  {7, 3, 2, 6, 7, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {2, 3, 11, 10, 6, 8, 10, 8, 9, 8, 6, 7, -1, -1, -1, -1},
  {2, 0, 7, 2, 7, 11, 0, 9, 7, 6, 7, 10, 9, 10, 7, -1},
  {1, 8, 0, 1, 7, 8, 1, 10, 7, 6, 7, 10, 2, 3, 11, -1},
  {11, 2, 1, 11, 1, 7, 10, 6, 1, 6, 7, 1, -1, -1, -1, -1},
  {8, 9, 6, 8, 6, 7, 9, 1, 6, 11, 6, 3, 1, 3, 6, -1},
  {0, 9, 1, 11, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {7, 8, 0, 7, 0, 6, 3, 11, 0, 11, 6, 0, -1, -1, -1, -1},
  {7, 11, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {7, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {3, 0, 8, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 1, 9, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {8, 1, 9, 8, 3, 1, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1},
  {10, 1, 2, 6, 11, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {1, 2, 10, 3, 0, 8, 6, 11, 7, -1, -1, -1, -1, -1, -1, -1},
  {2, 9, 0, 2, 10, 9, 6, 11, 7, -1, -1, -1, -1, -1, -1, -1},
  {6, 11, 7, 2, 10, 3, 10, 8, 3, 10, 9, 8, -1, -1, -1, -1},
  {7, 2, 3, 6, 2, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {7, 0, 8, 7, 6, 0, 6, 2, 0, -1, -1, -1, -1, -1, -1, -1},
  {2, 7, 6, 2, 3, 7, 0, 1, 9, -1, -1, -1, -1, -1, -1, -1},
  {1, 6, 2, 1, 8, 6, 1, 9, 8, 8, 7, 6, -1, -1, -1, -1},
  {10, 7, 6, 10, 1, 7, 1, 3, 7, -1, -1, -1, -1, -1, -1, -1},
  {10, 7, 6, 1, 7, 10, 1, 8, 7, 1, 0, 8, -1, -1, -1, -1},
  {0, 3, 7, 0, 7, 10, 0, 10, 9, 6, 10, 7, -1, -1, -1, -1},
  {7, 6, 10, 7, 10, 8, 8, 10, 9, -1, -1, -1, -1, -1, -1, -1},
  {6, 8, 4, 11, 8, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {3, 6, 11, 3, 0, 6, 0, 4, 6, -1, -1, -1, -1, -1, -1, -1},
  {8, 6, 11, 8, 4, 6, 9, 0, 1, -1, -1, -1, -1, -1, -1, -1},
  {9, 4, 6, 9, 6, 3, 9, 3, 1, 11, 3, 6, -1, -1, -1, -1},
  {6, 8, 4, 6, 11, 8, 2, 10, 1, -1, -1, -1, -1, -1, -1, -1},
  {1, 2, 10, 3, 0, 11, 0, 6, 11, 0, 4, 6, -1, -1, -1, -1},
  {4, 11, 8, 4, 6, 11, 0, 2, 9, 2, 10, 9, -1, -1, -1, -1},
  {10, 9, 3, 10, 3, 2, 9, 4, 3, 11, 3, 6, 4, 6, 3, -1},
  {8, 2, 3, 8, 4, 2, 4, 6, 2, -1, -1, -1, -1, -1, -1, -1},
  {0, 4, 2, 4, 6, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {1, 9, 0, 2, 3, 4, 2, 4, 6, 4, 3, 8, -1, -1, -1, -1},
  {1, 9, 4, 1, 4, 2, 2, 4, 6, -1, -1, -1, -1, -1, -1, -1},
  {8, 1, 3, 8, 6, 1, 8, 4, 6, 6, 10, 1, -1, -1, -1, -1},
  {10, 1, 0, 10, 0, 6, 6, 0, 4, -1, -1, -1, -1, -1, -1, -1},
  {4, 6, 3, 4, 3, 8, 6, 10, 3, 0, 3, 9, 10, 9, 3, -1},
  {10, 9, 4, 6, 10, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {4, 9, 5, 7, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 8, 3, 4, 9, 5, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1},
  {5, 0, 1, 5, 4, 0, 7, 6, 11, -1, -1, -1, -1, -1, -1, -1},
  {11, 7, 6, 8, 3, 4, 3, 5, 4, 3, 1, 5, -1, -1, -1, -1},
  {9, 5, 4, 10, 1, 2, 7, 6, 11, -1, -1, -1, -1, -1, -1, -1},
  {6, 11, 7, 1, 2, 10, 0, 8, 3, 4, 9, 5, -1, -1, -1, -1},
  {7, 6, 11, 5, 4, 10, 4, 2, 10, 4, 0, 2, -1, -1, -1, -1},
  {3, 4, 8, 3, 5, 4, 3, 2, 5, 10, 5, 2, 11, 7, 6, -1},
  {7, 2, 3, 7, 6, 2, 5, 4, 9, -1, -1, -1, -1, -1, -1, -1},
  {9, 5, 4, 0, 8, 6, 0, 6, 2, 6, 8, 7, -1, -1, -1, -1},
  {3, 6, 2, 3, 7, 6, 1, 5, 0, 5, 4, 0, -1, -1, -1, -1},
  {6, 2, 8, 6, 8, 7, 2, 1, 8, 4, 8, 5, 1, 5, 8, -1},
  {9, 5, 4, 10, 1, 6, 1, 7, 6, 1, 3, 7, -1, -1, -1, -1},
  {1, 6, 10, 1, 7, 6, 1, 0, 7, 8, 7, 0, 9, 5, 4, -1},
  {4, 0, 10, 4, 10, 5, 0, 3, 10, 6, 10, 7, 3, 7, 10, -1},
  {7, 6, 10, 7, 10, 8, 5, 4, 10, 4, 8, 10, -1, -1, -1, -1},
  {6, 9, 5, 6, 11, 9, 11, 8, 9, -1, -1, -1, -1, -1, -1, -1},
  {3, 6, 11, 0, 6, 3, 0, 5, 6, 0, 9, 5, -1, -1, -1, -1},
  {0, 11, 8, 0, 5, 11, 0, 1, 5, 5, 6, 11, -1, -1, -1, -1},
  {6, 11, 3, 6, 3, 5, 5, 3, 1, -1, -1, -1, -1, -1, -1, -1},
  {1, 2, 10, 9, 5, 11, 9, 11, 8, 11, 5, 6, -1, -1, -1, -1},
  {0, 11, 3, 0, 6, 11, 0, 9, 6, 5, 6, 9, 1, 2, 10, -1},
  {11, 8, 5, 11, 5, 6, 8, 0, 5, 10, 5, 2, 0, 2, 5, -1},
  {6, 11, 3, 6, 3, 5, 2, 10, 3, 10, 5, 3, -1, -1, -1, -1},
  {5, 8, 9, 5, 2, 8, 5, 6, 2, 3, 8, 2, -1, -1, -1, -1},
  {9, 5, 6, 9, 6, 0, 0, 6, 2, -1, -1, -1, -1, -1, -1, -1},
  {1, 5, 8, 1, 8, 0, 5, 6, 8, 3, 8, 2, 6, 2, 8, -1},
  {1, 5, 6, 2, 1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {1, 3, 6, 1, 6, 10, 3, 8, 6, 5, 6, 9, 8, 9, 6, -1},
  {10, 1, 0, 10, 0, 6, 9, 5, 0, 5, 6, 0, -1, -1, -1, -1},
  {0, 3, 8, 5, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {10, 5, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {11, 5, 10, 7, 5, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {11, 5, 10, 11, 7, 5, 8, 3, 0, -1, -1, -1, -1, -1, -1, -1},
  {5, 11, 7, 5, 10, 11, 1, 9, 0, -1, -1, -1, -1, -1, -1, -1},
  {10, 7, 5, 10, 11, 7, 9, 8, 1, 8, 3, 1, -1, -1, -1, -1},
  {11, 1, 2, 11, 7, 1, 7, 5, 1, -1, -1, -1, -1, -1, -1, -1},
  {0, 8, 3, 1, 2, 7, 1, 7, 5, 7, 2, 11, -1, -1, -1, -1},
  {9, 7, 5, 9, 2, 7, 9, 0, 2, 2, 11, 7, -1, -1, -1, -1},
  {7, 5, 2, 7, 2, 11, 5, 9, 2, 3, 2, 8, 9, 8, 2, -1},
  {2, 5, 10, 2, 3, 5, 3, 7, 5, -1, -1, -1, -1, -1, -1, -1},
  {8, 2, 0, 8, 5, 2, 8, 7, 5, 10, 2, 5, -1, -1, -1, -1},
  {9, 0, 1, 5, 10, 3, 5, 3, 7, 3, 10, 2, -1, -1, -1, -1},
  {9, 8, 2, 9, 2, 1, 8, 7, 2, 10, 2, 5, 7, 5, 2, -1},
  {1, 3, 5, 3, 7, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 8, 7, 0, 7, 1, 1, 7, 5, -1, -1, -1, -1, -1, -1, -1},
  {9, 0, 3, 9, 3, 5, 5, 3, 7, -1, -1, -1, -1, -1, -1, -1},
  {9, 8, 7, 5, 9, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {5, 8, 4, 5, 10, 8, 10, 11, 8, -1, -1, -1, -1, -1, -1, -1},
  {5, 0, 4, 5, 11, 0, 5, 10, 11, 11, 3, 0, -1, -1, -1, -1},
  {0, 1, 9, 8, 4, 10, 8, 10, 11, 10, 4, 5, -1, -1, -1, -1},
  {10, 11, 4, 10, 4, 5, 11, 3, 4, 9, 4, 1, 3, 1, 4, -1},
  {2, 5, 1, 2, 8, 5, 2, 11, 8, 4, 5, 8, -1, -1, -1, -1},
  {0, 4, 11, 0, 11, 3, 4, 5, 11, 2, 11, 1, 5, 1, 11, -1},
  {0, 2, 5, 0, 5, 9, 2, 11, 5, 4, 5, 8, 11, 8, 5, -1},
  {9, 4, 5, 2, 11, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {2, 5, 10, 3, 5, 2, 3, 4, 5, 3, 8, 4, -1, -1, -1, -1},
  {5, 10, 2, 5, 2, 4, 4, 2, 0, -1, -1, -1, -1, -1, -1, -1},
  {3, 10, 2, 3, 5, 10, 3, 8, 5, 4, 5, 8, 0, 1, 9, -1},
  {5, 10, 2, 5, 2, 4, 1, 9, 2, 9, 4, 2, -1, -1, -1, -1},
  {8, 4, 5, 8, 5, 3, 3, 5, 1, -1, -1, -1, -1, -1, -1, -1},
  {0, 4, 5, 1, 0, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {8, 4, 5, 8, 5, 3, 9, 0, 5, 0, 3, 5, -1, -1, -1, -1},
  {9, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {4, 11, 7, 4, 9, 11, 9, 10, 11, -1, -1, -1, -1, -1, -1, -1},
  {0, 8, 3, 4, 9, 7, 9, 11, 7, 9, 10, 11, -1, -1, -1, -1},
  {1, 10, 11, 1, 11, 4, 1, 4, 0, 7, 4, 11, -1, -1, -1, -1},
  {3, 1, 4, 3, 4, 8, 1, 10, 4, 7, 4, 11, 10, 11, 4, -1},
  {4, 11, 7, 9, 11, 4, 9, 2, 11, 9, 1, 2, -1, -1, -1, -1},
  {9, 7, 4, 9, 11, 7, 9, 1, 11, 2, 11, 1, 0, 8, 3, -1},
  {11, 7, 4, 11, 4, 2, 2, 4, 0, -1, -1, -1, -1, -1, -1, -1},
  {11, 7, 4, 11, 4, 2, 8, 3, 4, 3, 2, 4, -1, -1, -1, -1},
  {2, 9, 10, 2, 7, 9, 2, 3, 7, 7, 4, 9, -1, -1, -1, -1},
  {9, 10, 7, 9, 7, 4, 10, 2, 7, 8, 7, 0, 2, 0, 7, -1},
  {3, 7, 10, 3, 10, 2, 7, 4, 10, 1, 10, 0, 4, 0, 10, -1},
  {1, 10, 2, 8, 7, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {4, 9, 1, 4, 1, 7, 7, 1, 3, -1, -1, -1, -1, -1, -1, -1},
  {4, 9, 1, 4, 1, 7, 0, 8, 1, 8, 7, 1, -1, -1, -1, -1},
  {4, 0, 3, 7, 4, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {4, 8, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {9, 10, 8, 10, 11, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {3, 0, 9, 3, 9, 11, 11, 9, 10, -1, -1, -1, -1, -1, -1, -1},
  {0, 1, 10, 0, 10, 8, 8, 10, 11, -1, -1, -1, -1, -1, -1, -1},
  {3, 1, 10, 11, 3, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {1, 2, 11, 1, 11, 9, 9, 11, 8, -1, -1, -1, -1, -1, -1, -1},
  {3, 0, 9, 3, 9, 11, 1, 2, 9, 2, 11, 9, -1, -1, -1, -1},
  {0, 2, 11, 8, 0, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {3, 2, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {2, 3, 8, 2, 8, 10, 10, 8, 9, -1, -1, -1, -1, -1, -1, -1},
  {9, 10, 2, 0, 9, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {2, 3, 8, 2, 8, 10, 0, 1, 8, 1, 10, 8, -1, -1, -1, -1},
  {1, 10, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {1, 3, 8, 9, 1, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 9, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {0, 3, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}
};




unsigned        m_uStored = 0 ;
unsigned        m_uStoredIndex = 0;
MeshElement     m_MeshElement;
static Vector3D v3dOffsets[8];  
static Vector3D v3dBase;


#define GRIDSIZE  64
#define GRIDSHIFT 6

// Potencial evaluation
#define META_C      1.0f
#define POTENTIAL   0.08f
//#define POTENTIAL   0.06f


#define CACHESIZE 32768

struct VoxelCacheElement
{
  int         iElement;
  float       fPotential;
  Vector3D    v3dNormal;
};


static int iFetches = 0;
static int iHits    = 0;

VoxelCacheElement VoxelCacheTable[CACHESIZE];


__forceinline int GetElement(int x, int y, int z)
{
  return (x<<(2*GRIDSHIFT)) | (y<<(GRIDSHIFT)) | z;
}

__forceinline int GetHash(int iElement)
{
  return iElement & (CACHESIZE-1);
}

VoxelCacheElement* GetCachedElement(int x, int y, int z)
{
  int iElement = GetElement(x, y, z);
  int iHash    = GetHash(iElement);

  iFetches++;

  if (VoxelCacheTable[iHash].iElement == iElement)
  {
    iHits++;
    return &VoxelCacheTable[iHash];
  }

  return 0;
}

void ResetCache()
{
  int i;

  for (i = 0 ; i < CACHESIZE ; i++)
  {
    VoxelCacheTable[i].iElement = -1;
  }
}

void  AddCacheElement(int x, int y, int z, float fPotential, Vector3D& v3d)
{
  int iElement = GetElement(x, y, z);
  int iHash    = GetHash(iElement);

  VoxelCacheTable[iHash].iElement   = iElement;
  VoxelCacheTable[iHash].fPotential = fPotential;
  VoxelCacheTable[iHash].v3dNormal  = v3d;
}

void        SetShader(int iShader)
{
  m_MeshElement.m_iShader = iShader;
}





//
// Voxel mask functionality. Sets bits to mark voxels as already 
// visited
//
#define MASKSIZE (GRIDSIZE*GRIDSIZE*GRIDSIZE)/(sizeof(unsigned)<<3)
unsigned g_uVoxelMask[MASKSIZE];

void     ClearVoxelMask()
{
  memset(g_uVoxelMask, 0 , MASKSIZE*sizeof(unsigned));
  ResetCache();
}

__forceinline int VoxelMaskIsSet(int x, int y, int z)
{
  assert(x >= 0 && x < GRIDSIZE &&
         y >= 0 && y < GRIDSIZE &&
         z >= 0 && z < GRIDSIZE);

  int iVoxel = x + (y<<GRIDSHIFT) + (z<<(GRIDSHIFT*2));
  int iIndex = iVoxel >> 5;
  int iBit   = iVoxel & 31;

  return g_uVoxelMask[iIndex] & (1<<iBit);
}      

__forceinline int VoxelMaskIsSetThenSet(int x, int y, int z)
{
  assert(x >= 0 && x < GRIDSIZE &&
         y >= 0 && y < GRIDSIZE &&
         z >= 0 && z < GRIDSIZE);

  int iVoxel = x + (y<<GRIDSHIFT) + (z<<(GRIDSHIFT*2));
  int iIndex = iVoxel >> 5;
  int iBit   = iVoxel & 31;


  int iReturn = g_uVoxelMask[iIndex] & (1<<iBit);
  g_uVoxelMask[iIndex] |= (1<<iBit);

  return iReturn;
}        

__forceinline void VoxelMaskSet(int x, int y, int z)
{
  assert(x >= 0 && x < GRIDSIZE &&
         y >= 0 && y < GRIDSIZE &&
         z >= 0 && z < GRIDSIZE);

  int iVoxel = x + (y<<GRIDSHIFT) + (z<<(GRIDSHIFT*2));
  int iIndex = iVoxel >> 5;
  int iBit   = iVoxel & 31;

  g_uVoxelMask[iIndex] |= (1<<iBit);
}

// Metaball positions
#define MAX_METABALLS 64


int      g_uMetaballs = 0;
Metaball g_Metaballs[MAX_METABALLS];

void ClearMetaballs()
{
  g_uMetaballs = 0;
}

void AddMetaball(Metaball* pMetaball)
{
  if (g_uMetaballs == MAX_METABALLS)
  {
    return;
  }

  g_Metaballs[g_uMetaballs++] = *pMetaball;  
}


void PotentialNormal(int x, int y, int z, float& outPotential, Vector3D& outNormal)
{
  int i;

  VoxelCacheElement* pCache;
  if (pCache = GetCachedElement(x, y, z))
  {
    outPotential = pCache->fPotential;
    outNormal = pCache->v3dNormal;
    return;
  }

  Vector3D v3dPos(x, y, z);
  outPotential = 0.0f;
  outNormal = Vector3D(0.0f, 0.0f, 0.0f);
  
  for (i = 0 ; i < g_uMetaballs ; i++)
  {
    Vector3D v3dDiff = v3dPos - g_Metaballs[i].m_v3dPosition;
    float fCurrent = META_C / (1.0f+v3dDiff.SquaredLength());
    outPotential += fCurrent;    
    outNormal += v3dDiff.Normalize()*fCurrent;    
  }

  AddCacheElement(x, y, z, outPotential, outNormal);
}



float g_fVoxelPotentials[8];
Vector3D g_v3dNormals[8];

unsigned CalculateVoxelMask()
{
  unsigned u = 0;

  u |= (g_fVoxelPotentials[0] < POTENTIAL)?(1<<0):0;
  u |= (g_fVoxelPotentials[1] < POTENTIAL)?(1<<1):0;
  u |= (g_fVoxelPotentials[2] < POTENTIAL)?(1<<2):0;
  u |= (g_fVoxelPotentials[3] < POTENTIAL)?(1<<3):0;
  u |= (g_fVoxelPotentials[4] < POTENTIAL)?(1<<4):0;
  u |= (g_fVoxelPotentials[5] < POTENTIAL)?(1<<5):0;
  u |= (g_fVoxelPotentials[6] < POTENTIAL)?(1<<6):0;
  u |= (g_fVoxelPotentials[7] < POTENTIAL)?(1<<7):0;

  return u;
}
   
unsigned CalculateVoxelPotentials(int x, int y, int z)
{  
  
  PotentialNormal(x  , y  , z  , g_fVoxelPotentials[0], g_v3dNormals[0]);
  PotentialNormal(x+1, y  , z  , g_fVoxelPotentials[1], g_v3dNormals[1]);
  PotentialNormal(x+1, y+1, z  , g_fVoxelPotentials[2], g_v3dNormals[2]);
  PotentialNormal(x  , y+1, z  , g_fVoxelPotentials[3], g_v3dNormals[3]);
  PotentialNormal(x  , y  , z+1, g_fVoxelPotentials[4], g_v3dNormals[4]);
  PotentialNormal(x+1, y  , z+1, g_fVoxelPotentials[5], g_v3dNormals[5]);
  PotentialNormal(x+1, y+1, z+1, g_fVoxelPotentials[6], g_v3dNormals[6]);
  PotentialNormal(x  , y+1, z+1, g_fVoxelPotentials[7], g_v3dNormals[7]);
  
                      

  return CalculateVoxelMask();
}



#define MAXVOXELS 8192

unsigned g_uVoxelList[MAXVOXELS*3];
unsigned g_uVoxels = 0;

bool AddVoxel(int x, int y, int z)
{
  assert(g_uVoxels < MAXVOXELS);

  if (x < 0 || y < 0 || z < 0 ||
      x > GRIDSIZE-1 || y > GRIDSIZE-1 || z > GRIDSIZE-1 ||
      VoxelMaskIsSetThenSet(x, y, z))
  {
    return false;
  }
    
  g_uVoxelList[g_uVoxels*3+0] = x;
  g_uVoxelList[g_uVoxels*3+1] = y;
  g_uVoxelList[g_uVoxels*3+2] = z;    

  VoxelMaskSet(x, y, z);

  g_uVoxels++;
  return true;
}

void GetVoxel(int& x, int &y, int &z)
{
  assert(g_uVoxels != 0);
  
  g_uVoxels--;

  x = g_uVoxelList[g_uVoxels*3+0];
  y = g_uVoxelList[g_uVoxels*3+1];
  z = g_uVoxelList[g_uVoxels*3+2];  
}

void  AddNeighbours(int x, int  y, int z)
{
  AddVoxel(x-1, y-1, z-1);
  AddVoxel(x  , y-1, z-1);
  AddVoxel(x+1, y-1, z-1);
  AddVoxel(x-1, y  , z-1);
  AddVoxel(x  , y  , z-1);
  AddVoxel(x+1, y  , z-1);
  AddVoxel(x-1, y+1, z-1);
  AddVoxel(x  , y+1, z-1);
  AddVoxel(x+1, y+1, z-1);

  AddVoxel(x-1, y-1, z);
  AddVoxel(x  , y-1, z);
  AddVoxel(x+1, y-1, z);
  AddVoxel(x-1, y  , z);
  AddVoxel(x+1, y  , z);
  AddVoxel(x-1, y+1, z);
  AddVoxel(x  , y+1, z);
  AddVoxel(x+1, y+1, z);

  AddVoxel(x-1, y-1, z+1);
  AddVoxel(x  , y-1, z+1);
  AddVoxel(x+1, y-1, z+1);
  AddVoxel(x-1, y  , z+1);
  AddVoxel(x  , y  , z+1);
  AddVoxel(x+1, y  , z+1);
  AddVoxel(x-1, y+1, z+1);
  AddVoxel(x  , y+1, z+1);
  AddVoxel(x+1, y+1, z+1);
}

//FindIntersection
bool FindIntersection(int iMetaball)
{

  int x, y, z;

  x = int(g_Metaballs[iMetaball].m_v3dPosition.x);
  y = int(g_Metaballs[iMetaball].m_v3dPosition.y);
  z = int(g_Metaballs[iMetaball].m_v3dPosition.z);

  if (x < 0 || y < 0 || z < 0 ||
      x > GRIDSIZE-1 || y > GRIDSIZE-1 || z > GRIDSIZE-1)
  {
    return false;
  }

  while (x < GRIDSIZE)
  {
    unsigned uMask = CalculateVoxelPotentials(x, y, z);

    if (uMask && (uMask != 0xFF))
    {
      return AddVoxel(x, y, z);
    }

    x++;
  }

  return false;
}

static void VertexInterp(FVF_PosNormalDiffuseTex1* pVertex, int i1, int i2)
  {
    float fLerp=(POTENTIAL-g_fVoxelPotentials[i1])/(g_fVoxelPotentials[i2]-g_fVoxelPotentials[i1]);

    assert(fLerp>=0.0f && fLerp<=1.0f);

    Vector3D vPos = v3dBase + v3dOffsets[i1] + (v3dOffsets[i2] - v3dOffsets[i1])*fLerp;
    pVertex->x = vPos.x;
    pVertex->y = vPos.y;
    pVertex->z = vPos.z;

    
    Vector3D Normal = g_v3dNormals[i1]+(g_v3dNormals[i2]-g_v3dNormals[i1])*fLerp;                     
    Normal.Normalize();

    pVertex->diffuse = 0xFFFFFFFF;
    
    pVertex->nx=Normal.x;
    pVertex->ny=Normal.y;
    pVertex->nz=Normal.z;
  }
  
  
  static void SpitTri(int v0, int v1, int v2, int v3, unsigned uMask)
  {
    unsigned uSelector  = ((uMask&(1<<(v0)))>>(v0))<<0;
             uSelector |= ((uMask&(1<<(v1)))>>(v1))<<1;
             uSelector |= ((uMask&(1<<(v2)))>>(v2))<<2;
             uSelector |= ((uMask&(1<<(v3)))>>(v3))<<3;

    FVF_PosNormalDiffuseTex1* pVertex=m_MeshElement.m_pVertices+m_uStored;
    switch (uSelector) 
    {
     case 0x0E:
     case 0x01:
        VertexInterp(pVertex, v0,v1); pVertex++;
        VertexInterp(pVertex, v0,v2); pVertex++;
        VertexInterp(pVertex, v0,v3); pVertex++;
        m_uStored+=3;
        break;
     case 0x0D:
     case 0x02:
        VertexInterp(pVertex, v1,v0); pVertex++;
        VertexInterp(pVertex, v1,v3); pVertex++;
        VertexInterp(pVertex, v1,v2); pVertex++;
        m_uStored+=3;
        break;
        
     case 0x0C:
     case 0x03:
        VertexInterp(pVertex, v0,v3); pVertex++;
        VertexInterp(pVertex, v0,v2); pVertex++;
        VertexInterp(pVertex, v1,v3); pVertex++;
        m_uStored+=3;
        VertexInterp(pVertex, v1,v3); pVertex++;
        VertexInterp(pVertex, v1,v2); pVertex++;
        VertexInterp(pVertex, v0,v2); pVertex++;
        m_uStored+=3;
        break;
       
     case 0x0B:
     case 0x04:
        VertexInterp(pVertex, v2,v0); pVertex++;
        VertexInterp(pVertex, v2,v1); pVertex++;
        VertexInterp(pVertex, v2,v3); pVertex++;        
        m_uStored+=3;
        break;        
     case 0x0A:
     case 0x05:
        VertexInterp(pVertex, v0,v1); pVertex++;
        VertexInterp(pVertex, v2,v3); pVertex++;
        VertexInterp(pVertex, v0,v3); pVertex++;
        
        m_uStored+=3;
        VertexInterp(pVertex, v0,v1); pVertex++;
        VertexInterp(pVertex, v1,v2); pVertex++;                
        VertexInterp(pVertex, v2,v3); pVertex++;                
        m_uStored+=3;
        break;
     case 0x09:
     case 0x06:
        VertexInterp(pVertex, v0,v1); pVertex++;
        VertexInterp(pVertex, v1,v3); pVertex++;
        VertexInterp(pVertex, v2,v3); pVertex++;                
        m_uStored+=3;

        VertexInterp(pVertex, v0,v1); pVertex++;
        VertexInterp(pVertex, v0,v2); pVertex++;
        VertexInterp(pVertex, v2,v3); pVertex++;                
        m_uStored+=3;
        break;
     case 0x07:
     case 0x08:
        VertexInterp(pVertex, v3, v0); pVertex++;
        VertexInterp(pVertex, v3, v2); pVertex++;
        VertexInterp(pVertex, v3, v1); pVertex++;        
        m_uStored+=3;
        
        break;       
     }
  }




void Polygonize(int x, int y, int z, unsigned uMask)
{      
  v3dBase=Vector3D(x, y, z);

  if (0)
  {
    SpitTri(0,2,4,5, uMask);     
    SpitTri(0,2,4,5, uMask); 
    SpitTri(2,4,5,6, uMask); 
    SpitTri(2,5,6,7, uMask); 
    SpitTri(2,3,5,7, uMask); 
    SpitTri(0,1,2,5, uMask); 
    SpitTri(1,2,3,5, uMask);         
  }
  else
  {
    int eflags = s_edgeTable[uMask];
    if (eflags == 0)
    return;

    FVF_PosNormalDiffuseTex1* pVertex=m_MeshElement.m_pVertices+m_uStored;

    int iMap[12];
    #ifdef _DEBUG 
    memset(iMap, -1, 12*sizeof(int));
    #endif

    if (eflags & 1)
    {
      VertexInterp(pVertex, 0, 1);
      pVertex++;
      iMap[0] = m_uStored++;
    }
    if (eflags & 2)
    {
      VertexInterp(pVertex, 1, 2);
      pVertex++;
      iMap[1] = m_uStored++;
    }
    if (eflags & 4)
    {
      VertexInterp(pVertex, 2, 3);
      pVertex++;
      iMap[2] = m_uStored++;
    }
    if (eflags & 8)
    {
      VertexInterp(pVertex, 3, 0);
      pVertex++;
      iMap[3] = m_uStored++;
    }
    if (eflags & 16)
    {
      VertexInterp(pVertex, 4, 5);
      pVertex++;
      iMap[4] = m_uStored++;;
    }
    if (eflags & 32)
    {
      VertexInterp(pVertex, 5, 6);
      pVertex++;
      iMap[5] = m_uStored++;;
    }
    if (eflags & 64)
    {
      VertexInterp(pVertex, 6, 7);
      pVertex++;
      iMap[6] = m_uStored++;;
    }
    if (eflags & 128)
    {
      VertexInterp(pVertex, 7, 4);
      pVertex++;
      iMap[7] = m_uStored++;;
    }
    if (eflags & 256)
    {
      VertexInterp(pVertex, 0, 4);
      pVertex++;
      iMap[8] = m_uStored++;;
    }
    if (eflags & 512)
    {
      VertexInterp(pVertex, 1, 5);
      pVertex++;
      iMap[9] = m_uStored++;;
    }
    if (eflags & 1024)
    {
      VertexInterp(pVertex, 2, 6);
      pVertex++;
      iMap[10] = m_uStored++;;
    }
    if (eflags & 2048)
    {
      VertexInterp(pVertex, 3, 7);
      pVertex++;
      iMap[11] = m_uStored++;;
    }

    int i;
    for (i=0;s_TriTable[uMask][i]!=-1;i+=3) 
    {
      assert(iMap[s_TriTable[uMask][i]] != -1);

      m_MeshElement.m_pIndices[m_uStoredIndex++] = iMap[s_TriTable[uMask][i]];
      m_MeshElement.m_pIndices[m_uStoredIndex++] = iMap[s_TriTable[uMask][i+1]];
      m_MeshElement.m_pIndices[m_uStoredIndex++] = iMap[s_TriTable[uMask][i+2]];

      /*
      triangles[ntriang].p[0] = vertlist[triTable[cubeindex][i  ]];
      triangles[ntriang].p[1] = vertlist[triTable[cubeindex][i+1]];
      triangles[ntriang].p[2] = vertlist[triTable[cubeindex][i+2]];
      ntriang++;
      */
    }
  }
}

void Flush()
{

  //m_uStored=0;
  //return;

  m_MeshElement.m_uVertices  =m_uStored;
  m_MeshElement.m_uPrimitives=m_uStoredIndex/3;

  RenderPipeline::Render(&m_MeshElement);
  RenderPipeline::Flush();    

  m_uStored=0;
  m_uStoredIndex=0;
}

void Render(RenderContext* pRenderContext, int iOutcode)
{
  if (!g_uMetaballs)
  {
    return;
  }
  pRenderContext->SetViewport(0.0f, 0.0f, 640, 480);
  pRenderContext->SyncRasterizer();
  pRenderContext->UpdateFrustum();

  ShaderManager::SetRenderContext(pRenderContext);
    
  int Add=0;
  
 
  m_uStoredIndex = 0;
  m_uStored = 0;
  ClearVoxelMask();

  int i;
  for (i = 0 ; i < g_uMetaballs ; i++)
  {
    if (FindIntersection(i))
    {
      while (g_uVoxels)
      {
        int x, y, z;

        GetVoxel(x, y, z);

        unsigned uMask = CalculateVoxelPotentials(x, y, z);

        if (uMask && uMask != 0xFF)
        {
          // Did we fill the batch?
          if ((m_uStored>=MAX_BATCH-12*3) || (m_uStoredIndex>=MAX_BATCH-12*3))  // 12 is the max tris we can output for one cube
          {
            Flush();
          }

          Polygonize(x, y, z, uMask);
          
          AddNeighbours(x, y, z);
        }          
      }        
    }            
  }
    
  if (m_uStored)
  {
    Flush();
  }    
}

int Init()
{
    Shutdown();
    float fTime=0.0f;
        
    
    SM_D3d::SetRenderState(D3DRS_LIGHTING, FALSE);


    m_MeshElement.m_iVB               =-1;
    m_MeshElement.m_iIB               =-1;
    m_MeshElement.m_pVertices         =new FVF_PosNormalDiffuseTex1[MAX_BATCH]; 
    if (!m_MeshElement.m_pVertices) return -1;

    m_MeshElement.m_pIndices          =new unsigned short[MAX_BATCH];
    if (!m_MeshElement.m_pIndices) return -1;

    int i;
    for (i=0 ; i<MAX_BATCH ; i++)
    {
      m_MeshElement.m_pIndices[i]=i;
    }

    m_MeshElement.m_uStartVertex      =0;
    m_MeshElement.m_uVertices         =0;
    m_MeshElement.m_uStartIndex       =0;
    m_MeshElement.m_uPrimitives       =0;
    m_MeshElement.m_WorldTransform    =Matrix4X4::Identity;
    m_MeshElement.m_iActiveLightMask  =0;  
    m_MeshElement.m_fDepth            =0.0f;

  
    v3dOffsets[0]=Vector3D(0.0f, 0.0f, 0.0f );
    v3dOffsets[1]=Vector3D(1.0f, 0.0f, 0.0f );
    v3dOffsets[2]=Vector3D(1.0f, 1.0f, 0.0f);
    v3dOffsets[3]=Vector3D(0.0f, 1.0f, 0.0f);
    v3dOffsets[4]=Vector3D(0.0f, 0.0f, 1.0f );
    v3dOffsets[5]=Vector3D(1.0f, 0.0f, 1.0f );
    v3dOffsets[6]=Vector3D(1.0f, 1.0f, 1.0f);
    v3dOffsets[7]=Vector3D(0.0f, 1.0f, 1.0f);
    
    return 0;
}


int Shutdown()
{
  if (m_MeshElement.m_pVertices)
  {
      delete[] m_MeshElement.m_pVertices;
      m_MeshElement.m_pVertices=0; 
  }

  if (m_MeshElement.m_pIndices)
  {
    delete[] m_MeshElement.m_pIndices;
    m_MeshElement.m_pIndices=0;

  }
   
  return 0;
}
}