#ifndef __SM_MESH_ELEMENT

#define __SM_MESH_ELEMENT

struct MeshElement;

#include "SM_Matrix4X4.h"
#include "SM_Renderable.h"
#include "SM_Shader.h"



class MeshElementCache : public IRenderable
{
public:
                    MeshElementCache              ()
                    {
                    }

  virtual ~         MeshElementCache              ()
                    {
                    }

  virtual void      PreCache                      (MeshElement* pME)
                    {
                    }
};

struct ShadowVolumeData
{
  ShadowVolumeData()
  {
    m_pVertices = 0;
    m_pIndices = 0;
  }

  ~ShadowVolumeData()
  {
    Shutdown();
  }

  void Shutdown()
  {
    if (m_pVertices) delete[] m_pVertices;
    if (m_pIndices) delete[] m_pIndices;
  }

  FVF_PosNormal*    m_pVertices; 
  unsigned  short*  m_pIndices;  
  unsigned          m_uVertices;
  unsigned          m_uFaces;
  unsigned          m_uBorderFaces;
};

struct MeshElement
{
  MeshElement()
  {
    memset(this, 0, sizeof(*this));
  }

  ~MeshElement()
  {
    Shutdown();
  }

  void Shutdown()
  {
    ClearCache();

    if (m_pShadowVolumeData)
    {
      delete m_pShadowVolumeData;
      m_pShadowVolumeData = 0;
    }
  }

  void ClearCache()
  {
    if (m_pCache)
    {
      delete m_pCache;
      m_pCache = 0;
    }
  }

  void PreCache()
  {
    if (m_iShader != -1)
    {
      ShaderManager::GetShader(m_iShader)->PreCache(this);      
    }    
  }

  int                        m_iVB;
  int                        m_iIB;
  FVF_PosNormalDiffuseTex1*  m_pVertices; 
  unsigned  short*           m_pIndices;
  unsigned  short*           m_pShadowVolumeIndices;
  unsigned                   m_uStartVertex;
  unsigned                   m_uVertices;
  unsigned                   m_uStartIndex;
  unsigned                   m_uPrimitives;
  Matrix4X4                  m_WorldTransform;
  int                        m_iActiveLightMask;  
  float                      m_fDepth;
  MeshElementCache*          m_pCache;                // Cache associated with shader
  ShadowVolumeData*          m_pShadowVolumeData;


//  int                        GetShader();
//  int                        SetShader(int iShader);  // Assigns shader
//protected:
  int                        m_iShader;
  
};


#endif
