#include "SM_Renderable.h"


#define ROWS       75
#define COLUMNS    75
#define MAXTRIS    20000
#define ROWSPERDP  (min(ROWS, MAXTRIS/(COLUMNS*2)))
#define NVERTICES  ((ROWS+1)*(COLUMNS+1)) 
#define NPRIMITIVES (COLUMNS*ROWS*2)


class SM_GeomMorpher : public IRenderable
{
public:
      SM_GeomMorpher      ();
      ~SM_GeomMorpher     ();

  int  Reset              ();
  int  Init               (int iShader, IKFAnimable* pAnimable);
  int  Shutdown           ();
  void Render             (RenderContext* pRenderContext, int iOutcode, float fTime); 

  
  Vector3D                m_v3dPosition;
  Quaternion              m_qRotation;
protected:
  int                     m_iShader;    
  IKFAnimable*            m_pAnimable;

  static bool             m_bIndices;
  static bool             m_bGeometries;
  static Vector3D         m_v3dPositions[NVERTICES];
  static Vector3D         m_v3dNormals[NVERTICES];  
};
