#include "SM_Engine3DPch.h"
#include "SM_AviDecoder.h"

//#define CDECL _cdecl 


int SM_AviDecoder::InitSubsystem()
{
  AVIFileInit();

  return 0;
}

int SM_AviDecoder::ShutdownSubsystem()
{
  AVIFileExit();

  return 0;
}


SM_AviDecoder::SM_AviDecoder()
{
  m_Avi = 0;
  m_Frame = 0;
}

SM_AviDecoder::~SM_AviDecoder()
{
  Shutdown();
}

int   SM_AviDecoder::Init(const char* pcFile)
{

  if (AVIStreamOpenFromFile(&m_Avi, pcFile, streamtypeVIDEO, 0, OF_READ, NULL) != 0)
  {
    return -1;
  }


  AVISTREAMINFO streamInfo;

  AVIStreamInfo(m_Avi, &streamInfo, sizeof(streamInfo));  


  int width = streamInfo.rcFrame.right-streamInfo.rcFrame.left;
  int height = streamInfo.rcFrame.bottom-streamInfo.rcFrame.top;

  BITMAPINFOHEADER bmInfo;
  m_pBmInfo = &bmInfo;

  m_pBmInfo->biSize		      = sizeof (BITMAPINFOHEADER);
	m_pBmInfo->biPlanes		    = 1;
	m_pBmInfo->biBitCount   	= 32;
	m_pBmInfo->biWidth		    = width;
  m_pBmInfo->biHeight       = height;
  m_pBmInfo->biPlanes       = 1;
	m_pBmInfo->biCompression	= BI_RGB;  
  m_pBmInfo->biSizeImage    = 0;
  m_pBmInfo->biClrUsed      = 0;
  m_pBmInfo->biClrImportant = 0;

  

  m_Frame = AVIStreamGetFrameOpen(m_Avi, m_pBmInfo);
  if (!m_Frame)
  {
    return -1;
  }


  return 0;
}

int   SM_AviDecoder::Shutdown()
{
  if (m_Frame)
  {
    AVIStreamGetFrameClose(m_Frame);
    m_Frame = 0;
  }

  if (m_Avi) 
  {
    AVIStreamRelease(m_Avi);
    m_Avi = 0;
  }

  return 0;
}

void  SM_AviDecoder::Reset()
{
}

void  SM_AviDecoder::GetFrame(int iFrame)
{
  LPBITMAPINFOHEADER pBitmap;

  pBitmap = (LPBITMAPINFOHEADER) AVIStreamGetFrame(m_Frame, 0);

  if (!pBitmap)
  {
    return;
  }  
}