#include "SM_CommonFXPCH.h"
#include "SM_DemoEffect.h"
#include "SM_Terrain.h"
#include "SM_RenderContext.h"
#include "SM_D3d.h"

class TerrainFX : public SM_DemoEffect
{
public:              
  TerrainFX(char const* pcName) : SM_DemoEffect(pcName)
  {
  }

  virtual          ~TerrainFX()
  {
  }

  int      Init(const char* pcCommand)
  {
    m_Terrain.Init();
    return (0);
  }

  int      Shutdown()
  {
    return (0);
  }

  int      Start(float fTime)
  {
    return (0);
  }

  int      Stop()
  {
    return (0);
  }

  int      Reset()
  {
    return (0);
  }

  int      Run(float fTime)
  {
    RenderContext rc;

    rc.Set(Vector3D(0.0f+0.0f*sinf(fTime), 0.0f, -40.0f), Quaternion::IDENTITY, 90, 0.75f, 1.0f, 10000.0f);
    rc.SetViewport(0.0f, 0.0f, (float) SM_D3d::GetCurrentMode()->uWidth, (float) SM_D3d::GetCurrentMode()->uHeight);  
    rc.SyncRasterizer();
    rc.UpdateFrustum();

    m_Terrain.Render(&rc, 0xFFFFFFFF);

    return (1);
  }

  int      Command           (float fTime, const char* pcCommand)
  {
    return (0);
  }  

  Terrain m_Terrain;
};


DEFINE_EFFECT(TerrainFX)
TerrainFX Terreno("TERRENO");