#include "o3d.h"
#include "sincos.h"

#define RIBBON_NBTEX 3

extern u_long test;
extern u_long test2;
extern u_long logo128;

u_long *ribbon_tex[RIBBON_NBTEX] =
	{&logo128,&test,&test2};

u_short	ribbon_texID[RIBBON_NBTEX+4];

#define	RIBBON_NBPOLYS 112+3

#define RIBBON_NBVERTS (RIBBON_NBPOLYS-1)*2+2+8+4

SVECTOR	ribbon_vert[RIBBON_NBVERTS];

u_short	ribbon_polys_set[RIBBON_NBPOLYS][4];

u_short	*ribbon_polys[RIBBON_NBPOLYS];

u_char	ribbon_pdim[RIBBON_NBPOLYS];

u_char	ribbon_ptype[RIBBON_NBPOLYS];

u_char	ribbon_data_u[RIBBON_NBPOLYS][4];
u_char	ribbon_data_v[RIBBON_NBPOLYS][4];
Color	ribbon_data_color = {127,127,127};
TPolyData ribbon_data_set[RIBBON_NBPOLYS];

void	*ribbon_data[RIBBON_NBPOLYS];

SObject		ribbon_sobj;
Object3D 	ribbon_o3d = {0,&ribbon_sobj,0};

SVECTOR ribbon_f_normals[RIBBON_NBPOLYS];
SVECTOR ribbon_v_normals[RIBBON_NBVERTS];

Object3D* ribbon_object() {
	int i,a = 0;
	u_short dx = 4,mode;

	for (i=0;i<RIBBON_NBPOLYS-1;i++) {
		ribbon_vert[i].vx = (i%(RIBBON_NBPOLYS-1))*4-264;
		ribbon_vert[i].vy = ((tsin[a%PRECISION]*64)/MULT);
		ribbon_vert[i].vz = ((tcos[a%PRECISION]*128)/MULT);
		a+=16;
	}
	a = 0;
	for (i=0;i<RIBBON_NBPOLYS-1;i++) {
		ribbon_vert[i+RIBBON_NBPOLYS-1].vx = (i%(RIBBON_NBPOLYS-1))*4-202;
		ribbon_vert[i+RIBBON_NBPOLYS-1].vy = ((tsin[a%PRECISION]*64)/MULT);
		ribbon_vert[i+RIBBON_NBPOLYS-1].vz = ((tcos[a%PRECISION]*128)/MULT);
		a+=16;
	}

	ribbon_vert[RIBBON_NBVERTS-12].vx = -239;
	ribbon_vert[RIBBON_NBVERTS-12].vy = -23;
	ribbon_vert[RIBBON_NBVERTS-12].vz = 0;
	ribbon_vert[RIBBON_NBVERTS-11].vx = 16;
	ribbon_vert[RIBBON_NBVERTS-11].vy = -23;
	ribbon_vert[RIBBON_NBVERTS-11].vz = 0;
	ribbon_vert[RIBBON_NBVERTS-10].vx = -239;
	ribbon_vert[RIBBON_NBVERTS-10].vy = 38;
	ribbon_vert[RIBBON_NBVERTS-10].vz = 0;
	ribbon_vert[RIBBON_NBVERTS-9].vx = 16;
	ribbon_vert[RIBBON_NBVERTS-9].vy = 38;
	ribbon_vert[RIBBON_NBVERTS-9].vz = 0;

	ribbon_vert[RIBBON_NBVERTS-8].vx = 16;
	ribbon_vert[RIBBON_NBVERTS-8].vy = -23;
	ribbon_vert[RIBBON_NBVERTS-8].vz = 0;
	ribbon_vert[RIBBON_NBVERTS-7].vx = 239;
	ribbon_vert[RIBBON_NBVERTS-7].vy = -23;
	ribbon_vert[RIBBON_NBVERTS-7].vz = 0;
	ribbon_vert[RIBBON_NBVERTS-6].vx = 16;
	ribbon_vert[RIBBON_NBVERTS-6].vy = 38;
	ribbon_vert[RIBBON_NBVERTS-6].vz = 0;
	ribbon_vert[RIBBON_NBVERTS-5].vx = 239;
	ribbon_vert[RIBBON_NBVERTS-5].vy = 38;
	ribbon_vert[RIBBON_NBVERTS-5].vz = 0;

	ribbon_vert[RIBBON_NBVERTS-4].vx = -64;
	ribbon_vert[RIBBON_NBVERTS-4].vy = -20;
	ribbon_vert[RIBBON_NBVERTS-4].vz = 75;
	ribbon_vert[RIBBON_NBVERTS-3].vx = 64;
	ribbon_vert[RIBBON_NBVERTS-3].vy = -20;
	ribbon_vert[RIBBON_NBVERTS-3].vz = 75;
	ribbon_vert[RIBBON_NBVERTS-2].vx = -64;
	ribbon_vert[RIBBON_NBVERTS-2].vy = 35;
	ribbon_vert[RIBBON_NBVERTS-2].vz = 75;
	ribbon_vert[RIBBON_NBVERTS-1].vx = 64;
	ribbon_vert[RIBBON_NBVERTS-1].vy = 35;
	ribbon_vert[RIBBON_NBVERTS-1].vz = 75;

	for (i=0;i<RIBBON_NBPOLYS-3;i++) {
		int x = (dx*i)%256;
		ribbon_polys_set[i][0] = i;
		ribbon_polys_set[i][1] = i+1;
		ribbon_polys_set[i][2] = i+RIBBON_NBPOLYS-1;
		ribbon_polys_set[i][3] = i+RIBBON_NBPOLYS;
		ribbon_polys[i] = ribbon_polys_set[i];
		ribbon_pdim[i] = 4;
		ribbon_ptype[i] = TYPE_FT + FLAG_S;
		ribbon_data_u[i][0] = x;
		ribbon_data_u[i][1] = x+dx-1;
		ribbon_data_u[i][2] = x;
		ribbon_data_u[i][3] = x+dx-1;
		ribbon_data_v[i][0] = 0;
		ribbon_data_v[i][1] = 0;
		ribbon_data_v[i][2] = 61;
		ribbon_data_v[i][3] = 61;
		ribbon_data_set[i].texID = ((dx*i)/256)+RIBBON_NBTEX;
		ribbon_data_set[i].u = ribbon_data_u[i];
		ribbon_data_set[i].v = ribbon_data_v[i];
		ribbon_data_set[i].color = &ribbon_data_color;
		ribbon_data[i] = &ribbon_data_set[i];
	}

	ribbon_polys_set[i][0] = RIBBON_NBVERTS-12;
	ribbon_polys_set[i][1] = RIBBON_NBVERTS-11;
	ribbon_polys_set[i][2] = RIBBON_NBVERTS-10;
	ribbon_polys_set[i][3] = RIBBON_NBVERTS-9;
	ribbon_polys[i] = ribbon_polys_set[i];
	ribbon_pdim[i] = 4;
	ribbon_ptype[i] = TYPE_FT + FLAG_V;
	ribbon_data_u[i][0] = 0;
	ribbon_data_u[i][1] = 255;
	ribbon_data_u[i][2] = 0;
	ribbon_data_u[i][3] = 255;
	ribbon_data_v[i][0] = 62;
	ribbon_data_v[i][1] = 62;
	ribbon_data_v[i][2] = 123;
	ribbon_data_v[i][3] = 123;
	ribbon_data_set[i].texID = RIBBON_NBTEX+2;
	ribbon_data_set[i].u = ribbon_data_u[i];
	ribbon_data_set[i].v = ribbon_data_v[i];
	ribbon_data_set[i].color = &ribbon_data_color;
	ribbon_data[i] = &ribbon_data_set[i];
	i++;
	ribbon_polys_set[i][0] = RIBBON_NBVERTS-8;
	ribbon_polys_set[i][1] = RIBBON_NBVERTS-7;
	ribbon_polys_set[i][2] = RIBBON_NBVERTS-6;
	ribbon_polys_set[i][3] = RIBBON_NBVERTS-5;
	ribbon_polys[i] = ribbon_polys_set[i];
	ribbon_pdim[i] = 4;
	ribbon_ptype[i] = TYPE_FT + FLAG_V;
	ribbon_data_u[i][0] = 0;
	ribbon_data_u[i][1] = 223;
	ribbon_data_u[i][2] = 0;
	ribbon_data_u[i][3] = 223;
	ribbon_data_v[i][0] = 62;
	ribbon_data_v[i][1] = 62;
	ribbon_data_v[i][2] = 123;
	ribbon_data_v[i][3] = 123;
	ribbon_data_set[i].texID = RIBBON_NBTEX+3;
	ribbon_data_set[i].u = ribbon_data_u[i];
	ribbon_data_set[i].v = ribbon_data_v[i];
	ribbon_data_set[i].color = &ribbon_data_color;
	ribbon_data[i] = &ribbon_data_set[i];
	i++;
	ribbon_polys_set[i][0] = RIBBON_NBVERTS-4;
	ribbon_polys_set[i][1] = RIBBON_NBVERTS-3;
	ribbon_polys_set[i][2] = RIBBON_NBVERTS-2;
	ribbon_polys_set[i][3] = RIBBON_NBVERTS-1;
	ribbon_polys[i] = ribbon_polys_set[i];
	ribbon_pdim[i] = 4;
	ribbon_ptype[i] = TYPE_FT + FLAG_V;
	ribbon_data_u[i][0] = 0;
	ribbon_data_u[i][1] = 128;
	ribbon_data_u[i][2] = 0;
	ribbon_data_u[i][3] = 128;
	ribbon_data_v[i][0] = 0;
	ribbon_data_v[i][1] = 0;
	ribbon_data_v[i][2] = 56;
	ribbon_data_v[i][3] = 56;
	ribbon_data_set[i].texID = 0;
	ribbon_data_set[i].u = ribbon_data_u[i];
	ribbon_data_set[i].v = ribbon_data_v[i];
	ribbon_data_set[i].color = &ribbon_data_color;
	ribbon_data[i] = &ribbon_data_set[i];

	ribbon_sobj.nbv	= RIBBON_NBVERTS;
	ribbon_sobj.vert= ribbon_vert;
	ribbon_sobj.nbp	= RIBBON_NBPOLYS;
	ribbon_sobj.polys = ribbon_polys;
	ribbon_sobj.pdim  = ribbon_pdim;
	ribbon_sobj.ptype = ribbon_ptype;
	ribbon_sobj.data  = ribbon_data;
	ribbon_sobj.nbt	= RIBBON_NBTEX;
	ribbon_sobj.tex	= ribbon_tex;
	ribbon_sobj.texID = ribbon_texID;
	ribbon_sobj.f_normals = ribbon_f_normals;
	ribbon_sobj.v_normals = ribbon_v_normals;

	for (i=0;i<ribbon_sobj.nbt;i++)
            ribbon_texID[i] = regTex(ribbon_tex[i]);
	ribbon_texID[ribbon_sobj.nbt] = regTexTC(ribbon_texID[1],SCR_W,256);
	ribbon_texID[ribbon_sobj.nbt+1] = regTexTC(ribbon_texID[1],SCR_W+128,256);
	ribbon_texID[ribbon_sobj.nbt+2] = regTexTC(ribbon_texID[2],SCR_W,256);
	ribbon_texID[ribbon_sobj.nbt+3] = regTexTC(ribbon_texID[2],SCR_W+128,256);

	InitSObject(&ribbon_o3d);
	ribbon_sobj.nbt+=4;
	return &ribbon_o3d;
}
