#define _REGTEX_C

#include "regtex.h"

u_short getDivMode(u_short mode) {
  return mode==9 ? 2 : mode==8 ? 4 : 1;
}

u_short getMode(u_short mode) {
  return mode==1 ? 0 : mode==2 ? 1 : 2;
}

// Register a texture and return a texID

u_short regTex (u_long *texture) {
	int i;
	RECT _rect;
	for (i=0;i<nbtex;i++) {
		if (tex_addr[i] == texture)
			return i;
	}
	tex_addr[nbtex] = texture;
	GsGetTimInfo(++texture, &texInfo[nbtex]);
	_rect.x=texInfo[nbtex].px;
	_rect.y=texInfo[nbtex].py;
	_rect.w=texInfo[nbtex].pw;
	_rect.h=texInfo[nbtex].ph;
	modes[nbtex] = getDivMode(texInfo[nbtex].pmode);
	tpages[nbtex]=GetTPage(getMode(modes[nbtex]),0,_rect.x,_rect.y);
	if (texInfo[nbtex].pmode==8||texInfo[nbtex].pmode==9)
		cluts[nbtex] = LoadClut(texInfo[nbtex].clut,texInfo[nbtex].cx,texInfo[nbtex].cy);
	LoadImage(&_rect,texInfo[nbtex].pixel);
	DrawSync(0);
	return nbtex++;
}

u_short regTexTC(u_short texID,int x,int y) {
	tpages[nbtex] = GetTPage(getMode(modes[texID]),0,x,y);
	tex_addr[nbtex] = 0;
	texInfo[nbtex].px = x;
	texInfo[nbtex].py = y;
	texInfo[nbtex].pw = 64;
	texInfo[nbtex].ph = 64;
	cluts[nbtex] = cluts[texID];
	modes[nbtex] = modes[texID];
	return nbtex++;
}

// Return the tPage ID for the registered texture

u_short regTPage (u_short texID) {
	return tpages[texID];
}

// Return the clut ID for the registered texture

u_short regClut (u_short texID) {
	return cluts[texID];
}

// Return the absisse divider

u_short regMode (u_short texID) {
	return modes[texID];
}

// Return the clut ID for the registered texture

void regRect (u_short texID,RECT *rect) {
	rect->x=texInfo[texID].px;
	rect->y=texInfo[texID].py;
	rect->w=texInfo[texID].pw;
	rect->h=texInfo[texID].ph;
}

// set OT draw mode to registered texture

void regDrawTPage(u_short texID,DR_TPAGE *dm) {
	SetDrawTPage(dm,0,0,tpages[texID]);
}
