/*
   Reverie
   rotocube.cpp
   Copyright (C)2003 Dan Potter
*/

#include "global.h"
#include "rotocube.h"

/* Taken from the Parallax rotocube example */

/*

The fourth demo effect in my series of Parallax demo effects. A really
common demo effect back in the Amiga days (and somewhat in the middle
PC days) was "rotoscoping", where you have more or less silhouette
images of whatever you're animating. This example emulates that using
3D rendered objects.

Obviously what you can get away with drawing is somewhat limited to
things that the imagination can pick out of a silhouette but it's
neat and artistic looking.

The effect is so incredibly simple that some people probably wouldn't
even consider it a real effect, but it's one of those middle to later
PC demo day effects that is meant to be more artistic than impressive
code-wise. I went ahead and threw in a little wave generator to make
it more impressive looking.

One might also play with moving the wave to the front and switching it
to a translucent poly to interfere with the cube.

*/

RotoCube::RotoCube() {
	m_theta = 0;
}

RotoCube::~RotoCube() {
}

// Draws the full cube at the current position.
void RotoCube::draw(int list) {
	Color col = getColor();

	if (col.a < 1.0f) {
		if (list != PLX_LIST_TR_POLY)
			return;
	} else {
		if (list != PLX_LIST_OP_POLY)
			return;
	}

	plx_mat3d_identity();
	plx_mat3d_translate(0.0f, 0.0f, -30.0f);
	plx_mat3d_rotate(m_theta*0.3f, 1.0f, 0.0f, 0.0f);
	plx_mat3d_rotate(m_theta*1.5f, 0.0f, 1.0f, 0.0f);
	plx_mat3d_translate(10.0f, 0.0f, 0.0f);
	plx_mat3d_rotate(m_theta, 1.0f, 0.0f, 0.0f);
	plx_mat3d_rotate(m_theta*0.5f, 0.0f, 1.0f, 0.0f);
	plx_mat3d_rotate(m_theta*0.3f, 0.0f, 0.0f, 1.0f);

	plx_mat_identity();
	plx_mat3d_apply(PLX_MAT_SCREENVIEW);
	plx_mat3d_apply(PLX_MAT_PROJECTION);
	plx_mat3d_apply(PLX_MAT_MODELVIEW);

	plx_cxt_texture(NULL);
	plx_cxt_culling(PLX_CULL_NONE);
	plx_cxt_send(list);

	uint32 color = col;
	plx_dr_state_t dr;

	plx_dr_init(&dr);

	// Left face
	plx_vert_indm3(&dr, PLX_VERT, -3, -3, -3, color);
	plx_vert_indm3(&dr, PLX_VERT, -3,  3, -3, color);
	plx_vert_indm3(&dr, PLX_VERT, -3, -3,  3, color);
	plx_vert_indm3(&dr, PLX_VERT_EOS, -3,  3,  3, color);

	// Right face
	plx_vert_indm3(&dr, PLX_VERT, 3, -3, -3, color);
	plx_vert_indm3(&dr, PLX_VERT, 3,  3, -3, color);
	plx_vert_indm3(&dr, PLX_VERT, 3, -3,  3, color);
	plx_vert_indm3(&dr, PLX_VERT_EOS, 3,  3,  3, color);

	// Front face
	plx_vert_indm3(&dr, PLX_VERT, -3,  3, -3, color);
	plx_vert_indm3(&dr, PLX_VERT, -3, -3, -3, color);
	plx_vert_indm3(&dr, PLX_VERT,  3,  3, -3, color);
	plx_vert_indm3(&dr, PLX_VERT_EOS,  3, -3, -3, color);

	// Back face
	plx_vert_indm3(&dr, PLX_VERT, -3,  3, 3, color);
	plx_vert_indm3(&dr, PLX_VERT, -3, -3, 3, color);
	plx_vert_indm3(&dr, PLX_VERT,  3,  3, 3, color);
	plx_vert_indm3(&dr, PLX_VERT_EOS,  3, -3, 3, color);

	// Top face
	plx_vert_indm3(&dr, PLX_VERT, -3, -3, -3, color);
	plx_vert_indm3(&dr, PLX_VERT, -3, -3,  3, color);
	plx_vert_indm3(&dr, PLX_VERT,  3, -3, -3, color);
	plx_vert_indm3(&dr, PLX_VERT_EOS,  3, -3,  3, color);

	// Bottom face
	plx_vert_indm3(&dr, PLX_VERT, -3, 3, -3, color);
	plx_vert_indm3(&dr, PLX_VERT, -3, 3,  3, color);
	plx_vert_indm3(&dr, PLX_VERT,  3, 3, -3, color);
	plx_vert_indm3(&dr, PLX_VERT_EOS,  3, 3,  3, color);
}

void RotoCube::nextFrame() {
	m_theta++;
	Drawable::nextFrame();
}

