/*
   Tryptonite
        
   dbg/perfmeter.cpp

   Copyright (C)2003 Cryptic Allusion, LLC
*/

#include "global.h"
#include "perfmeter.h"

/* This DEBUG piece was pulled from Tryptonite. */

PerfMeter::PerfMeter(Font * fnt) {
	m_font = fnt;
}

PerfMeter::~PerfMeter() {
}

void PerfMeter::drawBar(float pct, const Vector & pos, uint32 c1, uint32 c2) {
	const float len = 200.0f;

	plx_vert_inp(PLX_VERT, pos.x, pos.y+6.0f, pos.z, c1);
	plx_vert_inp(PLX_VERT, pos.x, pos.y, pos.z, c1);
	plx_vert_inp(PLX_VERT, pos.x+len*pct, pos.y+6.0f, pos.z, c1);
	plx_vert_inp(PLX_VERT_EOS, pos.x+len*pct, pos.y, pos.z, c1);

	plx_vert_inp(PLX_VERT, pos.x+len*pct, pos.y+6.0f, pos.z, c2);
	plx_vert_inp(PLX_VERT, pos.x+len*pct, pos.y, pos.z, c2);
	plx_vert_inp(PLX_VERT, pos.x+len, pos.y+6.0f, pos.z, c2);
	plx_vert_inp(PLX_VERT_EOS, pos.x+len, pos.y, pos.z, c2);
}

void PerfMeter::draw(int list) {
	if (list != PLX_LIST_TR_POLY)
		return;

	// Get our stats
	pvr_stats_t stats;
	pvr_get_stats(&stats);

	// Make a nice stat display
	char str[64];
	sprintf(str, "fps %.2f  reg %d  rnd %d",
		(double)stats.frame_rate, (int)stats.reg_last_time,
		(int)stats.rnd_last_time);
	m_font->setSize(16.0f);

	// Draw the stat display
	Vector pos = getPosition();
	m_font->draw(pos.x, pos.y, pos.z, str);

	// Draw a bargraph for registration time
	plx_cxt_texture(NULL);
	plx_cxt_send(list);

	float pct = ((float)stats.reg_last_time) * 60.0f / 1000.0f;
	pos += Vector(240.0f, -12.0f, 0.0f);
	drawBar(pct, pos, 0xff00c000, 0xff007000);

	// Draw a bargraph for rendering time
	pct = ((float)stats.rnd_last_time) * 60.0f / 1000.0f;
	pos += Vector(0.0f, 8.0f, 0.0f);
	drawBar(pct, pos, 0xffc0c000, 0xff707000);
}
