comment	;-)

PROtected Mode Interface v2.01
By Ervin / AbaddoN

;-)

;-----------------------------------------------;
lomemreq	=400				; Low memory required (kbytes)
himemreq	=1028+1500			; High memory required (kbytes)
himemadd	=0				; Additional high memory (kb)

rlstacklen	=2000h				; Real stack length (bytes)
pmstacklen	=4000h				; 32-bit stack length (bytes)



;-----------------------------------------------; Abbrevations
b	equ	byte  ptr
w	equ	word  ptr
d	equ	dword ptr
f	equ	fword ptr
q	equ	qword ptr
p	equ	pword ptr
o	equ	offset
s	equ	small
l	equ	large



;-----------------------------------------------;
debug   =0
probeint=9


;-----------------------------------------------;
ypos	=5

__msg	macro	text
local	_text,_loop,_end
if	debug

		push	eax esi edi
		call	_text
db	text,0
_text:
		pop	esi
		mov	edi,0b8000h+ypos*160
		sub	edi,absprotseg
		mov	ah,1fh
_loop:
		lodsb
		test	al,al
		je	_end
		stosw
		jmp	_loop
_end:
		pop	edi esi eax

ypos	=ypos+1
endif
endm



;-----------------------------------------------;
_dsdx	macro	text:vararg
local	_text
		call	_text
db	text
_text:
		pop	edx
		add	edx,cs:absprotseg

		shld	real_eds,edx,28
		and	edx,0fh
endm



;-----------------------------------------------;
xms2pm	macro	offset32
		cli
		lgdt	gdtdesc			;; Load new GDT
		lidt	g_idt_desc		;; Load new IDT

		mov	eax,cr0			;; Enter PM
		or	al,1
		mov	cr0,eax

		db	0eah			;; Jump to the 32-bit segment
		dw	s o offset32
		dw	prcss
endm



;-----------------------------------------------;
save_regz	macro
		push	es
		mov	es,cs:prot_seg		;; Save real registers
		mov	real_eax,eax
		pop	ax
		mov	real_ds,ds
		mov	real_es,ax
		mov	real_fs,fs
		mov	real_gs,gs
		mov	real_ss,ss
		mov	real_esp,esp
		lahf
		mov	b real_flags,ah
endm



;-----------------------------------------------;
vcpi2pm	macro	offset32
		mov	cs:vcpi_eip,o offset32
		mov	ax,0de0ch
		mov	esi,cs:vcpisyscr3_lin
		int	67h
endm



;-----------------------------------------------;
pm162rm	macro
local	realrules
		mov	eax,cr0			; Switch to real mode
		and	al,0feh
		mov	cr0,eax

		db	0eah			; Reload CS limit
		dw	o realrules
		dw	realseg

realrules:
		mov	es,cs:prot_seg
		lss	esp,f real_esp		; Reload real stack
		lidt	cs:f defidt		; Reload real IDT
endm



;-----------------------------------------------; PM segment descriptor struc
segdesc struc					;
						; bits:
	limit0	dw	?			; 0-15
	base0	dw	?			; 0-15
	base1	db	?			;16-23
	rights	dw	?			; 0-15
	base2	db	?			;24-31
ends



;-----------------------------------------------; PM task state segment struc
tss	struc

_backlink	dw	?,0

_esp0		dd	?
_ss0		dw	?,0
_esp1		dd	?
_ss1		dw	?,0
_esp2		dd	?
_ss2		dw	?,0

_cr3		dd	?
_eip		dd	?
_eflag		dd	?

_eax		dd	?
_ecx		dd	?
_edx		dd	?
_ebx		dd	?
_esp		dd	?
_ebp		dd	?
_esi		dd	?
_edi		dd	?

_es		dw	?,0
_cs		dw	?,0
_ss		dw	?,0
_ds		dw	?,0
_fs		dw	?,0
_gs		dw	?,0
_ldt		dw	?,0

_trap		dw	0
_iomapoffs	dw	104
ends



;-----------------------------------------------; Sentinel functions
if	(himemreq and 3) or (himemadd and 3)
.err	'himemreq' & 'himemadd' must be divisable by 4!
endif



;-----------------------------------------------;
.386p
jumps


;-----------------------------------------------; Segment order sefinitions
realseg	segment use16	public
realseg	ends

protseg	segment use32	public
protseg	ends

stacky	segment use16 stack 'stack'
org	rlstacklen
stacky	ends



;===============================================;
realseg segment use16	public
assume cs:realseg,ds:realseg,es:protseg

.8086
;-----------------------------------------------; Error messages

protect_es	db	'Protected mode exception #'
pm_exp_code	dw	'00'
		db	' (dec).',13,10,'$'

a20_es		db	'Couldn''t enable A20 gate.',13,10,'$'

xms_es		db	'XMS error.',13,10,'$'

windows_es	db	'This program requires Microsoft Windows...',13,10
		db	'TO BE TERMINATED!',13,10,'$'

virtual_es	db	'System is in V86 mode without VCPI.',13,10
		db	'Enable EMM386 please.',13,10,'$'

processor_es	db	'Intel-compatible 80386 processor required.',13,10,'$'

nomem_es	db	'Not enough conventional memory.',13,10,'$'

nohimem_es	db	'Not enough extended memory.',13,10,'$'



;-----------------------------------------------; Error handlers
err_processor:
		mov	dx,o processor_es
		jmp	apmi_error

err_windows:
		mov	dx,o windows_es
		jmp	apmi_error

err_vm:
		mov	dx,o virtual_es
		jmp	apmi_error

err_a20:
		mov	dx,o a20_es
		jmp	apmi_error

err_xms:
		mov	dx,o xms_es
		jmp	apmi_error

err_nomem:
		mov	dx,o nomem_es
		jmp	apmi_error

err_nohimem:
		mov	dx,o nohimem_es
		jmp	apmi_error

err_pmexp:
		aam
		add	ax,'00'
		xchg	ah,al
		mov	cs:pm_exp_code,ax
		mov	dx,o protect_es

apmi_error:
		push	cs
		pop	ds

		mov	ah,0fh
		int	10h
		cmp	al,3
		jbe	ae_nvmc

		mov	ax,3
		int	10h

ae_nvmc:
		mov	ah,9
		int	21h

		mov	ax,4c00h
		int	21h



;-----------------------------------------------;
;Detect processor type

;in	:-
;out	:al: CPU (1: 186 & bellow, else x (x86))
;raze	:all?
;-----------------------------------------------;

detect_processor:
		push	sp			; Filter processors bellow 286
		pop	ax
		cmp	ax,sp
		je	_286
		mov	al,1
		ret
.286
_286:
		pushf				; Filter 286
		push	3020h
		popf
		pushf
		pop	ax
		popf
		test	ah,ah
		jne	_386
		mov	al,2
		ret
.386
_386:
		mov	bp,sp			; Align sp on dword boundary
		and	sp,0fffch		; to avoid alignment exception
		pushfd				; on 486+
		pop	eax
		and	eax,0fffh		; Clear some annoying flags
		push	eax
		pushfd
		pop	eax
		mov	ebx,eax
		xor	eax,240000h		; Flip Alignment Check & CPUID
		push	eax			; bits
		popfd
		pushfd
		pop	eax
		popfd
		mov	sp,bp
		mov	ecx,eax
		xor	eax,ebx
		test	eax,40000h
		jne	_486
		mov	al,3
		ret

_486:
		xor	ecx,ebx			; Filter older 486
		test	ecx,200000h
		jne	_586
		mov	al,4
		ret
.586
_586:
		mov	eax,1			; Get processor type
		cpuid
		mov	al,ah
		and	al,0fh
		ret
.386p



;-----------------------------------------------
;Detect system: Raw, XMS, EMS, VCPI, (DPMI not), Windows

;in	:ds=cs
;out	:ax:	system bitmask=	1:VM, 2:XMS, 4:EMS, 8:VCPI, 40h:Windows
;				10h:DPMI (not implemented) 20h:DPMI32 (not imp)
;-----------------------------------------------
emm_id0	db	'EMMXXXX0',0			; Standard EMS driver ID
	db	'$MMXXXX0',0			; EMM386
	db	'EMMQXXX0',0			; Disabled EMM386
	db	'$EMMXXX0',0
	db	'QEMM386$',0			; QEMM driver
emm_ids	equ	($-emm_id0)/9

detect_system:
		smsw	cx			; Detect protected master by
		and	cx,1			; chek the 0. ('PE') bit in CR0

		mov	ax,4300h		; Detect XMS
		int	2fh			; by calling multiplex
		neg	al			; interrupt 2fh/4300h:
		seto	al			; al=80h: XMS present
		add	ax,ax
		or	cl,al

		mov	dx,o emm_id0
		mov	bp,emm_ids
vcpi_detectloop:
		mov	ax,3d00h		; Detect EMM
		int	21h
		jnb	emm_open

		add	dx,9
		or	cl,4			; EMS not found
		dec	bp
		jne	vcpi_detectloop
		jmp	vcpi_tested

emm_open:
		xchg	ax,bx			; Handle to bx

		mov	ax,4400h		; Check if it's a device or a
		int	21h			; file by IOCTL Get Device Info
		pushf				; 7. bit in dl=0: file...

		mov	ah,3eh			; Close EMM handle
		int	21h

		popf
		jb	vcpi_tested

		test	dl,80h
		je	vcpi_tested		; It was just a file (exit)

		mov	ax,0de00h		; Detect VCPI
		int	67h			; by calling the EMM's interrupt
		test	ah,ah
		sete	al
		shl	ax,3
		or	cl,al

vcpi_tested:
		xor	cl,4

; This section is unnecessary since the interface doesn't use DPMI, but in
; future upgrades there's a possibility for supporting multitasking
; environments
;
;		mov	ax,1687h		; Detect DPMI
;		push	es cx			; by calling multiplex
;		int	2fh			; interrupt 2fh/1687h
;		pop	cx es
;		test	ax,ax			; ax=0: DPMI present
;		jne	dpmi_tested
;		or	cl,10h
;		test	bl,1			; 0. bit of bx=0:
;		je	dpmi_tested		; 32-bit programs disabled
;		or	cl,20h
;
;dpmi_tested:
		mov	ax,160ah		; Detect Windooz
		push	cx
		int	2fh
		pop	cx
		test	ax,ax
		sete	al
		shl	ax,6
		or	cl,al

		xchg	cx,ax
		ret



;-----------------------------------------------;
;Enable A20 gate

;in	:-

;out	:ZR: A20 disabled
;out	:NZ: A20 enabled
;-----------------------------------------------;

enable_a20:
		cli
		xor	ax,ax			;fs <-0000
		mov	fs,ax			;gs <-ffff
		dec	ax
		mov	gs,ax

		call	test_a20
		jne	ta20_ret

		call	empty8042		;Enable A20 traditionally
		jne	a20_ps2

		mov	al,0d1h			;Send write request
		out	64h,al
		call	empty8042
		jne	a20_ps2

		mov	al,0dfh			;Send command
		out	60h,al
		call	empty8042
		jne	a20_ps2

		call	test_a20
		jne	ta20_ret

a20_ps2:
		in	al,92h			;Enable A20 by PS/2 method
		or	al,2			;(Works on many ATs too)
		jmp	$+2
		jmp	$+2
		jmp	$+2
		out	92h,al

		call	test_a20
ta20_ret:
		sti
		ret


;-----------------------------------------------;
;Test if A20 enabled or not

;in	:fs=0
;	:gs=FFFF

;out	:ZR: A20 disabled
;	:NZ: A20 enabled
;-----------------------------------------------;

test_a20:
		mov	ax,fs:[04feh]		;Access a word on the Intra-
		cmp	ax,gs:[050eh]		;Application Communications
		jne	ta20_ret		;Area (ICA)

		dec	ax
		mov	fs:[04feh],ax
		cmp	ax,gs:[050eh]
		ret



;-----------------------------------------------;
;Wait until the 8042 slave processor is ready

;in	:-

;out	:ZR:ok
;	:NZ:8042 timeout
;-----------------------------------------------;

empty8042:
		mov	cx,100			;Number of tries
		mov	al,16h			;Send command byte to the PIT:
		out	43h,al			;Read/Write MSB
		mov	al,0			;Send MSB
		out	40h,al
e8042l:
		in	al,40h			;Get MSB
		mov	ah,al
wait8253:
		in	al,40h			;Wait for next MSB
		cmp	al,ah			;(0.217 ms/try)
		je	wait8253

		in	al,64h
		test	al,2
		loopne	e8042l

		ret



;-----------------------------------------------;
;Allocate eax bytes of low memory,
;aligned to paragraph boundary

;In:	eax:	required memory (bytes)
;	es:	protseg
;Out:	eax:	allocated segment
;	ebx:	0fh
;-----------------------------------------------;
public	getrealmemsegf
getrealmemsegf:
		call	getrealmemseg
		retf



getrealmemseg:
		mov	ebx,0fh			; Paragraph align mask



;-----------------------------------------------;
;Allocate eax bytes of low memory,
;aligned to the mask specified in ebx (00..0011..11b)

;In:	eax:	required memory (bytes)
;	ebx:	align mask (00..011..1b)
;	es:	protseg
;Out:	eax:	allocated segment
;-----------------------------------------------;
getrealmem:
		push	ebx ecx

		mov	ecx,prolomemstart	; Test if the free memory
		add	ecx,absprotseg		; is aligned properly
		test	ecx,ebx
		je	grm_aligned

		not	ebx
		sub	ecx,ebx
		and	ecx,ebx			; ECX <- new free memory (lin)

grm_aligned:
		mov	ebx,ecx
		sub	ecx,absprotseg		; ECX <- new prolomemstart
		add	eax,ecx
		mov	prolomemstart,eax
		xchg	ebx,eax
		shr	eax,4
		pop	ecx ebx
		ret



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
if	debug
newi9:
		push	ax ds
		mov	ax,0b800h
		mov	ds,ax
		mov	w ds:[160*20],0f361h
		pop	ds ax
		db	0eah
oldi9	dd	?
endif
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;===============================================;
even
psp_seg		dw	?			; PSP's segment
prot_seg	dw	protseg			; The 32-bit segment

.8086
;-----------------------------------------------;
ic_system_type	db	?			; Drivers, see detect_system

initcheck:
                push    cs			; Kick DS to point CS
                pop     ds
		mov	ax,es
		mov	psp_seg,es		; Save PSP's segment
		mov	es,prot_seg		; Kick ES to the 32-bit seg.

		call	detect_processor	; Query chip type
		cmp	al,3
		jb	err_processor		; 386+ rulez

.386p
		mov	g_processor_type,al	; Save chip type

		movzx	eax,psp_seg
		shl	eax,4
		mov	abspspseg,eax

		call	detect_system
		test	al,40h
		jne	err_windows
		mov	ic_system_type,al

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
if	debug
		xor	ax,ax
		mov	fs,ax
		mov	ax,cs
		shl	eax,16
		mov	ax,o newi9
		cli
		xchg	eax,fs:[probeint*4]
		mov	oldi9,eax
		sti
endif
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		mov	cx,es
		mov	es,psp_seg
		mov	ah,4ah			; Get the amount of
		mov	ebx,0ffffh		; available low memory
		int	21h
		mov	es,cx

		xor	eax,eax			; Init linear segment address
		mov	ax,cs			; variables
		shl	eax,4
		mov	absrealseg,eax

		xor	eax,eax
		mov	ax,prot_seg
		shl	eax,4
		mov	absprotseg,eax
		add	bx,psp_seg
		xchg	ebx,eax			; EBX <- absprotseg
		shl	eax,4
		sub	eax,ebx
		mov	prolomemend,eax
		mov	eax,stacky+rlstacklen/16
		shl	eax,4
		sub	eax,ebx
		mov	prolomemstart,eax

		sub	eax,prolomemend		; Check low memory
		cmp	eax,-pmstacklen-1800h-lomemreq*1024
		ja	err_nomem

		mov	eax,pmstacklen		; Reserve PM stack & init PM
		call	getrealmemseg		; stack pointer
		shl	eax,4
		sub	eax,absprotseg
		add	eax,pmstacklen
		mov	p_esp,eax

		mov	real_ss,ss		; Save real mode ss/esp
		mov	real_esp,esp

		mov	eax,800h		; Reserve mem. for IDT &
		call	getrealmemseg		; init IDT-specific info
		shl	eax,4
		mov	g_idt_lin,eax
		sub	eax,absprotseg
		mov	g_idt_address,eax

		mov	eax,absrealseg		; Initialize GDT
		or	d realcsdesc.base0,eax
		or	d realdsdesc.base0,eax
		mov	eax,absprotseg
		or	d gdtdesc.base0,eax
		or	d protcsdesc.base0,eax
		or	d protdsdesc.base0,eax

		mov	al,ic_system_type	; Jump to da appropriate driver
		test	al,1
		jne	ic_vm

		test	al,2
		je	raw_init
		jmp	xms_init

ic_vm:
		test	al,8
		je	err_vm
		mov	g_driver_type,2
		jmp	vcpi_init



;-----------------------------------------------; Int 15h handler for RAW mode
re_new_int_15:
		cmp	ah,88h			; Hook 'Query ext. mem size'
		je	ri_lie_himemsize        ; function

		db	0eah			; Pass control to the original
ri_old_int_15	dd	?			; handler

ri_lie_himemsize:
new_himemsize	equ	w $+1
		mov	ax,?			; Report ext. mem size to be
		iret				; less ;-)



;-----------------------------------------------;
raw_init:
		mov	eax,8800h		; Get amount of ext. mem.
		xor	ebx,ebx
		int	15h
		cmp	ax,himemreq		; Chek high memory
		jb	err_nohimem
		cmp	ax,himemreq+himemadd
		jbe	ri_himemresok
		mov	bx,ax
		sub	bx,himemadd
ri_himemresok:
		mov	new_himemsize,bx

		shl	eax,10
		sub	eax,absprotseg		; Init high mem. start/end
		add	eax,1024*1024		; addresses
		mov	prohimemend,eax
		shl	ebx,10
		sub	ebx,absprotseg
		add	ebx,1024*1024
		mov	prohimemstart,ebx

		call	enable_a20		; Enable the A20 line
		je	err_a20

		xor	ax,ax			; Init new int 15h handler
		mov	fs,ax
		mov	ax,cs
		shl	eax,16
		mov	ax,o re_new_int_15
		cli
		xchg	fs:[15h*4],eax
		mov	ri_old_int_15,eax

		mov	real_exit_point,o raw_exit_point
 		jmp	raw_xms_enterpm		; Go!



;-----------------------------------------------;
raw_exit_point:
		xor	ax,ax			; Restore old int 15h
		mov	fs,ax
		mov	eax,ri_old_int_15
		mov	fs:[15h*4],eax

		jmp	apmi_exit		; Bye!



;-----------------------------------------------;
align	4
xms_address	label	dword			; XMS driver's entry point
xms_addr_lo	dw	?
xms_addr_hi	dw	?
xms_handle	dw	0			; XMS mem. block's handle

defidt		dw	3ffh,0,0		; Default IDT
real_exit_point	dw	o xms_exit_point	; Real more driver exit address

xms_init:
		mov	ax,4310h		; Get XMS driver adress
		int	2fh
		mov	xms_addr_lo,bx
		mov	xms_addr_hi,es
		mov	es,prot_seg

		mov	ah,3			; Enable A20
		call	xms_address
		dec	ax
		je	xms_a20_ok

		call	enable_a20		; Violent enable of A20
		je	err_a20			; (0.0001% it's necessary)

xms_a20_ok:
		mov	ah,8
		call	xms_address		; Get free extended memory

		cmp	ax,himemreq		; Chek high mem.
		jb	err_nohimem
		cmp	ax,himemreq+himemadd
		jb	xms_himemsizeok
		mov	ax,himemreq+himemadd
xms_himemsizeok:
		movzx	esi,ax			; Save high mem. size
		xchg	dx,ax
		mov	ah,09h
		call	xms_address		; Allocate extended memory
		dec	ax
		jne	err_xms

		mov	xms_handle,dx		; Lock reserved region
		mov	ah,0ch
		call	d xms_address
		dec	ax
		jne	err_xms

		shrd	eax,edx,16		; Calculate linear address
		xchg	bx,ax
		mov	ebx,absprotseg
		sub	eax,ebx			; Set pointers
		mov	prohimemstart,eax
		shl	esi,10
		add	eax,esi
		mov	prohimemend,eax

raw_xms_enterpm:
		sgdt	defgdt			; Save GDT
		cli
		xms2pm	pro_go



;-----------------------------------------------;
xms_real_proc:
		pm162rm

		mov	ds,real_ds		; Reload virtual segregs
		mov	fs,real_fs
		mov	gs,real_gs
		mov	es,real_es

xms_proc_eax	equ	d $+2			; Reload real eax
		mov	eax,0

		db	9ah			; Call far procedure
xms_proc_addr	dd	?

		cli
		save_regz
		xms2pm	rawxms_realproc_return



;-----------------------------------------------;
xms_real_int:
		pm162rm

		mov	ds,real_ds		; Reload virtual segregs
		mov	fs,real_fs
		mov	gs,real_gs
		mov	es,real_es

xms_int_eax	equ	d $+2			; Reload real eax
		mov	eax,0

		db	0cdh			; Do interrupt
xms_int_num	db	?

		cli
		save_regz
		xms2pm	rawxms_int_return



;-----------------------------------------------
xms_real_irq:
		pm162rm

		db	0cdh			; Do interrupt (IRQ)
xms_irq_num	db	?

		cli
		xms2pm	rawxms_irq_return



;-----------------------------------------------
real_xms_bye:
		pm162rm

		mov	ax,cs
		mov	ds,ax

		lgdt	defgdt			; Load real mode gdt/idt
		sti

		jmp	real_exit_point		; Jump to RAW exit if necessary

xms_exit_point:
		mov	dx,xms_handle		; Chek XMS handle
		test	dx,dx
		je	r_xmsb_exit

		mov	ah,0dh			; Unlock memory block
		call	xms_address
		dec	ax
		jne	err_xms

		mov	ah,0ah			; Free memory block
		call	xms_address
		dec	ax
		jne	err_xms

r_xmsb_exit:
		jmp	apmi_exit



;-----------------------------------------------
xms_protproc:
		cli
		save_regz
		xms2pm	pm_protproc

xms_real_protproc_exit:
		pm162rm

		mov	ds,real_ds		; Reload virtual segregs
		mov	fs,real_fs
		mov	gs,real_gs
		mov	es,real_es

xms_prpr_eax	equ	d $+2
		mov	eax,0
		retf



;-----------------------------------------------
even
vcpi_pages_seg	dw	?
vcpi_1st_page	dw	?
vcpi_pagenum	dw	?

align	4
vcpisyscr3_lin	dd	?
vcpi_sys_cr3	dd	?
vcpi_sys_gdt	dd	o gdt
vcpi_sys_idt	dd	o g_idt_desc
vcpi_ldtr	dw	0
vcpi_tr		dw	tsdss
vcpi_eip	dd	o pro_go
vcpi_cs		dw	prcss

vcpi_init:
		mov	g_int_redirector,o vcpi_int_redirect
		mov	g_irq_redirector,o vcpi_irq_redirect
		mov	g_pro_exit_adr,o pro_vcpi_bye
		mov	realpr,o vcpi_realproc
		mov	protprocexit,o vcpiprotprocexit
		mov	ppaddr,o vcpi_protproc

		mov	ax,0de0ah		; Get IRQ mappings
		int	67h
		mov	bh,cl
		mov	picmap,bx

		mov	ax,0de03h		; Chek high mem.
		int	67h
		shl	edx,2
		cmp	edx,himemreq
		jb	err_nohimem
		mov	ebp,himemreq+himemadd
		cmp	edx,ebp
		jae	vi_himemok
		mov	ebp,edx			; EBP <- available himem. (kb)
vi_himemok:
		mov	ebx,0fffh		; Align allocated mem. on
		xor	eax,eax                 ; 4k boundary
		call	getrealmem

		mov	vcpi_pages_seg,ax	; Ask VCPI interface
		mov	fs,ax
		mov	es,ax
		xor	edi,edi
		mov	ds,prot_seg
		mov	esi,o gdt_vcpi_desc
		mov	ax,0de01h
		int	67h
		mov	ax,cs
		mov	ds,ax
		mov	es,prot_seg
		mov	vcpi_adr_pro,ebx

		mov	eax,edi			; Calculate VCPI strucrures
		add	eax,ebp			; length
		test	ax,0fffh
		je	vi_align1
		add	eax,1000h
		and	ax,0f000h
vi_align1:
		mov	ebx,eax
		shr	ebx,8
		lea	eax,[eax+ebx+10h+lomemreq*1024+70h]
		add	eax,prolomemstart
		cmp	eax,prolomemend
		ja	err_nomem

		mov	eax,edi			; Set high mem. start pointer
		shl	eax,10
		sub	eax,absprotseg
		mov	prohimemstart,eax
		mov	vcpi_1st_page,di
		mov	ebx,edi

		mov	ecx,ebp
		shr	ecx,2
vi_alloc_4k_pages:
		test	cx,cx
		je	vi_4kpages_allocated
		mov	ax,0de04h		; Allocate 4k pages
		int	67h

		xchg	edx,eax			; Fill page table
		mov	al,7
		mov	fs:[di],eax
		add	di,4
		dec	cx
		jmp	vi_alloc_4k_pages

vi_4kpages_allocated:
		mov	eax,edi			; Save the number of allocated
		sub	eax,ebx			; 4k pages
		shr	eax,2
		mov	vcpi_pagenum,ax

		mov	eax,edi			; Reserve mem. for page table
		call	getrealmemseg

		mov	ebx,0fffh		; Align reserved mem. on
		xor	eax,eax			; 4k boundary
		call	getrealmem

		mov	eax,edi			; Set high mem. end pointer
		shl	eax,10
		sub	eax,absprotseg
		mov	prohimemend,eax

		test	eax,03fffffh		; Reserve mem. for page dir.
		je	vi_pde_aligned
		add	eax,400000h
		and	eax,0ffc00000h
vi_pde_aligned:
		shr	eax,20			; Initialize CR3 register
		mov	cx,ax
		shr	cx,2
		call	getrealmemseg
		mov	gs,ax
		shr	eax,6
		mov	eax,fs:[eax]
		and	ax,0f000h
		mov	vcpi_sys_cr3,eax

		xor	ebx,ebx
		mov	bx,fs
		shr	ebx,6
		xor	di,di

vi_fill_page_dir:
		mov	eax,fs:[bx]		; Fill page directory
		add	bx,4
		or	al,7
		mov	gs:[di],eax
		add	di,4
		loop	vi_fill_page_dir

		mov	eax,68h			; Allocate mem. for TSS
		call	getrealmemseg
		mov	fs,ax
		shl	eax,4
		or	d gdt_tss_desc.base0,eax
		mov	ebx,absprotseg
		sub	eax,ebx
		mov	g_tss_pro,eax
		add	vcpi_sys_gdt,ebx
		add	vcpi_sys_idt,ebx

		xor	eax,eax
		call	getrealmemseg

		xor	di,di			; Clear TSS
		mov	cx,1ah
		xor	eax,eax
vi_clear_tss:
		mov	fs:[di],eax
		add	di,4
		loop	vi_clear_tss

		mov	fs:[_ss0],10h		; Set up TSS
		mov	fs:[_iomapoffs],68h
		mov	eax,vcpi_sys_cr3
		mov	fs:[_cr3],eax

		mov	ax,0de0ch		; Enter 32-bit PM
		mov	esi,o vcpi_sys_cr3
		add	esi,absrealseg
		mov	vcpisyscr3_lin,esi
		cli
		int	67h



;-----------------------------------------------
real_vcpi_bye:
		sti
		push	cs
		pop	ds

		mov	es,vcpi_pages_seg
		mov	si,vcpi_1st_page
		mov	cx,vcpi_pagenum
rvb_loop:
		test	cx,cx
		je	rvb_freed
		seges
		lodsd
		xchg	edx,eax
		mov	ax,0de05h
		int	67h
		dec	cx
		jmp	rvb_loop
rvb_freed:
		jmp	apmi_exit



;-----------------------------------------------
vcpi_real_proc:
vcpi_proc_eax	equ	d $+2
		mov	eax,0

		db	9ah
vcpi_proc_addr	dd	?

		cli
		save_regz
		mov	real_esi,esi

		vcpi2pm	vcpi_realproc_return



;-----------------------------------------------
vcpi_real_int:
vcpi_int_eax	equ	d $+2
		mov	eax,0

		db	0cdh
vcpi_int_num	db	?

		cli
		save_regz
		mov	real_esi,esi

		vcpi2pm	vcpi_int_return



;-----------------------------------------------
vcpi_real_irq:
		db	0cdh
vcpi_irq_num	db	?

		cli
		vcpi2pm	vcpi_irq_return



;-----------------------------------------------
vcpi_protproc:
		cli
		save_regz
		mov	real_esi,esi

		vcpi2pm	pm_protproc

vcpi_real_protproc_exit:
vcpi_prpr_eax	equ	d $+2
		mov	eax,0
		retf



;-----------------------------------------------
public	protproc
protproc:
		db	0eah
ppaddr		dw	o xms_protproc
		dw	realseg



;-----------------------------------------------
apmi_exit:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
if	debug
		mov	eax,oldi9
		push	0
		pop	ds
		mov	ds:[probeint*4],eax
endif
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		mov	ax,protseg
		mov	es,ax
		mov	al,errorcode
		cmp	al,0ffh
		jne	err_pmexp

		mov	ax,4c00h
		int	21h

realseg ends



;-----------------------------------------------;
protseg segment use32	public
assume cs:protseg,ds:protseg

;-----------------------------------------------;
public	getint,		getdirectint,	getirq,	getdirectirq
public	setint,		setdirectint,	setirq,	setdirectirq
public	kickbackint,	kickbackirq,	irq2int
public	getlomem,	gethimem
public	_exit

public	realproc

public	real_ds,	real_eds
public	real_es,	real_ees
public	real_fs,	real_efs
public	real_gs,	real_egs

public	absrealseg,	absprotseg
public	prolomemstart,	prolomemend
public	prohimemstart,	prohimemend
public	abspspseg

public	realprocaddr

extrn	_main:near



;-----------------------------------------------; PM descriptors
gdt	label	dword
gdtdesc         segdesc <gdtlen-1,0,  0,     0,0>
protcsdesc      segdesc <0ffffh,  0,  0,0cf9eh,0>	;protected code
protdsdesc      segdesc <0ffffh,  0,  0,0cf92h,0>	;protected data
realcsdesc      segdesc <0ffffh,  0,  0,   9eh,0>	;real code
realdsdesc      segdesc <0ffffh,  0,  0,   92h,0>	;real data
zerodesc        segdesc <0ffffh,  0,  0,0cf92h,0>	;zero
gdt_tss_desc	segdesc	<02067h,  0,  0,00089h,0>	;TSS
gdt_vcpi_desc	segdesc	3 dup(<>)			;VCPI
gdtlen  equ     $-gdtdesc


prcss	equ	8
prdss	equ	10h
rlcss	equ	18h
rldss	equ	20h
zrdss	equ	28h
tsdss	equ	30h


;-----------------------------------------------
;memory pointers
align 4

absrealseg	dd	0		;real codesegment's absolute adress
absprotseg	dd	0		;prot codesegment's absolute adress

prolomemstart	dd	0		;accessable lo mem's adresses, relative
prolomemend	dd	0		;to the protected segment

prohimemstart	dd	100000h		;accessable hi mem's adresses, relative
prohimemend	dd	0		;to the protected segment

abspspseg	dd	?

;-----------------------------------------------
g_idt_desc	label   fword
g_idt_limit	dw	7ffh
g_idt_lin	dd	?

defgdt		df	?

g_idt_address	dd	?
g_tss_pro	dd	?

g_processor_type	db	?
g_driver_type	db	1

g_int_redirector	dd	o rawxms_int_redirect
g_irq_redirector	dd	o rawxms_irq_redirect

g_pro_exit_adr	dd	o pro_xms_bye

picmap	label	word
pic_lomap	db	8
pic_himap	db	70h

p_ss_esp	label	fword
p_esp		dd	?
p_ss		dw	prdss

;-----------------------------------------------
p_int_red_base	dd	?

vcpi_call	label	fword
vcpi_adr_pro	dd	?
vcpi_adr_seg	dw	38h



;-----------------------------------------------
;Real mode communication variables

realpr		dd	o rawxms_realproc
realprocaddr	dd	?

real_registers	label
irp	reg,	ip,cs,flags,sp,ss,es,ds,fs,gs,ax,si

	real_e&reg	label	dword
	real_&reg	dw	0,0
endm



;-----------------------------------------------
pro_go:
		clts
		mov	eax,prdss
		mov	ds,ax
		mov	es,ax
		mov	eax,zrdss
		mov	fs,ax
		mov	gs,ax
		lss	esp,p_ss_esp

		mov	eax,prolomemstart
		add	eax,0fh
		and	eax,0fffffff0h
		mov	prolomemstart,eax

		mov	eax,prohimemstart
		add	eax,0fh
		and	eax,0fffffff0h
		mov	prohimemstart,eax

		call	setup_interrupts
		sti

		__msg	'Entering 32-bit pmode...'
		jmp	_main

_exit:
		__msg	'Leaving 32-bit pmode...'
		jmp	cs:g_pro_exit_adr



;-----------------------------------------------
pro_xms_bye:
		cli
		mov	eax,rldss
		mov	ds,ax
		mov	es,ax
		mov	fs,ax
		mov	gs,ax
		mov	ss,ax

		db	0eah
		dd	l o real_xms_bye
		dw	rlcss



;-----------------------------------------------
rawxms_realproc:
		pushfd
		cli
		__msg	'XMS real procedure runs.'
		push	ds es fs gs rldss
		pop	ds

assume	ds:realseg
		mov	ds:[l xms_proc_eax],eax
		mov	eax,cs:realprocaddr
		mov	ds:[l xms_proc_addr],eax
assume	ds:protseg

		mov	eax,prdss
		mov	ds,ax

		mov	p_esp,esp
		mov	p_ss,ss

		mov	eax,rldss
		mov	ds,ax
		mov	es,ax
		mov	fs,ax
		mov	gs,ax
		mov	ss,ax

		db	0eah
		dd	l o xms_real_proc
		dw	rlcss

rawxms_realproc_return:
		lss	esp,cs:p_ss_esp
		pop	gs fs es ds

		mov	ah,b cs:real_eflags
		sahf

		mov	eax,cs:real_eax

		__msg	'XMS real procedure exits.'
		popfd
		ret



;-----------------------------------------------
rawxms_int_redirect:
		__msg	'XMS Interrupt redirector runs.'

		push	ds zrdss
		pop	ds

assume	ds:realseg
pr_relo__xmsint	equ	d $+1
		mov	ds:[l xms_int_num],al
		pop	eax

pr_relo__xmseax	equ	d $+2
		pop	d ds:[l xms_int_eax]
assume	ds:protseg

		push	eax es fs gs

pr_relo__p_esp3	equ	d $+2
		mov	p_esp,esp
pr_relo__p_ss3	equ	d $+2
		mov	p_ss,ss

		mov	eax,rldss
		mov	ds,ax
		mov	es,ax
		mov	fs,ax
		mov	gs,ax
		mov	ss,ax

		db	0eah
		dd	l o xms_real_int
		dw	rlcss

;-----------------------------------------------
rawxms_int_return:
		lss	esp,cs:p_ss_esp
		pop	gs fs es ds

		mov	al,b cs:real_eflags
		mov	ss:[esp+8],al
		mov	eax,cs:real_eax

		__msg	'XMS Interrupt redirector exits.'
		iretd



;-----------------------------------------------
rawxms_irq_redirect:
		__msg	'XMS IRQ redirector runs.'

		push	ds es fs gs zrdss
		pop	ds

pr_relo__p_esp4	equ	d $+2
		mov	p_esp,esp
pr_relo__p_ss4	equ	d $+2
		mov	p_ss,ss

assume	ds:realseg
pr_relo__xmsirq	equ	d $+1
		mov	ds:[l xms_irq_num],al
assume	ds:protseg

		mov	eax,rldss
		mov	ss,ax
		mov	ds,ax
		mov	es,ax
		mov	fs,ax
		mov	gs,ax

		db	0eah
		dd	l o xms_real_irq
		dw	rlcss

;-----------------------------------------------
rawxms_irq_return:
		lss	esp,cs:p_ss_esp
		pop	gs fs es ds eax

		__msg	'XMS IRQ redirector exits.'
		iretd



;-----------------------------------------------
pro_vcpi_bye:
		cli
		sub	esp,16
		mov	eax,cs:real_ess
		push	eax
		mov	eax,cs:real_esp
		push	eax eax
		push	l realseg l o real_vcpi_bye

		mov	eax,zrdss
		mov	ds,ax
		mov	eax,0de0ch
		call	cs:vcpi_call



;-----------------------------------------------
vcpi_realproc:
		__msg	'VCPI real procedure runs.'

		pushfd
		push	ds es fs gs rldss
		pop	ds

assume	ds:realseg
		mov	d ds:[l vcpi_proc_eax],eax
		mov	eax,cs:realprocaddr
		mov	ds:[l vcpi_proc_addr],eax
assume	ds:protseg

		mov	eax,prdss
		mov	ds,ax

		mov	p_esp,esp
		mov	p_ss,ss

irp	reg,	gs,fs,ds,es,ss,sp
		mov	eax,real_e&reg
		push	eax
endm

		push	eax
		push	l realseg l o vcpi_real_proc

		mov	eax,zrdss
		mov	ds,ax

		mov	eax,0de0ch
		call	cs:vcpi_call

;-----------------------------------------------
vcpi_realproc_return:
		lss	esp,cs:p_ss_esp
		pop	gs fs es ds

		mov	ah,b cs:real_eflags
		sahf
		mov	eax,cs:real_eax
		mov	esi,cs:real_esi

		popfd

		__msg	'VCPI real procedure exits.'
		ret



;-----------------------------------------------
vcpi_int_redirect:
		__msg	'VCPI Interrupt redirector runs.'

		push	ds zrdss
		pop	ds

assume	ds:realseg
pr_relo__vcpint	equ	d $+1
		mov	ds:[l vcpi_int_num],al
		pop	eax

pr_relo__vcpiax	equ	d $+2
		pop	d ds:[l vcpi_int_eax]
assume	ds:protseg

		push	eax es fs gs

pr_relo__p_esp2	equ	d $+2
		mov	p_esp,esp
pr_relo__p_ss2	equ	d $+2
		mov	p_ss,ss

irp	reg,	gs,fs,ds,es,ss,sp
		mov	eax,cs:real_e&reg
		push	eax
endm

		push	eax
		push	l realseg l o vcpi_real_int

		mov	eax,0de0ch
		call	cs:vcpi_call

;-----------------------------------------------
vcpi_int_return:
		lss	esp,cs:p_ss_esp

		pop	gs fs es ds

		mov	al,b cs:real_eflags
		mov	ss:[esp+8],al
		mov	eax,cs:real_eax
		mov	esi,cs:real_esi

		__msg	'VCPI Interrupt redirector exits.'
		iretd



;-----------------------------------------------
vcpi_irq_redirect:
		__msg	'IRQ redirector runs.'

		push	esi ds es fs gs

		mov	esi,zrdss
		mov	ds,si

pr_relo__p_esp1	equ	d $+2
		mov	p_esp,esp
pr_relo__p_ss1	equ	d $+2
		mov	p_ss,ss

assume	ds:realseg
pr_relo__vcpirq	equ	d $+1
		mov	ds:[l vcpi_irq_num],al
assume	ds:protseg

		sub	esp,10h
		mov	eax,cs:real_ess
		push	eax
		mov	eax,cs:real_esp
		push	eax eax
		push	l realseg l o vcpi_real_irq

		mov	eax,0de0ch
		call	cs:vcpi_call

;-----------------------------------------------
vcpi_irq_return:
		lss	esp,cs:p_ss_esp
		pop	gs fs es ds esi eax

		__msg	'IRQ redirector exits.'
		iretd



;-----------------------------------------------
;Exception handlers


						;IRQ - cascaded exceptions
irp	exp_num,08,09,0a,0b,0c,0d,0e
exp_&exp_num:
		test	b ss:[esp+8],2
		je	sure_exp_&exp_num
		jmp	cs:int_table[(exp_num&h-8)*4]

sure_exp_&exp_num:
		mov	bl,exp_num&h
		jmp	cs:exp_handler_address
endm
expchek_len	equ	($-exp_08)/7

align	4
int_table	dd	7 dup(0)


;-----------------------------------------------
errorcode	db	0ffh
exp_handler_address	dd	exp_handler

exp_handler:
                mov     ax,prdss
                mov     ds,ax

		__msg	'Exception handler runs.'

                mov     errorcode,bl
		jmp	g_pro_exit_adr



;===============================================
;System services

;-----------------------------------------------; Call real mode procedure
realproc:
		jmp	cs:realpr



;-----------------------------------------------; Call PM procedure
public	protprocaddr
protprocaddr	dd	?

pm_protproc:
		clts
		mov	eax,prdss
		mov	ds,ax
		mov	es,ax
		mov	eax,zrdss
		mov	fs,ax
		mov	gs,ax
		lss	esp,p_ss_esp

		__msg	'PMTEST STARTS'

		call	protprocaddr

		__msg	'PMTEST ENDS'

		cli
		push	prdss
		pop	ds
		mov	p_esp,esp
		mov	p_ss,ss
		jmp	cs:protprocexit

protprocexit	dd	o xmsprotprocexit

xmsprotprocexit:
		mov	eax,rldss
		mov	ds,ax
		mov	es,ax
		mov	fs,ax
		mov	gs,ax
		mov	ss,ax

		db	0eah
		dd	l o xms_real_protproc_exit
		dw	rlcss

vcpiprotprocexit:
		sub	esp,10h
		mov	eax,cs:real_ess
		push	eax
		mov	eax,cs:real_esp
		push	eax eax
		push	l realseg l o vcpi_real_protproc_exit

		mov	eax,0de0ch
		call	cs:vcpi_call



;-----------------------------------------------
setup_interrupts:

		mov	eax,g_idt_address
		mov	bl,0

si_fill_idt:
		mov	d [eax+2],8e000008h	; Fill segment/rights fields
		inc	bl
		lea	eax,[eax+8]
		jne	si_fill_idt

		mov	eax,o exp_08
		mov	bl,8
		call	setdirectint
		add	eax,expchek_len
		add	bl,2

fill_idt_critical:
		add	eax,expchek_len		; Install exception checkers
		call	setdirectint
		inc	ebx
		cmp	bl,0fh
		jne	fill_idt_critical

		mov	eax,256*16		; Reserve mem for kickback code
		call	getlomem

		mov	p_int_red_base,eax
		mov	bl,0

si_loop_int:
		mov	d [eax],2e00b050h	; Generate kickback code
		mov	[eax+2],bl
		mov	d [eax+4],25ffh
		call	kickbackint		; Redirect all interrupts
		add	eax,16
		inc	bl
		jne	si_loop_int

si_loop_irq:
		call	kickbackirq		; Redirect all IRQs
		inc	ebx
		cmp	bl,16
		jne	si_loop_irq

		mov	eax,absprotseg		; Real mode callback relocation
		add	pr_relo__p_esp1,eax
		add	pr_relo__p_ss1,eax
		add	pr_relo__p_esp2,eax
		add	pr_relo__p_ss2,eax
		add	pr_relo__p_esp3,eax
		add	pr_relo__p_ss3,eax
		add	pr_relo__p_esp4,eax
		add	pr_relo__p_ss4,eax

		mov	eax,absrealseg
		add	pr_relo__vcpirq,eax
		add	pr_relo__vcpint,eax
		add	pr_relo__vcpiax,eax
		add	pr_relo__xmsirq,eax
		add	pr_relo__xmsint,eax
		add	pr_relo__xmseax,eax

		ret



;-----------------------------------------------
;In:	bl:	int number
;-----------------------------------------------
kbi_address	dd	?

kickbackdirectint:
		mov	kbi_address,o setdirectint
		jmp	kbn_address_ok

kickbackint:
		mov	kbi_address,o setint
kbn_address_ok:
		push	eax ebx
		movzx	eax,bl
		mov	ebx,o g_int_redirector
		shl	eax,4
		add	eax,p_int_red_base
		mov	[eax+6],ebx
		pop	ebx
		call	kbi_address
		pop	eax
		ret



;-----------------------------------------------
;In:	bl:	irq number
;-----------------------------------------------
kickbackdirectirq:
		mov	kbi_address,o setdirectint
		jmp	kbi_address_ok

kickbackirq:
		mov	kbi_address,o setint
kbi_address_ok:
		push	eax ebx
		call	irq2int
		push	ebx
		movzx	eax,bl
		shl	eax,4
		add	eax,p_int_red_base
		mov	ebx,o g_irq_redirector
		mov	[eax+6],ebx
		pop	ebx
		call	kbi_address
		pop	ebx eax
		ret


;-----------------------------------------------
;in	:bl:	interrupt number
;	:ds:	prdss
;out	:eax:	interrupt handler offset
;-----------------------------------------------
getint:
		cmp	bl,8
		je	gn_special_int
		cmp	bl,0ah
		jb	getdirectint
		cmp	bl,0eh
		ja	getdirectint

gn_special_int:
		movzx	eax,bl
		mov	eax,[eax*4+o int_table-8*4]
		ret

;-----------------------------------------------
;in	:bl:	interrupt number
;	:ds:	prdss
;out	:eax:	interrupt handler offset
;-----------------------------------------------
getdirectint:
		push	ebx
		movzx	eax,bl
		shl	eax,3
		add	eax,g_idt_address
		mov	ebx,[eax]
		mov	eax,[eax+4]
		xchg	bx,ax
		pop	ebx
		ret



;-----------------------------------------------
;In:	eax:	interrupt handler offset
;	bl:	interrupt number
;	ds:	prdss
;-----------------------------------------------
setint:
		cmp	bl,8
		je	sn_special_int
		cmp	bl,0ah
		jb	setdirectint
		cmp	bl,0eh
		ja	setdirectint

sn_special_int:
		push	ebx eax
		movzx	ebx,bl
		lea	eax,[ebx-8]
		imul	eax,expchek_len
		add	eax,o exp_08
		call	setdirectint
		pop	eax
		mov	[ebx*4+o int_table-8*4],eax
		pop	ebx
		ret



;-----------------------------------------------
;In:	eax:	interrupt handler offset
;	bl:	interrupt number
;	ds:	prdss
;-----------------------------------------------
setdirectint:
		push	ebx
		movzx	ebx,bl
		shl	ebx,3
		add	ebx,g_idt_address
		mov	[ebx],ax
		ror	eax,16
		mov	[ebx+6],ax
		ror	eax,16
		pop	ebx
		ret



;-----------------------------------------------
;In:	bl:	IRQ number
;	ds:	prdss
;Out:	eax:	IRQ handler address
;-----------------------------------------------
getirq:
		push	ebx
		call	irq2int
		call	getint
		pop	ebx
		ret

;-----------------------------------------------
;In:	bl:	IRQ number
;	ds:	prdss
;Out:	eax:	IRQ handler address
;-----------------------------------------------
getdirectirq:
		push	ebx
		call	irq2int
		call	getdirectint
		pop	ebx
		ret



;-----------------------------------------------
;In:	eax:	IRQ handler address
;	bl:	IRQ number
;	ds:	prdss
;-----------------------------------------------
setirq:
		push	ebx
		call	irq2int
		call	setint
		pop	ebx
		ret

;-----------------------------------------------
;In:	eax:	IRQ handler address
;	bl:	IRQ number
;	ds:	prdss
;-----------------------------------------------
setdirectirq:
		push	ebx
		call	irq2int
		call	setdirectint
		pop	ebx
		ret



;-----------------------------------------------
;In:	bl: IRQ num
;Out:	bl: interrupt num
;-----------------------------------------------
irq2int:
		push	eax
		mov	eax,d picmap
		cmp	bl,8
		jb	ii_lower_8

		sub	bl,8
		mov	al,ah
ii_lower_8:
		add	bl,al
		pop	eax
		ret


;-----------------------------------------------
getlomem:
		add	eax,prolomemstart
		add	eax,0fh
		and	eax,0fffffff0h
		cmp	eax,prolomemend
		jnb	glm_end
		xchg	prolomemstart,eax
glm_end:
		cmc
		ret



;-----------------------------------------------
gethimem:
		add	eax,prohimemstart
		add	eax,0fh
		and	eax,0fffffff0h
		cmp	eax,prohimemend
		jnb	ghm_end
		xchg	prohimemstart,eax
ghm_end:
		cmc
		ret

protseg ends

end	initcheck
